/* table.c - ATMARP table */
 
/* Written 1995,1996 by Werner Almesberger, EPFL-LRC */
 

#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <linux/atm.h>

#include "atm.h"
#include "atmd.h"

#include "table.h"


#define COMPONENT "TABLE"


const char *entry_state_name[] = { "NONE","RESOLV","INVALID","VALID" };


ENTRY *lookup_ip(const ITF *itf,unsigned long ip)
{
    ENTRY *walk;

    for (walk = itf->table; walk; walk = walk->next)
	if (walk->ip == ip) break;
    return walk;
}


ENTRY *lookup_addr(const ITF *itf,const struct sockaddr_atmsvc *addr)
{
    ENTRY *walk;

    for (walk = itf->table; walk; walk = walk->next)
	if (walk->addr && (*walk->addr->sas_addr.prv ? *addr->sas_addr.prv &&
	  !memcmp(addr->sas_addr.prv,walk->addr->sas_addr.prv,ATM_ESA_LEN) :
	  !*addr->sas_addr.prv) && ((*walk->addr->sas_addr.pub ?
	  *addr->sas_addr.pub && !strcmp(addr->sas_addr.pub,
	  walk->addr->sas_addr.pub) : !*addr->sas_addr.pub))) break;
    return walk;
}


static void dump_vcc(VCC *vcc)
{
    struct sockaddr_atmsvc addr;
    char buffer[MAX_ATM_ADDR_LEN+1];
    int size;

    size = sizeof(addr);
    if (getpeername(vcc->fd,(struct sockaddr *) &addr,&size) < 0) {
	diag(COMPONENT,DIAG_ERROR,"getpeername: %s",strerror(errno));
	strcpy(buffer,"<getsocknam error>");
    }
    else {
	if (0 && debug) { /* @@@ */
	    int i;

	    for (i = 0; i < size; i++)
		printf("%02X ",((unsigned char *) &addr)[i]);
	    printf("\n");
	}
	if (atm2text(buffer,MAX_ATM_ADDR_LEN+1,(struct sockaddr *) &addr,
	  A2T_PRETTY) < 0) strcpy(buffer,"<atm2text error>");
    }
    diag(COMPONENT,DIAG_DEBUG,"  %s%s",buffer,vcc->connecting ? ", connecting"
      : !vcc->entry->svc ? "" : vcc->active ? " (active)" : " (passive)");
}


static void dump_entries(ENTRY *list)
{
    ENTRY *entry;
    VCC *vcc;
    char buffer[MAX_ATM_ADDR_LEN+1];
    unsigned char *ipp;

    for (entry = list; entry ; entry = entry->next) {
	if (!entry->addr) strcpy(buffer,"<none>");
	else if (atm2text(buffer,MAX_ATM_ADDR_LEN+1,
	      (struct sockaddr *) entry->addr,A2T_PRETTY) < 0)
		strcpy(buffer,"<error>");
	ipp = (unsigned char *) &entry->ip;
	diag(COMPONENT,DIAG_DEBUG,"IP %d.%d.%d.%d, state %s, addr %s, flags "
	  "0x%x",ipp[0],ipp[1],ipp[2],ipp[3],entry_state_name[entry->state],
	  buffer,entry->flags);
	for (vcc = entry->vccs; vcc; vcc = vcc->next) dump_vcc(vcc);
    }
}


void dump_itf(ITF *itf)
{
    char buffer[MAX_ATM_ADDR_LEN+1];
    unsigned char *ipp;

    ipp = (unsigned char *) &itf->local_ip;
    if (atm2text(buffer,MAX_ATM_ADDR_LEN+1,(struct sockaddr *) &itf->local_addr,
      A2T_PRETTY) < 0) strcpy(buffer,"<unknown>");
    diag(COMPONENT,DIAG_DEBUG,"----- Itf %d (%d.%d.%d.%d, %s) -----",
      itf->number,ipp[0],ipp[1],ipp[2],ipp[3],buffer);
    dump_entries(itf->table);
}


void dump_all(void)
{
    ITF *itf;

    for (itf = itfs; itf; itf = itf->next) dump_itf(itf);
    diag(COMPONENT,DIAG_DEBUG,"----- Unknown incoming connections -----");
    dump_entries(unknown_incoming);
    diag(COMPONENT,DIAG_DEBUG,"----- End of dump -----");
}
