/* dualmon.h: configuration information for dual-monitor patches.
 *
 * todd j. derr 2 Aug 1994
 *
 * all dualmon-related configuration defines are now in this file.
 */

#ifndef __DUALMON_H
#define __DUALMON_H

/* comment the next three lines out if either:
 * (1) if you are using config.in to configure dualmon
 * (2) you want to disable dualmon (might also want to put an #undef)
 */

#ifndef CONFIG_DUALMON
#define CONFIG_DUALMON 1
#endif

#ifdef CONFIG_DUALMON
/* This controls whick ALT key selects which monitor.  0 is color and 1 is
 * mono.  Please make sure one of these is 0 and one is 1.
 */

#define LEFT_ADAPTER 0
#define RIGHT_ADAPTER 1

/* the default (bootup) VC number (starting at zero) for the mono screen.
 * subtract one from the tty/VC number (i.e. 7 is /dev/tty8)
 */

#define MONO_CONSOLE 7

/* (41a) should we blank the cursor on the active screen?  Kinda handy,
 * but comment this out if you don't like it that way.
 */

#define HIDE_NONACTIVE_CURSOR

/* !! don't edit below this line !! */

/* function prototypes */

void resize_console(int);
int set_adapter(int, int);

#define DUALMON_VERSION "1.1.42 alpha1 (10 Aug 94)"

#endif CONFIG_DUALMON
#endif __DUALMON_H

