proc initTable {} {
    global ivt_table
 	
    set ivt_table(0) {
		set opt "-for $alpha -text \" \" -bitmap {}"
		set graphics 0 }
    set ivt_table(1) {
        set opt "-for $alpha -text \" \" -bitmap {}"
        set alpha red
        set graphics 0 }
    set ivt_table(2)  {
		set opt "-for $alpha -text \" \" -bitmap {}"
        set alpha green
        set graphics 0 }
    set ivt_table(3)  {
		set opt "-for $alpha -text \" \" -bitmap {}"
        set alpha yellow  
        set graphics 0	}
    set ivt_table(4)  {
		set opt "-for $alpha -text \" \" -bitmap {}"
        set alpha blue   
        set graphics 0 }
    set ivt_table(5)  {
		set opt "-for $alpha -text \" \" -bitmap {}"
        set alpha magenta
        set graphics 0	}
    set ivt_table(6)  {
		set opt "-for $alpha -text \" \" -bitmap {}"
        set alpha cyan
        set graphics 0	}
    set ivt_table(7)  {
		set opt "-for $alpha -text \" \" -bitmap {}"
        set alpha white
        set graphics 0	}
    set ivt_table(8) {
    	set flash 1
		set opt "-for $alpha -text \" \" -bitmap {}"
    	}
    set ivt_table(9) {
    	set flash 0
		set opt "-for $alpha -text \" \" -bitmap {}"
    	}
    set ivt_table(10) {puts stdout "<10>"
		set opt "-for $alpha -text \" \" -bitmap {}"
	    }
    set ivt_table(11) {puts stdout "<11>"
		set opt "-for $alpha -text \" \" -bitmap {}"
    	}
    set ivt_table(12) {puts stdout "<12>"
		set opt "-for $alpha -text \" \" -bitmap {}"
		}
    set ivt_table(13) {puts stdout "<13>"
		set opt "-for $alpha -text \" \" -bitmap {}"
    	}
    set ivt_table(14) {};# unused 
    set ivt_table(15) {};# unused

    set ivt_table(16)  {
        set opt "-for $graph -text \" \" -bit \{\}"
        set graph black
        set graphics 1 }
    set ivt_table(17)  {
        set opt "-for $graph -text \" \" -bit \{\}"
        set graph red
        set graphics 1  }
    set ivt_table(18) {
       	set opt "-for $graph -text \" \" -bit \{\}"
        set graph green
        set graphics 1 }
    set ivt_table(19) {
        set opt "-for $graph -text \" \" -bit \{\}"
        set graph yellow
        set graphics 1 }
    set ivt_table(20)  {
        set opt "-for $graph -text \" \" -bit \{\}"
        set graph blue
         set graphics 1 }
    set ivt_table(21) {
        set opt "-for $graph -text \" \" -bit \{\}"
        set graph magenta
        set graphics 1 }
    set ivt_table(22) {
        set opt "-for $graph -text \" \" -bit \{\}"
        set graph cyan
        set graphics 1 }
    set ivt_table(23) {
        set opt "-for $graph -text \" \" -bit \{\}"
        set graph white
        set graphics 1 }
	set ivt_table(29) {
			# change background color to current fore color
			if { $graphics } {
				set back $graph
			} else {
				set back $alpha
			}
            set opt "-text \" \" -bit \{\} -back $back "
			}
    set ivt_table(24) {puts stdout "<24>"};# hidden text
    set ivt_table(25) {set grmode cont
    		}
    set ivt_table(26) {set grmode sep
    		}

    set ivt_table(27) {};# ESC -  unused

    set ivt_table(28) {set back  black
		set opt "-text \" \" -bit \{\} -back $back "
    	}
    set ivt_table(30) {
		set grhold 1
		set opt "-for $alpha -text \" \" -bitmap {}"
		}
    set ivt_table(31) {
		set grhold 0
		set opt "-for $alpha -text \" \" -bitmap {}"
		}
}

proc requestPage {nr} {
	global vtex
	set l {}
	set b [split $nr {} ]
        if {[lindex $b 0]==8} {set b [lreplace $b 0 0 0 ]}
 	set b [lreplace $b 0 0 [expr [lindex $b 0] | 8 ] ]
	set i 0
	foreach a $b {
		incr i
		lappend l [expr $a|16 ]
	}
	while { [llength $l] <7 } { lappend l 0 }
	eval ivt wr 2 [expr $vtex(page)*16] $l
}

proc parseChar {y x c} {
	upvar back back alpha alpha graph graph graphics graphics grmode grmode \
		grhold grhold flash flash
	global display vtex lang ivt_table mem
	set mem($display.$y.$x) $c
	set opt {}
	if { [expr $c < 32] } {
		eval $ivt_table($c)
		if {$grhold == 1 && $graphics || $c==30&& $x>0 } {
			set opt "-text \{ \} -fore [lindex [.display.$y.[expr $x-1] conf -fore ] 4]"
			if {[lindex [.display.$y.[expr $x-1] conf -bitmap] 4] != "" } {
			  set opt "$opt -bitmap [lindex [.display.$y.[expr $x-1]\
					conf -bitmap] 4] "
			}
		} else {
			set opt "-for $graph -text \" \" -bit \{\}"
       	}
		eval $display.$y.$x conf -back $back $opt
		return
	}
	if { $graphics && (( $c > 32 && $c < 64 )  || ( $c >=96 && $c < 128 )) } {
	  	if { $grmode == "sep" } { 
	  		set c [expr $c +128] 
	  	}
	  	set opt " $opt -bitmap @$vtex(prefix)/$c -fore $graph"
		eval $display.$y.$x conf -back $back $opt
		return
	} 

	switch $c {
				34 {
					set opt "$opt -bitmap \{\} -text \\\" \
						-fore $alpha"
				}
				35 { switch $lang(current) {
						"English" -
						"Italian" {	set opt "$opt -bitmap \{\} -text \"[chr 131]\" -fore $alpha"}
						"German"  -
						"Swedish" {	set opt "$opt -bitmap \{\} -text \"#\" -fore $alpha" }
						"French"  {	set opt "$opt -bitmap \{\} -text \"[chr 233]\" -fore $alpha" }
						"Spanish" { set opt "$opt -bitmap \{\} -text \"[chr 231]\" -fore $alpha" }
				} }
				36 { switch $lang(current) {
						"English" -
						"Italian" -
						"German"  -
						"Spanish" {	set opt "$opt -bitmap \{\} -text \"\$\" -fore $alpha" }
						"Swedish" {	set opt "$opt -bitmap \{\} -text \"[chr 132]\" -fore $alpha" }
						"French"  {	set opt "$opt -bitmap \{\} -text \"[chr 239]\" -fore $alpha" }
				} }
				64 { switch $lang(current) {
						"English" {	set opt "$opt -bitmap \{\} -text \"@\" -fore $alpha" }
						"Italian" {	set opt "$opt -bitmap \{\} -text \"[chr 233]\" -fore $alpha"}
						"German"  {	set opt "$opt -bitmap \{\} -text \"[chr 135]\" -fore $alpha" }
						"Swedish" {	set opt "$opt -bitmap \{\} -text \"[chr 201]\" -fore $alpha" }
						"French"  {	set opt "$opt -bitmap \{\} -text \"[chr 224]\" -fore $alpha" }
						"Spanish" { set opt "$opt -bitmap \{\} -text \"i\" -fore $alpha" }
				} }
				91 { switch $lang(current) {
						"English" {	set opt "$opt -bitmap @$vtex(prefix)/english/$c -fore $alpha"}
						"Italian" {	set opt "$opt -bitmap \{\} -text \"[chr 144]\" -fore $alpha"}
						"German"  - 
						"Swedish" {	set opt "$opt -bitmap \{\} -text \"[chr 196]\" -fore $alpha" }
						"French"  {	set opt "$opt -bitmap \{\} -text \"[chr 235]\" -fore $alpha" }
						"Spanish" { set opt "$opt -bitmap \{\} -text \"[chr 225]\" -fore $alpha" }
				} }
				92 { switch $lang(current) {
						"English" {	set opt "$opt -bitmap \{\} -text \"[chr 157]\" -fore $alpha" }
						"Italian" {	set opt "$opt -bitmap \{\} -text \"[chr 231]\" -fore $alpha"}
						"German"  { set opt "$opt -bitmap \{\} -text \"[chr 214]\" -fore $alpha" }
						"Swedish" {	set opt "$opt -bitmap \{\} -text \"[chr 214]\" -fore $alpha" }
						"French"  {	set opt "$opt -bitmap \{\} -text \"[chr 234]\" -fore $alpha" }
						"Spanish" { set opt "$opt -bitmap \{\} -text \"[chr 233]\" -fore $alpha" }
				} }
				93 { switch $lang(current) { 
						"Italian" -
						"English" { set opt "$opt -bitmap @$vtex(prefix)/english/$c -fore $alpha"}
						"German"  { set opt "$opt -bitmap \{\} -text \"[chr 220]\" -fore $alpha" }
						"Swedish" { set opt "$opt -bitmap \{\} -text \"[chr 197]\" -fore $alpha" }
						"French"  { set opt "$opt -bitmap \{\} -text \"[chr 249]\" -fore $alpha" }
						"Spanish" { set opt "$opt -bitmap \{\} -text \"[chr 237]\" -fore $alpha" }
				} }
				94 { switch $lang(current) {
						"Italian" -
						"English" { set opt "$opt -bitmap @$vtex(prefix)/english/$c -fore $alpha"}
						"German"  {	set opt "$opt -bitmap \{\} -text \"^\" -fore $alpha" }
						"Swedish" {	set opt "$opt -bitmap \{\} -text \"[chr 220]\" -fore $alpha" }
						"French"  {	set opt "$opt -bitmap \{\} -text \"[chr 238]\" -fore $alpha" }
						"Spanish" { set opt "$opt -bitmap \{\} -text \"[chr 243]\" -fore $alpha" }
				} }
				95 { switch $lang(current) {
						"French"  -
						"Italian" -
						"English" {	set opt "$opt -bitmap \{\} -text \"#\" -fore $alpha" }
						"German"  -
						"Swedish" {	set opt "$opt -bitmap \{\} -text \"_\" -fore $alpha" }
						"Spanish" { set opt "$opt -bitmap \{\} -text \"[chr 250]\" -fore $alpha" }
				} }
				96 { switch $lang(current) { 
						"English" { set opt "$opt -bitmap @$vtex(prefix)/english/$c -fore $alpha"}
						"Italian" { set opt "$opt -bitmap \{\} -text \"[chr 252]\" -fore $alpha"}
						"German"  { set opt "$opt -bitmap \{\} -text \"[chr 144]\" -fore $alpha" }
						"Swedish" { set opt "$opt -bitmap \{\} -text \"[chr 233]\" -fore $alpha" }
						"French"  { set opt "$opt -bitmap \{\} -text \"[chr 232]\" -fore $alpha" }
						"Spanish" { set opt "$opt -bitmap \{\} -text \"[chr 159]\" -fore $alpha" }
				} }
				123 { switch $lang(current) {
						"English" { set opt "$opt -bitmap \{\} -text \"[chr 156]\" -fore $alpha"}
						"Italian" {	set opt "$opt -bitmap \{\} -text \"[chr 224]\" -fore $alpha"}
						"German"  -
						"Swedish" {	set opt "$opt -bitmap \{\} -text \"[chr 228]\" -fore $alpha"}
						"French"  {	set opt "$opt -bitmap \{\} -text \"[chr 226]\" -fore $alpha"}
						"Spanish" { set opt "$opt -bitmap \{\} -text \"[chr 252]\" -fore $alpha"}
				} }
				124 { switch $lang(current) {
						"English" { set opt "$opt -bitmap @$vtex(prefix)/english/$c -fore $alpha"}
						"Italian" { set opt "$opt -bitmap \{\} -text \"[chr 242]\" -fore $alpha"}
						"German"  -
						"Swedish" { set opt "$opt -bitmap \{\} -text \"\[chr 246\]\" -fore $alpha" }
						"French"  { set opt "$opt -bitmap \{\} -text \"[chr 244]\" -fore $alpha" }
						"Spanish" { set opt "$opt -bitmap \{\} -text \"[chr 241]\" -fore $alpha" }
				} }
				125 { switch $lang(current) {
						"English" { set opt "$opt -bitmap \{\} -text \"[chr 158]\" -fore $alpha"}
						"Italian" { set opt "$opt -bitmap \{\} -text \"[chr 232]\" -fore $alpha"}
						"German"  { set opt "$opt -bitmap \{\} -text \"[chr 252]\" -fore $alpha"}
						"Swedish" { set opt "$opt -bitmap \{\} -text \"[chr 245]\" -fore $alpha"}
						"French"  { set opt "$opt -bitmap \{\} -text \"[chr 251]\" -fore $alpha"}
						"Spanish" { set opt "$opt -bitmap \{\} -text \"[chr 242]\" -fore $alpha"}
				} }
				126 { switch $lang(current) {
						"English" { set opt "$opt -bitmap \{\} -text \"[chr 247]\" -fore $alpha"}
						"Italian" { set opt "$opt -bitmap \{\} -text \"[chr 237]\" -fore $alpha"}
						"German"  { set opt "$opt -bitmap \{\} -text \"[chr 223]\" -fore $alpha" }
						"Swedish" { set opt "$opt -bitmap \{\} -text \"[chr 252]\" -fore $alpha" }
						"French"  { set opt "$opt -bitmap \{\} -text \"[chr 231]\" -fore $alpha" }
						"Spanish" { set opt "$opt -bitmap \{\} -text \"[chr 224]\" -fore $alpha" }
				} }
				default {
					set opt "$opt -bitmap \{\} -text \"[chr $c]\" -fore $alpha"
					}
	}
	eval $display.$y.$x conf -back $back $opt
}

proc parseLine {line str } {
	set back black
	set alpha white
	set graph white
	set graphics 0
	set grmode cont	
	set grhold 0
	set flash 0
	for {set x 0} {$x<40} { incr x} {
		parseChar $line $x [lindex $str $x]
	}
}

proc parseP { str } {
	# assert str has 1000 elems
	global display
	if { [catch { $display conf }]} {
		initDisplay
	}
	for {set i 0} {$i<25} { incr i} {
		parseLine $i [lrange $str [expr $i*40] [expr ($i+1)*40]]
	}
}


proc rollHeader {} {
#	disp first line until ! found & pblf.
	global vtex
	
	set l [ivt wr 8 $vtex(page) 25 0; ivt re 10]
	set found [expr ([lindex $l 8]&16)/16]
	set pblf [expr ([lindex $l 9]&32)/32]
	while {!$pblf && $found } {
		parseLine 0 [ivt wr 8 $vtex(page) 0 0; ivt re 40]
		update idletasks
		set l [ivt wr 8 $vtex(page) 25 0; ivt re 10]
		set found [expr ([lindex $l 8]&16)/16]
		set pblf [expr ([lindex $l 9]&32)/32]
	}
	parseP [ivt wr 8 $vtex(page) 0 0; ivt re 1000]
}
