#include <stdio.h>

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netinet6/in6.h>
#include <netdb.h>
#include <net/ndisc.h>

#define PROC_ENTRY "/proc/net/ndisc_cache"

int main(int argc, char *argv[])
{
	FILE *fp;
	struct in6_addr addr;
	int bucket, state, use, flags;
	__u32 timer, reach;
	char hwaddr[16];

	fp = fopen(PROC_ENTRY, "r");

	if (fp == NULL)
	{
		perror("error opening /proc file");
		exit(1);
	}

	while (fscanf(fp, "%8x%8x%8x%8x %02x %02x %08x %08x %04x %04x %s\n",
		      &addr.s6_addr32[0], &addr.s6_addr32[1],
		      &addr.s6_addr32[2], &addr.s6_addr32[3],
		      &bucket, &state, &timer, &reach, &use, &flags,
		      hwaddr) != EOF)
	{
		struct hostent *hp;

		addr.s6_addr32[0] = htonl(addr.s6_addr32[0]);
		addr.s6_addr32[1] = htonl(addr.s6_addr32[1]);
		addr.s6_addr32[2] = htonl(addr.s6_addr32[2]);
		addr.s6_addr32[3] = htonl(addr.s6_addr32[3]);

		hp = gethostbyaddr((void *)&addr, sizeof(struct in6_addr),
				   AF_INET6);

		if (hp)
		{
			printf("%s\t", hp->h_name);
		}
		else
		{
			char str[80];
			inet_ntop(AF_INET6, &addr, str, 80);
			printf("%s\t", str);
		}
		

		switch(state) {
		case NUD_NONE:
			printf("None     ");
			break;
		case NUD_INCOMPLETE:
			printf("Imcomplt ");
			break;
		case NUD_REACHABLE:
			printf("Reach    ");
			break;
		case NUD_STALE:
			printf("Stale    ");
			break;
		case NUD_DELAY:
			printf("Delay    ");
			break;
		case NUD_PROBE:
			printf("Probe    ");
			break;
		case NUD_FAILED:
			printf("Failed   ");
			break;
		}

		printf(" %02d\n", use);
	}

	fclose(fp);

	return 0;
}
