%{
#include <sys/types.h>
#include <netinet/in.h>
#include <netinet6/in6.h>
#include <arpa/inet.h>
#include "radv.h"
#include "gram.tab.h"

int num_lines = 1;
%}

digit		[0-9]
number		({digit})+
hexdigit	([a-f]|[A-F]|[0-9])
addr1		{hexdigit}{1,4}":"({hexdigit}{1,4}":")*(":"{hexdigit}{1,4})+
addr2		({hexdigit}{1,4}":"){7}{hexdigit}
addr		({addr1}|{addr2})
whitespace	([ \t])+
string		[a-z]([a-z]|{digit})*
%%

"/*".*"\*"		{}
^#.*			{}
\n			{num_lines++;}
{whitespace}		{}

interface		{return T_INTERFACE;}
prefix			{return T_PREFIX;}
length			{return T_LEN;}

AdvSendAdvert		{return T_AdvSendAdvert;}
MaxRtrAdvInterval	{return T_MaxRtrAdvInterval;}
MinRtrAdvInterval	{return T_MinRtrAdvInterval;}
AdvManagedFlag		{return T_AdvManagedFlag;}
AdvOtherConfigFlag	{return T_AdvOtherConfigFlag;}
AdvLinkMTU		{return T_AdvLinkMTU;}
AdvReachableTime	{return T_AdvReachableTime;}
AdvRetransTimer		{return T_AdvRetransTimer;}
AdvCurHopLimit		{return T_AdvCurHopLimit;}
AdvDefaultLifetime	{return T_AdvDefaultLifetime;}

AdvOnLink		{return T_AdvOnLink;}
AdvAutonomous		{return T_AdvAutonomous;}
AdvValidLifetime	{return T_AdvValidLifetime;}
AdvPreferedLifetime	{return T_AdvPreferedLifetime;}

{addr}			{
				static struct in6_addr addr;
				int i;
				
				i = inet_pton(AF_INET6, yytext, &addr);

				yylval.addr = &addr;

				if (i == 0)
				{
					fprintf(stderr, "invalid address\n");
					exit(1);
				}
				return ADDR;
			}

{number}		{yylval.num = atoi(yytext); return NUMBER;}
on			{yylval.bool = 1; return SWITCH;}
off			{yylval.bool = 0; return SWITCH;}
{string}		{
				static char name[IFNAMSIZ];
				
				strcpy(name, yytext);
				yylval.str = name;
				return STRING;
			}

.			{return *yytext;}			
%%
