#include <stdio.h>
#include <errno.h>
#include <string.h>
#include <sys/ioctl.h>
#include <sys/socket.h>
#include <netinet6/in6.h>
#include <net/if.h>


int main()
{
	int sk;
	int err;
	struct ifreq ifr;

	sk = socket(AF_INET6, SOCK_DGRAM, 0);

	if (sk < 0)
	{
		perror("sys_socket");
		exit(1);
	}

	memset(&ifr, 0, sizeof(struct ifreq));

	strcpy(ifr.ifr_name, "sit0");
	ifr.ifr_flags = IFF_UP;

	err = ioctl(sk, SIOCSIFFLAGS, &ifr);

	if (err)
		perror("ioctl");

	return 0;
}

/*
 * Local variables:
 *  compile-command: "gcc -Wall -m486 -c -o situp.o situp.c"
 * End:
 */
