/* CLNP defines */

struct clnp_fixed {	/* CLNP fixed part */
    u_char nlpi;	/* Network Layer Protocol ID */
    u_char hlen;	/* header length */
    u_char ver;		/* Version/Protocol ID extension */
    u_char ttl;		/* lifetime */
    u_char type;	/* type (with bits) */
    u_char slenh;	/* segment length (high) */
    u_char slenl;	/* segment length (low) */
    u_char chkh;	/* checksum (high) */
    u_char chkl;	/* checksum (low) */
    /* not in packets */
    u_short slen;	/* segment length */
    u_short chk;	/* checksum */
};
#define CLNP_FIXED_SIZE	9
#define CLNP_MAX_HLEN	254
#define CLNP_VERSION	1
#define CLNP_SEGPERM	0x80
#define	CLNP_MORE	0x40
#define CLNP_ERREPT	0x20
#define CLNP_TYPE	0x1f
#define CLNP_DT_PDU	0x1c
#define CLNP_ERR_PDU	0x01
#define CLNP_ECH_REQ	0x1e
#define CLNP_ECH_REP	0x1f

struct clnp_address {	/* CLNP address part */
    u_char len;		/* address length */
    const u_char *addr;	/* address */
};

struct clnp_segment {	/* CLNP segmentation part */
    u_char idh;		/* data unit ID (high) */
    u_char idl;		/* data unit ID (low) */
    u_char offh;	/* segment offset (high) */
    u_char offl;	/* segment offset (low) */
    u_char tlenh;	/* total length (high) */
    u_char tlenl;	/* total length (low) */
    /* no in packets */
    u_short id;		/* data unit ID */
    u_short off;	/* segment offset */
    u_short tlen;	/* total length */
};
#define CLNP_SEGMENT_PART 6

struct clnp_option {	/* CLNP option part */
    u_char code;	/* parameter code */
    u_char olen;	/* parameter length */
    const u_char *val;	/* parameter value */
    /* not in packet */
    struct clnp_option *next;	/* next option */
};

#define CLNP_OPT_PAD	0xcc	/* padding */
#define CLNP_OPT_SECU	0xc5	/* security */
#define CLNP_OPT_SR	0xc8	/* source routing */
#define CLNP_OPT_RR	0xcb	/* record route */
#define	CLNP_OPT_QOS	0xc3	/* quality of service */
#define CLNP_OPT_PRI	0xcd	/* priority */
#define CLNP_OPT_ERR	0xc1	/* ERRPDU : reason of discard */

struct clnp {		/* CLNP packet */
    struct clnp_fixed *cf;	/* fixed part */
    struct clnp_address *cad;	/* destination address part */
    struct clnp_address *cas;	/* source address part */
    struct clnp_segment *cs;	/* segmentation part */
    struct clnp_option *co;	/* option(s) part */
    const u_char *cd;			/* data */
};

#define PACK(full,high,low) \
    full = ((u_short)high << 8) | ((u_short)low)

/* EON */

#define EON_VERSION	1
#define EON_NORM_ADDR	0
#define EON_MULT_ES	1
#define EON_MULT_IS	2
#define EON_BROADCAST	3
#define EON_HDR_SIZE	4

struct eon_hdr {
    u_char vers;		/* version */
    u_char class;		/* class */
    u_short cksum;		/* checksum */
};
