/* IPv6 defines */

#define IPVERSION4	4
#define IPVERSION6	6

struct ipv6 {
	u_int32		ip6_head;	/* version and flow label */
	u_short		ip6_len;	/* payload length */
	u_char		ip6_nh;		/* next header */
	u_char		ip6_hlim;	/* hop limit */
	u_int32		ip6_src[4];	/* source address */
	u_int32		ip6_dst[4];	/* destination address */
};

struct ipv6_frag {
	u_char		ip6f_nh;	/* next header */
	u_char		ip6f_res;	/* reserved */
	u_short		ip6f_off;	/* offset */
	u_int32		ip6f_id;	/* identification */
};

/*
 * Definitions of next header field values.
 */
#define	IP6_NHDR_HOP	0		/* hop-by-hop IPv6 header */
#define IP6_NHDR_RT	43		/* routing IPv6 header */
#define IP6_NHDR_FRAG	44		/* fragment IPv6 header */
#define IP6_NHDR_AUTH	51		/* authentication IPv6 header */
#define IP6_NHDR_ESP	50		/* encryption IPv6 header */
#define IP6_NHDR_NONH	59		/* no next header */
#define IP6_NHDR_DOPT	60		/* destination options header */

#define IPPROTO_ICMPV6	58		/* ICMPv6/IGMPv6/NDPv6 */
#define IPPROTO_IPV6	41		/* IPv6 in IPv4 tunnels */

struct icmpv6 {
	u_char		icmp6_type;	/* type of message, see below */
	u_char		icmp6_code;	/* type sub code */
	u_short		icmp6_cksum;	/* checksum */
	union {
	    n_long	 ih6_pmtu;	    /* next MTU (for discovery) */
	    n_long	 ih6_pptr;	    /* bad parameter pointer */
	    struct ih6_idseq {		    /* echo */
		n_short	  icd6_id;
		n_short	  icd6_seq;
	    } ih6_idseq;
	    struct ih6_gmm {
		n_short	  igm6_mrd;	    /* maximum response delay */
		n_short	  igm6_spare;
	    } ih6_gmm;
	    struct ih6_rtad {
		u_char	  irta_mhlim;	    /* maximum hop limit */
		u_char	  irta_aflg;	    /* administrated flags */
		n_short	  irta_life;	    /* router lifetime */
	    } ih6_rtad;
	} icmp6_hun;
#define icmp6_pmtu	icmp6_hun.ih6_pmtu
#define icmp6_pptr	icmp6_hun.ih6_pptr
#define icmp6_id	icmp6_hun.ih6_idseq.icd6_id
#define icmp6_seq	icmp6_hun.ih6_idseq.icd6_seq
#define icmp6_mrd	icmp6_hun.ih6_gmm.igm6_mrd
#define icmp6_mhlim	icmp6_hun.ih6_rtad.irta_mhlim
#define icmp6_aflg	icmp6_hun.ih6_rtad.irta_aflg
#define icmp6_life	icmp6_hun.ih6_rtad.irta_life
	union {
	    u_int32	 id6_grp[4];	    /* group address */
	    struct id6_addr {
		u_int32	  id6_tgt[4];	     /* target address */
		u_int32	  id6_rdst[4];	     /* (redirect) destination */
	    } id6_addr;
	    struct id6_nud {
		u_int32	  id6_reach;	     /* reachable timer */
		u_int32	  id6_retrans;	     /* retrans timer */
	    } id6_nud;
	    struct ipv6	 id6_ip;	    /* header of packet in error */
	    u_char	 id6_data[1];	    /* other data */
	} icmp6_dun;
#define icmp6_grp	icmp6_dun.id6_grp
#define icmp6_tgt	icmp6_dun.id6_addr.id6_tgt
#define icmp6_rdst	icmp6_dun.id6_addr.id6_rdst
#define icmp6_reach	icmp6_dun.id6_nud.id6_reach
#define icmp6_retrans	icmp6_dun.id6_nud.id6_retrans
#define icmp6_ip	icmp6_dun.id6_ip
#define icmp6_data	icmp6_dun.id6_data
};

#define ICMP6_MINLEN	8		/* abs minimum */

/*
 * Definition of type and code field values.
 */
#define ICMP6_UNREACH		1	/* dest unreachable, codes: */
#define  ICMP6_UNREACH_NOROUTE	  0	 /* no route to destination */
#define  ICMP6_UNREACH_ADMIN	  1	 /* administratively prohibited */
#define  ICMP6_UNREACH_RTFAIL	  2	 /* not a neighbor */
#define  ICMP6_UNREACH_ADDRESS	  3	 /* address unreachable */
#define  ICMP6_UNREACH_PORT	  4	 /* port unreachable */
#define ICMP6_PKTTOBIG		2	/* packet too big */
#define ICMP6_TIMXCEED		3	/* time exceeded, code: */
#define  ICMP6_TIMXCEED_INTRANS	  0	 /* ttl==0 in transit */
#define  ICMP6_TIMXCEED_REASS	  1	 /* ttl==0 in reass */
#define ICMP6_PARAMPROB		4	/* ip header bad */
#define  ICMP6_PARAMPROB_HDR	  0      /* erroneous header field */
#define  ICMP6_PARAMPROB_NH	  1      /* unrecognized next header */
#define  ICMP6_PARAMPROB_OPT	  2      /* unrecognized option */
#define ICMP6_OLDREDIRECT	5	/* (old) redirect */
#define ICMP6_ECHO		128	/* echo service */
#define ICMP6_ECHOREPLY		129	/* echo reply */
#define ICMP6_GROUPMEM_QUERY	130	/* group membership query */
#define ICMP6_GROUPMEM_REPORT	131	/* group membership report */
#define ICMP6_GROUPMEM_TERM	132	/* group membership termination */
#define ICMP6_SOLICITATION_RT	133	/* router solicitation */
#define ICMP6_ADVERTISMENT_RT	134	/* router advertisment */
#define ICMP6_SOLICITATION_ND	135	/* neighbor solicitation */
#define ICMP6_ADVERTISMENT_ND	136	/* neighbor advertisment */
#define ICMP6_REDIRECT		137	/* redirect */

/*
 * Definition of extensions for Neighbor Discovery
 */
#define NDX6_LLADDR_SRC		1	/* Source Link-layer Address */
#define NDX6_LLADDR_TGT		2	/* Target Link-layer Address */
#define NDX6_PREF_INFO		3	/* Prefix-Information */
#define NDX6_RDRT_HDR		4	/* Redirected-Header */
#define NDX6_MTU		5	/* Maximum-Transmit-Unit */
#define NDX6_JUMBO		194	/* Jumbo-Payload */

/*
 * Extension layouts.
 */

struct ndx6_any {			/* common header */
	u_char		x6any_ext;	/* extension type */
	u_char		x6any_len;	/* length */
	u_short		x6any_res1;	/* reserved */
	u_int32		x6any_res2;	/* reserved */
};

struct ndx6_lladdr {			/* Link-layer Address */
	u_char		lla_ext;	/* extension type (1 or 2) */
	u_char		lla_len;	/* length (>=1) */
	u_char		lla_addr[6];	/* media address */
};

struct ndx6_pref {			/* Prefix-Information */
	u_char		pref_ext;	/* extension type (3) */
	u_char		pref_len;	/* length (4) */
	u_char		pref_plen;	/* prefix length (0..128) */
	u_char		pref_flg;	/* flags */
	u_int32		pref_ilife;	/* invalidation lifetime */
	u_int32		pref_dlife;	/* deprecation lifetime */
	u_int32		pref_res1;	/* reserved (0) */
	u_int32		pref_pref[4];	/* prefix */
};
#define	NDX6_PREF_FLG_L	0x80		/* On-link flag */
#define	NDX6_PREF_FLG_A	0x40		/* Address-configuration flag */

struct ndx6_mtu {			/* Maximum-Transmit-Unit */
	u_char		mtu_ext;	/* extension type (5) */
	u_char		mtu_len;	/* length (1) */
	u_short		mtu_res;	/* reserved (0) */
	u_int32		mtu_mtu;	/* MTU value */
};

struct ndx6_jbo {			/* Jumbo-Payload */
	u_char		jbo_ext;	/* extension type (194) */
	u_char		jbo_len;	/* length (4) */
	u_int32		jbo_plen;	/* payload length */
};
