/* IS-IS (ISO IS 10589) defines */

#define ISIS_VERX	1
#define ISIS_VERSION	1

#define ISIS_L1_LAN_IIH	15	/* PDU types */
#define ISIS_L2_LAN_IIH	16
#define ISIS_P2P_IIH	17
#define ISIS_L1_LSP	18
#define ISIS_L2_LSP	20
#define ISIS_L1_CSNP	24
#define ISIS_L2_CSNP	25
#define ISIS_L1_PSNP	26
#define ISIS_L2_PSNP	27

#define ISIS_ID_1	1	/* ID lengths */
#define ISIS_ID_2	2
#define ISIS_ID_3	3
#define ISIS_ID_4	4
#define ISIS_ID_5	5
#define ISIS_ID_6	6
#define ISIS_ID_7	7
#define ISIS_ID_8	8
#define ISIS_ID_DEF	0
#define ISIS_ID_NUL	255

#define ISIS_CIR_RES	0	/* circuit types */
#define ISIS_CIR_L1	1
#define ISIS_CIR_L2	2
#define ISIS_CIR_L12	3

#define ISIS_P_BIT	0x80	/* support Partition Repair */
#define ISIS_DEF_M	0x08	/* Default Metric */
#define ISIS_DLY_M	0x10	/* Delay Metric */
#define ISIS_EXP_M	0x20	/* Expense Metric */
#define ISIS_ERR_M	0x40	/* Error Metric */
#define ISIS_LSPDBOL	0x04	/* LSP database overflow */
#define ISIS_IST_RES0	0x00	/* IS type : reserved */
#define ISIS_IST_L1	0x01	/* IS type : Level 1 IS */
#define ISIS_IST_RES2	0x02	/* IS type : reserved */
#define ISIS_IST_L2	0x03	/* IS type : Level 2 IS */

#define ISIS_AREA_ADDR	1	/* area addresses */
#define ISIS_IS_NEIGHB	2	/* IS neighbours */
#define ISIS_ES_NEIGHB	3	/* ES neighbours */
#define ISIS_PD_L2_IS	4	/* partition designated L2 IS */
#define ISIS_PRE_NEIGHB	5	/* prefix neighbours */
#define ISIS_ANEIGHBOUR	6	/* adjancy neighbours */
#define ISIS_PADDING	8	/* padding */
#define ISIS_LSP_ENT	9	/* LSP entries */
#define ISIS_AUTH_INFO	10	/* authentification info */
#define ISIS_IP_INT_R	128	/* IP internal reachability info */
#define ISIS_PROTO	129	/* protocols supported */
#define ISIS_IP_EXT_R	130	/* IP external reachability info */
#define ISIS_IP_IDRP	131	/* inter-domain routing protocol info */
#define ISIS_IPINTA	132	/* IP interface addresses */
#define ISIS_IP_AUTH	133	/* IP authentification info (obsolete) */
#define ISIS_ROUTER_ID	134	/* IP router-ID */

#define NLPI_DODIP	0xcc	/* DOD IP NLPID */

#define ISIS_IDRP_RES0	0	/* IDRP info type 0 (reserved) */
#define ISIS_IDRP_LOCAL	1	/* IDRP local info */
#define ISIS_IDRP_ASN	2	/* IDRP AS number info */

struct isis_header {		/* IS-IS header */
    u_char nlpi;		/* Network Layer Protocol ID */
    u_char hlen;		/* header length */
    u_char verx;		/* Version/Protocol ID extension */
    u_char idlen;		/* ID length */
    u_char type;		/* type (with bits) */
    u_char vers;		/* version */
    u_char res;			/* Reserved */
    u_char maa;			/* Maximum area addresses */
    union {
	struct iih_header {	/* IS to IS Hello header */
	    u_char cirt;	/* reserved/circuit type */
	    u_char srcid[6];	/* source ID */
	    u_char hold[2];	/* holding timer */
	    u_char len[2];	/* PDU length */
	    union {
		struct lan_header {	/* LAN IIH header */
		    u_char pri;		/* priority */
		    u_char lanid[7];	/* LAN id */
		} lan_iih_hun;
		struct p2p_header {	/* P2P IIH header */
		    u_char locid;	/* local circuit ID */
		} p2p_iih_hun;
	    } _iih_hun;
	} iih_hun;
	struct lsp_header {	/* Link State PDU header */
	    u_char len[2];	/* PDU length */
	    u_char life[2];	/* remaining lifetime */
	    u_char lspid[8];	/* LSP ID */
	    u_char seq[4];	/* sequence number */
	    u_char chk[2];	/* checksum */
	    u_char flags;	/* flags */
	} lsp_hun;
	struct csnp_header {	/* Complete Sequence Number PDU header */
	    u_char len[2];	/* PDU length */
	    u_char srcid[7];	/* source ID */
	    u_char slspid[8];	/* start LSP ID */
	    u_char elspid[8];	/* end LSP ID */
	} csnp_hun;
	struct psnp_header {	/* Partial Sequence Number PDU header */
	    u_char len[2];	/* PDU length */
	    u_char srcid[7];	/* source ID */
	} psnp_hun;
    } _hun;
};

#define iih	_hun.iih_hun
#define lsp	_hun.lsp_hun
#define csnp	_hun.csnp_hun
#define psnp	_hun.psnp_hun
#define lan_iih	_iih_hun.lan_iih_hun
#define p2p_iih	_iih_hun.p2p_iih_hun

struct lsp_entry {	/* LSP entry */
    u_char life[2];	/* remaining lifetime */
    u_char lspid[8];	/* LSP ID */
    u_char lspseq[4];	/* LSP sequence number */
    u_char chk[2];	/* checksum */
};

