/* Transport & Session protocols defines */

/* Transport */

#define TP_TYPE_MASK	0xf0	/* 1110 xxxx */
#define TP_ED_PDU	0x10	/* Expedited Data */
#define TP_ED_MASK	0xff	/* 0001 0000 */
#define TP_EA_PDU	0x20	/* Expedited Data Acknowledge */
#define TP_EA_MASK	0xff	/* 0010 0000 */
#define TP_UD_PDU	0x40	/* Unidata */
#define TP_UD_MASK	0xff	/* 0100 0000 */
#define TP_RJ_PDU	0x50	/* Reject */
#define TP_AK_PDU	0x60	/* Data Acknowledge */
#define TP_ER_PDU	0x70	/* TPDU Error */
#define TP_ER_MASK	0xff	/* 0111 0000 */
#define TP_DR_PDU	0x80	/* Disconnect Request */
#define TP_DR_MASK	0xff	/* 1000 0000 */
#define TP_DC_PDU	0xc0	/* Disconnect Confirm */
#define TP_DC_MASK	0xff	/* 1100 0000 */
#define TP_CC_PDU	0xd0	/* Connection Confirm */
#define TP_CR_PDU	0xe0	/* Connection Request */
#define TP_DT_PDU	0xf0	/* Data */
#define TP_DT_MASK	0xff	/* 1111 0000 */
#define TP_PI_PDU	0x01	/* Protocol Identification */
#define TP_PI_MASK	0xff	/* 0000 0001 */

#define TP_MAX_HLEN	254
#define TP_VERSION	1

#define TP_CLASS0	0x00	/* class 0 */
#define TP_CLASS1	0x10	/* class 1 */
#define TP_CLASS2	0x20	/* class 2 */
#define TP_CLASS3	0x30	/* class 3 */
#define TP_CLASS4	0x40	/* class 4 */
#define TP_CLO_EXT	0x02	/* extended format */
#define TP_CLO_FLC	0x01	/* flow control */

#define TP_PAR_AKT	0x85	/* acknowledge time parameter */
#define TP_PAR_RERR	0x86	/* residual error rate parameter */
#define TP_PAR_PRI	0x87	/* priority parameter */
#define TP_PAR_TRDL	0x88	/* transit delay parameter */
#define TP_PAR_THR	0x89	/* throughput parameter */
#define TP_PAR_SUB	0x8a	/* sub-sequence number parameter */
#define TP_PAR_TTR	0x8b	/* reassignment time parameter */
#define TP_PAR_FLOW	0x8c	/* flow control confirmation parameter */
#define TP_PAR_SIZE	0xc0	/* TPDU max size parameter */
#define TP_PAR_INV	0xc1	/* invalid TPDU parameter */
#define TP_PAR_I_ID	0xc1	/* calling TSAP-ID parameter */
#define TP_PAR_E_ID	0xc2	/* called TSAP-ID parameter */
#define TP_PAR_CKM	0xc3	/* checksum parameter */
#define TP_PAR_VER	0xc4	/* version number parameter */
#define TP_PAR_PRO	0xc5	/* protection parameter */
#define TP_PAR_OPT	0xc6	/* additional option selection parameter */
#define IP_PAR_ACL	0xc7	/* alternative protocol class parameter */
#define TP_PAR_PISH	0xdf	/* protocol sharing parameter */
#define TP_PAR_ADDI	0xe0	/* additional info parameter */
#define TP_PAR_EXT	0xff	/* extension parameter */

#define TP_OPT_NED	0x08	/* use of network expedited data */
#define TP_OPT_AK	0x04	/* use of explicit AK */
#define TP_OPT_CKM	0x02	/* use of checksum */
#define TP_OPT_TED	0x01	/* use of transport expedited data */

#define TP_DRC_NDISC	0x80	/* normal disconnect */
#define TP_DRC_CONG	0x81	/* remote congestion */
#define TP_DRC_NEG	0x82	/* negotiation failed */
#define TP_DRC_DUP	0x83	/* duplicate src-ref */
#define TP_DRC_MIS	0x84	/* mismatched refs */
#define TP_DRC_PROT	0x85	/* protocol error */
#define TP_DRC_ROVF	0x87	/* ref overflow */
#define TP_DRC_NET	0x88	/* network connection refused */
#define TP_DRC_LEN	0x8a	/* bad length in heading */
#define TP_DRC_NSP	0x00	/* not specified */
#define TP_DRC_TCONG	0x01	/* TSAP congestion */
#define TP_DRC_SESS	0x02	/* session not attached */
#define TP_DRC_ADDR	0x03	/* address unknown */

#define TP_ERR_NSP	0x00	/* not specified */
#define TP_ERR_PARC	0x01	/* invalid parameter code */
#define TP_ERR_TYPE	0x02	/* invalid TPDU type */
#define TP_ERR_PARV	0x03	/* invalid parameter value */

#define TP_PI_OSI	0x01	/* OSI transport protocol */
#define TP_PI_SHARE	0x01	/* sharing allowed */

/* Session */

#define SS_ER_PDU	0	/* Exception Report */
#define SS_DT_PDU	1	/* Data Transfert */
#define SS_GT_PDU	1	/* Give Tokens */
#define SS_PT_PDU	2	/* Please Tokens */
#define SS_EX_PDU	5	/* Expedited */
#define SS_PR_PDU	7	/* Prepare */
#define SS_NF_PDU	8	/* Not Finished */
#define SS_FN_PDU	9	/* Finish */
#define SS_DN_PDU	10	/* Disconnect */
#define SS_RF_PDU	12	/* Refuse */
#define SS_CN_PDU	13	/* Connect */
#define SS_AC_PDU	14	/* Accept */
#define SS_CDO_PDU	15	/* Connect Data Overflow */
#define SS_OA_PDU	16	/* Overflow Accept */
#define SS_GTC_PDU	21	/* Give Tokens Confirm */
#define SS_GTA_PDU	22	/* Give Tokens Ack */
#define SS_AB_PDU	25	/* Abort */
#define SS_AI_PDU	25	/* Activity Interrupt */
#define SS_AA_PDU	26	/* Abort Accept */
#define SS_AIA_PDU	26	/* Activity Interrupt Ack */
#define SS_AR_PDU	29	/* Activity Resume */
#define SS_TD_PDU	33	/* Typed Data */
#define SS_RA_PDU	34	/* Resynchronize Ack */
#define SS_MAP_PDU	41	/* Major Sync Point */
#define SS_AE_PDU	41	/* Activity End */
#define SS_MAA_PDU	42	/* Major Sync Ack */
#define SS_AEA_PDU	42	/* Activity End Ack */
#define SS_AS_PDU	45	/* Activity Start */
#define SS_ED_PDU	48	/* Exception Data */
#define SS_MIP_PDU	49	/* Minor Sync Point */
#define SS_MIA_PDU	50	/* Minor Sync Ack */
#define SS_RS_PDU	53	/* Resynchronize */
#define SS_AD_PDU	57	/* Activity Discard */
#define SS_ADA_PDU	58	/* Activity Discard Ack */
#define SS_CD_PDU	61	/* Capability Data */
#define SS_CDA_PDU	62	/* Capability Data Ack */
