#include "insmod.h"

static char *dataseg;

static void
aout_relocate(char *seg, int segsize, int len, FILE *fp)
{
	struct relocation_info rel;
	unsigned long val;
	struct symbol *sp;

	while ((len -= sizeof rel) >= 0) {
		fread(&rel, sizeof rel, 1, fp);
#ifdef DEBUG
		printf("relocate %s:%u\n", seg == textseg? "text" : "data",
			rel.r_address);
#endif
		if (rel.r_address < 0 || rel.r_address >= segsize) {
			fprintf(stderr, "Bad relocation\n");
			exit(2);
		}
		if (rel.r_length != 2) {
			fprintf(stderr, "Unimplemented relocation:  r_length = %d\n", rel.r_length);
			exit(2);
		}
		val = * (long *) (seg + rel.r_address);
		if (rel.r_pcrel) {
			val -= addr;
#ifdef DEBUG
			printf("pc relative\n");
#endif
		}
		if (rel.r_extern) {
			if (rel.r_symbolnum >= nsymbols) {
				fprintf(stderr, "Bad relocation\n");
				exit(2);
			}
			sp = symtab + rel.r_symbolnum;
			val += sp->u.n.n_value;
			if ((sp->u.n.n_type &~ N_EXT) != N_ABS)
				val += addr;
		} else if (rel.r_symbolnum != N_ABS) {
			val += addr;
		}
		* (long *) (seg + rel.r_address) = val;
	}
}

void
relocate_aout(FILE *fp)
{
	struct exec *aouthdr = (struct exec *)&header;

	fseek(fp, N_TRELOFF((*aouthdr)), SEEK_SET);
	aout_relocate(textseg, aouthdr->a_text, aouthdr->a_trsize, fp);
	aout_relocate(dataseg, aouthdr->a_data, aouthdr->a_drsize, fp);
}

char *
load_aout(FILE *fp)
{
	struct exec *aouthdr = (struct exec *)&header;
	struct symbol *sp;
	long filesize;
	int i;
	int len;

	codesize = aouthdr->a_text + aouthdr->a_data;

	/* read in text and data segments */
	fseek(fp, sizeof(struct exec), SEEK_SET);
	textseg = (char*) ckalloc(codesize);
	fread(textseg, codesize, 1, fp);
	if (feof(fp) || ferror(fp))
		return "Error reading object";
	dataseg = textseg + aouthdr->a_text;

	/* read in the symbol table */
	fseek(fp, 0L, SEEK_END);
	filesize = ftell(fp);
	fseek(fp, N_SYMOFF((*aouthdr)), SEEK_SET);
	nsymbols = aouthdr->a_syms / sizeof (struct nlist);
	symtab = (struct symbol*) ckalloc(nsymbols * sizeof (*symtab));

	for (i = nsymbols, sp = symtab ; --i >= 0 ; sp++) {
		fread(&sp->u.n, sizeof sp->u.n, 1, fp);
		sp->child[0] = sp->child[1] = NULL;
	}

	if (feof(fp) || ferror(fp))
		return "Error reading object";

	len = filesize - N_STROFF((*aouthdr));
	stringtab = (char*) ckalloc(len);
	fread(stringtab, len, 1, fp);

	if (feof(fp) || ferror(fp))
		return "Error reading object";

	for (i = nsymbols, sp = symtab ; --i >= 0 ; sp++) {
		int pos;
		char *name = stringtab + sp->u.n.n_un.n_strx;

		pos = sp->u.n.n_un.n_strx;
		if (pos < 0 || pos >= len)
			return "Bad nlist entry";
		/* look up name and add sp to binary tree */
		findsym(name, sp, strncmp);
		if ((sp->u.n.n_type & N_EXT) && (sp->u.n.n_type != N_EXT))
			sp->u.n.n_other = DEF_BY_MODULE; /* abuse: mark extdef */
		else {
			sp->u.n.n_other = 0; /* abuse: mark extref */
		}
	}

	aout_flag = 1;
	return (char *)0;
}
