/*
 *	Super-block structure for user-level filesystem support.
 */

#ifndef _LINUX_USERFS_FS_SB
#define _LINUX_USERFS_FS_SB

#include <linux/fs.h>

#define USERFS_SUPER_MAGIC	0x73757265

struct userfs_sb_info
{
  struct file	*s_toproc;      /* To user process */
  struct file	*s_fromproc;    /* From user process */
  int		s_seq;          /* Sequence number */
  up_handle	s_root;         /* root of mounted fs */
  struct inode_operations *s_iops; /* inode ops for this fs */

  /* These are for serialising access to pipe */
  char		s_lock;
  struct wait_queue	*s_wait;

  /* This is for multiple outstanding operations */
  int		s_canread;      /* there is something reading */
  int		s_nwproc;       /* number of processes waiting */
  struct pwlist	*s_wlist;       /* list of waiting processes */
};

extern struct
super_block *userfs_read_super(struct super_block *, void *, int);

#endif /* _LINUX_USERFS_FS_SB */
