#include <stdio.h>
#include <sys/stat.h>
#include <fcntl.h>

/*
 * Find the major number for the device with a given name.
 */

int lookup_dev(char *name)
{
    FILE *f;
    int n;
    char s[80];
    char t[80];

    f = fopen("/proc/devices", "r");
    if (f == NULL)
	return -1;
    while (fgets(s, sizeof(s), f) != NULL) {
	if ((sscanf(s, "%d %s", &n, t) == 2)
	    && (strcmp(name, t) == 0)) {
	    fclose(f);
	    return n;
	}
    }
    fclose(f);
    return -1;
}

/*
 * Open a device given its dev_t
 */

int open_dev(dev_t dev)
{
    char *fn;
    int fd;

    if ((fn = tmpnam(NULL)) == NULL)
	return -1;
    if (mknod(fn, S_IFCHR | S_IREAD | S_IWRITE, dev) != 0)
	return -1;
    fd = open(fn, O_RDWR);
    unlink(fn);
    return fd;
}
