#!/bin/bash

# start by building all the rpms
# when everything but rpmdb is built, build the i686 and athlon targets
# make sure dontcopy.list is up to date
# copy
# rpmdb
# copy
# sign
# installer
# then you are ready for a network install

# /usr/lib/anaconda-runtime/check-repository.py

function beep
{
   /bin/echo -en \\a
}

function sign_unsigned_rpm
{
   unsigned=
   for dir in $* ; do
      for i in $dir/*.rpm ; do
         if ! rpm -Kv $i | grep -q "Good signature from.*$KEY" ; then
            unsigned="$unsigned $i"
         fi
      done
   done

   if [ -n "$unsigned" ] ; then
      echo $unsigned
      beep
      command="rpm $macro --resign $unsigned"
      echo $command
      eval "$command" 
   fi

}

function resign_rpm
{
   unsigned="$1"
   if [ -n "$unsigned" ] ; then
      echo $unsigned
      beep
      command="rpm $macro --resign $unsigned"
      echo $command
      eval "$command" 
   fi
}

if [ -d "$1" ] ; then
   cd $1

   topdir=`pwd`/redhat
   if [ `whoami` != "root" ] ; then
      export rpmdbversion=$(grep release_version ~/.rpmmacros | cut -d " " -f2)
   fi

   # load a config file to override .rpmmacros
   if [ -f config ] ; then
      . config
      export VENDOR DISTRIBUTION VERSION NAME KEY
   fi
   macro=""
   [ "$VERSION" ]      && macro="$macro --define \"release_version $VERSION\" "
   [ "$NAME" ]         && macro="$macro --define \"release_name $NAME\" "
   [ "$VENDOR" ]       && macro="$macro --define \"vendor $VENDOR\" "
   [ "$DISTRIBUTION" ] && macro="$macro --define \"distribution $DISTRIBUTION\" "
   [ "$KEY" ]          && macro="$macro --define \"_gpg_name $KEY\" "

   mkdir -p $topdir/BUILD
   mkdir -p $topdir/RPMS
   mkdir -p $topdir/SOURCES
   mkdir -p $topdir/SPECS
   mkdir -p $topdir/SRPMS

   mkdir -p logs
   mkdir -p done
   mkdir -p extra

   if [ "$2" ] ; then
      if [ "$2" = "i686" ] ; then
         list=`cat $2.list`
         for i in $list ; do
            mv done/$i $i
         done
         target="--target $2"
      elif [ "$2" = "athlon" ] ; then
         list=`cat $2.list`
         for i in $list ; do
            mv done/$i $i
         done
         target="--target $2"
      elif [ "$2" = "i386" ] ; then
         list=`cat $2.list`
         for i in $list ; do
            mv done/$i $i
         done
         target="--target $2"
      elif [ "$2" = "copy" ] ; then
         list=
         mkdir -p /tmp/$1/i386/RedHat/RPMS
         mkdir -p /tmp/$1/i386/RedHat/base
         ln -s RedHat /tmp/$1/i386/CentOS
         cp -fv redhat/RPMS/*/* /tmp/$1/i386/RedHat/RPMS
         cp -fv extra/*.rpm /tmp/$1/i386/RedHat/RPMS
         cp readme.txt /tmp/$1
         for jointfiles in COPYING RPM-GPG-KEY RELEASE-NOTES README autorun ; do
            cp -fv extra/$jointfiles /tmp/$1/i386
         done
         if [ -f comps ] ; then
            cp -f comps /tmp/$1/i386/RedHat/base
         fi
         if [ -f dontcopy.list ] ; then
            for f in `cat dontcopy.list` ; do
               rm -f /tmp/$1/i386/RedHat/RPMS/$f
            done
         fi
      elif [ "$2" = "signdist" ] ; then
         list=
         sign_unsigned_rpm /tmp/$1/i386/RedHat/RPMS/
      elif [ "$2" = "sign" ] ; then
         list=
         sign_unsigned_rpm redhat/RPMS/*
      elif [ "$2" = "check" ] ; then
         list=
         /usr/lib/anaconda-runtime/check-repository.py /tmp/$1/i386/
         ../../rpmlist file://tmp/$1/i386/RedHat/RPMS/ | grep ^-
         for i in `ls /tmp/$1/i386/RedHat/RPMS/*.rpm` ; do
            #rpm -K $i | grep -v gpg
            rpm -Kv $i | grep -q "Good signature from.*$KEY" || echo "$i not signed by $KEY"
            rpm -qp --queryformat "%{VENDOR}-%{DISTRIBUTION} " $i | grep -v "$VENDOR-$DISTRIBUTION" && echo $i
         done
      elif [ "$2" = "floppy" ] ; then
         list=
         dd if=/tmp/$1/i386/images/bootnet.img of=/dev/fd0 bs=512
      elif [ "$2" = "cd" ] ; then
         list=
         rm -rf /tmp/$1/SRPMS
         rm -rf /tmp/$1/i386/CentOS/headers
         /usr/lib/anaconda-runtime/splitdistro --fileorder /tmp/$1/pkgorder.txt /tmp/$1 i386 || exit

         /usr/lib/anaconda-runtime/genhdlist --fileorder /tmp/$1/pkgorder.txt --withnumbers /tmp/$1/i386-disc[1-2]

         # fixup RedHat -> CentOS dir
         rm -f /tmp/$1/i386/RedHat/RedHat
         rm /tmp/$1/i386-disc1/CentOS
         mv /tmp/$1/i386-disc1/RedHat /tmp/$1/i386-disc1/CentOS
         mv /tmp/$1/i386-disc2/RedHat /tmp/$1/i386-disc2/CentOS
#         rm -rf /tmp/$1/i386-disc1/CentOS/headers
         rm -rf /tmp/$1/isos
         mkdir /tmp/$1/isos

         if [ -f /tmp/$1/i386-disc1/dosutils/autoboot/cdboot.img ] ; then
            boot_file="-c boot.cat -b dosutils/autoboot/cdboot.img"
         elif [ -f /tmp/$1/i386-disc1/isolinux/isolinux.bin ] ; then
            boot_file="-b isolinux/isolinux.bin -c isolinux/boot.cat -no-emul-boot -boot-load-size 4 -boot-info-table"
         else
            boot_file="-c boot.cat -b images/boot.img"
         fi
         echo "Using '$boot_file' to boot from CD"
         mkisofs -quiet -r -J -T -V "$DISTRIBUTION $rpmdbversion disc 1" $boot_file -o /tmp/$1/isos/i386-disc1.iso /tmp/$1/i386-disc1
         mkisofs -quiet -r -J -T -V "$DISTRIBUTION $rpmdbversion disc 2" -o /tmp/$1/isos/i386-disc2.iso /tmp/$1/i386-disc2

         # clean up the disc directories
         (cd /tmp/$1/i386-disc1 ; find . > /tmp/$1/isos/i386-disc1.list )
         (cd /tmp/$1/i386-disc2 ; find . > /tmp/$1/isos/i386-disc2.list )
#         rm -rf /tmp/$1/i386-disc1 /tmp/$1/i386-disc2
#         rm -rf /tmp/$1/i386-disc3 /tmp/$1/i386-disc4
         beep
         (cd /tmp/$1/isos ; md5sum *.iso | gpg --clearsign --armor --default-key $KEY -o MD5SUMS)
      elif [ "$2" = "dist" ] ; then
         list=
         if [ "$IS_DIST" = "yes" ] ; then
            cd ..
            $0 $1 clean
            $0 $1 copy
            $0 $1 blend
            $0 $1 rpmdb
            $0 $1 rpmdbcopy
#            $0 $1 yumcache
#            $0 $1 yumcachecopy
            $0 $1 signdist
            $0 $1 check
            $0 $1 installer
            $0 $1 cd
            #$0 $1 media
            $0 $1 pub
         else
            echo $1 is not a distribution
         fi
      elif [ "$2" = "blend" ] ; then
         list=
         if [ -x make_blend.sh ] ; then
            ./make_blend.sh > blend.list
         fi
         if [ -f blend.list ] ; then
            # copy in some updates from ??
            pwd
            for blend in `cat blend.list | grep -vf dontcopy.list` ; do
               cp -fv ../$blend /tmp/$1/i386/RedHat/RPMS
            done

            # and remove superceded versions
            for blend in `../../rpmlist file://tmp/$1/i386/RedHat/RPMS | grep ^- | cut -c3-` ; do
               echo "- $blend"
               rm /tmp/$1/i386/RedHat/RPMS/$blend
            done
         fi
      elif [ "$2" = "pub" ] ; then
         list=
         pushd done
         pub_dir=/tmp/$1/SRPMS
         mkdir -p $pub_dir
         if [ "$PUBLISH" = "all" ] ; then
            rm -f $pub_dir/original.txt $pub_dir/modified.txt
         else
            echo "Only non-original and modified RPMS are included here." > $pub_dir/original.txt
            echo "Some SRPM have been modified to ensure that they build correctly (eg tetex)." >> $pub_dir/original.txt
            echo "Others have been modified to remove trademark issues (eg anaconda)." >> $pub_dir/original.txt
            echo "Original SRPM can be found on mirror.centos.org, ftp.redhat.com or rpmfind.net" >> $pub_dir/original.txt
            echo "Source to updates can be found in the updates directory." >> $pub_dir/original.txt
         fi
         KEY_=${KEY}
         unset KEY
         sign_unsigned_rpm .
         KEY=${KEY_}
         for rpm in *.rpm ; do
            echo -n "$rpm "
            if [ "$PUBLISH" = "all" ] ; then
               if rpm -qp --qf "%{buildhost}\n" $rpm | grep -q "it.swin.edu.au" ; then
                  echo modified
                  echo $rpm >> $pub_dir/modified.txt
                  if rpm -K $rpm | grep -q gpg ; then
                     cp -p $rpm $pub_dir
                  else
                     echo "$rpm not signed"
                  fi
               else
                  echo orig
                  echo $rpm >> $pub_dir/original.txt
               fi
            else
               if [ -f $UPSTREAM/$rpm ] ; then
                  if cmp -s $UPSTREAM/$rpm $rpm ; then
                     echo orig
                     echo $rpm >> $pub_dir/original.txt
                  else
                     echo modified
                     cp -p $rpm $pub_dir
                  fi
               else
                  echo new
                  cp -p $rpm $pub_dir
               fi
            fi
         done
         echo "Packages installed in the bender build environment" > $pub_dir/build_env.txt
         rpm -qa --queryformat "%{NAME} %{NAME}-%{VERSION}-%{RELEASE}\n" | sort >> $pub_dir/build_env.txt
         popd
      elif [ "$2" = "kernel" ] ; then
         if [ -f kernel-2.4.9-e.*.src.rpm ] ; then
            list=$(echo kernel-2.4.9-e.*.src.rpm)
         fi
         pushd ..
         #target="--target i386 --with up --without smp --with BOOT --without enterprise --without summit --without debug"
         #target="$target" $0 $1 $list
         #mv $1/done/$list $1/$list

#         target="--target i686 --with up --with smp --without BOOT --with enterprise --with summit --with debug"
#         target="$target" $0 $1 $list
#         mv $1/done/$list $1/$list

         target="--target athlon --with up --with smp --without BOOT --without enterprise --without summit --without debug"
         target="$target" $0 $1 $list
         mv $1/done/$list $1/$list

         popd



         exit
      elif [ "$2" = "rpmdb" ] ; then
         if [ `whoami` = "root" ] ; then
            rm -f redhat/RPMS/i386/rpmdb*.i386.rpm
            rm -f /tmp/$1/i386/RedHat/RPMS/rpmdb*.i386.rpm
            if [ -f done/rpmdb*.src.rpm ] ; then
               mv done/rpmdb*.src.rpm .
            fi
            list=rpmdb*.src.rpm
            target="--define \"rpmdbname redhat\" \
                    --define \"rpmdbversion $rpmdbversion\" \
                    --define \"rpmdbtree/tmp/$1\""
         else
            cd ..
            su -c "$0 $*"
            exit
         fi
      elif [ "$2" = "rpmdbcopy" ] ; then
         beep
         resign_rpm redhat/RPMS/i386/rpmdb-redhat-*.rpm
         # rpm --resign redhat/RPMS/i386/rpmdb-redhat-*.rpm
         cp -fv redhat/RPMS/i386/rpmdb-redhat-*.rpm /tmp/$1/i386/RedHat/RPMS
      elif [ "$2" = "installer" ] ; then
         if [ `whoami` = "root" ] ; then
            list=
            /usr/lib/anaconda-runtime/genhdlist /tmp/$1/i386/
            /usr/lib/anaconda-runtime/buildinstall --pkgorder /tmp/$1/pkgorder.txt --version $rpmdbversion /tmp/$1/i386/
            chown --reference=/tmp/$1 -R /tmp/$1/*
            chmod u+w /tmp/$1/i386/isolinux/isolinux.bin
         else
            cd ..
            su -c "$0 $*"
            exit
         fi
      elif [ "$2" = "clean" ] ; then
         if [ `whoami` = "root" ] ; then
            list=
            rm -rf /tmp/$1
         else
            cd ..
            su -c "$0 $*"
            exit
         fi
      elif [ "$2" = "yumcache" ] ; then
         # this is currently centos specific...
         #(cd /tmp/centos2update/ ; yum-arch .)
         #(cd /tmp/centos2/i386/CentOS/ ; yum-arch .)
         rm -f redhat/RPMS/noarch/centos-yumcache*.noarch.rpm
         rm -f /tmp/$1/i386/RedHat/RPMS/centos-yumcache*.noarch.rpm
         if [ -f done/centos-yumcache*.src.rpm ] ; then
            mv done/centos-yumcache*.src.rpm .
         fi
         list=centos-yumcache*.src.rpm
         target="--define \"base_cachepatch /tmp/centos2/i386/CentOS/\" \
                 --define \"update_cachepatch /tmp/centos2update/\""
      elif [ "$2" = "yumcachecopy" ] ; then
         beep
         resign_rpm redhat/RPMS/noarch/centos-yumcache-*.rpm
         #rpm --resign redhat/RPMS/noarch/centos-yumcache-*.rpm
         if [ -d /tmp/$1/i386/RedHat/RPMS ] ; then
            cp -fv redhat/RPMS/noarch/centos-yumcache-*.rpm /tmp/$1/i386/RedHat/RPMS
         else
            cp -fv redhat/RPMS/noarch/centos-yumcache-*.rpm /tmp/$1/i386/CentOS/RPMS
         fi
         list=
      elif [ "$2" = "media" ] ; then
         if [ `whoami` = "root" ] ; then
            list=
            for disc in 1 2 ; do
               /bin/echo -n "Insert blank disc $disc and press Enter"
               read ready
               cdrecord dev=0,0,0 -v speed=32 --eject /tmp/$1/i386-disc$disc.iso
            done
         else
            cd ..
            su -c "$0 $*"
            exit
         fi
      else
         list=$2
      fi
   else
      list=*.rpm
   fi

   for i in $list ; do
      log=logs/$i.log
      echo "Starting $i" | tee -a $log
      date >> $log
      command="rpmbuild --define _topdir$topdir $target $macro --rebuild $i"
      echo $command
      eval "$command" < /dev/null >> $log 2>&1 && mv $i done || echo "Failed"
      echo "Finished $i" >> $log
      date >> $log
      /bin/echo -n "RPM built    "
      ls done/*.rpm 2>/dev/null | wc --lines
      /bin/echo -n "RPM remaining"
      ls *.rpm 2>/dev/null | wc --lines
   done
else
   # can we convert asdf/qwer into asdf qwer?
   space=${1/\// }
   if [ "$space" = "$1" ] ; then
      echo "Usage: $0 directory [.src.rpm filename|i686|athlon|clean|copy|sign|floppy|cd|dist|pub|rpmdb|rpmdbcopy|installer|clean|mdeia]"
   else
      $0 $space
   fi
fi
