/*
 * PnP, ISA Plug'n'Play configuration manager
 * Copyright 1996, David Howells (dwh@nexor.co.uk)
 * 
 * For more information, please consult 
 * 
 * Plug and Play ISA Specification
 * (c) 1993/4 Intel/Microsoft
 *
 */

#ifndef LINUX_PNP_IF_H
#define LINUX_PNP_IF_H

#include <linux/types.h>
#include <linux/pnp.h>

/* auto-configuration ports */
#define PNP_ADDRESS_PORT 0x279
#define PNP_WRITE_DATA_PORT 0x0A79
#define PNP_READ_DATA_PORT_FIRST 0x0203
#define PNP_READ_DATA_PORT_LAST 0x03FF

/* current read port */
extern u_short pnp_isa_rdport;
#define inpnp() inb(pnp_isa_rdport)
#define outpnp(data) outb(data,PNP_WRITE_DATA_PORT)
#define addrpnp(address) outb(address,PNP_ADDRESS_PORT)

/*===========================================================================*/
/* config registers */
enum PNP_REGISTERS {
    /* card level regs */
    PNPREG_SET_RD_DATA,			/* 0x00 */
    PNPREG_SERIAL_ISOLATION,		/* 0x01 */
    PNPREG_CONFIG_CONTROL,		/* 0x02 */
    PNPREG_WAKE,			/* 0x03 */
    PNPREG_RESOURCE_DATA,		/* 0x04 */
    PNPREG_STATUS,			/* 0x05 */
    PNPREG_CARD_SELECT,			/* 0x06 */
    PNPREG_LOGICAL_DEVICE_SELECT,	/* 0x07 */
    PNPREG_CL_RESV_0,			/* 0x08..0x1F */
    PNPREG_CL_RESV_N = 0x1F,
    PNPREG_CL_VENDOR_0,			/* 0x20..0x2F */
    PNPREG_CL_VENDOR_N = 0x2F,

    /* logical device control regs */
    PNPREG_ACTIVATE,			/* 0x30 */
    PNPREG_IO_RANGE_CHECK,		/* 0x31 */
    PNPREG_LDC_RESV_0,			/* 0x32..0x37 */
    PNPREG_LDC_RESV_N = 0x37,
    PNPREG_LDC_VENDOR_0, 		/* 0x38..0x3F */
    PNPREG_LDC_VENDOR_N = 0x3F,

    /* config regs */
    PNPREG_MEM_0 = 0x40,		/* memory space */
    PNPREG_MEM_1 = 0x48,
    PNPREG_MEM_2 = 0x50,
    PNPREG_MEM_3 = 0x58,
    PNPREG_IO_0 = 0x60,			/* io ports */
    PNPREG_IO_1 = 0x62,
    PNPREG_IO_2 = 0x64,
    PNPREG_IO_3 = 0x66,
    PNPREG_IO_4 = 0x68,
    PNPREG_IO_5 = 0x6A,
    PNPREG_IO_6 = 0x6C,
    PNPREG_IO_7 = 0x6E,
    PNPREG_IRQ_0 = 0x70,		/* interrupts */
    PNPREG_IRQ_1 = 0x72,
    PNPREG_DMA_0 = 0x74,		/* dma */
    PNPREG_DMA_1 = 0x75,
    PNPREG_MEM32_0 = 0x76,		/* 32-bit memory space */
    PNPREG_MEM32_1 = 0x80,
    PNPREG_MEM32_2 = 0x90,
    PNPREG_MEM32_3 = 0xA0,

    PNPREG_LDC_RESV1_0 = 0xA9,
    PNPREG_LDC_RESV1_N = 0xEF,
    PNPREG_LDC_VENDOR1_0 = 0xF0,
    PNPREG_LDC_VENDOR1_N = 0xFE,
    PNPREG_RESV = 0xFF
};

/*===========================================================================*/
/* plug and play resource data-type type */
enum PNP_RES_TAG_TYPE {
    PNP_SMALL_TAG = 0x00,
    PNP_LARGE_TAG = 0x01
};

/* plug and play small resource data tags */
enum PNP_SMALL_RES_TAG {
    PNPSTAG_RESV0,
    PNPSTAG_PNPVERSION,
    PNPSTAG_LOGICAL_DEV_ID,
    PNPSTAG_COMPATIBLE_DEV_ID,
    PNPSTAG_IRQ,
    PNPSTAG_DMA,
    PNPSTAG_START_DEP,
    PNPSTAG_END_DEP,
    PNPSTAG_IO,
    PNPSTAG_IO_FIXED,
    PNPSTAG_RESVA,
    PNPSTAG_RESVB,
    PNPSTAG_RESVC,
    PNPSTAG_RESVD,
    PNPSTAG_VENDOR_DEF,
    PNPSTAG_END
};

/* plug and play small resource data tags */
enum PNP_LARGE_RES_TAG {
    PNPLTAG_RESV0,
    PNPLTAG_MEM,
    PNPLTAG_ANSI_ID,
    PNPLTAG_UNICODE_ID,
    PNPLTAG_VENDOR_DEF,
    PNPLTAG_MEM32,
    PNPLTAG_MEM32_FIXED
};

#endif LINUX_PNP_IF_H
