/* This file is part of the KDE project
 *
 * Copyright (C) 2001 George Staikos <staikos@kde.org>
 * Copyright (C) 2001 Fernando Llobregat <fernando.llobregat@free.fr>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <klocale.h>
#include <kcmdlineargs.h>
#include <kapplication.h>
#include <kaboutdata.h>
#include <kmessagebox.h>
#include <kmainwindow.h>
#include "kcardchoosermain.h"


static KCmdLineOptions options[] =
{
	{ "slot <slot>", I18N_NOOP("Slot name of the card in question."), 0 },
	{ "atr <atr>", I18N_NOOP("ATR of the card in question."), 0 },
	{ 0, 0, 0}
};




int main(int argc, char **argv) {
  KAboutData aboutData("kcardchooser", I18N_NOOP("KCardChooser"),
		      "1.0", I18N_NOOP("KDE Smartcard Chooser"), 
		      KAboutData::License_GPL, "(c) 2001, George Staikos");
  aboutData.addAuthor("George Staikos", 0, "staikos@kde.org");
  aboutData.addAuthor("Fernando Llobregat",0,"fernando.llobregat@free.fr");
  KCmdLineArgs::init( argc, argv, &aboutData );
  KCmdLineArgs::addCmdLineOptions( options );
  KCmdLineArgs *args = KCmdLineArgs::parsedArgs();

  KApplication app;

	KMainWindow *mw = new KMainWindow;

	QString caption(i18n("KDE Smartcard Chooser"));
	
	QString slot = args->getOption("slot"); 
	QString atr = args->getOption("atr");
	// TODO: Acutally do something with the attributes
	//	while (slot.isEmpty())
	//  slot = i18n("Please specify a slot:"));  // use KLineEditDlg!


	mw->setCaption(caption);
	KCardChooserMain *chooser = new KCardChooserMain(mw);
	mw->setCentralWidget(chooser);


	chooser->show();
	chooser->setATR(atr);
	chooser->setSlot(slot);

	app.exec();

	delete chooser;
	return 0;
}

