/*  ksim - a system monitor for kde
 *
 *  Copyright (C) 2001  Robbie Ward <linuxphreak@gmx.co.uk>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <kcmdlineargs.h>
#include <kaboutdata.h>
#include <klocale.h>
#include <kapplication.h>

#include "ksim.h"
#include <common.h>
#include "cmdhandler.h"

static const char *const description = I18N_NOOP("A plugin based system monitor"
   " for KDE");

static KCmdLineOptions options[] =
{
  { "+[URLS]", I18N_NOOP("Desktop files to open as plugins."), 0 },
  { "theme <dir>", I18N_NOOP("sets <dir> to current theme."), 0 },
  { "themeAlt <number>", I18N_NOOP("sets <number> to current theme"
       " alternative. \n(Used in conjunction with --theme)"), 0 },
  { "parse-theme <dir>", I18N_NOOP("Parse a theme dir and generate a \n"
                 "gkrellmrc_ksim file that KSim will understand \nbetter and exit."), 0 },
  { "themeFile <file>", I18N_NOOP("used with --parse-theme so it knows \n"
                 "the name of the gkrellmrc file."), 0 },
  { 0, 0, 0 }
};

int main(int argc, char *argv[])
{
  KAboutData aboutData("ksim", I18N_NOOP("KSim"),
     KSIM_VERSION_STRING, description, KAboutData::License_GPL,
     "(C) 2001, Robbie Ward", 0, "http://ksim.sourceforge.net");

  aboutData.addAuthor("Robbie Ward",
     I18N_NOOP("Author and developer"), "linuxphreak@gmx.co.uk");
  aboutData.addAuthor("Jason Katz-Brown",
     I18N_NOOP("Developer"), "jason@katzbrown.com");
  aboutData.addAuthor("Heitham Omar",
     I18N_NOOP("Some FreeBSD ports"), "super_ice@ntlworld.com");
  aboutData.addAuthor("Otto Bruggeman",
     I18N_NOOP("Testing, Bug fixing and some help"), "bruggie@home.nl");
  KCmdLineArgs::init(argc, argv, &aboutData);
  KCmdLineArgs::addCmdLineOptions(options); // Add our own options.

  KApplication app;

  if (app.isRestored()) {
    RESTORE(KSim::MainWindow);
  }
  else {
    KCmdLineArgs *args = KCmdLineArgs::parsedArgs();
    KSim::MainWindow *ksim = 0L;
    KSim::CmdHandler cmdHandler;
    cmdHandler.setThemeAlternatives(args->isSet("themeAlt") ? 
       args->getOption("themeAlt").toInt() : 0);
    cmdHandler.setConfigFileName(args->isSet("themeFile") ?
       args->getOption("themeFile") : QCString("gkrellmrc"));

    if (args->isSet("theme"))
      cmdHandler.themeOption(args->getOption("theme"));

    if (args->isSet("parse-theme")) {
      cmdHandler.parseThemeOption(args->getOption("parse-theme"));
      return 0;
    }

    if (args->count() == 0) {
      ksim = new KSim::MainWindow();
    }
    else {
      KURL::List urlList;
      // collect all the url args into one list
      for (int i = 0; i < args->count(); ++i)
        urlList.append(args->url(i));
      ksim = new KSim::MainWindow(urlList);
    }

    app.setMainWidget(ksim);
    ksim->show();
    args->clear();
  }

  return app.exec();
}
