/***************************************************************************
  mainwindowideal.h  -  KDevelop main widget for IDEAl user interface mode
                             -------------------
    begin                : 22 Dec 2002
    copyright            : (C) 2002 by the KDevelop team
    email                : team@kdevelop.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef _MAINWINDOWIDEAL_H_
#define _MAINWINDOWIDEAL_H_


#include "widgets/ktabwidget.h"


#include <kparts/mainwindow.h>


class KTabZoomWidget;
class MainWindowShare;

#include "kdevtoplevel.h"


class MainWindowIDEAl : public KParts::MainWindow, public KDevTopLevel
{
  Q_OBJECT

public:

  MainWindowIDEAl(QWidget* parent=0, const char *name=0);
  ~MainWindowIDEAl();
    
  void embedPartView(QWidget *view, const QString &title, const QString &toolTip);
  void embedSelectView(QWidget *view, const QString &title, const QString &toolTip);
  void embedOutputView(QWidget *view, const QString &title, const QString &toolTip);
  
  void embedSelectViewRight ( QWidget* view, const QString& title, const QString &toolTip);

  void removeView(QWidget *view);
  void setViewAvailable(QWidget *pView, bool bEnabled);

  void raiseView(QWidget *view);
  void lowerView(QWidget *view);
  void lowerAllViews();

  void loadSettings();

  KMainWindow *main();

  void init();

  void prepareToCloseViews();
  void realClose();

signals:

  void wantsToQuit();

protected:
   /**
   * Pointer to the Window menu. SDI specific. MDI uses the feature of qextmdimainfrm.
   */
   QPopupMenu              *m_pWindowMenu;

public slots:

  void createGUI(KParts::Part *part);
  void gotoNextWindow();
  void gotoPreviousWindow();

  void raiseLeftTabbar();
  void raiseRightTabbar();
  void raiseBottomTabbar();
  void raiseEditor();

private slots:
  void slotQuit();
  void slotBufferSelected();      // One entry of the Windows menu has been selected
  void slotFillWindowMenu();
  void slotPartAdded(KParts::Part*);
  void slotTextChanged();
  void slotUpdateModifiedFlags();

  void slotBottomTabsChanged();
  void slotRightTabsChanged();
  void slotLeftTabsChanged();

private:

  virtual bool queryClose();

  void createStatusBar();
  void createFramework();
  void createActions();

  void saveSettings();

  void moveRelativeTab(int);
  void raiseTabbar( KTabZoomWidget *tabBar );

  KAction *m_raiseLeftBar, *m_raiseRightBar, *m_raiseBottomBar, *m_raiseEditor;

  KTabWidget *m_tabWidget;
  KTabZoomWidget *m_leftBar, *m_rightBar, *m_bottomBar;

  bool m_closing;

  MainWindowShare*   m_pMainWindowShare;
};


#endif
