/* $Id: linux_logo.h,v 1.5 1998/07/30 16:30:40 jj Exp $
 * include/asm-sparc/linux_logo.h: This is a linux logo
 *                                 to be displayed on boot.
 *
 * Copyright (C) 1996 Larry Ewing (lewing@isc.tamu.edu)
 * Copyright (C) 1998 Jakub Jelinek (jj@sunsite.mff.cuni.cz)
 *
 * You can put anything here, but:
 * LINUX_LOGO_COLORS has to be less than 224
 * image size has to be 80x80
 * values have to start from 0x20
 * (i.e. RGB(linux_logo_red[0],
 *	     linux_logo_green[0],
 *	     linux_logo_blue[0]) is color 0x20)
 * BW image has to be 80x80 as well, with MS bit
 * on the left
 * Serial_console ascii image can be any size,
 * but should contain %s to display the version
 */
 
#include <linux/init.h>
#include <linux/version.h>

#define linux_logo_banner "Linux/SPARC version " UTS_RELEASE

#define LINUX_LOGO_COLORS 219

#ifdef INCLUDE_LINUX_LOGO_DATA

unsigned char linux_logo_red[] __initdata = {
  0x03, 0x9E, 0xEC, 0xEE, 0xC4, 0xDA, 0x50, 0xC9,
  0xC5, 0xED, 0x65, 0xE3, 0xE3, 0xF4, 0x24, 0xA4,
  0xEC, 0xEE, 0x94, 0xE5, 0xE3, 0x6A, 0xA6, 0xC4,
  0xDC, 0xE5, 0x13, 0xF3, 0xD1, 0xFD, 0xE2, 0xDB,
  0xA0, 0xC2, 0xEC, 0xB8, 0xC2, 0xD5, 0xF2, 0xF4,
  0xC5, 0x3E, 0xF1, 0x1B, 0x55, 0xF5, 0xCF, 0xF7,
  0xA9, 0xB4, 0xEB, 0x6C, 0x0A, 0x74, 0xB4, 0xF7,
  0xF0, 0xF5, 0xD4, 0xF2, 0xCE, 0xF5, 0xC7, 0x26,
  0x5B, 0xF4, 0xBC, 0x7F, 0xAB, 0x82, 0x94, 0xE5,
  0xFC, 0x3A, 0xF2, 0xFD, 0xF0, 0x1C, 0xEF, 0xD4,
  0xF3, 0x0F, 0xED, 0xF7, 0xC9, 0x49, 0xC3, 0xBA,
  0xC8, 0xD4, 0xE7, 0xF3, 0xF5, 0xA7, 0xEC, 0xF9,
  0xFA, 0x0A, 0xF5, 0xCF, 0xFC, 0xEA, 0xE1, 0xA6,
  0xD6, 0xBC, 0xF8, 0xF7, 0xB4, 0xEB, 0xDC, 0x84,
  0xCE, 0xBA, 0x45, 0xD6, 0x86, 0x50, 0x96, 0xC6,
  0x8C, 0x6E, 0xE8, 0x60, 0x3C, 0x70, 0xF0, 0x93,
  0x7C, 0xDA, 0xDA, 0x9C, 0xBA, 0x6D, 0x4D, 0x2B,
  0x2F, 0x8B, 0xE0, 0xCC, 0xDA, 0x5C, 0x3D, 0xEE,
  0xDB, 0x46, 0xAC, 0x96, 0xCE, 0xD1, 0xE3, 0xF1,
  0x96, 0x7A, 0x80, 0xB2, 0xBA, 0xB6, 0xD2, 0x1E,
  0x7E, 0xAA, 0xC4, 0xF0, 0x96, 0x65, 0x9E, 0xC2,
  0xAA, 0xF5, 0xF2, 0xE9, 0xE6, 0xD1, 0x35, 0xC7,
  0xF6, 0xB6, 0xE8, 0x82, 0xBE, 0xC2, 0xF2, 0x9E,
  0xC7, 0xB4, 0x0F, 0xF7, 0xE8, 0xD8, 0xCC, 0x9C,
  0xD8, 0xD8, 0xA0, 0xEA, 0xC6, 0xA8, 0xE0, 0xEC,
  0xD1, 0xF7, 0xF4, 0xFC, 0x75, 0xBD, 0xDC, 0xDD,
  0xCC, 0xE1, 0xFA, 0xEE, 0xAA, 0xEC, 0xF2, 0xB8,
  0xE2, 0xCD, 0x87
};

unsigned char linux_logo_green[] __initdata = {
  0x03, 0x88, 0xC4, 0xE2, 0x85, 0xC2, 0x44, 0xA3,
  0xA9, 0xD3, 0x65, 0xA6, 0xC5, 0xF3, 0x24, 0xA4,
  0xB4, 0xD6, 0x63, 0xD5, 0xB7, 0x44, 0x86, 0x94,
  0xC2, 0xE4, 0x14, 0xB6, 0xD2, 0xFB, 0xD4, 0xB2,
  0x73, 0x96, 0xDB, 0x92, 0xC2, 0x95, 0xC2, 0xDA,
  0xA4, 0x36, 0xD4, 0x0E, 0x55, 0xF4, 0xC4, 0xE9,
  0x75, 0xB4, 0xBC, 0x52, 0x0A, 0x74, 0x84, 0xEB,
  0xDC, 0xDA, 0xA2, 0xD6, 0x9B, 0xBD, 0xB7, 0x12,
  0x44, 0xCA, 0x8C, 0x65, 0x7B, 0x54, 0x94, 0xAB,
  0xF4, 0x25, 0xC4, 0xFD, 0xE4, 0x1C, 0xDD, 0xAB,
  0xBD, 0x06, 0xCB, 0xD6, 0xCA, 0x33, 0x8C, 0xA2,
  0x92, 0x9C, 0xBC, 0xDB, 0xCD, 0x6E, 0xEC, 0xEE,
  0xBC, 0x03, 0xDA, 0xCE, 0xF4, 0xB6, 0xDB, 0x92,
  0xAD, 0xBC, 0xDE, 0xD5, 0x7B, 0xAE, 0x9D, 0x84,
  0xB6, 0x96, 0x44, 0xBA, 0x6E, 0x3C, 0x7A, 0xB2,
  0x8C, 0x4C, 0xCE, 0x4C, 0x3C, 0x5A, 0xCA, 0x6D,
  0x7C, 0xCE, 0xDA, 0x9C, 0xAA, 0x6D, 0x4D, 0x2B,
  0x1B, 0x5E, 0xCB, 0xAC, 0xBE, 0x5C, 0x2E, 0xDC,
  0xBD, 0x3E, 0xAC, 0x82, 0xB6, 0xBE, 0xD3, 0xBD,
  0x72, 0x62, 0x6C, 0x82, 0x92, 0x9E, 0xB0, 0x13,
  0x4A, 0x8E, 0xBE, 0xCE, 0x86, 0x45, 0x6B, 0xAA,
  0x9A, 0xC5, 0xC6, 0xDA, 0xC5, 0xC4, 0x34, 0x9B,
  0xCC, 0xAC, 0xC4, 0x76, 0x9A, 0x9E, 0xEE, 0x62,
  0xC6, 0x76, 0x0D, 0xE4, 0xDA, 0xD5, 0xA5, 0x92,
  0xCD, 0xB2, 0x7C, 0xCC, 0xBE, 0x7E, 0xDC, 0xD6,
  0xB9, 0xE3, 0xD4, 0xF6, 0x55, 0x82, 0xA4, 0xAA,
  0x8D, 0xBB, 0xCE, 0xD5, 0x8A, 0xDB, 0xD4, 0x8B,
  0xCA, 0x93, 0x63
};

unsigned char linux_logo_blue[] __initdata = {
  0x04, 0x28, 0x10, 0x8C, 0x0B, 0x84, 0x14, 0x1A,
  0x77, 0x1F, 0x64, 0x0E, 0x85, 0xD2, 0x24, 0xA4,
  0x0F, 0x54, 0x0C, 0x7C, 0x3F, 0x04, 0x20, 0x0D,
  0x54, 0xDF, 0x14, 0x0D, 0xD1, 0xE9, 0xB0, 0x11,
  0x0A, 0x40, 0x57, 0x14, 0xC3, 0x0C, 0x04, 0x12,
  0x50, 0x0C, 0x7D, 0x05, 0x55, 0xF2, 0xBA, 0xC7,
  0x09, 0xB4, 0x0E, 0x24, 0x0B, 0x74, 0x0C, 0xB6,
  0x80, 0x48, 0x10, 0x34, 0x0F, 0x0C, 0xA0, 0x04,
  0x19, 0x10, 0x0E, 0x14, 0x0E, 0x05, 0x94, 0x0E,
  0xCA, 0x0B, 0x46, 0xFB, 0xB4, 0x1C, 0x9B, 0x1A,
  0x21, 0x09, 0x14, 0x4D, 0xCB, 0x08, 0x11, 0x7C,
  0x20, 0x10, 0x24, 0x66, 0x79, 0x07, 0xEA, 0xC9,
  0x0C, 0x08, 0x38, 0xC4, 0xD8, 0x24, 0xBE, 0x6C,
  0x51, 0xBB, 0x8C, 0x36, 0x0A, 0x0F, 0x0C, 0x84,
  0x3C, 0x54, 0x44, 0x7C, 0x28, 0x0E, 0x28, 0x7F,
  0x8C, 0x0F, 0x54, 0x24, 0x3C, 0x18, 0x54, 0x17,
  0x7C, 0x9C, 0xDA, 0x9C, 0x7C, 0x6C, 0x4D, 0x2C,
  0x09, 0x0E, 0x8A, 0x50, 0x4C, 0x5B, 0x14, 0xAC,
  0x19, 0x3C, 0xAC, 0x5C, 0x64, 0x97, 0x94, 0x37,
  0x29, 0x3C, 0x44, 0x3C, 0x2C, 0x7C, 0x70, 0x07,
  0x04, 0x29, 0xB2, 0x64, 0x74, 0x07, 0x07, 0x2C,
  0x74, 0x2E, 0x6C, 0xA4, 0x29, 0x9E, 0x34, 0x27,
  0x2F, 0x98, 0x48, 0x5C, 0x0C, 0x5C, 0xE8, 0x04,
  0xC2, 0x0C, 0x0A, 0xB2, 0x74, 0xCB, 0x46, 0x78,
  0xB4, 0x5C, 0x18, 0x80, 0x8C, 0x24, 0xD9, 0xAC,
  0x87, 0x99, 0x1D, 0xE8, 0x14, 0x0D, 0x10, 0x17,
  0x0A, 0x67, 0x3C, 0x68, 0x3C, 0x69, 0x90, 0x22,
  0x6C, 0x0D, 0x17
};

unsigned char linux_logo[] __initdata = {
  0xD8, 0xA3, 0x98, 0x98, 0xA3, 0xB2, 0x2F, 0x2F,
  0xA3, 0x66, 0x98, 0x98, 0x98, 0xA3, 0x2F, 0xA3,
  0x98, 0x55, 0xA0, 0xA3, 0xB2, 0x51, 0x51, 0x2F,
  0x98, 0x55, 0x8F, 0x2F, 0x89, 0x44, 0x89, 0x51,
  0xB2, 0x2F, 0x66, 0xA3, 0x2F, 0x2F, 0x66, 0x66,
  0xA3, 0xB2, 0xB2, 0xB2, 0x89, 0xD8, 0x44, 0x44,
  0xD8, 0x83, 0xD8, 0xA3, 0x98, 0x98, 0xA3, 0xB2,
  0x2F, 0x2F, 0xA3, 0x66, 0x98, 0x98, 0x98, 0xA3,
  0x2F, 0xA3, 0x98, 0x55, 0xA0, 0xA3, 0xB2, 0x51,
  0x51, 0x2F, 0x98, 0x55, 0x8F, 0x2F, 0x89, 0x44,
  0xA3, 0x55, 0x55, 0x98, 0x2F, 0x2F, 0x2F, 0xA3,
  0x66, 0x66, 0x98, 0x98, 0x66, 0x66, 0x66, 0x98,
  0x55, 0xA5, 0x8F, 0xA3, 0x51, 0x51, 0xB2, 0x2F,
  0x66, 0x66, 0xA3, 0x51, 0x89, 0x51, 0xB2, 0x2F,
  0x2F, 0xA3, 0x66, 0xA3, 0xA3, 0xA3, 0x2F, 0x2F,
  0xB2, 0xB2, 0x2F, 0x2F, 0xB2, 0x51, 0x51, 0x51,
  0x51, 0x51, 0xA3, 0x55, 0x55, 0x98, 0x2F, 0x2F,
  0x2F, 0xA3, 0x66, 0x66, 0x98, 0x98, 0x66, 0x66,
  0x66, 0x98, 0x55, 0xA5, 0x8F, 0xA3, 0x51, 0x51,
  0xB2, 0x2F, 0x66, 0x66, 0xA3, 0x51, 0x89, 0x51,
  0x98, 0xA5, 0x55, 0x8F, 0x2F, 0xB2, 0x2F, 0xA3,
  0x66, 0x66, 0x98, 0x8F, 0x66, 0x66, 0x66, 0x98,
  0xA0, 0x8F, 0xA3, 0xB2, 0x51, 0x51, 0xB2, 0x2F,
  0xA3, 0xA3, 0x2F, 0xB2, 0x51, 0xB2, 0x2F, 0x2F,
  0xA3, 0x66, 0x98, 0xA3, 0x51, 0xB2, 0x2F, 0xA3,
  0xB2, 0x51, 0x51, 0xB2, 0xB2, 0x51, 0xB2, 0xB2,
  0xB2, 0x2F, 0x98, 0xA5, 0x55, 0x8F, 0x2F, 0xB2,
  0x2F, 0xA3, 0x66, 0x66, 0x98, 0x8F, 0x66, 0x66,
  0x66, 0x98, 0xA0, 0x8F, 0xA3, 0xB2, 0x51, 0x51,
  0xB2, 0x2F, 0xA3, 0xA3, 0x2F, 0x51, 0x51, 0xB2,
  0xA0, 0xA5, 0x55, 0x66, 0xB2, 0x51, 0xB2, 0xA3,
  0x66, 0x66, 0x98, 0x66, 0x66, 0x66, 0x98, 0x98,
  0x66, 0xA3, 0x2F, 0xB2, 0x51, 0x51, 0xB2, 0xA3,
  0xA3, 0xA3, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0xA3,
  0x66, 0x98, 0xB2, 0x4C, 0x54, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0xCE, 0x2F, 0xB2, 0x2F, 0x2F,
  0xA3, 0x98, 0xA0, 0xA5, 0x55, 0x66, 0xB2, 0x51,
  0xB2, 0xA3, 0x66, 0x66, 0x98, 0x66, 0x66, 0x66,
  0x98, 0x98, 0x66, 0xA3, 0x2F, 0xB2, 0x51, 0x51,
  0xB2, 0xA3, 0xA3, 0xA3, 0x2F, 0x2F, 0x2F, 0x2F,
  0xA0, 0xA0, 0x8F, 0xA3, 0xB2, 0x51, 0xB2, 0x2F,
  0x66, 0x66, 0x98, 0x66, 0x66, 0x66, 0x66, 0x66,
  0xA3, 0x2F, 0x51, 0x51, 0x51, 0xB2, 0x2F, 0xA3,
  0x66, 0x66, 0xA3, 0xA3, 0xA3, 0xA3, 0xA3, 0xA3,
  0x2F, 0xA0, 0xDA, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x9C, 0xB2, 0xA3,
  0x66, 0x98, 0xA0, 0xA0, 0x8F, 0xA3, 0xB2, 0x51,
  0xB2, 0x2F, 0x66, 0x66, 0x98, 0x66, 0x66, 0x66,
  0x66, 0x66, 0xA3, 0x2F, 0x51, 0x51, 0x51, 0xB2,
  0x2F, 0xA3, 0x66, 0x66, 0x66, 0xA3, 0xA3, 0xA3,
  0x8F, 0x8F, 0x66, 0x2F, 0x51, 0x51, 0xB2, 0xA3,
  0x66, 0x98, 0x98, 0x66, 0x66, 0x66, 0x2F, 0x2F,
  0xB2, 0x51, 0xB2, 0xB2, 0x2F, 0x2F, 0xA3, 0x66,
  0x66, 0x66, 0xA3, 0xA3, 0x2F, 0xA3, 0xA3, 0xB2,
  0x9C, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0xDA, 0x3A, 0x20, 0x54, 0x55,
  0xA3, 0x98, 0x8F, 0x8F, 0x66, 0x2F, 0x51, 0x51,
  0xB2, 0xA3, 0x66, 0x98, 0x98, 0x66, 0x66, 0x66,
  0x2F, 0x2F, 0xB2, 0x51, 0xB2, 0xB2, 0x2F, 0x2F,
  0xA3, 0x66, 0x66, 0x66, 0x2F, 0xA3, 0x2F, 0x2F,
  0x66, 0x66, 0xA3, 0x2F, 0xB2, 0xB2, 0x2F, 0x66,
  0x8F, 0x8F, 0x8F, 0x66, 0xA3, 0xA3, 0xB2, 0xB2,
  0xB2, 0xB2, 0xB2, 0xB2, 0x2F, 0xA3, 0xA3, 0xA3,
  0xA3, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0xAD,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0xA7, 0x4C, 0xCE, 0xDA, 0x20,
  0xA6, 0x2F, 0x66, 0x66, 0xA3, 0x2F, 0xB2, 0xB2,
  0x2F, 0x66, 0x8F, 0x8F, 0x8F, 0x66, 0xA3, 0xA3,
  0xB2, 0xB2, 0xB2, 0xB2, 0xB2, 0xB2, 0x2F, 0xA3,
  0xA3, 0xA3, 0xA3, 0xA3, 0x2F, 0x2F, 0x2F, 0x2F,
  0xA3, 0x98, 0x66, 0x2F, 0xB2, 0xB2, 0x2F, 0x98,
  0x8F, 0x8F, 0x98, 0x66, 0xA3, 0xB2, 0xB2, 0xB2,
  0x2F, 0x2F, 0x2F, 0x2F, 0xA3, 0x2F, 0xA3, 0xA3,
  0xA3, 0xA3, 0xA3, 0xA3, 0xA3, 0xA3, 0x51, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0xCE, 0x55, 0xAD, 0xA7, 0x54,
  0x20, 0x8F, 0xA3, 0x98, 0x66, 0x2F, 0xB2, 0xB2,
  0x2F, 0x98, 0x8F, 0x8F, 0x98, 0x66, 0xA3, 0xB2,
  0xB2, 0xB2, 0x2F, 0x2F, 0x2F, 0x2F, 0xA3, 0x2F,
  0xA3, 0xA3, 0xA3, 0x2F, 0xA3, 0xA3, 0xA3, 0xA3,
  0xA3, 0x8F, 0x66, 0x2F, 0xB2, 0x51, 0x2F, 0x98,
  0xA0, 0x8F, 0x66, 0xA3, 0x2F, 0x51, 0x51, 0xB2,
  0xA3, 0xA3, 0xA3, 0x2F, 0xA3, 0xA3, 0x66, 0x66,
  0x98, 0x98, 0x98, 0x66, 0x98, 0x66, 0x55, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0xCE, 0x4C, 0x9C, 0x2E, 0xDA,
  0x20, 0xDA, 0x51, 0x8F, 0x66, 0x2F, 0xB2, 0x51,
  0x2F, 0x98, 0xA0, 0x8F, 0x66, 0xA3, 0x2F, 0x51,
  0x51, 0xB2, 0xA3, 0xA3, 0xA3, 0x2F, 0xA3, 0xA3,
  0x66, 0x66, 0x98, 0x98, 0x98, 0x98, 0x98, 0x66,
  0x51, 0x66, 0x2F, 0xB2, 0x51, 0xB2, 0xA3, 0xA0,
  0xA0, 0x66, 0xA3, 0xB2, 0xB2, 0xB2, 0xB2, 0xA3,
  0x66, 0x66, 0x66, 0xA3, 0xA3, 0x66, 0x98, 0x98,
  0x98, 0x98, 0x98, 0x66, 0x66, 0xB2, 0x6D, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x6D, 0x3A, 0x20, 0x20, 0x20,
  0x20, 0x20, 0xA5, 0x66, 0x2F, 0xB2, 0x51, 0xB2,
  0xA3, 0xA0, 0xA0, 0x66, 0xA3, 0xB2, 0xB2, 0xB2,
  0xB2, 0xA3, 0x66, 0x66, 0x66, 0xA3, 0xA3, 0x66,
  0x98, 0x98, 0x8F, 0x98, 0x66, 0x66, 0x66, 0x66,
  0x51, 0x2F, 0xB2, 0x51, 0x51, 0x2F, 0x66, 0xA0,
  0x8F, 0xA3, 0x2F, 0xB2, 0xB2, 0x2F, 0x2F, 0x66,
  0x98, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66,
  0x66, 0x2F, 0xA3, 0x2F, 0x2F, 0x51, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0xDA, 0x51, 0xB2, 0x51, 0x51, 0x2F,
  0x66, 0xA0, 0x8F, 0xA3, 0x2F, 0xB2, 0xB2, 0x2F,
  0x2F, 0x66, 0x98, 0x66, 0x66, 0x66, 0x66, 0x66,
  0x66, 0x66, 0x66, 0xA3, 0x2F, 0x2F, 0x2F, 0x2F,
  0x51, 0x2F, 0xB2, 0x51, 0x2F, 0xA3, 0x8F, 0x8F,
  0x98, 0xA3, 0xB2, 0xB2, 0x2F, 0xA3, 0x98, 0x66,
  0x98, 0x98, 0x66, 0x66, 0x66, 0x66, 0xA3, 0x2F,
  0xB2, 0xB2, 0x51, 0xB2, 0xB2, 0x66, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0xA3, 0xB2, 0x51, 0x2F, 0xA3,
  0x8F, 0x8F, 0x98, 0xA3, 0xB2, 0xB2, 0x2F, 0xA3,
  0x98, 0x66, 0x98, 0x98, 0x66, 0x66, 0x66, 0x66,
  0xA3, 0xB2, 0xB2, 0xB2, 0xB2, 0xB2, 0xB2, 0xB2,
  0xB2, 0x2F, 0xA3, 0x2F, 0x66, 0x98, 0x8F, 0x98,
  0xA3, 0x2F, 0x2F, 0xA3, 0x98, 0x98, 0x98, 0x98,
  0x66, 0x98, 0x66, 0x98, 0x66, 0xA3, 0x2F, 0xB2,
  0x51, 0x51, 0x51, 0xB2, 0xB2, 0x8F, 0x20, 0x20,
  0x20, 0x54, 0x6D, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x54, 0x6D, 0x6D, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x4C, 0xA3, 0x2F, 0x66, 0x98,
  0x8F, 0x98, 0xA3, 0x2F, 0x2F, 0xA3, 0x98, 0x98,
  0x98, 0x98, 0x66, 0x98, 0x66, 0x98, 0x66, 0xA3,
  0x2F, 0xB2, 0x51, 0x51, 0x51, 0xB2, 0x2F, 0x2F,
  0x2F, 0xA3, 0xA3, 0x66, 0x98, 0x98, 0x8F, 0x98,
  0x2F, 0x2F, 0x2F, 0x66, 0x8F, 0x8F, 0x98, 0xA3,
  0x66, 0x66, 0x8F, 0x98, 0x98, 0x66, 0x2F, 0xB2,
  0x51, 0xB2, 0x2F, 0xA3, 0xA3, 0xA0, 0x20, 0x20,
  0xDA, 0x2E, 0x3A, 0xA7, 0x20, 0x20, 0x20, 0x20,
  0x20, 0xCE, 0x2A, 0x2A, 0x2E, 0xA7, 0xDA, 0x20,
  0x20, 0x20, 0x20, 0x9C, 0xA3, 0x66, 0x98, 0x98,
  0x8F, 0x98, 0x2F, 0x2F, 0x2F, 0x66, 0x8F, 0x8F,
  0x98, 0xA3, 0x66, 0x66, 0x8F, 0x98, 0x98, 0x66,
  0x2F, 0xB2, 0x51, 0xB2, 0x2F, 0x2F, 0xA3, 0xA3,
  0xB2, 0xA3, 0x66, 0x98, 0x8F, 0x8F, 0x66, 0xA3,
  0x2F, 0x2F, 0x66, 0x98, 0x98, 0x66, 0x2F, 0x2F,
  0xA3, 0x98, 0x8F, 0x98, 0x66, 0x2F, 0xB2, 0xB2,
  0xB2, 0xA3, 0x66, 0x66, 0x66, 0x98, 0x20, 0x3A,
  0x98, 0x89, 0x8F, 0x6D, 0x20, 0x20, 0x20, 0x20,
  0x4C, 0x66, 0x51, 0x44, 0x51, 0x2E, 0x54, 0x20,
  0x20, 0x20, 0x20, 0xA7, 0x66, 0x98, 0x8F, 0x8F,
  0x66, 0xA3, 0x2F, 0x2F, 0x66, 0x98, 0x98, 0x66,
  0x2F, 0x2F, 0xA3, 0x98, 0x8F, 0x98, 0x66, 0x2F,
  0xB2, 0xB2, 0xB2, 0xA3, 0x66, 0x66, 0x66, 0xA3,
  0x2F, 0x66, 0x98, 0x8F, 0x8F, 0x98, 0x66, 0x2F,
  0x2F, 0xA3, 0x66, 0x98, 0x98, 0xA3, 0x2F, 0xB2,
  0xA3, 0x8F, 0x98, 0xA3, 0xB2, 0x51, 0x89, 0x89,
  0xB2, 0xA3, 0x66, 0x98, 0x66, 0x98, 0x20, 0xA6,
  0x44, 0x39, 0xE6, 0x98, 0x20, 0x20, 0x20, 0x9C,
  0x74, 0xD6, 0x7E, 0xD6, 0x39, 0x8F, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x2E, 0x98, 0x8F, 0x8F, 0x98,
  0x66, 0x2F, 0x2F, 0xA3, 0x66, 0x98, 0x98, 0xA3,
  0x2F, 0xB2, 0x66, 0x98, 0x8F, 0xA3, 0xB2, 0x51,
  0x89, 0x89, 0xB2, 0xA3, 0x66, 0x98, 0x66, 0x66,
  0x2F, 0x66, 0x8F, 0xA0, 0x8F, 0x98, 0xA3, 0xB2,
  0x2F, 0x66, 0x66, 0x66, 0xA3, 0x2F, 0x2F, 0x2F,
  0x66, 0x98, 0xA3, 0xB2, 0x89, 0x44, 0x89, 0x51,
  0x2F, 0x66, 0x98, 0x98, 0xA3, 0x66, 0x20, 0x2F,
  0x2F, 0xAD, 0x89, 0xD6, 0x3A, 0x20, 0x20, 0x55,
  0x6B, 0x51, 0x6D, 0x4C, 0xD8, 0xD6, 0x2E, 0x20,
  0x20, 0x20, 0x20, 0x54, 0x8F, 0xA0, 0x8F, 0x98,
  0xA3, 0xB2, 0x2F, 0x66, 0x66, 0x66, 0xA3, 0x2F,
  0xB2, 0x2F, 0x66, 0x66, 0xA3, 0xB2, 0x89, 0x44,
  0x89, 0x51, 0x2F, 0x66, 0x98, 0x98, 0xA3, 0xA3,
  0xA3, 0x66, 0x8F, 0xA0, 0x8F, 0x66, 0x2F, 0xB2,
  0xA3, 0x66, 0x98, 0x66, 0xA3, 0x2F, 0x2F, 0xA3,
  0xA3, 0x2F, 0xB2, 0x89, 0xD8, 0xD8, 0x51, 0x66,
  0x8F, 0xA0, 0xA0, 0x8F, 0x98, 0xA3, 0x20, 0x44,
  0xA7, 0xCE, 0xA6, 0x4D, 0xCE, 0x6D, 0xA7, 0xA0,
  0x6B, 0xA7, 0x20, 0x92, 0xAD, 0x6B, 0x4C, 0x20,
  0x20, 0x20, 0x20, 0x54, 0x98, 0xA0, 0x8F, 0x66,
  0x2F, 0xB2, 0xA3, 0x66, 0x98, 0x66, 0xA3, 0x2F,
  0x2F, 0xA3, 0xA3, 0xA3, 0xB2, 0x89, 0xD8, 0xD8,
  0x51, 0x66, 0x8F, 0xA0, 0xA0, 0x8F, 0x98, 0x66,
  0x66, 0x66, 0x8F, 0x55, 0x8F, 0xA3, 0xB2, 0xB2,
  0xA3, 0x66, 0x66, 0xA3, 0x2F, 0xA3, 0xA3, 0xA3,
  0xA3, 0xB2, 0x89, 0x44, 0x44, 0x51, 0x66, 0xA0,
  0x55, 0xA5, 0x55, 0x8F, 0x66, 0xA3, 0x20, 0x44,
  0x6D, 0x54, 0xA7, 0x74, 0x2E, 0x4B, 0xBF, 0x9C,
  0x7E, 0xDA, 0x20, 0x54, 0x2E, 0x6B, 0x2A, 0x20,
  0x20, 0x20, 0x20, 0x3A, 0x8F, 0x55, 0x8F, 0xA3,
  0xB2, 0xB2, 0xA3, 0x66, 0x66, 0xA3, 0xA3, 0x2F,
  0xA3, 0xA3, 0xA3, 0xB2, 0x89, 0x44, 0x44, 0x51,
  0x66, 0xA0, 0xA5, 0xA5, 0x55, 0x8F, 0x66, 0x66,
  0xA0, 0xA0, 0xA0, 0xA0, 0x8F, 0xA3, 0x2F, 0xB2,
  0x66, 0x98, 0xA3, 0x2F, 0x2F, 0xB2, 0x2F, 0x2F,
  0xB2, 0x51, 0x89, 0x89, 0xB2, 0x98, 0xA0, 0x2A,
  0xA5, 0x55, 0x98, 0x66, 0xA3, 0xB2, 0x20, 0x2F,
  0x4C, 0x20, 0x4B, 0xBB, 0xCF, 0x6F, 0x27, 0x36,
  0x93, 0xCE, 0x20, 0x20, 0xA6, 0x3D, 0x4C, 0x20,
  0x20, 0x20, 0x20, 0xDA, 0xA0, 0xA0, 0x8F, 0xA3,
  0x2F, 0xB2, 0x66, 0x98, 0xA3, 0x2F, 0xB2, 0x2F,
  0x2F, 0x2F, 0xB2, 0x51, 0x89, 0x89, 0xB2, 0x98,
  0xA0, 0x2A, 0xA5, 0xA0, 0x8F, 0x66, 0xA3, 0xA3,
  0xA0, 0x8F, 0x8F, 0xA0, 0x8F, 0xA3, 0xB2, 0x2F,
  0x66, 0x98, 0x2F, 0xB2, 0xB2, 0xB2, 0xB2, 0x2F,
  0xB2, 0x89, 0x44, 0x51, 0x66, 0x55, 0xAD, 0x2A,
  0x55, 0x8F, 0x66, 0xA3, 0x2F, 0xB2, 0x20, 0x2A,
  0xE6, 0x95, 0xE5, 0x5A, 0x52, 0x52, 0x3F, 0x27,
  0x22, 0xC7, 0x9D, 0x60, 0xA2, 0xA2, 0x3A, 0x20,
  0x20, 0x20, 0x20, 0x54, 0x66, 0xA0, 0x8F, 0xA3,
  0xB2, 0x2F, 0x66, 0x98, 0x2F, 0xB2, 0xB2, 0xB2,
  0xB2, 0x2F, 0xB2, 0x89, 0x44, 0x51, 0x66, 0x55,
  0x2A, 0x2A, 0xA5, 0x8F, 0x66, 0xA3, 0x2F, 0x2F,
  0xA3, 0xA3, 0x66, 0x98, 0x98, 0x2F, 0xB2, 0xB2,
  0xA3, 0xA3, 0x2F, 0x51, 0x51, 0x51, 0x2F, 0x2F,
  0x51, 0x89, 0x89, 0x2F, 0x8F, 0x2A, 0x2A, 0xA5,
  0x8F, 0x66, 0xA3, 0xB2, 0x2F, 0x51, 0x20, 0x6D,
  0x77, 0xF7, 0xEE, 0x30, 0xB0, 0x72, 0x72, 0x5B,
  0x82, 0xEA, 0x72, 0xB0, 0x90, 0x96, 0x71, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x2F, 0x98, 0x98, 0x2F,
  0xB2, 0xB2, 0x66, 0xA3, 0x2F, 0x51, 0x51, 0xB2,
  0xB2, 0x2F, 0x51, 0x89, 0x89, 0x2F, 0x8F, 0x2A,
  0xAD, 0xA5, 0x98, 0x66, 0xA3, 0xB2, 0x2F, 0xB2,
  0xD8, 0xB2, 0xA3, 0x98, 0x98, 0x2F, 0xB2, 0xB2,
  0x66, 0xA3, 0xB2, 0x51, 0x51, 0xB2, 0x2F, 0xA3,
  0x51, 0x89, 0x89, 0xA3, 0xA0, 0x2A, 0xA5, 0x8F,
  0x66, 0xA3, 0x2F, 0xB2, 0xB2, 0x51, 0x20, 0x69,
  0x64, 0xF9, 0x3F, 0x52, 0x52, 0x72, 0x29, 0x82,
  0x47, 0x47, 0x47, 0x8B, 0x72, 0xB7, 0x60, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x2F, 0x98, 0x98, 0x2F,
  0xB2, 0xB2, 0xA3, 0xA3, 0xB2, 0x89, 0x51, 0x2F,
  0x2F, 0xA3, 0x51, 0x89, 0x89, 0xA3, 0xA0, 0x2A,
  0xA5, 0x8F, 0x66, 0xA3, 0x2F, 0xB2, 0xB2, 0xB2,
  0xDD, 0xA3, 0x66, 0x98, 0x66, 0x2F, 0xB2, 0xB2,
  0xA3, 0xA3, 0xB2, 0x51, 0xB2, 0x2F, 0xA3, 0x2F,
  0xB2, 0x89, 0xB2, 0x66, 0xA0, 0xA5, 0x8F, 0x98,
  0x66, 0x66, 0xB2, 0x51, 0x51, 0x51, 0x81, 0xFA,
  0x62, 0xEE, 0x30, 0x52, 0x22, 0x72, 0x82, 0x82,
  0x47, 0x47, 0xEA, 0x3F, 0x37, 0x6F, 0x26, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x2A, 0x98, 0x66, 0x2F,
  0x51, 0xB2, 0xA3, 0x66, 0xB2, 0x51, 0x51, 0xB2,
  0xA3, 0x2F, 0xB2, 0x89, 0xB2, 0x66, 0x55, 0x55,
  0x8F, 0x98, 0x66, 0xA3, 0xB2, 0x51, 0x51, 0xB2,
  0x74, 0xA0, 0x8F, 0x98, 0x66, 0xB2, 0xB2, 0xB2,
  0xA3, 0xA3, 0x2F, 0x51, 0x51, 0x2F, 0xA3, 0x2F,
  0xB2, 0x51, 0xA3, 0x98, 0xA0, 0x55, 0xA0, 0xA0,
  0x8F, 0x66, 0x2F, 0x51, 0xB2, 0x51, 0x54, 0xA9,
  0x62, 0xEF, 0x52, 0x22, 0x72, 0x29, 0xEA, 0xEA,
  0x29, 0x22, 0x37, 0x37, 0x8E, 0xCF, 0x49, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x6D, 0x2F, 0x66, 0x2F,
  0x51, 0xB2, 0xA3, 0x66, 0x2F, 0xB2, 0xB2, 0x2F,
  0xA3, 0x2F, 0xB2, 0x51, 0x2F, 0x98, 0xA0, 0x55,
  0xA0, 0xA0, 0x8F, 0x66, 0x2F, 0x51, 0xB2, 0xA3,
  0xA3, 0x2A, 0xA5, 0x98, 0xA3, 0x2F, 0xB2, 0x2F,
  0x66, 0x66, 0x2F, 0xB2, 0xB2, 0xB2, 0x2F, 0x2F,
  0xB2, 0x2F, 0xA3, 0x8F, 0xA0, 0xA0, 0xA0, 0xA0,
  0x8F, 0xA3, 0x51, 0x51, 0x2F, 0xB2, 0x54, 0xA8,
  0x65, 0x5C, 0x52, 0x22, 0x29, 0x29, 0x29, 0xB0,
  0x62, 0x56, 0xF9, 0x79, 0xF9, 0xBB, 0x4B, 0x20,
  0x6D, 0xA5, 0x2E, 0x20, 0x20, 0xA3, 0xA3, 0x2F,
  0xB2, 0x2F, 0xA3, 0x66, 0x2F, 0xB2, 0xB2, 0xB2,
  0x2F, 0x2F, 0xB2, 0x2F, 0x66, 0x8F, 0xA0, 0xA0,
  0x55, 0xA0, 0x8F, 0xA3, 0x51, 0x51, 0x2F, 0xA3,
  0xA0, 0x2A, 0x55, 0x66, 0xA3, 0x2F, 0xB2, 0xB2,
  0xA3, 0x66, 0xA3, 0xB2, 0xB2, 0xB2, 0xA3, 0x66,
  0xA3, 0xA3, 0x66, 0x8F, 0x8F, 0x8F, 0xA0, 0x98,
  0xA3, 0x51, 0x89, 0x89, 0xA3, 0x2F, 0x20, 0x54,
  0xDF, 0xFA, 0x40, 0x37, 0xD4, 0x43, 0x56, 0x64,
  0x76, 0xF9, 0x78, 0x41, 0x5E, 0x5E, 0x4C, 0x20,
  0x20, 0xAD, 0x8F, 0x9C, 0x20, 0xA5, 0xA3, 0x2F,
  0x2F, 0x2F, 0xA3, 0x66, 0x2F, 0xB2, 0xB2, 0xB2,
  0xA3, 0x66, 0xA3, 0x2F, 0x66, 0x8F, 0x8F, 0x8F,
  0x8F, 0x8F, 0xA3, 0x51, 0x89, 0x51, 0xA3, 0x66,
  0xA0, 0xA0, 0x8F, 0xA3, 0x2F, 0x2F, 0x2F, 0xB2,
  0x2F, 0xA3, 0x2F, 0xB2, 0x51, 0xB2, 0x2F, 0x66,
  0xA3, 0xA3, 0x66, 0x66, 0x66, 0x66, 0x66, 0xA3,
  0xB2, 0x89, 0xD8, 0x51, 0x66, 0x51, 0x20, 0x6D,
  0x51, 0x77, 0x9F, 0xF7, 0xEE, 0x8E, 0xF9, 0xF0,
  0x24, 0xF7, 0x77, 0x5E, 0x74, 0xD8, 0x98, 0x20,
  0x20, 0x2E, 0x55, 0x92, 0x20, 0x54, 0x51, 0x2F,
  0x2F, 0xB2, 0xB2, 0xA3, 0x2F, 0x51, 0x51, 0xB2,
  0xA3, 0xA3, 0x66, 0xA3, 0x66, 0x66, 0x66, 0x66,
  0x66, 0xA3, 0xB2, 0x89, 0xD8, 0x51, 0xA3, 0x98,
  0x98, 0x66, 0x66, 0xA3, 0x2F, 0x2F, 0x2F, 0xB2,
  0xB2, 0x2F, 0x2F, 0xB2, 0xB2, 0x2F, 0x2F, 0x66,
  0x66, 0xA3, 0xA3, 0xA3, 0x2F, 0x2F, 0x2F, 0xB2,
  0x89, 0xD8, 0x89, 0xB2, 0x66, 0x66, 0x20, 0x6D,
  0x89, 0xC2, 0xA4, 0x96, 0xC6, 0x64, 0x50, 0x40,
  0xF4, 0x97, 0x89, 0x74, 0x7E, 0x6B, 0x39, 0xA7,
  0x20, 0x20, 0x3A, 0x54, 0x20, 0x20, 0xA7, 0x51,
  0x2F, 0xB2, 0xB2, 0xA3, 0xA3, 0xB2, 0xB2, 0xB2,
  0xA3, 0xA3, 0x66, 0xA3, 0xA3, 0xA3, 0x2F, 0x2F,
  0x2F, 0xB2, 0x89, 0xD8, 0x44, 0x2F, 0x66, 0x66,
  0x2F, 0xA3, 0xA3, 0x2F, 0x2F, 0x2F, 0x2F, 0xB2,
  0x2F, 0xA3, 0xA3, 0xA3, 0x2F, 0x2F, 0x2F, 0xA3,
  0x66, 0xA3, 0x2F, 0xB2, 0xB2, 0xB2, 0x51, 0x51,
  0x89, 0x89, 0xB2, 0x66, 0x2F, 0x6D, 0x20, 0xCE,
  0x39, 0x74, 0x89, 0x5E, 0xBD, 0x87, 0xC8, 0xD1,
  0x89, 0x44, 0x3C, 0x4D, 0x6B, 0x6B, 0x6B, 0x2F,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0xA3,
  0x2F, 0x2F, 0x2F, 0xA3, 0xA3, 0x2F, 0x2F, 0x2F,
  0x2F, 0xA3, 0x66, 0x66, 0x2F, 0xB2, 0xB2, 0xB2,
  0x51, 0x51, 0x89, 0x89, 0xB2, 0xA3, 0x98, 0x66,
  0xA3, 0x66, 0x66, 0xA3, 0xA3, 0xA3, 0xA3, 0x2F,
  0x2F, 0xA3, 0xA3, 0xA3, 0x2F, 0xA3, 0x2F, 0xA3,
  0x66, 0x66, 0x2F, 0x2F, 0xB2, 0xB2, 0xB2, 0xB2,
  0xB2, 0x2F, 0x66, 0x66, 0x2A, 0x20, 0x54, 0x44,
  0x6B, 0x39, 0x89, 0x89, 0x89, 0x89, 0x89, 0x89,
  0xD8, 0x39, 0x4D, 0x6B, 0x6B, 0x6B, 0x6B, 0x4D,
  0x9C, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x6D,
  0x51, 0x2F, 0x2F, 0x2F, 0xA3, 0xA3, 0xA3, 0x2F,
  0xA3, 0xA3, 0x66, 0xA3, 0x2F, 0xB2, 0xB2, 0xB2,
  0xB2, 0xB2, 0xB2, 0x2F, 0x66, 0x98, 0x98, 0x66,
  0x98, 0x98, 0x66, 0xA3, 0xA3, 0xA3, 0xA3, 0xA3,
  0x2F, 0x2F, 0xA3, 0xA3, 0x66, 0xA3, 0xA3, 0x66,
  0x98, 0x66, 0x66, 0x2F, 0xA3, 0xA3, 0xA3, 0xA3,
  0x66, 0x98, 0x98, 0x98, 0x3A, 0x54, 0x2A, 0x6B,
  0x6B, 0x6B, 0x83, 0x44, 0x89, 0x89, 0x44, 0x3C,
  0xD6, 0x6B, 0x6B, 0x6B, 0x6B, 0x6B, 0x6B, 0x6B,
  0xB2, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0xAD, 0x2F, 0x2F, 0xA3, 0xA3, 0xA3, 0xA3, 0xA3,
  0xA3, 0x66, 0x66, 0x98, 0x66, 0xA3, 0xA3, 0xA3,
  0xA3, 0xA3, 0x66, 0x98, 0x8F, 0x8F, 0x8F, 0x98,
  0x8F, 0x98, 0x98, 0x66, 0xA3, 0xA3, 0xA3, 0xA3,
  0x2F, 0xA3, 0xA3, 0x66, 0x66, 0x66, 0x66, 0x66,
  0x8F, 0x8F, 0x8F, 0x98, 0x98, 0x98, 0x8F, 0xA0,
  0xA0, 0xA0, 0xA3, 0xDA, 0x20, 0x3A, 0x39, 0x6B,
  0x6B, 0x6B, 0x4D, 0xA2, 0x74, 0x3C, 0x7E, 0x6B,
  0x6B, 0x6B, 0x6B, 0x6B, 0x6B, 0x6B, 0x6B, 0x6B,
  0x6B, 0x2E, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x2F, 0x2F, 0xA3, 0x66, 0x66, 0x66, 0x66,
  0x66, 0x98, 0x8F, 0x8F, 0x98, 0x98, 0x98, 0x98,
  0x8F, 0xA0, 0xA0, 0xA0, 0x8F, 0x8F, 0x8F, 0xA0,
  0x8F, 0x66, 0x66, 0xA3, 0x66, 0xA3, 0xA3, 0x2F,
  0x2F, 0x2F, 0xA3, 0xA3, 0x66, 0x66, 0x66, 0x98,
  0x98, 0xA0, 0x98, 0x66, 0x66, 0x98, 0x8F, 0xA0,
  0xA0, 0xA3, 0x2E, 0x20, 0x20, 0x8F, 0x6B, 0x6B,
  0x6B, 0x6B, 0x6B, 0x6B, 0x3D, 0x6B, 0x6B, 0x6B,
  0x6B, 0x6B, 0x6B, 0x6B, 0x6B, 0x6B, 0x6B, 0x6B,
  0x6B, 0x55, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x3A, 0x51, 0x2F, 0xA3, 0x66, 0x66, 0x66,
  0x66, 0x66, 0x98, 0x8F, 0x8F, 0x98, 0x66, 0x98,
  0x8F, 0xA0, 0xA0, 0x8F, 0x8F, 0x8F, 0x8F, 0xA0,
  0x66, 0x2F, 0x2F, 0x2F, 0x2F, 0xA3, 0xA3, 0xA3,
  0x2F, 0x2F, 0xA3, 0xA3, 0x66, 0xA3, 0x66, 0x66,
  0x66, 0x98, 0xA3, 0x2F, 0x2F, 0xA3, 0x66, 0x8F,
  0x66, 0xA6, 0x20, 0x20, 0x6D, 0x39, 0x6B, 0x6B,
  0x6B, 0x6B, 0x6B, 0x6B, 0x6B, 0x6B, 0x6B, 0x6B,
  0x6B, 0x6B, 0x6B, 0x6B, 0x6B, 0x6B, 0x6B, 0x6B,
  0x6B, 0xB2, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x2E, 0x89, 0xA3, 0xA3, 0x66, 0x66,
  0x66, 0x66, 0x98, 0x98, 0xA3, 0x2F, 0x2F, 0xA3,
  0x66, 0x8F, 0x98, 0x98, 0x66, 0x98, 0x98, 0x8F,
  0x2F, 0x51, 0xB2, 0xB2, 0x2F, 0xA3, 0xA3, 0xA3,
  0xA3, 0xA3, 0xA3, 0xA3, 0xA3, 0xA3, 0xA3, 0xA3,
  0xA3, 0xA3, 0x2F, 0xB2, 0x2F, 0xA3, 0x66, 0x2F,
  0x55, 0x20, 0x20, 0x20, 0x4C, 0x39, 0x6B, 0x6B,
  0x6B, 0x6B, 0x6B, 0x6B, 0x6B, 0x6B, 0x6B, 0x6B,
  0x6B, 0x6B, 0x6B, 0x6B, 0x6B, 0x6B, 0x6B, 0x6B,
  0x4D, 0x7E, 0x54, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x2E, 0x51, 0xA3, 0xA3, 0xA3,
  0xA3, 0xA3, 0xA3, 0x2F, 0xB2, 0xB2, 0x2F, 0xA3,
  0x66, 0x66, 0xA3, 0xA3, 0xA3, 0xA3, 0x66, 0x66,
  0xB2, 0x51, 0x51, 0xB2, 0xB2, 0xA3, 0x2F, 0xA3,
  0x2F, 0x2F, 0x2F, 0xA3, 0xA3, 0xA3, 0xA3, 0x66,
  0xA3, 0x2F, 0xB2, 0x2F, 0xA3, 0x98, 0x98, 0xA0,
  0x20, 0x20, 0x20, 0x20, 0xA5, 0x83, 0x6B, 0x6B,
  0x6B, 0x6B, 0x6B, 0x4D, 0x7E, 0x4D, 0x6B, 0x6B,
  0x6B, 0x6B, 0x6B, 0x4D, 0x4D, 0xD6, 0x7E, 0xDD,
  0x3C, 0x39, 0xA7, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x92, 0xB2, 0xA3, 0xA3,
  0xA3, 0x66, 0xA3, 0x2F, 0x2F, 0x2F, 0xA3, 0x98,
  0x98, 0x66, 0xA3, 0xA3, 0x66, 0x66, 0x66, 0xA3,
  0x89, 0x89, 0x51, 0xB2, 0xB2, 0x2F, 0x2F, 0x2F,
  0x2F, 0xA3, 0xA3, 0x2F, 0xA3, 0xA3, 0xA3, 0xA3,
  0xA3, 0xA3, 0xA3, 0x66, 0x8F, 0x8F, 0x2F, 0xDA,
  0x20, 0x20, 0x20, 0xDA, 0xA0, 0x51, 0x3C, 0x7E,
  0x6B, 0x6B, 0x6B, 0x4D, 0x7E, 0x6B, 0x6B, 0x6B,
  0x6B, 0x6B, 0x6B, 0x7E, 0x3C, 0xD8, 0x44, 0xD8,
  0x44, 0x83, 0x89, 0xDA, 0x20, 0x3A, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0xB2, 0xA3, 0xA3,
  0xA3, 0xA3, 0xA3, 0xA3, 0xA3, 0x66, 0x8F, 0x8F,
  0x98, 0x98, 0x98, 0x98, 0x66, 0xA3, 0xA3, 0x2F,
  0x3C, 0x89, 0x89, 0x51, 0xB2, 0xB2, 0x2F, 0x2F,
  0x2F, 0x2F, 0xA3, 0xA3, 0x66, 0x66, 0x66, 0xA3,
  0xA3, 0xA3, 0xA3, 0x66, 0x98, 0x98, 0xA3, 0x20,
  0x20, 0x20, 0x20, 0x6D, 0x2F, 0xE6, 0x6B, 0x6B,
  0x6B, 0x6B, 0x6B, 0x6B, 0x6B, 0x3D, 0xD6, 0x3D,
  0x6B, 0x6B, 0x6B, 0x6B, 0x6B, 0x4D, 0x7E, 0xA2,
  0x74, 0x44, 0xA2, 0xA3, 0x20, 0x3A, 0x2E, 0x6D,
  0x20, 0x20, 0x20, 0x20, 0x20, 0xA6, 0xA3, 0x66,
  0x66, 0x66, 0xA3, 0x2F, 0xA3, 0x66, 0x66, 0x98,
  0x66, 0x66, 0x98, 0x98, 0x98, 0x66, 0xA3, 0xA3,
  0x83, 0xB2, 0x2F, 0x2F, 0xB2, 0xB2, 0xB2, 0x2F,
  0x2F, 0x2F, 0xA3, 0x66, 0x66, 0x98, 0x98, 0x66,
  0xA3, 0xA3, 0xA3, 0xA3, 0xA3, 0x66, 0xA6, 0x20,
  0x3A, 0x3A, 0x54, 0x55, 0x7E, 0x6B, 0x6B, 0x6B,
  0x4D, 0x3D, 0x6B, 0x6B, 0x6B, 0x57, 0x33, 0xEB,
  0x6B, 0x6B, 0x6B, 0x6B, 0x6B, 0x6B, 0x6B, 0x6B,
  0x4D, 0xA2, 0x74, 0x39, 0x92, 0x20, 0x20, 0x6D,
  0x2E, 0x20, 0x20, 0x20, 0x20, 0x20, 0x2F, 0x98,
  0x98, 0xA3, 0xA3, 0xA3, 0xA3, 0xA3, 0x66, 0x66,
  0x66, 0x66, 0x66, 0x66, 0x66, 0xA3, 0x66, 0xA3,
  0x89, 0xA3, 0x66, 0x66, 0xA3, 0xA3, 0x2F, 0x2F,
  0xA3, 0x2F, 0xA3, 0xA3, 0x66, 0x66, 0x66, 0xA3,
  0xA3, 0xA3, 0xA3, 0xA3, 0xA3, 0xB2, 0x3A, 0x20,
  0xA7, 0x20, 0x3A, 0x39, 0x6B, 0x6B, 0x6B, 0x6B,
  0xB5, 0xCB, 0x6B, 0x6B, 0x3D, 0x8A, 0x42, 0x3D,
  0x6B, 0x6B, 0x6B, 0x84, 0x6C, 0x4D, 0x6B, 0x6B,
  0x6B, 0x6B, 0x7E, 0x83, 0x51, 0x20, 0x20, 0x20,
  0x6D, 0x3A, 0x20, 0x20, 0x20, 0x20, 0xAD, 0x66,
  0x66, 0x66, 0xA3, 0xA3, 0xA3, 0xA3, 0xA3, 0xA3,
  0xA3, 0xA3, 0xA3, 0xA3, 0x66, 0xA3, 0xA3, 0xA3,
  0xB2, 0x98, 0x66, 0x66, 0x98, 0x66, 0x66, 0xA3,
  0xA3, 0xA3, 0xA3, 0xA3, 0x2F, 0x2F, 0x2F, 0x2F,
  0xA3, 0x2F, 0xA3, 0xA3, 0xA3, 0x2F, 0x20, 0x6D,
  0x3A, 0x20, 0x98, 0x6B, 0x6B, 0x6B, 0x6B, 0x6B,
  0xAA, 0x33, 0x6B, 0x6B, 0x3D, 0xF5, 0x7B, 0x3D,
  0x6B, 0x6B, 0x4F, 0x4A, 0x58, 0x3D, 0x6B, 0x6B,
  0x6B, 0x6B, 0x6B, 0x7E, 0x7E, 0x9C, 0x54, 0xA7,
  0x2E, 0xA7, 0x20, 0x20, 0x20, 0x20, 0x54, 0x51,
  0x2F, 0x2F, 0xA3, 0x2F, 0xA3, 0xA3, 0xA3, 0xA3,
  0x2F, 0xA3, 0xA3, 0xA3, 0xA3, 0xA3, 0xA3, 0x2F,
  0xB2, 0x66, 0x66, 0x66, 0x66, 0xA3, 0x66, 0xA3,
  0x66, 0x66, 0xA3, 0x2F, 0x2F, 0xB2, 0x2F, 0xB2,
  0x2F, 0x2F, 0x2F, 0xA3, 0x2F, 0xA6, 0x20, 0xCE,
  0x20, 0x6D, 0x4D, 0x6B, 0xD6, 0x7E, 0x6B, 0x6B,
  0x6E, 0x9A, 0x57, 0x6B, 0x2D, 0x7B, 0x7B, 0x3D,
  0x6B, 0x84, 0xF5, 0x7B, 0x84, 0x6B, 0x6B, 0x6B,
  0x6B, 0x6B, 0x6B, 0x6B, 0x6B, 0x98, 0x3A, 0x9C,
  0xCE, 0x3A, 0x2E, 0x20, 0x20, 0x20, 0x20, 0x98,
  0xB2, 0xB2, 0x2F, 0x2F, 0x2F, 0xA3, 0x2F, 0x2F,
  0x2F, 0xA3, 0xA3, 0xA3, 0xA3, 0x2F, 0x2F, 0x2F,
  0x89, 0xA3, 0x66, 0x66, 0xA3, 0x2F, 0x2F, 0xA3,
  0x66, 0x66, 0xA3, 0xA3, 0x2F, 0x2F, 0xB2, 0xB2,
  0xB2, 0x2F, 0x2F, 0x2F, 0x89, 0x54, 0x6D, 0x3A,
  0x20, 0x98, 0x6B, 0x6B, 0xE0, 0xB4, 0x6B, 0x6B,
  0x2D, 0x9E, 0x4A, 0x3D, 0x84, 0xF5, 0xF5, 0x84,
  0x6B, 0x6E, 0x59, 0x6C, 0x6B, 0x6B, 0x6B, 0x6B,
  0x3D, 0x6B, 0x6B, 0x6B, 0x6B, 0xDD, 0xDA, 0x6D,
  0x54, 0x20, 0xCE, 0x20, 0x20, 0x20, 0x20, 0xA7,
  0x51, 0xB2, 0xB2, 0xB2, 0x2F, 0xB2, 0x2F, 0x2F,
  0x2F, 0x66, 0x66, 0xA3, 0xA3, 0xA3, 0xA3, 0x66,
  0x89, 0xA3, 0xA3, 0xA3, 0x2F, 0xB2, 0xB2, 0x2F,
  0x66, 0x66, 0xA3, 0xA3, 0x2F, 0xA3, 0xA3, 0x2F,
  0xB2, 0x2F, 0x2F, 0xA3, 0x98, 0x20, 0xA7, 0x20,
  0x3A, 0x7E, 0x6B, 0x6B, 0x7F, 0xDE, 0xF6, 0x3D,
  0x6B, 0xDB, 0x8A, 0xDB, 0xE9, 0xF3, 0xF3, 0xDB,
  0x68, 0xF3, 0x73, 0x7F, 0x6B, 0x6B, 0x57, 0x58,
  0xDC, 0x2D, 0x6B, 0x6B, 0x6B, 0x6B, 0x3A, 0x20,
  0x20, 0x20, 0x6D, 0x54, 0x20, 0x20, 0x20, 0x20,
  0x51, 0x2F, 0x2F, 0x2F, 0xA3, 0xA3, 0xA3, 0x66,
  0xA3, 0x66, 0x98, 0x98, 0x66, 0x98, 0x98, 0x66,
  0x2F, 0x66, 0x66, 0xA3, 0x2F, 0xB2, 0x2F, 0xA3,
  0xA3, 0xA3, 0xA3, 0xA3, 0x66, 0xA3, 0xA3, 0xA3,
  0x66, 0x98, 0x8F, 0x98, 0xCE, 0xDA, 0x2E, 0x20,
  0x2A, 0x6B, 0x6B, 0x6B, 0x6B, 0x2C, 0x34, 0xCB,
  0xEB, 0x6C, 0x31, 0x59, 0x82, 0x82, 0x8B, 0x82,
  0xF3, 0x73, 0xE9, 0x6B, 0x3D, 0x6E, 0xF3, 0x4A,
  0x4F, 0x6B, 0x6B, 0x6B, 0x6B, 0x6B, 0x92, 0x20,
  0x20, 0x20, 0x6D, 0x6D, 0x20, 0x20, 0x20, 0x20,
  0xA3, 0xA3, 0x66, 0x98, 0x98, 0x8F, 0x8F, 0x98,
  0x98, 0x98, 0x98, 0x66, 0x98, 0x66, 0x66, 0xA3,
  0xA3, 0x66, 0x66, 0x66, 0xA3, 0x2F, 0x2F, 0xA3,
  0xA3, 0xA3, 0x66, 0x66, 0xA3, 0xA3, 0xA3, 0x66,
  0x8F, 0x55, 0xA5, 0x98, 0x20, 0x2E, 0x54, 0x54,
  0x89, 0x6B, 0x6B, 0x6B, 0x6B, 0x84, 0xE3, 0x4A,
  0x58, 0x42, 0x5B, 0x8B, 0x82, 0x82, 0x82, 0x82,
  0x82, 0x59, 0x58, 0x57, 0x57, 0x59, 0x7B, 0x84,
  0x6B, 0x6B, 0x6B, 0x6B, 0x6B, 0x6B, 0xAD, 0x20,
  0x20, 0x20, 0x3A, 0x3A, 0x20, 0x20, 0x20, 0x20,
  0x2A, 0x66, 0x8F, 0x55, 0xA5, 0xA5, 0xA0, 0x8F,
  0x66, 0xA3, 0xA3, 0x66, 0x98, 0x66, 0x66, 0x2F,
  0x2F, 0x2F, 0x2F, 0xA3, 0xA3, 0x2F, 0x2F, 0x2F,
  0xA3, 0x2F, 0xA3, 0xA3, 0x66, 0xA3, 0xA3, 0x66,
  0x8F, 0xA5, 0x8F, 0x2E, 0x20, 0x2E, 0x20, 0x3A,
  0x4D, 0x6B, 0xE6, 0x84, 0x3D, 0x6B, 0xEB, 0x4A,
  0xC9, 0x8B, 0x8B, 0x31, 0x59, 0x82, 0x59, 0x59,
  0x5B, 0x82, 0x59, 0x73, 0x7B, 0xDC, 0x57, 0x6B,
  0x6B, 0x6B, 0x6B, 0x6B, 0x6B, 0x6B, 0x55, 0x20,
  0x20, 0x20, 0x6D, 0xDA, 0x20, 0x20, 0x20, 0x20,
  0x9C, 0x66, 0x8F, 0xA5, 0xA5, 0x55, 0x8F, 0x66,
  0x2F, 0xB2, 0x2F, 0x66, 0x98, 0x98, 0x2F, 0x51,
  0x89, 0xB2, 0x2F, 0xA3, 0xA3, 0xB2, 0xB2, 0xB2,
  0x2F, 0x2F, 0xA3, 0xA3, 0xA3, 0xA3, 0xA3, 0x66,
  0x8F, 0xA5, 0x8F, 0x20, 0x20, 0xA7, 0x20, 0xA6,
  0x6B, 0x6B, 0xE4, 0x48, 0x2C, 0xDB, 0x4F, 0x9E,
  0xD0, 0xD0, 0x8B, 0x82, 0x82, 0x82, 0x82, 0x82,
  0x59, 0x82, 0x82, 0x73, 0x7B, 0x68, 0x6B, 0x3D,
  0x68, 0x68, 0x84, 0x3D, 0x6B, 0x6B, 0xA0, 0x20,
  0x20, 0x20, 0x6D, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x6D, 0x2F, 0xA0, 0xA5, 0x55, 0x98, 0x66, 0xA3,
  0xB2, 0x89, 0xB2, 0x98, 0x8F, 0x98, 0x2F, 0x51,
  0x74, 0xB2, 0xA3, 0xA3, 0x2F, 0x2F, 0xB2, 0x2F,
  0xA3, 0xA3, 0xA3, 0x66, 0x66, 0xA3, 0x2F, 0xA3,
  0x98, 0xA3, 0x6D, 0x20, 0x20, 0xCE, 0x20, 0x2A,
  0x6B, 0x6B, 0xEB, 0x2C, 0xE1, 0xF1, 0x7C, 0xD0,
  0x8B, 0x8B, 0x82, 0x82, 0x82, 0x82, 0x82, 0x59,
  0x82, 0x82, 0x42, 0x82, 0x31, 0x57, 0x4F, 0x7B,
  0x7B, 0xF5, 0xF6, 0xDB, 0x6B, 0x6B, 0x98, 0x20,
  0x20, 0x20, 0x2E, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x51, 0x66, 0xA0, 0xA0, 0x66, 0x2F, 0xB2,
  0xB2, 0x51, 0x2F, 0xA0, 0x55, 0xA3, 0x51, 0x89,
  0x44, 0xA3, 0x98, 0x98, 0x2F, 0x2F, 0x2F, 0xA3,
  0xA3, 0x66, 0x98, 0x98, 0x98, 0xA3, 0x2F, 0x2F,
  0x98, 0x8F, 0x20, 0x20, 0x3A, 0xA6, 0x20, 0xA0,
  0x6B, 0x6B, 0x6B, 0x6B, 0x7F, 0x7F, 0xC3, 0xC9,
  0xD0, 0xD0, 0x29, 0x59, 0x82, 0x73, 0x82, 0x73,
  0x59, 0x59, 0x59, 0x59, 0x59, 0x58, 0xAF, 0xF5,
  0x8A, 0x68, 0xEB, 0x6B, 0x6B, 0x6B, 0x98, 0x20,
  0x20, 0x20, 0x6D, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x51, 0x98, 0x55, 0xA0, 0xA3, 0xB2, 0x51,
  0x51, 0x2F, 0x98, 0x55, 0x8F, 0xB2, 0x89, 0x44,
  0xA3, 0x55, 0x55, 0x98, 0xA3, 0xB2, 0x2F, 0xA3,
  0x66, 0x66, 0x98, 0x8F, 0x66, 0xA3, 0x66, 0x98,
  0x55, 0x4C, 0x20, 0x20, 0xDA, 0xAD, 0x20, 0x98,
  0x6B, 0x6B, 0x6B, 0x6B, 0x6B, 0x3D, 0x9A, 0xD0,
  0xF2, 0x8B, 0x8B, 0x8B, 0x73, 0x82, 0x5B, 0x82,
  0x82, 0x59, 0x59, 0x73, 0x73, 0x58, 0x3D, 0x3D,
  0x6B, 0x6B, 0x6B, 0x6B, 0x6B, 0x6B, 0x66, 0x20,
  0x20, 0x3A, 0x3A, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x2F, 0x55, 0xA5, 0x8F, 0xA3, 0x51, 0x51,
  0xB2, 0xA3, 0x66, 0x66, 0xA3, 0xB2, 0x89, 0x51,
  0x98, 0xA5, 0x55, 0x8F, 0x2F, 0xB2, 0xB2, 0xA3,
  0x66, 0x66, 0x98, 0x98, 0x98, 0x66, 0x66, 0x8F,
  0x8F, 0x92, 0x20, 0x20, 0x20, 0x6D, 0x6D, 0xA3,
  0x6B, 0x6B, 0xEB, 0x7F, 0x4F, 0xDB, 0xD2, 0xC9,
  0xC9, 0xD0, 0x8B, 0x8B, 0x73, 0x82, 0x59, 0x8B,
  0x59, 0x82, 0x59, 0x59, 0x73, 0xF5, 0xEB, 0x6B,
  0x6B, 0x6B, 0x6B, 0x6B, 0x6B, 0x6B, 0x55, 0x20,
  0x20, 0xA7, 0x54, 0xDA, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x98, 0xA0, 0x8F, 0xA3, 0xB2, 0x51, 0x51,
  0x51, 0x2F, 0xA3, 0xA3, 0xB2, 0xB2, 0x51, 0xB2,
  0xA0, 0xA5, 0x55, 0x66, 0x2F, 0x51, 0x2F, 0xA3,
  0x66, 0x66, 0x66, 0x98, 0x66, 0x66, 0x98, 0x98,
  0x98, 0x2A, 0x54, 0x95, 0x95, 0x71, 0x2E, 0x98,
  0x6B, 0x6B, 0x4D, 0x28, 0xDE, 0x88, 0xB7, 0x70,
  0xC9, 0xC9, 0xD0, 0xF2, 0x8B, 0x8B, 0x8B, 0x59,
  0x59, 0x59, 0x59, 0x5B, 0x59, 0xF3, 0x57, 0xE9,
  0xDB, 0x84, 0x6B, 0x6B, 0x6B, 0x6B, 0x4C, 0xDA,
  0x2E, 0xDA, 0x20, 0xDA, 0x2E, 0x2E, 0x6D, 0x20,
  0x4C, 0x98, 0x66, 0xA3, 0x2F, 0xB2, 0x51, 0x51,
  0xB2, 0xA3, 0xA3, 0xA3, 0x2F, 0x2F, 0x2F, 0x2F,
  0xA0, 0xA0, 0x8F, 0x2F, 0xB2, 0x89, 0xB2, 0xA3,
  0x66, 0x66, 0x98, 0x66, 0x66, 0x66, 0x66, 0xA3,
  0x2F, 0xD1, 0xE2, 0x52, 0x52, 0xF4, 0xBF, 0x9C,
  0x39, 0x6B, 0x6B, 0x6B, 0x7F, 0x4F, 0xE3, 0x6A,
  0xD0, 0xC9, 0xC9, 0xD0, 0xD0, 0x8B, 0x8B, 0x82,
  0x5B, 0x5B, 0x73, 0x8B, 0x59, 0x23, 0x6E, 0x31,
  0x59, 0x7B, 0xDB, 0x84, 0x68, 0x7F, 0xAE, 0x54,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x54, 0xA6, 0x3A,
  0xA0, 0xA3, 0xA3, 0x2F, 0x51, 0x51, 0x51, 0xB2,
  0x2F, 0xA3, 0x66, 0x66, 0xA3, 0xA3, 0xA3, 0xA3,
  0x8F, 0x8F, 0x66, 0x2F, 0x51, 0x51, 0xB2, 0xA3,
  0x66, 0x98, 0x98, 0x66, 0x66, 0xA3, 0x2F, 0x2F,
  0x3C, 0x88, 0x8D, 0x52, 0x52, 0x5D, 0xF7, 0xBF,
  0xCE, 0xA2, 0x6B, 0x6B, 0x6B, 0x6B, 0x7F, 0x85,
  0x70, 0xC9, 0xC9, 0xC9, 0xD0, 0xEA, 0x8B, 0x5B,
  0x82, 0xEA, 0x82, 0x82, 0x42, 0x57, 0x3D, 0x68,
  0x68, 0x57, 0x4A, 0x34, 0x22, 0xCC, 0x21, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0xDA, 0xA7, 0x6D,
  0xDF, 0xB2, 0xB2, 0xB2, 0xB2, 0xB2, 0x2F, 0x2F,
  0xA3, 0x66, 0x66, 0x66, 0xA3, 0xA3, 0x2F, 0x2F,
  0x66, 0x66, 0xA3, 0x2F, 0xB2, 0xB2, 0x2F, 0x66,
  0x8F, 0x8F, 0x8F, 0x98, 0xA3, 0xA3, 0x89, 0xD8,
  0x25, 0x5C, 0x3B, 0x5D, 0x52, 0x80, 0x70, 0x36,
  0x71, 0xA7, 0x44, 0x6B, 0x84, 0xCB, 0xAA, 0xF3,
  0xC9, 0xC9, 0xC9, 0xC9, 0xD0, 0x8B, 0x5B, 0x5B,
  0x5B, 0xEA, 0x82, 0x47, 0x7B, 0x68, 0x3D, 0x3D,
  0x6B, 0x3D, 0x6C, 0x2B, 0x80, 0x61, 0x96, 0x81,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x3A, 0xDA, 0x63,
  0xAC, 0x6C, 0xB2, 0xB2, 0xB2, 0xB2, 0x2F, 0xA3,
  0xA3, 0x66, 0xA3, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F,
  0x66, 0x98, 0x66, 0xA3, 0xB2, 0xB2, 0x2F, 0x66,
  0x8F, 0x8F, 0x2F, 0xD8, 0xE4, 0xCD, 0xAA, 0xB4,
  0x78, 0x2B, 0x3B, 0x70, 0x46, 0x5D, 0x5D, 0x52,
  0x9D, 0x81, 0x3A, 0xA3, 0xCD, 0x48, 0xBE, 0x4F,
  0xC3, 0xC9, 0xD0, 0xD0, 0xD0, 0xEA, 0x5B, 0x8B,
  0x5B, 0x82, 0x8B, 0x59, 0x4A, 0xF3, 0x33, 0x7F,
  0x3D, 0x6B, 0x4F, 0x6F, 0x5D, 0x52, 0x63, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x75, 0x85,
  0x72, 0xDC, 0xD8, 0x2F, 0xA3, 0x2F, 0xA3, 0xA3,
  0xA3, 0xA3, 0xA3, 0xA3, 0xA3, 0xA3, 0xA3, 0xA3,
  0xA3, 0x98, 0x66, 0x2F, 0xB2, 0x51, 0xA3, 0x98,
  0xA0, 0xA3, 0x93, 0xCF, 0x79, 0x27, 0x5C, 0x79,
  0x2B, 0x30, 0x80, 0x80, 0x5D, 0x5D, 0x5D, 0x5D,
  0x3F, 0x69, 0x20, 0x20, 0x2A, 0xD6, 0x3D, 0x6B,
  0x84, 0xE3, 0x34, 0xB7, 0xC9, 0xD0, 0xD0, 0xF2,
  0xD0, 0x8B, 0x31, 0x68, 0x68, 0x6E, 0x31, 0x33,
  0x7F, 0x7E, 0xA1, 0x6F, 0x52, 0x8D, 0xE5, 0xBF,
  0x20, 0x20, 0x20, 0x20, 0x81, 0xA8, 0x78, 0x52,
  0x52, 0xD2, 0xD8, 0xA3, 0xA3, 0x2F, 0x2F, 0xA3,
  0xA3, 0x66, 0x98, 0x98, 0x98, 0x98, 0x98, 0x66,
  0x51, 0x66, 0x2F, 0x51, 0x51, 0xB2, 0xA3, 0xA0,
  0xA0, 0x44, 0x78, 0xEF, 0x52, 0x30, 0x30, 0x30,
  0x3B, 0x70, 0x5D, 0x5D, 0x5D, 0x80, 0x5D, 0x5D,
  0x46, 0xC1, 0x71, 0x20, 0x81, 0xB1, 0xDD, 0x3D,
  0xA1, 0xE7, 0xDB, 0xCA, 0xD2, 0x6A, 0x6A, 0x6A,
  0xF3, 0xE9, 0xDB, 0x8A, 0x84, 0x3D, 0x84, 0xDC,
  0x25, 0x44, 0xB5, 0xEE, 0x30, 0xEF, 0xF0, 0x32,
  0x69, 0x5F, 0x4B, 0xA8, 0x99, 0x56, 0x67, 0x30,
  0x30, 0x34, 0xB2, 0x2F, 0xA3, 0xA3, 0x66, 0x66,
  0x98, 0x8F, 0x98, 0x98, 0x66, 0x66, 0x66, 0x66,
  0x51, 0x2F, 0xB2, 0x51, 0x51, 0x2F, 0x66, 0xA0,
  0x8F, 0xE0, 0xF9, 0x8D, 0x52, 0x5D, 0x46, 0x5D,
  0x80, 0x5D, 0x80, 0x5D, 0x5D, 0x5D, 0x5D, 0x5D,
  0x52, 0x52, 0x60, 0x81, 0x20, 0x20, 0x6D, 0xD1,
  0x48, 0xE7, 0x6B, 0x33, 0xF6, 0x7F, 0x7F, 0xDB,
  0x84, 0x6B, 0x6C, 0x6A, 0xF3, 0xEB, 0x6B, 0x3D,
  0x4F, 0xD8, 0xCD, 0x79, 0x30, 0x67, 0xF9, 0x24,
  0xED, 0xD9, 0x8C, 0xED, 0x37, 0x2B, 0x3B, 0x5D,
  0x80, 0x85, 0x4E, 0x98, 0x66, 0x66, 0x66, 0x66,
  0x66, 0x66, 0x66, 0xA3, 0x2F, 0x2F, 0x2F, 0x2F,
  0x51, 0x2F, 0xB2, 0xB2, 0xB2, 0xA3, 0x8F, 0x8F,
  0x98, 0xE0, 0xF0, 0x67, 0x5D, 0x80, 0x80, 0x5D,
  0x5D, 0x5D, 0x5D, 0x5D, 0x80, 0x5D, 0x5D, 0x5D,
  0x5D, 0x70, 0x27, 0x4B, 0x20, 0x81, 0x71, 0x3A,
  0xB5, 0xEB, 0x3D, 0xF1, 0xE1, 0x84, 0x84, 0xF1,
  0xE3, 0x3D, 0x6B, 0x6C, 0x34, 0xE7, 0x6B, 0x6B,
  0xD6, 0x74, 0x5E, 0x78, 0x67, 0x30, 0xEE, 0x5C,
  0xF9, 0xF9, 0x45, 0x5C, 0x2B, 0x3B, 0x5D, 0x5D,
  0x5D, 0x5D, 0xF8, 0x44, 0x66, 0x66, 0x66, 0x66,
  0x2F, 0x2F, 0xB2, 0xB2, 0xB2, 0xB2, 0xB2, 0xB2,
  0xB2, 0x2F, 0xA3, 0xA3, 0xA3, 0x98, 0x8F, 0x98,
  0x66, 0x83, 0x76, 0x67, 0x30, 0x80, 0x5D, 0x80,
  0x5D, 0x5D, 0x80, 0x5D, 0x5D, 0x5D, 0x5D, 0x5D,
  0x80, 0x5D, 0x22, 0xFA, 0x20, 0x81, 0x20, 0x20,
  0xA5, 0x6B, 0x6B, 0xE8, 0xBE, 0x3D, 0x6B, 0x2C,
  0xE1, 0xEB, 0x6B, 0x3D, 0x3E, 0xA1, 0x6B, 0x6B,
  0x4D, 0x74, 0xE8, 0x62, 0x67, 0x30, 0x8D, 0x67,
  0xEE, 0xEE, 0xEE, 0x67, 0x30, 0x80, 0x5D, 0x5D,
  0x52, 0x5D, 0x85, 0xAC, 0x3E, 0xA3, 0x66, 0x66,
  0x2F, 0x51, 0x51, 0x51, 0x51, 0xB2, 0x2F, 0x2F,
  0x2F, 0xA3, 0xA3, 0x66, 0x98, 0x8F, 0x8F, 0x66,
  0x2F, 0x83, 0xBC, 0xEE, 0x5D, 0x5D, 0x5D, 0x5D,
  0x5D, 0x5D, 0x5D, 0x5D, 0x5D, 0x80, 0x5D, 0x5D,
  0x5D, 0x5D, 0x22, 0xB0, 0xAE, 0x81, 0x20, 0x20,
  0x4C, 0x3D, 0xEB, 0x39, 0x57, 0x6B, 0x6B, 0x3E,
  0x97, 0x3D, 0x6B, 0x3D, 0x6B, 0x6B, 0x6B, 0x6B,
  0x3D, 0x3C, 0xBA, 0x62, 0xEE, 0x5D, 0x5D, 0x30,
  0x30, 0x8D, 0x8D, 0x30, 0x52, 0x5D, 0x5D, 0x80,
  0x5D, 0x5D, 0x5D, 0x85, 0xB0, 0x6E, 0x2F, 0x66,
  0x2F, 0xB2, 0x51, 0xB2, 0x2F, 0x2F, 0xA3, 0xA3,
  0xB2, 0xA3, 0x66, 0x98, 0x98, 0x8F, 0x98, 0xA3,
  0x2F, 0x51, 0xDE, 0x8E, 0x30, 0x5D, 0x5D, 0x5D,
  0x5D, 0x5D, 0x5D, 0x5D, 0x5D, 0x5D, 0x5D, 0x5D,
  0x52, 0x80, 0x5D, 0x22, 0x43, 0x4B, 0x20, 0x6D,
  0x44, 0x6B, 0x6B, 0x3D, 0x6B, 0x6B, 0x6B, 0x4D,
  0x3D, 0x6B, 0x6B, 0x6B, 0x6B, 0x6B, 0x3D, 0x6B,
  0x4D, 0x2A, 0xAE, 0x76, 0xEE, 0x30, 0x80, 0x80,
  0x80, 0x80, 0x80, 0x80, 0x5D, 0x5D, 0x5D, 0x80,
  0x5D, 0x5D, 0x80, 0x80, 0x5D, 0x7A, 0xB6, 0x51,
  0xB2, 0xB2, 0xB2, 0xA3, 0x66, 0x66, 0x66, 0xA3,
  0x2F, 0x66, 0x98, 0x8F, 0xA0, 0x98, 0xA3, 0x2F,
  0x2F, 0x51, 0xAB, 0x8E, 0x5D, 0x5D, 0x5D, 0x5D,
  0x5D, 0x5D, 0x5D, 0x5D, 0x5D, 0x5D, 0x5D, 0x80,
  0x5D, 0x80, 0x5D, 0x52, 0x52, 0x94, 0x2F, 0x7E,
  0x6B, 0x3D, 0x6B, 0x6B, 0x6B, 0x6B, 0x6B, 0x6B,
  0x6B, 0x6B, 0x6B, 0x6B, 0x6B, 0x6B, 0x6B, 0x7E,
  0xAD, 0x54, 0xAE, 0x24, 0x2B, 0x3B, 0x5D, 0x52,
  0x5D, 0x5D, 0x5D, 0x5D, 0x80, 0x5D, 0x5D, 0x80,
  0x5D, 0x52, 0x52, 0x5D, 0x5D, 0x5D, 0xD2, 0x3E,
  0x89, 0x89, 0xB2, 0xA3, 0x66, 0x98, 0x66, 0x66,
  0x2F, 0x66, 0x8F, 0x8F, 0xA0, 0x98, 0xA3, 0xB2,
  0x2F, 0x51, 0xDE, 0x79, 0x5D, 0x80, 0x5D, 0x5D,
  0x5D, 0x5D, 0x5D, 0x5D, 0x5D, 0x5D, 0x5D, 0x5D,
  0x5D, 0x5D, 0x80, 0x5D, 0x52, 0x6F, 0xA4, 0x6B,
  0x6B, 0x6B, 0x6B, 0x6B, 0x6B, 0x6B, 0x6B, 0x6B,
  0x6B, 0x6B, 0x6B, 0x6B, 0x6B, 0x4D, 0xA2, 0xCE,
  0x20, 0x20, 0x95, 0x24, 0x67, 0x3B, 0x80, 0x80,
  0x5D, 0x5D, 0x5D, 0x5D, 0x5D, 0x5D, 0x5D, 0x5D,
  0x80, 0x5D, 0x5D, 0x5D, 0x5D, 0x30, 0xB0, 0x86,
  0x89, 0x51, 0x2F, 0x66, 0x98, 0x98, 0xA3, 0xA3,
  0xA3, 0x66, 0x8F, 0xA0, 0x8F, 0x66, 0x2F, 0xB2,
  0x2F, 0x4E, 0x76, 0x2B, 0x30, 0x5D, 0x5D, 0x5D,
  0x80, 0x80, 0x5D, 0x5D, 0x5D, 0x5D, 0x5D, 0x5D,
  0x80, 0x5D, 0x5D, 0x5D, 0x46, 0x52, 0x21, 0x74,
  0x6B, 0x6B, 0x6B, 0x6B, 0x6B, 0x6B, 0x6B, 0x6B,
  0x6B, 0x6B, 0x6B, 0x6B, 0x7E, 0x98, 0x3A, 0x20,
  0x20, 0x81, 0x60, 0xED, 0x2B, 0x52, 0x5D, 0x5D,
  0x80, 0x5D, 0x5D, 0x80, 0x5D, 0x5D, 0x5D, 0x80,
  0x22, 0x5D, 0x5D, 0x5D, 0x8D, 0x2B, 0x38, 0x39,
  0x51, 0x66, 0x8F, 0xA0, 0xA0, 0x8F, 0x98, 0x66,
  0x66, 0x66, 0x8F, 0x55, 0x8F, 0xA3, 0xB2, 0xB2,
  0xA3, 0xE8, 0xF9, 0x30, 0x3B, 0x80, 0x5D, 0x5D,
  0x5D, 0x80, 0x80, 0x5D, 0x5D, 0x5D, 0x80, 0x5D,
  0x5D, 0x5D, 0x5D, 0x5D, 0x52, 0x30, 0xD4, 0x99,
  0x51, 0x4D, 0x6B, 0x6B, 0x6B, 0x6B, 0x4D, 0x6B,
  0x6B, 0x6B, 0x7E, 0xA3, 0x2E, 0x20, 0x20, 0x20,
  0x20, 0x81, 0xC5, 0xED, 0x2B, 0x3B, 0x5D, 0x5D,
  0x5D, 0x5D, 0x5D, 0x5D, 0x80, 0x5D, 0x5D, 0x80,
  0x5D, 0x52, 0x52, 0x6F, 0xDE, 0x2C, 0x39, 0x51,
  0x66, 0xA0, 0xA5, 0xA5, 0x55, 0x8F, 0x66, 0x66,
  0xA0, 0xA0, 0xA0, 0xA0, 0x8F, 0xA3, 0x2F, 0x2F,
  0x51, 0xD5, 0x45, 0x8D, 0x3B, 0x5D, 0x80, 0x5D,
  0x5D, 0x5D, 0x5D, 0x5D, 0x5D, 0x5D, 0x5D, 0x5D,
  0x80, 0x5D, 0x5D, 0x5D, 0x52, 0x67, 0x37, 0xA9,
  0x3A, 0xCE, 0xA0, 0x2F, 0x51, 0x51, 0xB2, 0xA3,
  0xA5, 0x9C, 0x54, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x54, 0x99, 0xED, 0x67, 0x30, 0x5D, 0x5D,
  0x5D, 0x80, 0x5D, 0x5D, 0x5D, 0x5D, 0x3B, 0x80,
  0x8D, 0x79, 0x48, 0x2C, 0x39, 0x44, 0xB2, 0x66,
  0xA0, 0x2A, 0xA5, 0xA0, 0x8F, 0x66, 0xA3, 0xA3,
  0xA0, 0x8F, 0x8F, 0xA0, 0x8F, 0xA3, 0xB2, 0xB2,
  0xD8, 0xBC, 0x45, 0xEE, 0x67, 0x8D, 0x30, 0x30,
  0x52, 0x52, 0x80, 0x5D, 0x5D, 0x5D, 0x5D, 0x80,
  0x5D, 0x5D, 0x5D, 0x80, 0x3B, 0x67, 0xF9, 0x32,
  0x69, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0xBF, 0xEC, 0xED, 0x2B, 0x30, 0x5D, 0x5D,
  0x80, 0x5D, 0x5D, 0x5D, 0x52, 0x30, 0x67, 0x2B,
  0xCF, 0xAA, 0xD8, 0x89, 0x89, 0x51, 0x66, 0x55,
  0x2A, 0x2A, 0xA5, 0x8F, 0x66, 0xA3, 0x2F, 0x2F,
  0xA3, 0xA3, 0x66, 0x98, 0x98, 0x2F, 0xB2, 0x2F,
  0xD1, 0x28, 0x56, 0xED, 0x62, 0x37, 0x5C, 0x79,
  0x8E, 0x2B, 0x2B, 0x30, 0x30, 0x30, 0x5D, 0x5D,
  0x5D, 0x5D, 0x5D, 0x80, 0x3B, 0xEE, 0x56, 0xA9,
  0x75, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x5F, 0x99, 0xD9, 0x45, 0x8D, 0x3B, 0x5D,
  0x5D, 0x3B, 0x5D, 0x8D, 0x2B, 0x79, 0x79, 0x41,
  0x83, 0xB2, 0xB2, 0x89, 0x89, 0x2F, 0xA0, 0x2A,
  0xAD, 0xA5, 0x98, 0x66, 0xA3, 0xB2, 0x2F, 0xB2,
  0xD8, 0xB2, 0xA3, 0x98, 0x98, 0x2F, 0x51, 0xB2,
  0xA3, 0x83, 0x3E, 0x25, 0xD5, 0xE5, 0x50, 0x8C,
  0xED, 0x24, 0x24, 0xF0, 0x45, 0x8E, 0x2B, 0x30,
  0x30, 0x5D, 0x3B, 0x30, 0xEE, 0xF0, 0xC6, 0x65,
  0x75, 0x71, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x4B, 0xC5, 0x7D, 0x24, 0xEE, 0x67, 0x30,
  0x30, 0x8D, 0x67, 0x8E, 0xF9, 0xF7, 0x97, 0xDD,
  0x2F, 0x2F, 0x51, 0x89, 0x89, 0x2F, 0x55, 0x2A,
  0xA5, 0x8F, 0x66, 0xA3, 0x2F, 0xB2, 0xB2, 0xB2,
  0xDD, 0xA3, 0x66, 0x98, 0x66, 0x2F, 0xB2, 0xB2,
  0xA3, 0xA3, 0xB2, 0x51, 0x89, 0x44, 0xE0, 0x5E,
  0x91, 0x9F, 0x9F, 0x7D, 0x7D, 0xD9, 0x24, 0xF0,
  0x79, 0x8E, 0xEE, 0x8E, 0x24, 0x40, 0x65, 0x35,
  0x69, 0x2E, 0x98, 0xA3, 0x2F, 0x2F, 0x2F, 0x2F,
  0x2F, 0xB2, 0xB2, 0xB2, 0x2F, 0x2F, 0x2F, 0x98,
  0xA5, 0xA7, 0x95, 0xD7, 0x8C, 0xF0, 0x8E, 0x8E,
  0xEE, 0x79, 0xF0, 0xED, 0x50, 0xE8, 0x89, 0x2F,
  0xA3, 0xA3, 0xB2, 0x89, 0xB2, 0x66, 0xA0, 0x55,
  0x8F, 0x98, 0x66, 0xA3, 0xB2, 0x51, 0x51, 0xB2,
  0x74, 0xA0, 0xA0, 0x98, 0x66, 0xB2, 0xB2, 0xB2,
  0xA3, 0xA3, 0x2F, 0xB2, 0xB2, 0xB2, 0xA3, 0x2F,
  0x51, 0x83, 0xE4, 0x87, 0xB8, 0xFA, 0xA9, 0xC6,
  0x40, 0x64, 0x64, 0x50, 0xD7, 0x65, 0x35, 0x60,
  0x98, 0xB2, 0x66, 0x66, 0xA3, 0x2F, 0xA3, 0xA3,
  0xA3, 0x2F, 0x2F, 0x2F, 0x2F, 0xA3, 0x2F, 0xB2,
  0x89, 0xDD, 0x9B, 0xC0, 0x7D, 0x50, 0x8C, 0xED,
  0xED, 0x8C, 0x40, 0x9F, 0x4E, 0x51, 0xB2, 0x2F,
  0x2F, 0x2F, 0xB2, 0x51, 0xA3, 0x98, 0xA0, 0x55,
  0xA0, 0xA0, 0x8F, 0x66, 0x2F, 0x51, 0xB2, 0xA3,
  0xA3, 0x2A, 0x55, 0x98, 0xA3, 0x2F, 0xB2, 0x2F,
  0x66, 0x66, 0x2F, 0xB2, 0xD1, 0x2F, 0x2F, 0xA3,
  0xB2, 0xB2, 0xA3, 0x8F, 0xA3, 0x2F, 0xD1, 0x94,
  0xEC, 0x65, 0x65, 0xC0, 0xC0, 0x35, 0x95, 0xC2,
  0xA3, 0x98, 0x66, 0xA3, 0x2F, 0x2F, 0x2F, 0xA3,
  0xA3, 0x2F, 0xB2, 0x2F, 0x2F, 0x2F, 0x2F, 0x51,
  0x89, 0x44, 0xD1, 0x60, 0x35, 0xA9, 0x32, 0xC6,
  0xD7, 0x32, 0x94, 0x44, 0x2F, 0xB2, 0xB2, 0xB2,
  0xA3, 0x2F, 0xB2, 0x2F, 0xA3, 0x8F, 0xA0, 0xA0,
  0x55, 0xA0, 0x8F, 0xA3, 0x51, 0x51, 0x2F, 0xA3,
  0x8F, 0x2A, 0x55, 0x66, 0xA3, 0x2F, 0x2F, 0xB2,
  0xA3, 0x66, 0x2F, 0xB2, 0x51, 0xB2, 0x2F, 0x66,
  0xA3, 0xA3, 0x66, 0x8F, 0x8F, 0x8F, 0xA0, 0x2F,
  0x5E, 0xDF, 0xB9, 0x60, 0x95, 0xD3, 0x89, 0x2F,
  0xA3, 0x66, 0xA3, 0x2F, 0xB2, 0x2F, 0xA3, 0xA3,
  0xA3, 0xA3, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0xB2,
  0x51, 0x2F, 0x8F, 0x2F, 0xC4, 0xB9, 0x9B, 0xEC,
  0x53, 0xB3, 0x4E, 0xA3, 0x2F, 0xB2, 0xB2, 0xB2,
  0xA3, 0x66, 0xA3, 0xA3, 0x66, 0x8F, 0x8F, 0x8F,
  0x8F, 0x8F, 0xA3, 0x51, 0x89, 0x51, 0xA3, 0x66,
  0xA0, 0x55, 0x8F, 0xA3, 0x2F, 0x2F, 0x2F, 0xB2,
  0x2F, 0xA3, 0x2F, 0x51, 0x51, 0xB2, 0xA3, 0x66,
  0x66, 0xA3, 0x66, 0x66, 0x66, 0x66, 0x66, 0xA3,
  0xB2, 0xC2, 0x74, 0xD8, 0xB2, 0xA3, 0xA3, 0xA3,
  0x66, 0x66, 0x2F, 0x2F, 0xA3, 0x66, 0x66, 0x66,
  0xA3, 0xA3, 0xB2, 0xB2, 0xB2, 0xB2, 0x2F, 0xB2,
  0x2F, 0x66, 0xA0, 0x55, 0x98, 0x2F, 0x89, 0x89,
  0x89, 0xB2, 0x2F, 0xA3, 0x2F, 0x51, 0x51, 0xB2,
  0x2F, 0x66, 0xA3, 0xA3, 0x66, 0x66, 0x66, 0x66,
  0x66, 0xA3, 0xB2, 0x89, 0xD8, 0x51, 0xA3, 0x98,
  0x66, 0x98, 0x66, 0x2F, 0x2F, 0x2F, 0x2F, 0xB2,
  0xB2, 0xA3, 0xA3, 0xB2, 0xB2, 0xB2, 0x2F, 0xA3,
  0x66, 0xA3, 0xA3, 0xA3, 0x2F, 0x2F, 0x2F, 0xB2,
  0x89, 0xD8, 0x89, 0x2F, 0x66, 0x66, 0xA3, 0xA3,
  0x98, 0x98, 0x66, 0x66, 0x98, 0x98, 0x66, 0xA3,
  0x2F, 0xA3, 0xB2, 0xB2, 0xB2, 0xB2, 0x2F, 0x2F,
  0xB2, 0x2F, 0x66, 0x98, 0x66, 0xA3, 0x2F, 0x2F,
  0x2F, 0xB2, 0x2F, 0xA3, 0xA3, 0xB2, 0xB2, 0x2F,
  0x2F, 0x66, 0x66, 0xA3, 0xA3, 0xA3, 0x2F, 0x2F,
  0x2F, 0xB2, 0x89, 0xD8, 0x44, 0x2F, 0x66, 0x66,
  0xA3, 0xA3, 0xA3, 0xA3, 0x2F, 0x2F, 0x2F, 0x2F,
  0x2F, 0xA3, 0xA3, 0xA3, 0x2F, 0x2F, 0x2F, 0xA3,
  0x66, 0xA3, 0x2F, 0xB2, 0xB2, 0xB2, 0x51, 0x51,
  0x89, 0x89, 0xB2, 0xA3, 0x98, 0x66, 0xA3, 0x66,
  0x98, 0x98, 0x98, 0x98, 0x98, 0x66, 0xA3, 0x2F,
  0xA3, 0x2F, 0xB2, 0xB2, 0xB2, 0xB2, 0xB2, 0xB2,
  0xB2, 0x2F, 0xA3, 0xA3, 0xA3, 0x2F, 0x2F, 0x2F,
  0x2F, 0xB2, 0xB2, 0xA3, 0xA3, 0x2F, 0x2F, 0x2F,
  0x2F, 0xA3, 0x66, 0xA3, 0x2F, 0xB2, 0xB2, 0xB2,
  0x51, 0x51, 0x89, 0x89, 0xB2, 0xA3, 0x98, 0x66
};

unsigned char linux_logo_bw[] __initdata = {
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x80, 0x00, 0x3F,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x1F,
  0xFE, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFE, 0x3F, 0xFF, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFE, 0x7F, 0xFF, 0xC7, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0xFF, 0xFF, 0xC3,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0xFF,
  0xFB, 0xE3, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFD, 0xFF, 0xFF, 0xE1, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xF9, 0xFF, 0xFF, 0xF1, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xF9, 0xFF, 0xFF, 0xF1,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF9, 0xFF,
  0xFF, 0xF8, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xF9, 0xFF, 0xFF, 0xF8, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xF9, 0xCF, 0xC3, 0xF8, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xF9, 0x87, 0x81, 0xF9,
  0xF8, 0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xF9, 0xA7,
  0x99, 0xF9, 0xC2, 0x40, 0xFF, 0xFF, 0xFF, 0xFF,
  0xF9, 0xF3, 0xBC, 0xF9, 0x90, 0x00, 0x1F, 0xFF,
  0xFF, 0xFF, 0xF9, 0xE3, 0xBC, 0xF9, 0xA0, 0x00,
  0x8F, 0xFF, 0xFF, 0xFF, 0xF9, 0xB0, 0x3C, 0xF9,
  0x83, 0xE0, 0x2F, 0xFF, 0xFF, 0xFF, 0xF9, 0xB0,
  0x19, 0xF0, 0x1F, 0xFE, 0x0F, 0xFF, 0xFF, 0xFF,
  0xF9, 0xC0, 0x03, 0xF0, 0x3F, 0xF7, 0x8F, 0xFF,
  0xFF, 0xFF, 0xF9, 0x80, 0x01, 0xF8, 0x7F, 0xF7,
  0xC7, 0xFF, 0xFF, 0xFF, 0xF9, 0x80, 0x01, 0xF8,
  0x6F, 0xF7, 0xE7, 0xFF, 0xFF, 0xFF, 0xF9, 0x80,
  0x01, 0xF8, 0x7F, 0xF7, 0xE7, 0xFF, 0xFF, 0xFF,
  0xF9, 0xC0, 0x21, 0xD8, 0x7F, 0xE7, 0xEF, 0xFF,
  0xFF, 0xFF, 0xF9, 0xB1, 0x80, 0xEC, 0x7B, 0xFF,
  0xEF, 0xFF, 0xFF, 0xFF, 0xF1, 0x90, 0x00, 0xE4,
  0x7B, 0xFF, 0xEF, 0xFF, 0xFF, 0xFF, 0xF1, 0x8C,
  0xC0, 0x7C, 0x79, 0xFF, 0xEF, 0xFF, 0xFF, 0xFF,
  0xE3, 0x80, 0x00, 0x7C, 0x7C, 0xFF, 0xCF, 0xFF,
  0xFF, 0xFF, 0xE3, 0x80, 0x00, 0x7F, 0x77, 0xFF,
  0xDF, 0xFF, 0xFF, 0xFF, 0x87, 0x00, 0x00, 0x3F,
  0x3F, 0xFF, 0xDF, 0xFF, 0xFF, 0xFF, 0x0E, 0x00,
  0x00, 0x3F, 0xBF, 0xFF, 0x9F, 0xFF, 0xFF, 0xFF,
  0x1E, 0x00, 0x00, 0x1F, 0x9F, 0xFF, 0x3F, 0xFF,
  0xFF, 0xFE, 0x1C, 0x00, 0x00, 0x1F, 0x9F, 0xFF,
  0x7F, 0xFF, 0xFF, 0xFE, 0x3C, 0x00, 0x00, 0x1F,
  0x8F, 0xFE, 0x7F, 0xFF, 0xFF, 0xFC, 0x7C, 0x00,
  0x00, 0x0F, 0xC7, 0xFC, 0xFF, 0xFF, 0xFF, 0xFC,
  0xF8, 0x00, 0x00, 0x0F, 0xF7, 0xF9, 0xFF, 0xFF,
  0xFF, 0xFC, 0xF8, 0x00, 0x00, 0x07, 0xFB, 0xF3,
  0xFF, 0xFF, 0xFF, 0xF8, 0xF8, 0x00, 0x00, 0x07,
  0xFD, 0xE7, 0xFF, 0xFF, 0xFF, 0xF9, 0xF0, 0x00,
  0x00, 0x03, 0xFE, 0x8F, 0xFF, 0xFF, 0xFF, 0xF1,
  0xF0, 0x00, 0x00, 0x03, 0xFE, 0x1F, 0xFF, 0xFF,
  0xFF, 0xF1, 0xE0, 0x00, 0x00, 0x00, 0xFF, 0xBF,
  0xFF, 0xFF, 0xFF, 0xE3, 0xE0, 0x00, 0x00, 0x00,
  0xFE, 0xBF, 0xFF, 0xFF, 0xFF, 0xE3, 0xC0, 0x00,
  0x00, 0x00, 0xFE, 0x3F, 0xFF, 0xFF, 0xFF, 0xC7,
  0xC0, 0x00, 0x00, 0x01, 0xFE, 0xBF, 0xFF, 0xFF,
  0xFF, 0xC7, 0x80, 0x00, 0x00, 0x01, 0xFE, 0x9F,
  0xFF, 0xFF, 0xFF, 0x8F, 0x80, 0x00, 0x00, 0x01,
  0xFE, 0x07, 0xFF, 0xFF, 0xFF, 0x8F, 0x80, 0x00,
  0x00, 0x01, 0xFE, 0x87, 0xFF, 0xFF, 0xFF, 0x9F,
  0x80, 0x00, 0x00, 0x01, 0xFD, 0x33, 0xFF, 0xFF,
  0xFF, 0x9F, 0x80, 0x00, 0x00, 0x01, 0x80, 0xF3,
  0xFF, 0xFF, 0xFF, 0x9E, 0x80, 0x00, 0x00, 0x03,
  0x8B, 0xF9, 0xFF, 0xFF, 0xFF, 0x9F, 0x80, 0x00,
  0x00, 0x02, 0x27, 0xF8, 0xFF, 0xFF, 0xFF, 0x99,
  0x80, 0x00, 0x00, 0x00, 0x07, 0xF8, 0xFF, 0xFF,
  0xFF, 0x00, 0x80, 0x00, 0x00, 0x01, 0x8F, 0xF8,
  0xFF, 0xFF, 0xFE, 0x20, 0x60, 0x00, 0x00, 0x00,
  0xE3, 0xF8, 0xFF, 0xFF, 0xF8, 0x00, 0x30, 0x00,
  0x00, 0x00, 0xF8, 0x78, 0xFF, 0xFF, 0xC0, 0x40,
  0x38, 0x00, 0x00, 0x00, 0xFE, 0x00, 0x7F, 0xFF,
  0x81, 0x00, 0x1C, 0x00, 0x00, 0x00, 0xFC, 0x20,
  0x7F, 0xFF, 0x90, 0x00, 0x1E, 0x00, 0x00, 0x00,
  0x78, 0x10, 0xFF, 0xFF, 0x80, 0x00, 0x0F, 0x80,
  0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x80, 0x00,
  0x07, 0xC0, 0x00, 0x00, 0x00, 0x08, 0xFF, 0xFF,
  0xC0, 0x00, 0x07, 0xC0, 0x00, 0x00, 0x00, 0x04,
  0x7F, 0xFF, 0x80, 0x00, 0x03, 0xC0, 0x00, 0x10,
  0x00, 0x00, 0x1F, 0xFF, 0x80, 0x00, 0x01, 0x80,
  0x00, 0x30, 0x00, 0x00, 0x0F, 0xFF, 0x80, 0x00,
  0x00, 0x00, 0x00, 0x70, 0x00, 0x01, 0x4F, 0xFF,
  0x80, 0x00, 0x00, 0x00, 0x00, 0xF0, 0x00, 0x00,
  0x0F, 0xFF, 0xC0, 0x00, 0x00, 0x80, 0x03, 0xF0,
  0x00, 0x00, 0x8F, 0xFF, 0x80, 0x00, 0x00, 0x40,
  0x0F, 0xF0, 0x00, 0x04, 0x1F, 0xFF, 0x80, 0x00,
  0x00, 0x7F, 0xFF, 0xF0, 0x00, 0x10, 0x1F, 0xFF,
  0xC0, 0x00, 0x00, 0x7F, 0xFF, 0xF0, 0x00, 0x40,
  0xFF, 0xFF, 0x98, 0x00, 0x00, 0xFF, 0xFF, 0xF0,
  0x00, 0x83, 0xFF, 0xFF, 0x81, 0xE0, 0x01, 0xFF,
  0xFF, 0xF8, 0x02, 0x07, 0xFF, 0xFF, 0x80, 0x3F,
  0x07, 0xE0, 0x00, 0x1C, 0x0C, 0x1F, 0xFF, 0xFF,
  0xF8, 0x03, 0xFF, 0x80, 0x00, 0x1F, 0x78, 0x1F,
  0xFF, 0xFF, 0xFF, 0x80, 0x7F, 0x00, 0x07, 0x0F,
  0xF0, 0x7F, 0xFF, 0xFF, 0xFF, 0xFE, 0x0C, 0x07,
  0xFF, 0x83, 0xC0, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0x00, 0x1F, 0xFF, 0xC0, 0x03, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x07, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
};

unsigned char linux_logo16_red[0];
unsigned char linux_logo16_green[0];
unsigned char linux_logo16_blue[0];
unsigned char linux_logo16[0];

#else

/* prototypes only */
extern unsigned char linux_logo_red[];
extern unsigned char linux_logo_green[];
extern unsigned char linux_logo_blue[];
extern unsigned char linux_logo[];
extern unsigned char linux_logo_bw[];
extern unsigned char linux_logo16_red[];
extern unsigned char linux_logo16_green[];
extern unsigned char linux_logo16_blue[];
extern unsigned char linux_logo16[];

#endif
