/*
 * Copyright (c) 1998 Wyman Miles
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted provided
 * that: (1) source distributions retain this entire copyright notice and
 * comment, and (2) distributions including binaries display the following
 * acknowledgement:  ``This product includes software developed by
 * Wyman Miles, Rice University, Houston, Texas and its contributors''
 * in the documentation or other materials provided with the distribution
 * and in all advertising materials mentioning features or use of this
 * software.
 * Neither the name of the University nor the names of its contributors may
 * be used to endorse or promote products derived from this software without
 * specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <strings.h>
#include <unistd.h>
#include <pwd.h> 
#ifdef SHADOW_PASSWORDS
#include <shadow.h>
#endif
#include <crypt.h>
#include <netinet/in.h>
#include <netdb.h>

#ifdef LINUX
#define PAM_STATIC
#include <security/pam_modules.h>
#endif

#ifdef SOLARIS
#define PAM_EXTERN   extern
#include <security/pam_appl.h>
#endif

#include <sys/types.h>
#include <sys/param.h>


#ifdef HAVE_SECURID
#include "sdi_athd.h"
#include "sdi_size.h"
#include "sdi_type.h"
#include "sdacmvls.h"
#include "sdconf.h"
#include "sdi_defs.h"
union config_record configure;
static int securid_initialized = 0;
int creadcfg(void);
int sd_init(struct SD_CLIENT *sd);
int sd_check(char *passcode, char *username, struct SD_CLIENT *sd);
int sd_next(char *nextcode, struct SD_CLIENT *sd);
int sd_pin(char *pin, char canceled, struct SD_CLIENT *sd);
void sd_close(void);
int delay = 0;
#ifndef SDACE_FILE
#define SDACE_FILE "/etc/sdace.txt"
#endif
#endif

#ifdef HAVE_SKEY
extern int skey_haskey(char *username);
extern int skey_passcheck(char *username, char *response);
#include "skey.h"
#endif

int either = 0;
int skey_only = 0;
int securid_only = 0;

PAM_EXTERN int pam_sm_setcred (pam_handle_t *pamh,
			       int flags,
			       int argc,
			       const char **argv)
{
  return PAM_SUCCESS;
}

PAM_EXTERN int pam_sm_authenticate(pam_handle_t *pamh,
                                   int flags,
                                   int argc,
                                   const char **argv)
{
	struct passwd *pwd = NULL;
#ifdef SHADOW_PASSWORDS
	struct spwd *spwd = NULL;
#endif
	char *password = NULL;
#ifdef HAVE_SKEY
	char *challenge = NULL;
	struct skey *keydat = NULL;
#endif
	char *username = NULL;
	char *service = NULL;
	int status;
	char *tty_name = NULL ;
	char message_buf[PAM_MAX_MSG_SIZE];
	struct pam_conv *conversation = NULL;
	struct pam_message message;
	struct pam_message *pmessage = &message;
	struct pam_response *response = NULL;
#ifdef HAVE_SECURID
	struct SD_CLIENT sd_dat, *sd;
	char szVarAce[256]; 
	FILE *sdacefp;
/*	FILE *fp; */
#endif

	/* process our args */
	while (argc-- > 0) {
	  if (!strcmp(*argv, "securid_only")) {
	    securid_only = 1;
	  }
	  if (!strcmp(*argv, "skey_only")) {
	    skey_only = 1;
	  }
	  if (atoi(*argv) != 0) {
	    delay = atoi(*argv);
	  }
	  if (!strcmp(*argv, "either")) {
	    either = 1;
	  }
	  ++argv;
	}
	
	
/* determine the username and the terminal.  if we've got root coming in 
 * on the console, return a Password: prompt and validate the user
 * otherwise, drop through and do securid */

	if (pam_get_item (pamh, PAM_SERVICE, (void **)&service) != PAM_SUCCESS) {
	  fprintf(stderr, "Unable to determine service!\n");
	  return(PAM_SERVICE_ERR);
	}

	/* so, here's the deal.  we'd like telnet, rlogin, and rsh to use
	 * s/key, assuming other pams fall through to this one */


	if (strcmp(service, "login") == 0) {
	  
	if (pam_get_item (pamh, PAM_TTY, (void **)&tty_name) != PAM_SUCCESS) {
	  fprintf(stderr, "Unable to determine TTY!\n");
	  return (PAM_SERVICE_ERR);
	}
	
	if (pam_get_item (pamh, PAM_USER, (void **)&username) != PAM_SUCCESS) {
	  fprintf(stderr, "Unable to determine username!\n");
	  return (PAM_SERVICE_ERR);
	}

#ifdef SHADOW_PASSWORDS
	spwd = getspnam(username);
	if (spwd == NULL) {
	  fprintf(stderr, "No password info available: %s\n", username);
	  return (PAM_SERVICE_ERR);
	}
	pwd = getpwnam(username);
	if (pwd == NULL) {
	  fprintf(stderr, "No password info available: %s\n", username);
	  return (PAM_SERVICE_ERR);
	}
#else
	pwd = getpwnam(username);
	if (pwd == NULL) {
	  fprintf(stderr, "No password info available for: %s\n", username);
	  return (PAM_SERVICE_ERR);
	}
#endif
	if ((pwd -> pw_uid == 0) && (!strncmp(tty_name, "/dev/console",
					      strlen("/dev/console")))) {
	  /* root logging in on the console */
	  password = getpass("pam: Password: ");
#ifdef SHADOW_PASSWORDS
	  status = strcmp(crypt(password, spwd -> sp_pwdp), spwd -> sp_pwdp);
	  /* bzero out the passwords now that we're done */
	  bzero(password, strlen(password));
	  bzero(spwd -> sp_pwdp, strlen(spwd -> sp_pwdp));
#else
	  status = strcmp(crypt(password, pwd -> pw_passwd), pwd -> pw_passwd);
	  bzero(password, strlen(password));
	  bzero(pwd -> pw_passwd, strlen(pwd -> pw_passwd);
#endif
	  
	  if (status == 0) {
	      return(PAM_SUCCESS);
	    } else {
	      return(PAM_PERM_DENIED);
	    }
	  }
	} /* here we are, done with console login  */
	
	/* what've we got left...there's rlogin, rsh, and telnet */
	
	
	if (strcmp(service, "telnet") == 0) {
	  if (pam_get_user(pamh, &username, "login: ") != PAM_SUCCESS) {
	    return(PAM_SERVICE_ERR);
	  }
	  
	} else {
	  /* we should be able to get the username with a call to
	     pam_get_item(blah, PAM_USER, blah) as above */
	  if (pam_get_item (pamh, PAM_USER, (void **)&username) != PAM_SUCCESS) {
	    fprintf(stderr, "Unable to determine username!\n");
	    return (PAM_SERVICE_ERR);
	  } 
	} /* now, we should have a username */


#ifdef HAVE_SKEY	
	/* now for the skey portion of our show. */
	switch (skey_haskey(username)) {
	case 1:
	  return (PAM_USER_UNKNOWN);
	case -1:
	  return (PAM_AUTHINFO_UNAVAIL);
	case 0:
	  break;
	default:
	  return (PAM_AUTHINFO_UNAVAIL);
	}
	
	challenge = (char *) malloc(PAM_MAX_MSG_SIZE);

	if (challenge == NULL) {
	  fprintf(stderr, "unable to malloc\n");
	  return(PAM_SERVICE_ERR);
	}

	snprintf(challenge, PAM_MAX_MSG_SIZE, "s/key %s\nPassword: ", skey_keyinfo (username));

	/* now that we have a challenge, open a connection to the user
	 * and get his response */
	
	message.msg_style = PAM_PROMPT_ECHO_ON; /* let them see their typing */
	
	message.msg = challenge; /* their s/key challenge */
#endif

#ifdef HAVE_SECURID
	/* read the sdace.txt file and attempt to find the sdconf.rec */
	
	sdacefp = fopen(SDACE_FILE, "r");
	if (sdacefp == NULL) {
	  /* we have no config file...not necessarily a bad thing */
	  /* why?  if we don't have the sdconf.rec and securid file in the
	   * expected location, we'll fizzle anyway */
	} else {
	  fscanf(sdacefp, "%s", szVarAce);
	  fclose(sdacefp);
	  /* we should find our config at that location */
	  putenv(szVarAce);
	}
	  
	message.msg_style = PAM_PROMPT_ECHO_OFF;

	snprintf(message_buf, PAM_MAX_MSG_SIZE, "PASSCODE required for %s:",
		 username);

	message.msg = message_buf;
#endif
	/* hand it over and get the result */
	status = pam_get_item(pamh, PAM_CONV, (void **)&conversation);
	if (status != PAM_SUCCESS) {
	  return(PAM_SERVICE_ERR);
	}
	conversation -> conv(1, (struct pam_message **)&pmessage,
			     &response, conversation ->appdata_ptr);
	

	status = pam_set_item(pamh, PAM_AUTHTOK, response -> resp);
	if (status != PAM_SUCCESS) {
	  return(PAM_SERVICE_ERR);
	}
	
#ifdef HAVE_SKEY
	if ((skey_passcheck(username, response -> resp)) != -1) {
	  /* free everything we've malloc'd */
	  free(challenge);
	  free(pmessage);
	  return (PAM_AUTH_ERR);
	} else {
	  free(challenge);
	  free(pmessage);
	  return (PAM_SUCCESS);
	}
#endif

#ifdef HAVE_SECURID
	/* do securID crap inside here */
	/* if we don't have a response, bail */
	if (response -> resp == '\0') {
	  return(PAM_AUTH_ERR);
	}
	sd = &sd_dat;
	if (!securid_initialized) {
	  memset(&sd_dat, 0, sizeof(sd_dat));   /* clear struct */
	  creadcfg();         /*  accesses sdconf.rec  */
	  if (sd_init(sd)) { 
	    return(PAM_SERVICE_ERR);
	  }
	  securid_initialized = 1;
	}
	
	status = sd_check(response -> resp, username, sd);

	if (status == ACM_OK) {
	  return(PAM_SUCCESS);
	}
	if (status == ACM_ACCESS_DENIED) {
	  sleep(delay);
	  return(PAM_PERM_DENIED);
	}
	/* handle PIN changes and whatnot */
	if (status == ACM_NEXT_CODE_REQUIRED) {
	  /* notify the user that we need the next code */
	  message.msg_style = PAM_PROMPT_ECHO_OFF;
	  snprintf(message_buf, sizeof(message_buf), "The SecurID server requires the next PASSCODE generated by your token: ");
	  message.msg = message_buf;
	  /* hand it over and get the result */
	  status = pam_get_item(pamh, PAM_CONV, (void **)&conversation);
	  if (status != PAM_SUCCESS) {
	    return(PAM_SERVICE_ERR);
	  }
	  conversation -> conv(1, (struct pam_message **)&pmessage,
			       &response, conversation ->appdata_ptr);
	  
	  /* response -> resp should be the next tokencode */
	  status = sd_next(response -> resp, sd);
	  sd_close();
	  if (status == ACM_OK) {
	    return(PAM_SUCCESS);
	  } else {
	    sleep(delay);
	    return(PAM_PERM_DENIED);
	  }
	} /* done with next code required */
	
	if (status == ACM_NEW_PIN_REQUIRED) {
	  /* we can either offer up the suggested PIN,
	   * let them select a PIN,
	   * or not let them in.
	   */

	  if (sd ->user_selectable == CANNOT_CHOOSE_PIN) {
	    /* we give them the system PIN and bail. */
	    snprintf(message_buf, sizeof(message_buf), "The SecurID system has generated a new PIN that you must use: %s\n", sd ->system_pin);
	    /* initialize the conversation struct and give it to them */
	    message.msg_style = PAM_TEXT_INFO;	
	    message.msg = message_buf;
	    status = pam_get_item(pamh, PAM_CONV, (void **)&conversation);
	    if (status != PAM_SUCCESS) {
	      return(PAM_SERVICE_ERR);
	    }
	    conversation -> conv(1, (struct pam_message **)&pmessage,
				 &response, conversation ->appdata_ptr);
	    /* they've been informed.  set the PIN */
	    status = sd_pin (sd -> system_pin, 0, sd);
	    sd_close();
	    if (status == ACM_NEW_PIN_ACCEPTED) {
	      return(PAM_SUCCESS);
	    } else {
	      sleep(delay);
	      return(PAM_PERM_DENIED);
	    }
	  } /* done with the forced PIN */
	  else {
	    /* they don't have a choice */
	    snprintf(message_buf, sizeof(message_buf), 
		     "You must choose a 4-8 digit numeric PIN to use with the token card for %s.\nEnter a PIN: ", username);
	    message.msg_style = PAM_PROMPT_ECHO_OFF;
	    message.msg = message_buf;
	    status = pam_get_item(pamh, PAM_CONV, (void **)&conversation);
	    if (status != PAM_SUCCESS) {
	      return(PAM_SERVICE_ERR);
	    }
	    conversation -> conv(1, (struct pam_message **)&pmessage,
				 &response, conversation ->appdata_ptr);
	    /* test the length of the PIN */
	    if (strlen(response -> resp) < 4 || strlen(response -> resp) > 8) {
	      sd_close();
	      sleep(delay);
	      return(PAM_PERM_DENIED);
	    }
	    /* OK.  set the PIN */
	    status = sd_pin (response -> resp, 0, sd);
	    sd_close();
	    if (status == ACM_NEW_PIN_ACCEPTED) {
	      return(PAM_SUCCESS);
	    } else {
	      sleep(delay);
	      return(PAM_PERM_DENIED);
	    }
	  } /* done with the new PIN */

	} /* end new PIN required */

#endif
	/* we should never get here */
#ifdef HAVE_SECURID
	sd_close();
#endif
	return(PAM_PERM_DENIED);

}
