#include <linux/errno.h>
#include <linux/sched.h>
#include <linux/kernel.h>
#include <linux/signal.h>
#include <linux/errno.h>
#include <linux/ctype.h>
#include <linux/ptrace.h>
#include <linux/mm.h>
#include <linux/malloc.h>
#include <linux/stat.h>
#include <asm/string.h>
#include <asm/segment.h>
#include <asm/pgtable.h>
#include <asm/io.h>
#include <linux/proc_fs.h>
#include <linux/module.h>
#include "include/syscallmgr.h"
#include "ucmd.h"

extern int printk( const char* fmt, ...);
extern int sys_execve(), _TRANSIENT_sys_execve();
extern int getname();
extern int console_loglevel;
extern 

static struct file_operations proc_ucmd_operations = {
        NULL,           /* lseek */
        ucmd_read,
        NULL,           /* write */
        NULL,           /* readdir */
        ucmd_select,    /* select */
        NULL,           /* ioctl */
        NULL,           /* mmap */
        ucmd_open,
        ucmd_release,
        NULL            
};

struct inode_operations proc_ucmd_inode_operations = {
        &proc_kmsg_operations,  /* default base directory file-ops */
        NULL,                   /* create */
        NULL,                   /* lookup */
        NULL,                   /* link */
        NULL,                   /* unlink */
        NULL,                   /* symlink */
        NULL,                   /* mkdir */
        NULL,                   /* rmdir */
        NULL,                   /* mknod */
        NULL,                   /* rename */
        NULL,                   /* readlink */
        NULL,                   /* follow_link */
        NULL,                   /* readpage */
        NULL,                   /* writepage */
        NULL,                   /* bmap */
        NULL,                   /* truncate */
        NULL                    /* permission */
};


proc_read_inode_alternate(struct inode *inode) {

        unsigned long ino, pid;
        struct task_struct * p;
        int i;

        inode->i_op = NULL;
        inode->i_mode = 0;
        inode->i_uid = 0;
        inode->i_gid = 0;
        inode->i_nlink = 1;
        inode->i_size = 0;
        inode->i_mtime = inode->i_atime = inode->i_ctime = CURRENT_TIME;
        inode->i_blocks = 0;
        inode->i_blksize = 1024;
        ino = inode->i_ino;
        pid = ino >> 16;
        p = task[0];
        for (i = 0; i < NR_TASKS ; i++)
                if ((p = task[i]) && (p->pid == pid))
                        break;
        if (!p || i >= NR_TASKS)
                return;

        if (!pid) {
		if (ino==PROC_UCMD) {
			inode->i_mode = S_IFREG | S_IRUSR;
			inode->i_op = &proc_kmsg_inode_operations;
		} else {
			proc_read_inode(&inode);
		}
	}
	return;
}
	
			
			                                                                break;
		
void init_it(void) {

	proc_register (&proc_root,&(struct proc_dir_entry) {
			PROC_UCMD,4,"ucmd",
			S_IFREG|S_IURGO,1,0,0,
		      });

}






