/* 
 * (C) Copyright 1992, ..., 2000 the "DOSEMU-Development-Team".
 *
 * for details see file COPYING in the DOSEMU distribution
 */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <linux/kd.h>
#include <linux/keyboard.h>
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <errno.h>

#include "config.h"
#include "keymaps.h"
#include "keyb_clients.h"

static int is_a_console(int);
static int open_a_console(char *);
static int getfd(void);
static char *dosemu_val(unsigned, unsigned *);
static int read_kbd_table(struct keytable_entry *);


/* DANG_BEGIN_MODULE
 * 
 * REMARK
 * These are definitions, giving which key is related to which scancode in
 * raw keyboard mode. Basically, the code of 'x' on a US keyboard may be that
 * of a 'Y' on a German keyboard. This way, all types of keyboard can be
 * represented under DOSEMU. Also, the right ALT-key is often a function
 * key in it's own right.
 *
 * /REMARK
 * DANG_END_MODULE
 *
 * DANG_BEGIN_CHANGELOG
 *
 * 1999/06/16: Added support for automatic keyboard configuration.
 * Latin-1 keyboards should work. Latin-2 probably not.
 * -- sw (Steffen Winterfeldt <wfeldt@suse.de>)
 *
 * DANG_END_CHANGELOG
 *
 */


CONST unsigned char key_map_finnish[] =
{
  0, 27, '1', '2', '3', '4', '5', '6',
  '7', '8', '9', '0', '+', '\'', 127, 9,
  'q', 'w', 'e', 'r', 't', 'y', 'u', 'i',
  'o', 'p', '}', 0, 13, 0, 'a', 's',
  'd', 'f', 'g', 'h', 'j', 'k', 'l', '|',
  '{', 0, 0, '\'', 'z', 'x', 'c', 'v',
  'b', 'n', 'm', ',', '.', '-', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '<', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char shift_map_finnish[] =
{
  0, 27, '!', '\"', '#', '$', '%', '&',
  '/', '(', ')', '=', '?', '`', 127, 9,
  'Q', 'W', 'E', 'R', 'T', 'Y', 'U', 'I',
  'O', 'P', ']', '^', 13, 0, 'A', 'S',
  'D', 'F', 'G', 'H', 'J', 'K', 'L', '\\',
  '[', 0, 0, '*', 'Z', 'X', 'C', 'V',
  'B', 'N', 'M', ';', ':', '_', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '>', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char alt_map_finnish[] =
{
  0, 0, 0, '@', 163, '$', 0, 0,
  '{', '[', ']', '}', '\\', 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, '~', 13, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, '|', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char key_map_finnish_latin1[] =
{
  0, 27, '1', '2', '3', '4', '5', '6',
  '7', '8', '9', '0', '+', 180, 127, 9,
  'q', 'w', 'e', 'r', 't', 'y', 'u', 'i',
  'o', 'p', 134, 168, 13, 0, 'a', 's',
  'd', 'f', 'g', 'h', 'j', 'k', 'l', 148,
  132, 167, 0, '\'', 'z', 'x', 'c', 'v',
  'b', 'n', 'm', ',', '.', '-', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '<', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char shift_map_finnish_latin1[] =
{
  0, 27, '!', '"', '#', '$', '%', '&',
  '/', '(', ')', '=', '?', '`', 127, 9,
  'Q', 'W', 'E', 'R', 'T', 'Y', 'U', 'I',
  'O', 'P', 143, '^', 13, 0, 'A', 'S',
  'D', 'F', 'G', 'H', 'J', 'K', 'L', 153,
  142, 171, 0, '*', 'Z', 'X', 'C', 'V',
  'B', 'N', 'M', ';', ':', '_', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '>', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char alt_map_finnish_latin1[] =
{
  0, 0, 0, '@', 156, '$', 0, 0,
  '{', '[', ']', '}', '\\', 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, '~', 13, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, '|', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char key_map_us[] =
{
  0, 27, '1', '2', '3', '4', '5', '6',
  '7', '8', '9', '0', '-', '=', 127, 9,
  'q', 'w', 'e', 'r', 't', 'y', 'u', 'i',
  'o', 'p', '[', ']', 13, 0, 'a', 's',
  'd', 'f', 'g', 'h', 'j', 'k', 'l', ';',
  '\'', '`', 0, '\\', 'z', 'x', 'c', 'v',
  'b', 'n', 'm', ',', '.', '/', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '<', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char shift_map_us[] =
{
  0, 27, '!', '@', '#', '$', '%', '^',
  '&', '*', '(', ')', '_', '+', 127, 9,
  'Q', 'W', 'E', 'R', 'T', 'Y', 'U', 'I',
  'O', 'P', '{', '}', 13, 0, 'A', 'S',
  'D', 'F', 'G', 'H', 'J', 'K', 'L', ':',
  '"', '~', '0', '|', 'Z', 'X', 'C', 'V',
  'B', 'N', 'M', '<', '>', '?', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '>', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

#if 0
CONST unsigned char alt_map_us[] =
{
  0, 0, 0, '@', 0, '$', 0, 0,
  '{', '[', ']', '}', '\\', 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, '~', 13, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, '|', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};
#else
CONST unsigned char alt_map_us[] =
{
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};
#endif

CONST unsigned char key_map_jp106[] =
{
  0, 27, '1', '2', '3', '4', '5', '6',
  '7', '8', '9', '0', '-', '^', 127, 9,
  'q', 'w', 'e', 'r', 't', 'y', 'u', 'i',
  'o', 'p', '@', '[', 13, 0, 'a', 's',
  'd', 'f', 'g', 'h', 'j', 'k', 'l', ';',
  ':', '`', 0, ']', 'z', 'x', 'c', 'v',
  'b', 'n', 'm', ',', '.', '/', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '0', 0,
  0, '\\', 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, '\\', 0, 0, 0, 0,
  0, 0, 0, 0, 0, '\\', 0, 0,
  0};

CONST unsigned char shift_map_jp106[] =
{
  0, 27, '!', '"', '#', '$', '%', '&',
  '\'', '(', ')', '~', '=', '~', 127, 9,
  'Q', 'W', 'E', 'R', 'T', 'Y', 'U', 'I',
  'O', 'P', '`', '{', 1, 0, 'A', 'S',
  'D', 'F', 'G', 'H', 'J', 'K', 'L', '+',
  '*', '~', '0', '}', 'Z', 'X', 'C', 'V',
  'B', 'N', 'M', '<', '>', '?', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '0', 0,
  0, '_', 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, '_', 0, 0, 0, 0,
  0, 0, 0, 0, 0, '|', 0, 0,
  0};

CONST unsigned char alt_map_jp106[] =
{
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};


CONST unsigned char key_map_uk[] =
{
  0, 27, '1', '2', '3', '4', '5', '6',
  '7', '8', '9', '0', '-', '=', 127, 9,
  'q', 'w', 'e', 'r', 't', 'y', 'u', 'i',
  'o', 'p', '[', ']', 13, 0, 'a', 's',
  'd', 'f', 'g', 'h', 'j', 'k', 'l', ';',
  '\'', '`', 0, '#', 'z', 'x', 'c', 'v',
  'b', 'n', 'm', ',', '.', '/', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '\\', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char shift_map_uk[] =
{
  0, 27, '!', '"', 156, '$', '%', '^',
  '&', '*', '(', ')', '_', '+', 127, 9,
  'Q', 'W', 'E', 'R', 'T', 'Y', 'U', 'I',
  'O', 'P', '{', '}', 13, 0, 'A', 'S',
  'D', 'F', 'G', 'H', 'J', 'K', 'L', ':',
  '@', '~', '0', '~', 'Z', 'X', 'C', 'V',
  'B', 'N', 'M', '<', '>', '?', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '|', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char alt_map_uk[] =
{
  0, 0, 0, '@', 0, '$', 0, 0,
  '{', '[', ']', '}', '\\', 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, '~', 13, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  DEAD_ACUTE, DEAD_GRAVE, 0, DEAD_TILDE, 0, 0, 0, 0, /*dead keys for testing */
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, '|', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char key_map_de[] =
{
  0, 27, '1', '2', '3', '4', '5', '6',
  '7', '8', '9', '0', 0xe1, '\'', 127, 9,
  'q', 'w', 'e', 'r', 't', 'z', 'u', 'i',
  'o', 'p', 0x81, '+', 13, 0, 'a', 's',
  'd', 'f', 'g', 'h', 'j', 'k', 'l', 0x94,
  0x84, '^', 0, '#', 'y', 'x', 'c', 'v',
  'b', 'n', 'm', ',', '.', '-', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '<', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char shift_map_de[] =
{
  0, 27, '!', '"', 0x9c, '$', '%', '&',
  '/', '(', ')', '=', '?', '`', 127, 9,
  'Q', 'W', 'E', 'R', 'T', 'Z', 'U', 'I',
  'O', 'P', 0x9A, '*', 13, 0, 'A', 'S',
  'D', 'F', 'G', 'H', 'J', 'K', 'L', 0x99,
  0x8e, 0xf8, 0, '\'', 'Y', 'X', 'C', 'V',
  'B', 'N', 'M', ';', ':', '_', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '>', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char alt_map_de[] =
{
  0, 0, 0, 0xfd, 0xfc, 0, 0, 0,
  '{', '[', ']', '}', '\\', 0, 0, 0,
  '@', 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, '~', 13, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0xe6, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, '|', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char key_map_de_latin1[] =
{
  0, 27, '1', '2', '3', '4', '5', '6',
  '7', '8', '9', '0', 225, DEAD_ACUTE, 127, 9,
  'q', 'w', 'e', 'r', 't', 'z', 'u', 'i',
  'o', 'p', 129, '+', 13, 0, 'a', 's',
  'd', 'f', 'g', 'h', 'j', 'k', 'l', 148,
  132, DEAD_CIRCUMFLEX, 0, '#', 'y', 'x', 'c', 'v',
  'b', 'n', 'm', ',', '.', '-', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '<', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char shift_map_de_latin1[] =
{
  0, 27, '!', '"', 21, '$', '%', '&',
  '/', '(', ')', '=', '?', DEAD_GRAVE, 127, 9,
  'Q', 'W', 'E', 'R', 'T', 'Z', 'U', 'I',
  'O', 'P', 154, '*', 13, 0, 'A', 'S',
  'D', 'F', 'G', 'H', 'J', 'K', 'L', 153,
  142, 248, 0, '\'', 'Y', 'X', 'C', 'V',
  'B', 'N', 'M', ';', ':', '_', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '>', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char alt_map_de_latin1[] =
{
  0, 0, 0, 253, 252, '$', 0, 0,
  '{', '[', ']', '}', '\\', 0, 0, 0,
  '@', 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, '~', 13, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 230, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, '|', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char key_map_fr[] =
{
  0, 27, '&', '{', '"', '\'', '(', '-',
  '}', '_', '/', '@', ')', '=', 127, 9,
  'a', 'z', 'e', 'r', 't', 'y', 'u', 'i',
  'o', 'p', '^', '$', 13, 0, 'q', 's',
  'd', 'f', 'g', 'h', 'j', 'k', 'l', 'm',
  '|', '`', 0, 42, 'w', 'x', 'c', 'v',
  'b', 'n', ',', ';', ':', '!', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '<', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char shift_map_fr[] =
{
  0, 27, '1', '2', '3', '4', '5', '6',
  '7', '8', '9', '0', ']', '+', 127, 9,
  'A', 'Z', 'E', 'R', 'T', 'Y', 'U', 'I',
  'O', 'P', '<', '>', 13, 0, 'Q', 'S',
  'D', 'F', 'G', 'H', 'J', 'K', 'L', 'M',
  '%', '~', 0, '#', 'W', 'X', 'C', 'V',
  'B', 'N', '?', '.', '/', '\\', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '>', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char alt_map_fr[] =
{
  0, 0, 0, '~', '#', '{', '[', '|',
  '`', '\\', '^', '@', ']', '}', 0, 0,
  '@', 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, '~', 13, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, '|', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char key_map_fr_latin1[] =
{
  0, 27, '&', 0x82, '"', '\'', '(', '-',
  0x8a, '_', 0x87, 0x85, ')', '=', 127, 9,
  'a', 'z', 'e', 'r', 't', 'y', 'u', 'i',
  'o', 'p', DEAD_CIRCUMFLEX, '$', 13, 0, 'q', 's',
  'd', 'f', 'g', 'h', 'j', 'k', 'l', 'm',
  0x97, 0xfd, 0, 42, 'w', 'x', 'c', 'v',
  'b', 'n', ',', ';', ':', '!', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '<', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char shift_map_fr_latin1[] =
{
  0, 27, '1', '2', '3', '4', '5', '6',
  '7', '8', '9', '0', 0xf8, '+', 127, 9,
  'A', 'Z', 'E', 'R', 'T', 'Y', 'U', 'I',
  'O', 'P', DEAD_DIAERESIS, 0x9c, 13, 0, 'Q', 'S',
  'D', 'F', 'G', 'H', 'J', 'K', 'L', 'M',
  '%', '~', 0, 0xe6, 'W', 'X', 'C', 'V',
  'B', 'N', '?', '.', '/', 167, 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '>', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char alt_map_fr_latin1[] =
{
  0, 0, 0, '~', '#', '{', '[', '|',
  '`', '\\', '^', '@', ']', '}', 0, 0,
  '@', 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 164, 13, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, '|', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char key_map_dk[] =
{
  0, 27, '1', '2', '3', '4', '5', '6',
  '7', '8', '9', '0', '+', '\'', 127, 9,
  'q', 'w', 'e', 'r', 't', 'y', 'u', 'i',
  'o', 'p', 134, 0, 13, 0, 'a', 's',
  'd', 'f', 'g', 'h', 'j', 'k', 'l', 145,
  155, 0, 0, '\'', 'z', 'x', 'c', 'v',
  'b', 'n', 'm', ',', '.', '-', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '<', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};
 
CONST unsigned char shift_map_dk[] =
{
  0, 27, '!', '\"', '#', '$', '%', '&',
  '/', '(', ')', '=', '?', '`', 127, 9,
  'Q', 'W', 'E', 'R', 'T', 'Y', 'U', 'I',
  'O', 'P', 143, '^', 13, 0, 'A', 'S',
  'D', 'F', 'G', 'H', 'J', 'K', 'L', 146,
  157, 0, 0, '*', 'Z', 'X', 'C', 'V',
  'B', 'N', 'M', ';', ':', '_', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '>', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char alt_map_dk[] =
{
  0, 0, 0, '@', 163, '$', 0, 0,
  '{', '[', ']', '}', 0, '|', 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, '~', 13, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, '\\', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char key_map_dk_latin1[] =
{
  0, 27, '1', '2', '3', '4', '5', '6',
  '7', '8', '9', '0', '+', 180, 127, 9,
  'q', 'w', 'e', 'r', 't', 'y', 'u', 'i',
  'o', 'p', 229, 168, 13, 0, 'a', 's',
  'd', 'f', 'g', 'h', 'j', 'k', 'l', 230,
  162, 189, 0, '\'', 'z', 'x', 'c', 'v',
  'b', 'n', 'm', ',', '.', '-', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '<', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char shift_map_dk_latin1[] =
{
  0, 27, '!', '\"', '#', '$', '%', '&',
  '/', '(', ')', '=', '?', '`', 127, 9,
  'Q', 'W', 'E', 'R', 'T', 'Y', 'U', 'I',
  'O', 'P', 197, '^', 13, 0, 'A', 'S',
  'D', 'F', 'G', 'H', 'J', 'K', 'L', 198,
  165, 167, 0, '*', 'Z', 'X', 'C', 'V',
  'B', 'N', 'M', ';', ':', '_', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '>', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char alt_map_dk_latin1[] =
{
  0, 0, 0, '@', 163, '$', 0, 0,
  '{', '[', ']', '}', 0, '|', 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, '~', 13, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, '\\', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char key_map_dvorak[] =
{
  0, 27, '1', '2', '3', '4', '5', '6',
  '7', '8', '9', '0', '\\', '=', 127, 9,
  '\'', ',', '.', 'p', 'y', 'f', 'g', 'c',
  'r', 'l', '/', ']', 13, 0, 'a', 'o',
  'e', 'u', 'i', 'd', 'h', 't', 'n', 's',
  '-', '`', 0, '[', ';', 'q', 'j', 'k',
  'x', 'b', 'm', 'w', 'v', 'z', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '<', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char shift_map_dvorak[] =
{
  0, 27, '!', '@', '#', '$', '%', '^',
  '&', '*', '(', ')', '|', '+', 127, 9,
  '"', '<', '>', 'P', 'Y', 'F', 'G', 'C',
  'R', 'L', '?', '}', 13, 0, 'A', 'O',
  'E', 'U', 'I', 'D', 'H', 'T', 'N', 'S',
  '_', '~', 0, '{', ':', 'Q', 'J', 'K',
  'X', 'B', 'M', 'W', 'V', 'Z', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '<', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char alt_map_dvorak[] =
{
  0, 0, 0, '@', 0, '$', 0, 0,
  '{', '[', ']', '}', '\\', 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, '~', 13, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, '|', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char key_map_sg[] =
{
  0, 27, '1', '2', '3', '4', '5', '6',
  '7', '8', '9', '0', '\'', '^', 127, 9,
  'q', 'w', 'e', 'r', 't', 'z', 'u', 'i',
  'o', 'p', 0, 0, 13, 0, 'a', 's',
  'd', 'f', 'g', 'h', 'j', 'k', 'l', 0,
  0, 0, 0, '$', 'y', 'x', 'c', 'v',
  'b', 'n', 'm', ',', '.', '-', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '<', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char shift_map_sg[] =
{
  0, 27, '+', '"', '*', 0, '%', '&',
  '/', '(', ')', '=', '?', '`', 127, 9,
  'Q', 'W', 'E', 'R', 'T', 'Z', 'U', 'I',
  'O', 'P', 0, '!', 13, 0, 'A', 'S',
  'D', 'F', 'G', 'H', 'J', 'K', 'L', 0,
  0, 0, 0, 0, 'Y', 'X', 'C', 'V',
  'B', 'N', 'M', ';', ':', '_', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '>', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char alt_map_sg[] =
{
  0, 0, 0, '@', '#', 0, 0, 0,
  '|', 0, 0, 0, '\'', '~', 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '[', ']', 13, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  '{', 0, 0, '}', 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, '\\', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char key_map_sg_latin1[] =
{
  0, 27, '1', '2', '3', '4', '5', '6',
  '7', '8', '9', '0', '\'', '^', 127, 9,
  'q', 'w', 'e', 'r', 't', 'z', 'u', 'i',
  'o', 'p', 192, 0, 13, 0, 'a', 's',
  'd', 'f', 'g', 'h', 'j', 'k', 'l', 148,
  132, 167, 0, '$', 'y', 'x', 'c', 'v',
  'b', 'n', 'm', ',', '.', '-', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '<', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char shift_map_sg_latin1[] =
{
  0, 27, '+', '"', '*', 128, '%', '&',
  '/', '(', ')', '=', '?', '`', 127, 9,
  'Q', 'W', 'E', 'R', 'T', 'Z', 'U', 'I',
  'O', 'P', 154, '!', 13, 0, 'A', 'S',
  'D', 'F', 'G', 'H', 'J', 'K', 'L', 153,
  142, 176, 0, 163, 'Y', 'X', 'C', 'V',
  'B', 'N', 'M', ';', ':', '_', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '>', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char alt_map_sg_latin1[] =
{
  0, 0, 179, '@', '#', 0, 0, 170,
  '|', 162, 0, 0, '\'', '~', 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '[', ']', 13, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 233,
  '{', 0, 0, '}', 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, '\\', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char key_map_no[] =
{
  0, 27, '1', '2', '3', '4', '5', '6',
  '7', '8', '9', '0', '+', '\\', 127, 9,
  'q', 'w', 'e', 'r', 't', 'y', 'u', 'i',
  'o', 'p', '}', '~', 13, 0, 'a', 's',
  'd', 'f', 'g', 'h', 'j', 'k', 'l', '|',
  '{', '|', 0, '\'', 'z', 'x', 'c', 'v',
  'b', 'n', 'm', ',', '.', '-', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '<', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char shift_map_no[] =
{
  0, 27, '!', '\"', '#', '$', '%', '&',
  '/', '(', ')', '=', '?', '`', 127, 9,
  'Q', 'W', 'E', 'R', 'T', 'Y', 'U', 'I',
  'O', 'P', ']', '^', 13, 0, 'A', 'S',
  'D', 'F', 'G', 'H', 'J', 'K', 'L', '\\',
  '[', 0, 0, '*', 'Z', 'X', 'C', 'V',
  'B', 'N', 'M', ';', ':', '_', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '>', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char alt_map_no[] =
{
  0, 0, 0, '@', 0, '$', 0, 0,
  '{', '[', ']', '}', 0, '\'', 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, '~', 13, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char key_map_no_latin1[] =
{
  0, 27, '1', '2', '3', '4', '5', '6',
  '7', '8', '9', '0', '+', '\\', 127, 9,
  'q', 'w', 'e', 'r', 't', 'y', 'u', 'i',
  'o', 'p', 134, DEAD_DIAERESIS, 13, 0, 'a', 's',
  'd', 'f', 'g', 'h', 'j', 'k', 'l', 155,
  145, '|', 0, '\'', 'z', 'x', 'c', 'v',
  'b', 'n', 'm', ',', '.', '-', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '<', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char shift_map_no_latin1[] =
{
  0, 27, '!', '\"', '#', '$', '%', '&',
  '/', '(', ')', '=', '?', DEAD_GRAVE, 127, 9,
  'Q', 'W', 'E', 'R', 'T', 'Y', 'U', 'I',
  'O', 'P', 143, DEAD_CIRCUMFLEX, 13, 0, 'A', 'S',
  'D', 'F', 'G', 'H', 'J', 'K', 'L', 157,
  146, 245, 0, '*', 'Z', 'X', 'C', 'V',
  'B', 'N', 'M', ';', ':', '_', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '>', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char alt_map_no_latin1[] =
{
  0, 0, 0, '@', 156, 207, 0, 0,
  '{', '[', ']', '}', 0, DEAD_ACUTE, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, DEAD_TILDE, 13, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char key_map_sf[] =
{
  0, 27, '1', '2', '3', '4', '5', '6',
  '7', '8', '9', '0', '\'', '^', 127, 9,
  'q', 'w', 'e', 'r', 't', 'z', 'u', 'i',
  'o', 'p', 0, 0, 13, 0, 'a', 's',
  'd', 'f', 'g', 'h', 'j', 'k', 'l', 0,
  0, 0, 0, '$', 'y', 'x', 'c', 'v',
  'b', 'n', 'm', ',', '.', '-', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '<', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char shift_map_sf[] =
{
  0, 27, '+', '"', '*', 0, '%', '&',
  '/', '(', ')', '=', '?', '`', 127, 9,
  'Q', 'W', 'E', 'R', 'T', 'Z', 'U', 'I',
  'O', 'P', 0, '!', 13, 0, 'A', 'S',
  'D', 'F', 'G', 'H', 'J', 'K', 'L', 0,
  0, 0, 0, 0, 'Y', 'X', 'C', 'V',
  'B', 'N', 'M', ';', ':', '_', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '>', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char alt_map_sf[] =
{
  0, 0, 0, '@', '#', 0, 0, 0,
  '|', 0, 0, 0, '\'', '~', 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '[', ']', 13, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  '{', 0, 0, '}', 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, '\\', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char key_map_sf_latin1[] =
{
  0, 27, '1', '2', '3', '4', '5', '6',
  '7', '8', '9', '0', '\'', '^', 127, 9,
  'q', 'w', 'e', 'r', 't', 'z', 'u', 'i',
  'o', 'p', 232, 168, 13, 0, 'a', 's',
  'd', 'f', 'g', 'h', 'j', 'k', 'l', 233,
  224, 167, 0, '$', 'y', 'x', 'c', 'v',
  'b', 'n', 'm', ',', '.', '-', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '<', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char shift_map_sf_latin1[] =
{
  0, 27, '+', '"', '*', 231, '%', '&',
  '/', '(', ')', '=', '?', '`', 127, 9,
  'Q', 'W', 'E', 'R', 'T', 'Z', 'U', 'I',
  'O', 'P', 252, '!', 13, 0, 'A', 'S',
  'D', 'F', 'G', 'H', 'J', 'K', 'L', 246,
  228, 176, 0, 163, 'Y', 'X', 'C', 'V',
  'B', 'N', 'M', ';', ':', '_', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '>', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char alt_map_sf_latin1[] =
{
  0, 0, 0, '@', '#', 0, 0, 172,
  '|', 162, 0, 0, 180, '~', 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '[', ']', 13, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  '{', 0, 0, '}', 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, '\\', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char key_map_es[] = {
      0,   27,  '1',  '2',  '3',  '4',  '5',  '6',
    '7',  '8',  '9',  '0', '\'',    0,  127,    9,
    'q',  'w',  'e',  'r',  't',  'y',  'u',  'i',
    'o',  'p',  '`',  '+',   13,    0,  'a',  's',
    'd',  'f',  'g',  'h',  'j',  'k',  'l',    0,
   '\'',  '`',    0,    0,  'z',  'x',  'c',  'v',
    'b',  'n',  'm',  ',',  '.',  '-',    0,  '*',
      0,   32,    0,    0,    0,    0,    0,    0,
      0,    0,    0,    0,    0,    0,    0,    0,
      0,    0,  '-',    0,    0,    0,  '+',    0,
      0,    0,    0,    0,    0,    0,  '<',    0,
      0,    0,    0,    0,    0,    0,    0,    0,
      0 };

CONST unsigned char shift_map_es[] = {
      0,   27,  '!',  '"',  '#',  '$',  '%',  '&',
    '/',  '(',  ')',  '=',  '?',    0,  127,    9, 
    'Q',  'W',  'E',  'R',  'T',  'Y',  'U',  'I',
    'O',  'P',  '^',  '*',   13,    0,  'A',  'S',
    'D',  'F',  'G',  'H',  'J',  'K',  'L',    0,
      0,  '~',    0,    0,  'Z',  'X',  'C',  'V',
    'B',  'N',  'M',  ';',  ':',  '_',    0,  '*',
      0,   32,    0,    0,    0,    0,    0,    0,
      0,    0,    0,    0,    0,    0,    0,    0,
      0,    0,  '-',    0,    0,    0,  '+',    0,
      0,    0,    0,    0,    0,    0,  '>',    0,
      0,    0,    0,    0,    0,    0,    0,    0,
      0 };

CONST unsigned char alt_map_es[] = {
      0,    0,  '|',  '@',  '#',  '$',    0,    0,
    '{',  '[',  ']',  '}', '\\',  '~',    0,    0,
      0,    0,    0,    0,    0,    0,    0,    0,
      0,    0,  '[',  ']',   13,    0,    0,    0,
      0,    0,    0,    0,    0,    0,    0,    0,
    '{', '\\',    0,  '}',    0,    0,    0,    0,
      0,    0,    0,    0,    0,    0,    0,    0,
      0,    0,    0,    0,    0,    0,    0,    0,
      0,    0,    0,    0,    0,    0,    0,    0,
      0,    0,  '~',    0,    0,    0,    0,    0,
      0,    0,    0,    0,    0,    0,  '|',    0,
      0,    0,    0,    0,    0,    0,    0,    0,
      0 };

CONST unsigned char key_map_es_latin1[] = {
      0,   27,  '1',  '2',  '3',  '4',  '5',  '6',
    '7',  '8',  '9',  '0', '\'',  173,  127,    9,
    'q',  'w',  'e',  'r',  't',  'y',  'u',  'i',
    'o',  'p',  DEAD_GRAVE,  '+',   13,    0,  'a',  's',
    'd',  'f',  'g',  'h',  'j',  'k',  'l',  164,
    DEAD_ACUTE,  167,    0,  135,  'z',  'x',  'c',  'v',
    'b',  'n',  'm',  ',',  '.',  '-',    0,  '*',
      0,   32,    0,    0,    0,    0,    0,    0,
      0,    0,    0,    0,    0,    0,    0,    0,
      0,    0,  '-',    0,    0,    0,  '+',    0,
      0,    0,    0,    0,    0,    0,  '<',    0,
      0,    0,    0,    0,    0,    0,    0,    0,
      0 };

CONST unsigned char shift_map_es_latin1[] = {
      0,   27,  '!',  '"',  250,  '$',  '%',  '&',
    '/',  '(',  ')',  '=',  '?',  168,  127,    9, 
    'Q',  'W',  'E',  'R',  'T',  'Y',  'U',  'I',
    'O',  'P',  DEAD_CIRCUMFLEX,  '*',   13,    0,  'A',  'S',
    'D',  'F',  'G',  'H',  'J',  'K',  'L',  165,
    DEAD_DIAERESIS,  166,    0,  128,  'Z',  'X',  'C',  'V',
    'B',  'N',  'M',  ';',  ':',  '_',    0,  '*',
      0,   32,    0,    0,    0,    0,    0,    0,
      0,    0,    0,    0,    0,    0,    0,    0,
      0,    0,  '-',    0,    0,    0,  '+',    0,
      0,    0,    0,    0,    0,    0,  '>',    0,
      0,    0,    0,    0,    0,    0,    0,    0,
      0 };

CONST unsigned char alt_map_es_latin1[] = {
      0,    0,  '|',  '@',  '#',  '$',    0,  172,
    '{',  '[',  ']',  '}', '\\',  '~',    0,    0,
      0,    0,    0,    0,    0,    0,    0,    0,
      0,    0,  '[',  ']',   13,    0,    0,    0,
      0,    0,    0,    0,    0,    0,    0,    0,
    '{', '\\',    0,  '}',    0,    0,    0,    0,
      0,    0,    0,    0,    0,    0,    0,    0,
      0,    0,    0,    0,    0,    0,    0,    0,
      0,    0,    0,    0,    0,    0,    0,    0,
      0,    0,  '~',    0,    0,    0,    0,    0,
      0,    0,    0,    0,    0,    0,  '|',    0,
      0,    0,    0,    0,    0,    0,    0,    0,
      0 };

/* keyboard driver for BELGIAN KEYBOARD */

CONST unsigned char key_map_be[] =
{
  0, 27, '&', 130, '"', '\'', '(', 21,
  138, '!', 128, 133, ')', '-', 127, 9,
  'a', 'z', 'e', 'r', 't', 'y', 'u', 'i',
  'o', 'p', DEAD_CIRCUMFLEX, '$', 13, 0, 'q', 's',
  'd', 'f', 'g', 'h', 'j', 'k', 'l', 'm',
  151, 253, 0, 230, 'w', 'x', 'c', 'v',
  'b', 'n', ',', ';', ':', '=', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '<', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char shift_map_be[] =
{
  0, 27, '1', '2', '3', '4', '5', '6',
  '7', '8', '9', '0', 248, '_', 127, 9,
  'A', 'Z', 'E', 'R', 'T', 'Y', 'U', 'I',
  'O', 'P', DEAD_DIAERESIS, '*', 13, 0, 'Q', 'S',
  'D', 'F', 'G', 'H', 'J', 'K', 'L', 'M',
  '%', 252, 0, 156, 'W', 'X', 'C', 'V',
  'B', 'N', '?', '.', '/', '+', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '>', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char alt_map_be[] =
{
  0, 0, '|', '@', '#', 0, 0, '^',
  0, 0, '{', '}', DEAD_ABOVERING, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '[', ']', 13, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  DEAD_ACUTE, DEAD_GRAVE, 0, DEAD_GRAVE, 0, 0, 0, 0,
  0, 0, DEAD_CEDILLA, 0, 0, DEAD_TILDE, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, '\\', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char key_map_po[] =
{
  0, 27, '1', '2', '3', '4', '5', '6',
  '7', '8', '9', '0', '`', 174, 127, 9,
  'q', 'w', 'e', 'r', 't', 'y', 'u', 'i',
  'o', 'p', '+', DEAD_ACUTE, 13, 0, 'a', 's',
  'd', 'f', 'g', 'h', 'j', 'k', 'l', 135,
  167, '\\', 0, DEAD_TILDE, 'z', 'x', 'c', 'v',
  'b', 'n', 'm', ',', '.', '-', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '<', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char shift_map_po[] =
{
  0, 27, '!', '"', '#', '$', '%', '&',
  '/', '(', ')', '=', '?', 175, 127, 9,
  'Q', 'W', 'E', 'R', 'T', 'Y', 'U', 'I',
  'O', 'P', '*', DEAD_GRAVE, 13, 0, 'A', 'S',
  'D', 'F', 'G', 'H', 'J', 'K', 'L', 128,
  166, '|', '0', DEAD_CIRCUMFLEX, 'Z', 'X', 'C', 'V',
  'B', 'N', 'M', ';', ':', '_', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '>', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char alt_map_po[] =
{
  0, 0, 0, '@', 156, 21, 0, 0,
  '{', '[', ']', '}', 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, DEAD_DIAERESIS, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char key_map_it[] =
{
  0, 27, '1', '2', '3', '4', '5', '6',
  '7', '8', '9', '0', '\'', 141, 127, 9,
  'q', 'w', 'e', 'r', 't', 'y', 'u', 'i',
  'o', 'p', 138, '+', 13, 0, 'a', 's',
  'd', 'f', 'g', 'h', 'j', 'k', 'l', 149,
  133, '\\', 0, 151, 'z', 'x', 'c', 'v',
  'b', 'n', 'm', ',', '.', '-', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '<', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char shift_map_it[] =
{
  0, 27, '!', '\"', 156, '$', '%', '&',
  '/', '(', ')', '=', '?', '^', 127, 9,
  'Q', 'W', 'E', 'R', 'T', 'Y', 'U', 'I',
  'O', 'P', 130, '*', 13, 0, 'A', 'S',
  'D', 'F', 'G', 'H', 'J', 'K', 'L', 135,
  248, '|', '0', 21, 'Z', 'X', 'C', 'V',
   'B', 'N', 'M', ';', ':', '_', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '>', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char alt_map_it[] =
{
  0, 0, 0, '@', 0, '$', 0, 0,
  '{', '[', ']', '}', '{', '}', 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '[', ']', 13, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, '@',
  '#', 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, '|', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char key_map_sw[] =
{
  0, 27, '1', '2', '3', '4', '5', '6',
  '7', '8', '9', '0', '+', '\'', 127, 9,
  'q', 'w', 'e', 'r', 't', 'y', 'u', 'i',
  'o', 'p', 134, '~', 13, 0, 'a', 's',
  'd', 'f', 'g', 'h', 'j', 'k', 'l', 148,
  132, 21, 0, '\'', 'z', 'x', 'c', 'v',
  'b', 'n', 'm', ',', '.', '-', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '<', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char shift_map_sw[] =
{
  171, 0, '!', '\"', '#', '$', '%', '&',
  '/', '(', ')', '=', '?', '`', 127, 9,
  'Q', 'W', 'E', 'R', 'T', 'Y', 'U', 'I',
  'O', 'P', 143, '^', 13, 0, 'A', 'S',
  'D', 'F', 'G', 'H', 'J', 'K', 'L', 153,
  142, 171, 0, '*', 'Z', 'X', 'C', 'V',
  'B', 'N', 'M', ';', ':', '_', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '>', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char alt_map_sw[] =
{
  0, 0, 0, '@', 156, '$', 0, 0,
  '{', '[', ']', '}', '\\', 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, '~', 13, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, '|', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char key_map_hu[] =
{
  0, 27, '1', '2', '3', '4', '5', '6',
  '7', '8', '9', 148, 129, 162, 127, 9,
  'q', 'w', 'e', 'r', 't', 'z', 'u', 'i',
  'o', 'p', 139, 163, 13, 0, 'a', 's',
  'd', 'f', 'g', 'h', 'j', 'k', 'l', 130,
  160, '0', 0, 251, 'y', 'x', 'c', 'v',
  'b', 'n', 'm', ',', '.', '-', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, 161, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char shift_map_hu[] =
{
  0, 27, '\'', '"', '+', '!', '%', '/',
  '=', '(', ')', 153, 154, '\'', 127, 9,
  'Q', 'W', 'E', 'R', 'T', 'Z', 'U', 'I',
  'O', 'P', 138, 233, 13, 0, 'A', 'S',
  'D', 'F', 'G', 'H', 'J', 'K', 'L', 144,
  181, 21, '0', 235, 'Y', 'X', 'C', 'V',
  'B', 'N', 'M', '?', ':', '_', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, 146, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char alt_map_hu[] =
{
  0, 0, '~', DEAD_CARON, DEAD_CIRCUMFLEX, DEAD_BREVE, 248, DEAD_OGONEK,
  DEAD_GRAVE, DEAD_ABOVEDOT, DEAD_ACUTE, DEAD_DOUBLEACUTE, DEAD_DIAERESIS, DEAD_CEDILLA, 0, 0,
  '\\', '|', 0, 0, 0, 0, 0, 146,
  0, 0, 246, 158, 13, 0, 0, 208,
  209, '[', ']', 0, 161, 136, 157, '$',
  225, 0, 0, 207, '>', '#', '&', '@',
  '{', '}', 0, ';', 0, '*', 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, '<', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char key_map_hu_cwi[] =
{
  0, 27, '1', '2', '3', '4', '5', '6',
  '7', '8', '9', 148, 129, 162, 127, 9,
  'q', 'w', 'e', 'r', 't', 'z', 'u', 'i',
  'o', 'p', 147, 163, 13, 0, 'a', 's',
  'd', 'f', 'g', 'h', 'j', 'k', 'l', 130,
  160, '0', 0, 150, 'y', 'x', 'c', 'v',
  'b', 'n', 'm', ',', '.', '-', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, 161, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char shift_map_hu_cwi[] =
{
  0, 27, '\'', '"', '+', '!', '%', '/',
  '=', '(', ')', 153, 154, 149, 127, 9,
  'Q', 'W', 'E', 'R', 'T', 'Z', 'U', 'I',
  'O', 'P', 167, 151, 13, 0, 'A', 'S',
  'D', 'F', 'G', 'H', 'J', 'K', 'L', 144,
  143, 21, '0', 152, 'Y', 'X', 'C', 'V',
  'B', 'N', 'M', '?', ':', '_', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, 141, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char alt_map_hu_cwi[] =
{
  0, 0, '~', DEAD_CARON, DEAD_CIRCUMFLEX, DEAD_BREVE, 248, DEAD_OGONEK,
  DEAD_GRAVE, DEAD_ABOVEDOT, DEAD_ACUTE, DEAD_DOUBLEACUTE, DEAD_DIAERESIS, DEAD_CEDILLA, 0, 0,
  '\\', '|', 0, 0, 0, 0, 0, 141,
  0, 0, 246, 0, 13, 0, 0, 0,
  0, '[', ']', 0, 161, 0, 0, '$',
  225, 0, 0, 0, '>', '#', '&', '@',
  '{', '}', 0, ';', 0, '*', 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, '<', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char key_map_hu_latin2[] =
{
  0, 27, '1', '2', '3', '4', '5', '6',
  '7', '8', '9', 246, 252, 243, 127, 9,
  'q', 'w', 'e', 'r', 't', 'z', 'u', 'i',
  'o', 'p', 245, 250, 13, 0, 'a', 's',
  'd', 'f', 'g', 'h', 'j', 'k', 'l', 233,
  225, '0', 0, 251, 'y', 'x', 'c', 'v',
  'b', 'n', 'm', ',', '.', '-', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, 237, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char shift_map_hu_latin2[] =
{
  0, 27, '\'', '"', '+', '!', '%', '/',
  '=', '(', ')', 214, 220, 211, 127, 9,
  'Q', 'W', 'E', 'R', 'T', 'Z', 'U', 'I',
  'O', 'P', 213, 218, 13, 0, 'A', 'S',
  'D', 'F', 'G', 'H', 'J', 'K', 'L', 201,
  193, 21, '0', 219, 'Y', 'X', 'C', 'V',
  'B', 'N', 'M', '?', ':', '_', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, 205, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char alt_map_hu_latin2[] =
{
  0, 0, '~', DEAD_CARON, DEAD_CIRCUMFLEX, DEAD_BREVE, 248, DEAD_OGONEK,
  DEAD_GRAVE, DEAD_ABOVEDOT, DEAD_ACUTE, DEAD_DOUBLEACUTE, DEAD_DIAERESIS, DEAD_CEDILLA, 0, 0,
  '\\', '|', 0, 0, 0, 0, 0, 205,
  0, 0, 247, 215, 13, 0, 0, 240,
  208, '[', ']', 0, 237, 179, 163, '$',
  223, 0, 0, 164, '>', '#', '&', '@',
  '{', '}', 0, ';', 0, '*', 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, '<', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

/* Polish keyboard */
CONST unsigned char key_map_pl[] =
{
  0, 27, '1', '2', '3', '4', '5', '6',
  '7', '8', '9', '0', '+', '\'', 127, 9,
  'q', 'w', 'e', 'r', 't', 'z', 'u', 'i',
  'o', 'p', 190, 152, 13, 0, 'a', 's',
  'd', 'f', 'g', 'h', 'j', 'k', 'l', 136,
  165, DEAD_ABOVEDOT, 0, 162, 'y', 'x', 'c', 'v',
  'b', 'n', 'm', ',', '.', '-', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '<', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char shift_map_pl[] =
{
  0, 27, '!', '"', '#', '$', '%', '&',
  '/', '(', ')', '=', '?', '*', 127, 9,
  'Q', 'W', 'E', 'R', 'T', 'Z', 'U', 'I',
  'O', 'P', 228, 134, 13, 0, 'A', 'S',
  'D', 'F', 'G', 'H', 'J', 'K', 'L', 157,
  169, DEAD_OGONEK, '0', 171, 'Y', 'X', 'C', 'V',
  'B', 'N', 'M', ';', ':', '_', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '>', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char alt_map_pl[] =
{
  0, 0, '~', DEAD_CARON, DEAD_CIRCUMFLEX, DEAD_BREVE, 248, DEAD_OGONEK,
  DEAD_GRAVE, DEAD_ABOVEDOT, DEAD_ACUTE, DEAD_DOUBLEACUTE, DEAD_DIAERESIS, DEAD_CEDILLA, 0, 0,
  '\\', '|', 169, 0, 0, 0, 0, 0,
  162, 0, 246, 158, 0, 0, 165, 208,
  209, '[', ']', 0, 0, 0, 136, '$',
  225, 0, 0, DEAD_CARON, 190, 171, 134, '@',
  '{', '}', 21, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, '|', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char key_map_hr_cp852[] =
{
  0, 27, '1', '2', '3', '4', '5', '6',
  '7', '8', '9', '0', '\'', '+', 127, 9,
  'q', 'w', 'e', 'r', 't', 'z', 'u', 'i',
  'o', 'p', 231, 208, 13, 0, 'a', 's',     /*231=s, 208=d*/
  'd', 'f', 'g', 'h', 'j', 'k', 'l', 159,  /*159=c tvrdo*/
  134, 0, 0, 167, 'y', 'x', 'c', 'v',      /*134=c meko,167=z*/
  'b', 'n', 'm', ',', '.', '-', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '<', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char shift_map_hr_cp852[] =
{
  0, 27, '!', '\"', '#', '$', '%', '&',
  '/', '(', ')', '=', '?', '*', 127, 9,
  'Q', 'W', 'E', 'R', 'T', 'Z', 'U', 'I',
  'O', 'P', 230, 209, 13, 0, 'A', 'S',     /*230=S, 209=D*/
  'D', 'F', 'G', 'H', 'J', 'K', 'L', 172,  /*172=C tvrdo*/
  143, 0, 0, 166, 'Y', 'X', 'C', 'V',      /*143=C meko,166=Z*/
  'B', 'N', 'M', ';', ':', '_', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '>', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char alt_map_hr_cp852[] =
{
  0, 0, 126, 183, '^', 244, 248, 242,
  '`', 250, 239, 241, 249, 247, 0, 0,
  '\\', '|', 0, 0, 0, 0, 0, 0,
  0, 0, 246, 158, 13, 0, 0, 0,
  0, '[', ']', 0, 0, 146, 145, '\\',
  225, 0, 0, 207, 0, 0, 0, '@',
  '{', '}', 245, 0, '|', '/', 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, '|', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char key_map_hr_latin2[] =
{
  0, 27, '1', '2', '3', '4', '5', '6',
  '7', '8', '9', '0', '\'', '+', 127, 9,
  'q', 'w', 'e', 'r', 't', 'z', 'u', 'i',
  'o', 'p', 185, 240, 13, 0, 'a', 's',     /*185=s, 240=d*/
  'd', 'f', 'g', 'h', 'j', 'k', 'l', 232,  /*232=c tvrdo*/
  230, 0, 0, 190, 'y', 'x', 'c', 'v',      /*230=c meko,190=z*/
  'b', 'n', 'm', ',', '.', '-', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '<', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char shift_map_hr_latin2[] =
{
  0, 27, '!', '\"', '#', '$', '%', '&',
  '/', '(', ')', '=', '?', '*', 127, 9,
  'Q', 'W', 'E', 'R', 'T', 'Z', 'U', 'I',
  'O', 'P', 169, 208, 13, 0, 'A', 'S',     /*169=S, 208=D*/
  'D', 'F', 'G', 'H', 'J', 'K', 'L', 200,  /*200=C tvrdo*/
  198, 0, 0, 174, 'Y', 'X', 'C', 'V',      /*198=C meko,174=Z*/
  'B', 'N', 'M', ';', ':', '_', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '>', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char alt_map_hr_latin2[] =
{
  0, 0, 126, 183, '^', 162, 176, 178,
  '`', 255, 180, 189, 168, 184, 0, 0,
  '\\', '|', 0, 0, 0, 0, 0, 0,
  0, 0, 247, 215, 13, 0, 0, 0,
  0, '[', ']', 0, 0, 179, 163, '\\',
  223, 0, 0, 164, 0, 0, 0, '@',
  '{', '}', 167, 0, '|', '/', 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, '|', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};


/* Czech keyboard QWERTY */
CONST unsigned char key_map_cz_qwerty[] =
{
  0, 27, '+', 216, 231, 159, 253, 167,
  236, 160, 161, 130, '=', DEAD_ACUTE, 127, 9,
  'q', 'w', 'e', 'r', 't', 'y', 'u', 'i',
  'o', 'p', 163, ')', 13, 0, 'a', 's',
  'd', 'f', 'g', 'h', 'j', 'k', 'l', 133,
  245, ';', 0, DEAD_DIAERESIS, 'z', 'x', 'c', 'v',
  'b', 'n', 'm', ',', '.', '-', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '&', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char shift_map_cz_qwerty[] =
{
  0, 27, '1', '2', '3', '4', '5', '6',
  '7', '8', '9', '0', '%', DEAD_CARON, 127, 9,
  'Q', 'W', 'E', 'R', 'T', 'Y', 'U', 'I',
  'O', 'P', '/', '(', 13, 0, 'A', 'S',
  'D', 'F', 'G', 'H', 'J', 'K', 'L', '"',
  '!', 248, 0, '\'', 'Z', 'X', 'C', 'V',
  'B', 'N', 'M', '?', ':', '_', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '*', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char alt_map_cz_qwerty[] =
{
  0, 0, '~', DEAD_CARON, DEAD_CIRCUMFLEX, DEAD_BREVE, 248, DEAD_OGONEK,
  DEAD_GRAVE, DEAD_ABOVEDOT, DEAD_ACUTE, DEAD_DOUBLEACUTE, DEAD_DIAERESIS, DEAD_CEDILLA, 0, 0,
  '\\', '|', 169, 0, 0, 0, 0, 0,
  162, 0, 246, 158, 0, 0, 165, 208,
  209, '[', ']', 0, 0,136, 157, '$',
  225, 0, 0, 207, '>', '#', 134, '@',
  '{', '}', 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, '<', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

/* Czech keyboard QWERTZ */
CONST unsigned char key_map_cz_qwertz[] =
{
  0, 27, '+', 216, 231, 159, 253, 167,
  236, 160, 161, 130, '=', DEAD_ACUTE, 127, 9,
  'q', 'w', 'e', 'r', 't', 'z', 'u', 'i',
  'o', 'p', 163, ')', 13, 0, 'a', 's',
  'd', 'f', 'g', 'h', 'j', 'k', 'l', 133,
  245, ';', 0, DEAD_DIAERESIS, 'y', 'x', 'c', 'v',
  'b', 'n', 'm', ',', '.', '-', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '&', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char shift_map_cz_qwertz[] =
{
  0, 27, '1', '2', '3', '4', '5', '6',
  '7', '8', '9', '0', '%', DEAD_CARON, 127, 9,
  'Q', 'W', 'E', 'R', 'T', 'Z', 'U', 'I',
  'O', 'P', '/', '(', 13, 0, 'A', 'S',
  'D', 'F', 'G', 'H', 'J', 'K', 'L', '"',
  '!', 248, 0, '\'', 'Y', 'X', 'C', 'V',
  'B', 'N', 'M', '?', ':', '_', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '*', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char alt_map_cz_qwertz[] =
{
  0, 0, '~', DEAD_CARON, DEAD_CIRCUMFLEX, DEAD_BREVE, 248, DEAD_OGONEK,
  DEAD_GRAVE, DEAD_ABOVEDOT, DEAD_ACUTE, DEAD_DOUBLEACUTE, DEAD_DIAERESIS, DEAD_CEDILLA, 0, 0,
  '\\', '|', 169, 0, 0, 0, 0, 0,
  162, 0, 246, 158, 0, 0, 165, 208,
  209, '[', ']', 0, 0, 136, 157, '$',
  225, 0, 0, 207, '>', '#', 134, '@',
  '{', '}', 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, '<', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};
/* this prefereable is overloaded via '-I keytable keyb-user'
 * and is preset with an US keyboard layout
 */

CONST unsigned char key_map_user[] =
{
  0, 27, '1', '2', '3', '4', '5', '6',
  '7', '8', '9', '0', '-', '=', 127, 9,
  'q', 'w', 'e', 'r', 't', 'y', 'u', 'i',
  'o', 'p', '[', ']', 13, 0, 'a', 's',
  'd', 'f', 'g', 'h', 'j', 'k', 'l', ';',
  '\'', '`', 0, '\\', 'z', 'x', 'c', 'v',
  'b', 'n', 'm', ',', '.', '/', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '<', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char shift_map_user[] =
{
  0, 27, '!', '@', '#', '$', '%', '^',
  '&', '*', '(', ')', '_', '+', 127, 9,
  'Q', 'W', 'E', 'R', 'T', 'Y', 'U', 'I',
  'O', 'P', '{', '}', 13, 0, 'A', 'S',
  'D', 'F', 'G', 'H', 'J', 'K', 'L', ':',
  '"', '~', '0', '|', 'Z', 'X', 'C', 'V',
  'B', 'N', 'M', '<', '>', '?', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '>', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char alt_map_user[] =
{
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};


CONST unsigned char num_table_dot[]   = "789-456+1230.";
CONST unsigned char num_table_comma[] = "789-456+1230,";


/* DANG_BEGIN_REMARK
 *
 * The DEAD codes must refer to keys that don't exist on any language
 * keyboard. I hope nobody has a smily face key :-)
 * dead_key_table is a list of the dead keys supported. They must
 * be placed on the correct key in the keymaps above. See key_map_es_latin1.
 *
 * DANG_END_REMARK
 */

CONST unsigned char dead_key_table[] = {FULL_DEADKEY_LIST, 0};

/* DANG_BEGIN_REMARK
 *
 * dos850_dead_map consists of the triple, {deadkey, letter, result}.
 * It should be correct for all the code page 850 users (Western Europe).
 * If you uses a different code page, please create a map!
 * Jon Tombs jon@gtex02.us.es
 *
 * DANG_END_REMARK
 */

CONST struct dos_dead_key dos850_dead_map[] = {
        {DEAD_GRAVE, DEAD_GRAVE, '`'},  {DEAD_ACUTE, DEAD_ACUTE, '\''},
        {DEAD_CIRCUMFLEX, DEAD_CIRCUMFLEX, '^'}, {DEAD_DIAERESIS, DEAD_DIAERESIS, '"'},
	{DEAD_TILDE, DEAD_TILDE, '~'},

	{DEAD_ABOVERING, 'A', 143}, {DEAD_ABOVERING, 'a', 134},

	{DEAD_CEDILLA, 'C', 128}, {DEAD_CEDILLA, 'c', 135},

	{DEAD_TILDE, 'A', 199}, {DEAD_TILDE, 'a', 198},
	{DEAD_TILDE, 'N', 165}, {DEAD_TILDE, 'n', 164},
	{DEAD_TILDE, 'O', 229}, {DEAD_TILDE, 'o', 228},
	
	{DEAD_ACUTE, 'A', 181},	{DEAD_ACUTE, 'a', 160},
	{DEAD_ACUTE, 'E', 144},	{DEAD_ACUTE, 'e', 130},
	{DEAD_ACUTE, 'I', 214},	{DEAD_ACUTE, 'i', 161},
	{DEAD_ACUTE, 'O', 224},	{DEAD_ACUTE, 'o', 162},
	{DEAD_ACUTE, 'U', 233},	{DEAD_ACUTE, 'u', 163},
	{DEAD_ACUTE, 'Y', 237}, {DEAD_ACUTE, 'y', 236},

	{DEAD_GRAVE, 'A', 183},	{DEAD_GRAVE, 'a', 133},
	{DEAD_GRAVE, 'E', 212},	{DEAD_GRAVE, 'e', 138},
	{DEAD_GRAVE, 'I', 222},	{DEAD_GRAVE, 'i', 141},
	{DEAD_GRAVE, 'O', 227},	{DEAD_GRAVE, 'o', 149},
	{DEAD_GRAVE, 'U', 235},	{DEAD_GRAVE, 'u', 151},

  	{DEAD_CIRCUMFLEX, 'A', 182},	{DEAD_CIRCUMFLEX, 'a', 131},
	{DEAD_CIRCUMFLEX, 'E', 210},	{DEAD_CIRCUMFLEX, 'e', 136},
	{DEAD_CIRCUMFLEX, 'I', 215},	{DEAD_CIRCUMFLEX, 'i', 140},
	{DEAD_CIRCUMFLEX, 'O', 226},	{DEAD_CIRCUMFLEX, 'o', 147},
	{DEAD_CIRCUMFLEX, 'U', 234},	{DEAD_CIRCUMFLEX, 'u', 150},

	{DEAD_DIAERESIS, 'A', 142},	{DEAD_DIAERESIS, 'a', 132},
	{DEAD_DIAERESIS, 'E', 211},	{DEAD_DIAERESIS, 'e', 137},
	{DEAD_DIAERESIS, 'I', 216},	{DEAD_DIAERESIS, 'i', 139},
	{DEAD_DIAERESIS, 'O', 153},	{DEAD_DIAERESIS, 'o', 148},
	{DEAD_DIAERESIS, 'U', 154},	{DEAD_DIAERESIS, 'u', 129},
	{DEAD_DIAERESIS, 'y', 0x98},
        {0, 0, 0}
};

CONST struct dos_dead_key dos852_dead_map[] = {
	{DEAD_GRAVE, DEAD_GRAVE, '`'},  {DEAD_ACUTE, DEAD_ACUTE, '\''},
	{DEAD_CIRCUMFLEX, DEAD_CIRCUMFLEX, '^'}, {DEAD_DIAERESIS, DEAD_DIAERESIS, '"'},
	{DEAD_TILDE, DEAD_TILDE, '~'}, {DEAD_DOUBLEACUTE, DEAD_DOUBLEACUTE, 241},
	{DEAD_OGONEK, DEAD_OGONEK, 242}, {DEAD_CARON, DEAD_CARON, 243},
	{DEAD_BREVE, DEAD_BREVE, 244},

	{DEAD_ABOVERING, 'U', 222}, {DEAD_ABOVERING, 'u', 133},

	{DEAD_DOUBLEACUTE, 'O', 138}, {DEAD_DOUBLEACUTE, 'o', 139},
	{DEAD_DOUBLEACUTE, 'U', 235}, {DEAD_DOUBLEACUTE, 'u', 251},

	{DEAD_ABOVEDOT, 'Z', 189}, {DEAD_ABOVEDOT, 'z', 190},

	{DEAD_BREVE, 'A', 198}, {DEAD_BREVE, 'a', 199},

	{DEAD_CEDILLA, 'C', 128}, {DEAD_CEDILLA, 'c', 135},
	{DEAD_CEDILLA, 'S', 184}, {DEAD_CEDILLA, 's', 173},
	{DEAD_CEDILLA, 'T', 221}, {DEAD_CEDILLA, 't', 238},

	{DEAD_ACUTE, 'A', 181}, {DEAD_ACUTE, 'a', 160},
	{DEAD_ACUTE, 'C', 143}, {DEAD_ACUTE, 'c', 134},
	{DEAD_ACUTE, 'E', 144}, {DEAD_ACUTE, 'e', 130},
	{DEAD_ACUTE, 'I', 214}, {DEAD_ACUTE, 'i', 161},
	{DEAD_ACUTE, 'L', 145}, {DEAD_ACUTE, 'l', 146},
	{DEAD_ACUTE, 'N', 227}, {DEAD_ACUTE, 'n', 228},
	{DEAD_ACUTE, 'O', 224}, {DEAD_ACUTE, 'o', 162},
	{DEAD_ACUTE, 'R', 232}, {DEAD_ACUTE, 'r', 234},
	{DEAD_ACUTE, 'S', 151}, {DEAD_ACUTE, 's', 152},
	{DEAD_ACUTE, 'U', 233}, {DEAD_ACUTE, 'u', 163},
	{DEAD_ACUTE, 'Y', 237}, {DEAD_ACUTE, 'y', 236},
	{DEAD_ACUTE, 'Z', 141}, {DEAD_ACUTE, 'z', 171},

	{DEAD_CIRCUMFLEX, 'A', 182},    {DEAD_CIRCUMFLEX, 'a', 131},
	{DEAD_CIRCUMFLEX, 'I', 215},    {DEAD_CIRCUMFLEX, 'i', 140},
	{DEAD_CIRCUMFLEX, 'O', 226},    {DEAD_CIRCUMFLEX, 'o', 147},

	{DEAD_DIAERESIS, 'A', 142},     {DEAD_DIAERESIS, 'a', 132},
	{DEAD_DIAERESIS, 'E', 211},     {DEAD_DIAERESIS, 'e', 137},
	{DEAD_DIAERESIS, 'O', 153},     {DEAD_DIAERESIS, 'o', 148},
	{DEAD_DIAERESIS, 'U', 154},     {DEAD_DIAERESIS, 'u', 129},

	{DEAD_CARON, 'C', 172}, {DEAD_CARON, 'c', 159},
	{DEAD_CARON, 'D', 210}, {DEAD_CARON, 'd', 212},
	{DEAD_CARON, 'E', 183}, {DEAD_CARON, 'e', 216},
	{DEAD_CARON, 'L', 149}, {DEAD_CARON, 'l', 150},
	{DEAD_CARON, 'N', 213}, {DEAD_CARON, 'n', 229},
	{DEAD_CARON, 'R', 252}, {DEAD_CARON, 'r', 253},
	{DEAD_CARON, 'S', 230}, {DEAD_CARON, 's', 231},
	{DEAD_CARON, 'T', 155}, {DEAD_CARON, 't', 156},
	{DEAD_CARON, 'Z', 166}, {DEAD_CARON, 'z', 167},

	{DEAD_OGONEK, 'A', 164}, {DEAD_OGONEK, 'a', 165},
	{DEAD_OGONEK, 'E', 168}, {DEAD_OGONEK, 'e', 169},

        {0, 0, 0}
};

struct keytable_entry keytable_list[] = {
  {"finnish", KEYB_FINNISH, KT_USES_ALTMAP, sizeof(key_map_finnish), sizeof(num_table_comma),
    key_map_finnish, shift_map_finnish, alt_map_finnish,
    num_table_comma, dead_key_table,
    dos850_dead_map},
  {"finnish-latin1", KEYB_FINNISH_LATIN1, KT_USES_ALTMAP, sizeof(key_map_finnish_latin1), sizeof(num_table_comma),
    key_map_finnish_latin1, shift_map_finnish_latin1, alt_map_finnish_latin1,
    num_table_comma, dead_key_table,
    dos850_dead_map},
  {"us", KEYB_US, 0, sizeof(key_map_us), sizeof(num_table_comma),
    key_map_us, shift_map_us, alt_map_us,
    num_table_dot, dead_key_table,
    dos850_dead_map},
  {"uk", KEYB_UK, KT_USES_ALTMAP, sizeof(key_map_uk), sizeof(num_table_comma),
    key_map_uk, shift_map_uk, alt_map_uk,
    num_table_dot, dead_key_table,
    dos850_dead_map},
  {"de", KEYB_DE, KT_USES_ALTMAP, sizeof(key_map_de), sizeof(num_table_comma),
    key_map_de, shift_map_de, alt_map_de,
    num_table_comma, dead_key_table,
    dos850_dead_map},
  {"de-latin1", KEYB_DE_LATIN1, KT_USES_ALTMAP, sizeof(key_map_de_latin1), sizeof(num_table_comma),
    key_map_de_latin1, shift_map_de_latin1, alt_map_de_latin1,
    num_table_comma, dead_key_table,
    dos850_dead_map},
  {"fr", KEYB_FR, KT_USES_ALTMAP, sizeof(key_map_fr), sizeof(num_table_comma),
    key_map_fr, shift_map_fr, alt_map_fr,
    num_table_dot, dead_key_table,
    dos850_dead_map},
  {"fr-latin1", KEYB_FR_LATIN1, KT_USES_ALTMAP, sizeof(key_map_fr_latin1), sizeof(num_table_comma),
    key_map_fr_latin1, shift_map_fr_latin1, alt_map_fr_latin1,
    num_table_dot, dead_key_table,
    dos850_dead_map},
  {"dk", KEYB_DK, KT_USES_ALTMAP, sizeof(key_map_dk), sizeof(num_table_comma),
    key_map_dk, shift_map_dk, alt_map_dk,
    num_table_comma, dead_key_table,
    dos850_dead_map},
  {"dk-latin1", KEYB_DK_LATIN1, KT_USES_ALTMAP, sizeof(key_map_dk_latin1), sizeof(num_table_comma),
    key_map_dk_latin1, shift_map_dk_latin1, alt_map_dk_latin1,
    num_table_comma, dead_key_table,
    dos850_dead_map},
  {"dvorak", KEYB_DVORAK, KT_USES_ALTMAP, sizeof(key_map_dvorak), sizeof(num_table_comma),
    key_map_dvorak, shift_map_dvorak, alt_map_dvorak,
    num_table_comma, dead_key_table,
    dos850_dead_map},
  {"sg", KEYB_SG, KT_USES_ALTMAP, sizeof(key_map_sg), sizeof(num_table_comma),
    key_map_sg, shift_map_sg, alt_map_sg,
    num_table_comma, dead_key_table,
    dos850_dead_map},
  {"sg-latin1", KEYB_SG_LATIN1, KT_USES_ALTMAP, sizeof(key_map_sg_latin1), sizeof(num_table_comma),
    key_map_sg_latin1, shift_map_sg_latin1, alt_map_sg_latin1,
    num_table_comma, dead_key_table,
    dos850_dead_map},
  {"keyb-no", KEYB_NO, KT_USES_ALTMAP, sizeof(key_map_no), sizeof(num_table_comma),
    key_map_no, shift_map_no, alt_map_no,
    num_table_comma, dead_key_table,
    dos850_dead_map},
  {"no-latin1", KEYB_NO_LATIN1, KT_USES_ALTMAP, sizeof(key_map_no_latin1), sizeof(num_table_comma),
    key_map_no_latin1, shift_map_no_latin1, alt_map_no_latin1,
    num_table_comma, dead_key_table,
    dos850_dead_map},
  {"sf", KEYB_SF, KT_USES_ALTMAP, sizeof(key_map_sf), sizeof(num_table_comma),
    key_map_sf, shift_map_sf, alt_map_sf,
    num_table_comma, dead_key_table,
    dos850_dead_map},
  {"sf-latin1", KEYB_SF_LATIN1, KT_USES_ALTMAP, sizeof(key_map_sf_latin1), sizeof(num_table_comma),
    key_map_sf_latin1, shift_map_sf_latin1, alt_map_sf_latin1,
    num_table_comma, dead_key_table,
    dos850_dead_map},
  {"es", KEYB_ES, KT_USES_ALTMAP, sizeof(key_map_es), sizeof(num_table_comma),
    key_map_es, shift_map_es, alt_map_es,
    num_table_comma, dead_key_table,
    dos850_dead_map},
  {"es-latin1", KEYB_ES_LATIN1, KT_USES_ALTMAP, sizeof(key_map_es_latin1), sizeof(num_table_comma),
    key_map_es_latin1, shift_map_es_latin1, alt_map_es_latin1,
    num_table_comma, dead_key_table,
    dos850_dead_map},
  {"be", KEYB_BE, KT_USES_ALTMAP, sizeof(key_map_be), sizeof(num_table_comma),
    key_map_be, shift_map_be, alt_map_be,
    num_table_dot, dead_key_table,
    dos850_dead_map},
  {"po", KEYB_PO, KT_USES_ALTMAP, sizeof(key_map_po), sizeof(num_table_comma),
    key_map_po, shift_map_po, alt_map_po,
    num_table_dot, dead_key_table,
    dos850_dead_map},
  {"it", KEYB_IT, KT_USES_ALTMAP, sizeof(key_map_it), sizeof(num_table_comma),
    key_map_it, shift_map_it, alt_map_it,
    num_table_dot, dead_key_table,
    dos850_dead_map},
  {"sw", KEYB_SW, KT_USES_ALTMAP, sizeof(key_map_sw), sizeof(num_table_comma),
    key_map_sw, shift_map_sw, alt_map_sw,
    num_table_dot, dead_key_table,
    dos850_dead_map},
  {"hu", KEYB_HU, KT_USES_ALTMAP, sizeof(key_map_hu), sizeof(num_table_comma),
    key_map_hu, shift_map_hu, alt_map_hu,
    num_table_comma, dead_key_table,
    dos852_dead_map},
  {"hu-cwi", KEYB_HU_CWI, KT_USES_ALTMAP, sizeof(key_map_hu_cwi), sizeof(num_table_comma),
    key_map_hu_cwi, shift_map_hu_cwi, alt_map_hu_cwi,
    num_table_comma, dead_key_table,
    dos852_dead_map},
  {"hu-latin2", KEYB_HU_LATIN2, KT_USES_ALTMAP, sizeof(key_map_hu_latin2), sizeof(num_table_comma),
    key_map_hu_latin2, shift_map_hu_latin2, alt_map_hu_latin2,
    num_table_comma, dead_key_table,
    dos852_dead_map},
  {"jp106", KEYB_JP106, 0, sizeof(key_map_jp106), sizeof(num_table_comma),
    key_map_jp106, shift_map_jp106, alt_map_jp106,
    num_table_dot, dead_key_table,
    dos850_dead_map},
  {"pl", KEYB_PL, KT_USES_ALTMAP, sizeof(key_map_pl), sizeof(num_table_comma),
    key_map_pl, shift_map_pl, alt_map_pl,
    num_table_comma, dead_key_table,
    dos852_dead_map},
  {"hr-cp852", KEYB_HR_CP852, KT_USES_ALTMAP, sizeof(key_map_hr_cp852), sizeof(num_table_comma),
    key_map_hr_cp852, shift_map_hr_cp852, alt_map_hr_cp852,
    num_table_comma, dead_key_table,
    dos850_dead_map},
  {"hr-latin2", KEYB_HR_LATIN2, KT_USES_ALTMAP, sizeof(key_map_hr_latin2), sizeof(num_table_comma),
    key_map_hr_latin2, shift_map_hr_latin2, alt_map_hr_latin2,
    num_table_comma, dead_key_table,
    dos850_dead_map},
  {"cz-qwerty", KEYB_CZ_QWERTY, KT_USES_ALTMAP, sizeof(key_map_cz_qwerty), sizeof(num_table_comma),
    key_map_cz_qwerty, shift_map_cz_qwerty, alt_map_cz_qwerty,
    num_table_dot, dead_key_table,
    dos852_dead_map},
  {"cz-qwertz", KEYB_CZ_QWERTZ, KT_USES_ALTMAP, sizeof(key_map_cz_qwertz), sizeof(num_table_comma),
    key_map_cz_qwertz, shift_map_cz_qwertz, alt_map_cz_qwertz,
    num_table_comma, dead_key_table,
    dos852_dead_map},                                       
  {"keyb-user", KEYB_USER, 0, sizeof(key_map_user), sizeof(num_table_comma),
    key_map_user, shift_map_user, alt_map_user,
    num_table_dot, dead_key_table,
    dos850_dead_map},
  {0},
  {0}
};


/*
 * Look for a console. This is based on code in getfd.c from the kbd-0.99 package
 * (see loadkeys(1)).
 */

static int is_a_console(int fd)
{
  char arg = 0;

  return ioctl(fd, KDGKBTYPE, &arg) == 0 && (arg == KB_101 || arg == KB_84);
}

static int open_a_console(char *fnam)
{
  int fd;

  fd = open(fnam, O_RDONLY);
  if(fd < 0 && errno == EACCES) fd = open(fnam, O_WRONLY);
  if(fd < 0 || ! is_a_console(fd)) return -1;

  return fd;
}

static int getfd()
{
  int fd, i;
  char *t[] = { "", "", "", "/dev/tty", "/dev/tty0", "/dev/console" };
  
  for(i = 0; i < sizeof t / sizeof *t; i++) {
    if(!*t[i] && is_a_console(i)) return i;
    if(*t[i] && (fd = open_a_console(t[i])) >= 0) return fd;
  }

  return -1;
}

/*
 * Try to translate a keycode to a DOSEMU keycode...
 */

static char *dosemu_val(unsigned k, unsigned *dv)
{
  static char b[100];
  char *s = b;
  unsigned t = KTYP(k), v = KVAL(k), d = 0;
  static char *acc[13] = {
    "DEAD_GRAVE", "DEAD_ACUTE", "DEAD_CIRCUMFLEX", "DEAD_TILDE", "DEAD_BREVE",
    "DEAD_ABOVEDOT", "DEAD_DIAERESIS", "DEAD_ABOVERING", "DEAD_DOUBLEACUTE", "DEAD_CEDILLA",
    "DEAD_IOTA", "DEAD_OGONEK", "DEAD_CARON"
  };

  d = 0;

  switch(t) {
    case KT_LATIN:
    case KT_LETTER:
      d = v;
      if(v >= 0xa0 && v <= 0xff) d = latin1_to_dos[v - 0xa0];
      break;

    case KT_SPEC:
      switch(k) {
        case K_HOLE:  d = 0; break;
        case K_ENTER: d = 0x0d; break;
        default:      d = 0; /* K_CAPS, K_NUM, ... ??? */
      }
      break;

    case KT_PAD:
      switch(k) {
        case K_PPLUS:  d = '+'; break;
        case K_PMINUS: d = '-'; break;
        case K_PSTAR:  d = '*'; break;
        default:       d = 0;
      }
      break;

    case KT_SHIFT:
    case KT_META:
      d = 0;
      break;

    case KT_DEAD:
      switch(k) {
        case K_DGRAVE: d = 1; break;
        case K_DACUTE: d = 2; break;
        case K_DCIRCM: d = 3; break;
#if 0
        /* make '~' a normal key */
        case K_DTILDE: d = '~'; break;
#else
        case K_DTILDE: d = 4; break;
#endif
        case K_DDIERE: d = 7; break;
        case K_DCEDIL: d = 11; break;
      }
      break;

    default:
      break;
  }

  if(dv) *dv = d;

  sprintf(b, "%04x", k);

  if(d == 400) return b;

  if(d < 0x20 || d == 0x7f || d >= 0x80) {
    sprintf(b, "0x%02x", d);
  }
  else {
    sprintf(b, "'%c' ", (char) d);
  }

  if(d >= 1 && d <= 15 && d != 9 && d != 13) {
    if(d > 8) d--;
    if(d > 12) d--;
    s = acc[d - 1];
  }

  if(d == '\'') s = "'\\''";
  if(d == 0) s = " -- ";

  return s;
}


static int read_kbd_table(struct keytable_entry *kt)
{
  int fd, i, j = -1, k;
  struct kbentry ke;
  unsigned v, vs, va;

  fd = getfd();
  if(fd < 0) return fprintf(stderr, "no console\n"), 1;

  for(i = 0; i < kt->sizemap - 1; i++) {
    ke.kb_index = i;

    ke.kb_table = 0;
    if((j = ioctl(fd, KDGKBENT, (unsigned long) &ke))) break;
    v = ke.kb_value;

    ke.kb_table = 1 << KG_SHIFT;
    if((j = ioctl(fd, KDGKBENT, (unsigned long) &ke))) break;
    vs = ke.kb_value;

    ke.kb_table = 1 << KG_ALTGR;
    if((j = ioctl(fd, KDGKBENT, (unsigned long) &ke))) break;
    va = ke.kb_value;

    if(va == v) va = 0;

    dosemu_val(v, &k); kt->key_map[i] = k;
    dosemu_val(vs, &k); kt->shift_map[i] = k;
    dosemu_val(va, &k); kt->alt_map[i] = k;

#if 0
    printf("%3d: %04x %04x %04x   ", i, v, vs, va);

    printf("%s ", dosemu_val(v, &k));
    printf("%s ", dosemu_val(vs, &k));
    printf("%s\n", dosemu_val(va, &k));
#endif
  }

  /* look for numpad ',' or '.' */
  ke.kb_index = 83;
  ke.kb_table = 0;
  if(!j && !(j = ioctl(fd, KDGKBENT, (unsigned long) &ke))) {
    if(ke.kb_value == K_PDOT) kt->num_table[12] = '.';
  }

  if(fd > 2) close(fd);

  return j;
}


/*
 * Read the console keyboard description and try to build
 * a DOSEMU compatible map from it.
 *
 * NOTE: If you use X you might get the *wrong* mapping
 * (e.g. on remote machines)... :-)
 */

int setup_default_keytable()
{
  static char *dt_name = "auto";
  static char map0[97], map1[97], map2[97], map3[14];
  struct keytable_entry *kt;
  int idx;

  idx = sizeof keytable_list / sizeof *keytable_list - 2;

  k_printf("KBD: setup_default_keytable: setting up table %d\n", idx);

  kt = keytable_list + idx;

  kt->name = dt_name;
  kt->keyboard = KEYB_AUTO;
  kt->flags = KT_USES_ALTMAP;
  kt->sizemap = sizeof map0;
  kt->sizepad = sizeof map3;
  kt->key_map = map0;
  kt->shift_map = map1;
  kt->alt_map = map2;
  kt->num_table = map3;
  kt->dead_key_table = dead_key_table;
  kt->dead_map = dos850_dead_map;

  memcpy(map3, "789-456+1230,", sizeof map3);

  if(read_kbd_table(kt)) {
    k_printf("setup_default_keytable: failed\n");
    return -1;
  }

#if 0
  {
    int i;

    kt = keytable_list;
    i = 0; while(kt->name) {
      printf(
        "%2d: name \"%s\", keyboard %d, flags 0x%x, sizemap %d, sizepad %d\n",
        i, kt->name, kt->keyboard, kt->flags, kt->sizemap, kt->sizepad
      );
      i++, kt++;
    }
  }
#endif

#if 0
  {
    int i;

    kt = keytable_list + KEYB_DE;
    for(i = 0; i < kt->sizemap; i++) {
      printf("%3d: %04x %04x %04x\n",
        i, kt->key_map[i], kt->shift_map[i], kt->alt_map[i]
      );
    }
  }
#endif

  return KEYB_AUTO;
}


