#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <X11/Xlib.h>
#include <X11/keysym.h>

#include "dsimple.h"

/*
 * Report syntax for calling keybaord_test
 */
void usage(void)
{
  	fprintf(stderr,
		"usage: %s [-options ...]\n\n", program_name);
	fprintf(stderr,
		"where options include:\n");
	fprintf(stderr,
		"    -help                print this message\n");
	fprintf(stderr,
		"    -display host:dpy    X server to contact\n");
	fprintf(stderr,
		 "    -root               use the root window\n");
	fprintf(stderr,
		"    -id windowid         use the window with the specified id\n");
	fprintf(stderr,
		"    -name windowname     use the window with the specified name\n");
	fprintf(stderr,
		"%s sends a stream of simulated keyboard events to the selected\n",
		program_name);
	fprintf(stderr,
		"window.  This is designed to be used in testing dosemu but may be useful in\n");
	fprintf(stderr,
		"other situations.\n");
	fprintf(stderr,
		"\n");
	exit(1);
}

int init(XKeyEvent *sample, int argc, char **argv)
{
	Display *display;
	Window window;
	int i;

	INIT_NAME;

	/* Open display, handle command line arguments */
	Setup_Display_And_Screen(&argc, argv);

	/* Get window selected on command line, if any */
	window = Select_Window_Args(&argc, argv);

	display = dpy;

	for(i = 1; i < argc; i++) {
		if (strcmp(argv[i], "-help") == 0) {
			usage();
			continue;
		}
		usage();
	}
	if (!window) {
		usage();
	}

	sample->type = KeyPress;
	sample->serial = 0;
	sample->send_event = True;
	sample->display = display;
	sample->window = window;
	sample->root = XRootWindow(display, XDefaultScreen(display));
	sample->subwindow = 0;
	sample->time = time(NULL) * 1000;
	sample->x = sample->y = sample->x_root = sample->y_root = 0;
	sample->state = 0;		/* ShiftMask, ControlMask */
	sample->keycode = XKeysymToKeycode(display, XK_a);
	sample->same_screen = True;
	return 0;

}

void fini(XKeyEvent *sample)
{
	XCloseDisplay(sample->display);
}

void send_keycode(const XKeyEvent *sample, int make, int keycode)
{
	XKeyEvent xk;
	xk = *sample;
	xk.type = make? KeyPress : KeyRelease;
	xk.time = time(NULL) *1000;
	xk.keycode = keycode;

#if 0
	fprintf(stderr, "XSendEvent(%p, %x, %d, %d, %p)\n",
		xk.display, xk.window, True, KeyPressMask, &xk);
#endif
	XSendEvent(xk.display, xk.window, True, KeyPressMask, (XEvent *) &xk);
	XFlush(xk.display);
	usleep(1); /* quick nap */
}

void send_keysym(const XKeyEvent *sample, int make, KeySym keysym)
{
	int keycode = XKeysymToKeycode(sample->display, keysym);
	send_keycode(sample, make, keycode);
}
void press_release_keycode(const XKeyEvent *sample, int keycode)
{
	send_keycode(sample, True, keycode);
	send_keycode(sample, False, keycode);
}
void press_release_keysym(const XKeyEvent *sample, KeySym keysym)
{
	send_keysym(sample, True,  keysym);
	send_keysym(sample, False, keysym);
}


void do_tests(XKeyEvent *sample);

int main(int argc, char **argv)
{
	XKeyEvent xk;
	int result;

	result = init(&xk, argc, argv);
	if (result) {
		return result;
	}
	do_tests(&xk);
	fini(&xk);

	return 0;
}


void alphabet(const XKeyEvent *xk)
{
	press_release_keysym(xk, XK_a);
	press_release_keysym(xk, XK_b);
	press_release_keysym(xk, XK_c);
	press_release_keysym(xk, XK_d);
	press_release_keysym(xk, XK_e);
	press_release_keysym(xk, XK_f);
	press_release_keysym(xk, XK_g);
	press_release_keysym(xk, XK_h);
	press_release_keysym(xk, XK_i);
	press_release_keysym(xk, XK_j);
	press_release_keysym(xk, XK_k);
	press_release_keysym(xk, XK_l);
	press_release_keysym(xk, XK_m);
	press_release_keysym(xk, XK_n);
	press_release_keysym(xk, XK_o);
	press_release_keysym(xk, XK_p);
	press_release_keysym(xk, XK_q);
	press_release_keysym(xk, XK_r);
	press_release_keysym(xk, XK_s);
	press_release_keysym(xk, XK_t);
	press_release_keysym(xk, XK_u);
	press_release_keysym(xk, XK_v);
	press_release_keysym(xk, XK_w);
	press_release_keysym(xk, XK_x);
	press_release_keysym(xk, XK_y);
	press_release_keysym(xk, XK_z);
}


int caps_alphabet(const XKeyEvent *xk)
{
	send_keysym(xk, True, XK_Shift_L);
	alphabet(xk);
	send_keysym(xk, False, XK_Shift_L);
	
}

/* This is how my keyboard is laid out --Eric */
KeySym us_keys[]  = {
	/* row 1 */
	XK_Escape,

	XK_F1,
	XK_F2,
	XK_F3,
	XK_F4,

	XK_F5,
	XK_F6,
	XK_F7,
	XK_F8,

	XK_F9,
	XK_F10,
	XK_F11,
	XK_F12,

	XK_Print,
	XK_Scroll_Lock,
	XK_Pause,

	/* row 2 */
	XK_grave,
	XK_1,
	XK_2,
	XK_3,
	XK_4,
	XK_5,
	XK_6,
	XK_7,
	XK_8,
	XK_9,
	XK_0,
	XK_minus,
	XK_equal,
	XK_BackSpace,
	
	XK_Insert,
	XK_Home,
	XK_Page_Up,

	XK_Num_Lock,
	XK_KP_Divide,
	XK_KP_Multiply,
	XK_KP_Subtract,
	
	/* row3 */
	XK_Tab,
	XK_q,
	XK_w,
	XK_e,
	XK_r,
	XK_t,
	XK_y,
	XK_u,
	XK_i,
	XK_o,
	XK_p,
	XK_bracketleft,
	XK_bracketright,
	XK_backslash,

	XK_Delete,
	XK_End,
	XK_Page_Down,

	XK_KP_Home,
	XK_KP_Up,
	XK_KP_Page_Up,
	XK_KP_Add,

	/* row 4 */
	XK_Caps_Lock,
	XK_a,
	XK_s,
	XK_d,
	XK_f,
	XK_g,
	XK_h,
	XK_j,
	XK_k,
	XK_l,
	XK_semicolon,
	XK_apostrophe,
	XK_Return,


	XK_KP_Left,
	XK_KP_Begin,  /* odd translation */
	XK_KP_Right,
	XK_KP_Add,   /* second appearance */

	/* row 5 */
	XK_Shift_L,
	XK_z,
	XK_x,
	XK_c,
	XK_v,
	XK_b,
	XK_n,
	XK_m,
	XK_comma,
	XK_period,
	XK_slash,
	XK_Shift_R,

	XK_Up,

	XK_KP_End,
	XK_KP_Down,
	XK_KP_Page_Down,
	XK_KP_Enter,

	XK_Control_L,
	XK_Alt_L,
	XK_space,
	XK_Alt_R,
	XK_Control_R,

	XK_Left,
	XK_Down,
	XK_Right,

	XK_KP_Insert,
	XK_KP_Delete,
	XK_KP_Enter, /* second appearance */	
};
#define us_keys_count  (sizeof(us_keys)/sizeof(KeySym))

void all_us_keys(const XKeyEvent *xk, KeySym pressed)
{
	int i;
	for(i = 0; i < us_keys_count; i++) {
		KeySym sym = us_keys[i];
		if ( pressed == sym) {
			continue;
		}
		press_release_keysym(xk, sym);
		switch(sym) {
		case XK_Scroll_Lock: /* don't change the scroll lock status */
		case XK_Num_Lock: /* don't change the num lock status */
		case XK_Caps_Lock: /* don't change the caps lock status */
			press_release_keysym(xk, sym);
			break;
		default:
			/* do nothing */
		}
	}
}

void all_us_keys_plain(XKeyEvent *xk)
{
	xk->state = 0;
	all_us_keys(xk, NoSymbol);
	xk->state = 0;
}

void set_shift_state(XKeyEvent *xk, KeySym pressed)
{
	switch(pressed) {
	case XK_Shift_L:
	case XK_Shift_R:
		xk->state |= ShiftMask;
		break;
	case XK_Control_L:
	case XK_Control_R:
		xk->state |= ControlMask;
		break;
	case XK_Alt_L:
	case XK_Alt_R:
		xk->state |= Mod1Mask;
		break;
	case XK_Caps_Lock:
		xk->state |= LockMask;
		break;
	case XK_Num_Lock:
		xk->state |= Mod2Mask;
		break;
	case XK_Scroll_Lock:
		xk->state |= Mod5Mask;
		break;
	}
}

void all_us_keys_held(XKeyEvent *xk, KeySym pressed)
{
	xk->state = 0;
	send_keysym(xk, True, pressed);
	set_shift_state(xk, pressed);
	all_us_keys(xk, pressed);
	send_keysym(xk, False, pressed);
	xk->state = 0;
}

void all_us_keys_state(XKeyEvent *xk, KeySym pressed)
{
	xk->state = 0;
	send_keysym(xk, True, pressed);
	set_shift_state(xk, pressed);
	send_keysym(xk, False, pressed);
	all_us_keys(xk, pressed);
	press_release_keysym(xk, pressed);
	xk->state = 0;
}

void do_us_tests(XKeyEvent *xk)
{
	all_us_keys_plain(xk);
	all_us_keys_held(xk, XK_Shift_L);
	all_us_keys_held(xk, XK_Shift_R);
	all_us_keys_held(xk, XK_Alt_L);
	all_us_keys_held(xk, XK_Alt_R);
	all_us_keys_state(xk, XK_Caps_Lock);
	all_us_keys_state(xk, XK_Num_Lock);
	all_us_keys_held(xk, XK_Control_L);
	all_us_keys_held(xk, XK_Control_R);
	press_release_keysym(xk, XK_Escape);
	press_release_keysym(xk, XK_Escape);
}

void do_tests(XKeyEvent *xk)
{
	#if 1
	do_us_tests(xk);
	#else
	alphabet(xk);
	caps_alphabet(xk);
	alphabet(xk);
	#endif
}




