/****************************************************************************
 * This module is mostly all new
 * by Rob Nation (nation@rocket.sanders.lockheed.com)
 * A little of it is borrowed from ctwm.
 * Copyright 1993 Robert Nation. No restrictions are placed on this code,
 * as long as the copyright notice is preserved
 ****************************************************************************/
/***********************************************************************
 *
 * fvwm menu code
 *
 ***********************************************************************/

#include <stdio.h>
#include <signal.h>
#include <string.h>
#include <X11/Xos.h>
#ifdef XPM
#include "xpm.h"
#endif /* XPM */
#include "fvwm.h"
#include "menus.h"
#include "misc.h"
#include "parse.h"
#include "screen.h"
#ifdef SHAPE
#include <X11/extensions/shape.h>
#endif /* SHAPE */


void GrabIconButtons(FvwmWindow *, Window);
void GrabIconKeys(FvwmWindow *, Window);
MyFont *IconFont;

/****************************************************************************
 *
 * Creates an icon window as needed
 *
 ****************************************************************************/
void CreateIconWindow(FvwmWindow *tmp_win, int def_x, int def_y)
{
#ifndef NO_ICONS
  int final_x, final_y;
  unsigned int HotX,HotY;
  unsigned long valuemask;		/* mask for create windows */
  XSetWindowAttributes attributes;	/* attributes for create windows */
#ifdef XPM
  XWindowAttributes root_attr;
  XpmAttributes xpm_attributes;
#endif /* XPM */

  tmp_win->flags |= ICON_OURS;
  tmp_win->flags &= ~XPM_FLAG;
  tmp_win->flags &= ~PIXMAP_OURS;
  tmp_win->flags &= ~SHAPED_ICON;
  tmp_win->icon_pixmap_w = None;
  tmp_win->iconPixmap = None;
  tmp_win->iconDepth = 0;

  if(Scr.flags & SuppressIcons)
    return;


  /* First, see if it was specified in the .fvwmrc */
  if(tmp_win->icon_bitmap_file != (char *)0)
    {
      if(XReadBitmapFile (dpy, Scr.Root,tmp_win->icon_bitmap_file,
			  &tmp_win->icon_p_width, &tmp_win->icon_p_height,
			  &tmp_win->iconPixmap,
			  &HotX, &HotY) != BitmapSuccess)
	{
#ifdef XPM
	  XGetWindowAttributes(dpy,Scr.Root,&root_attr);
	  xpm_attributes.colormap = root_attr.colormap;
	  xpm_attributes.valuemask = XpmSize | XpmReturnPixels|XpmColormap;
	  if(XpmReadFileToPixmap(dpy, Scr.Root, tmp_win->icon_bitmap_file,
				 &tmp_win->iconPixmap, 
				 &tmp_win->icon_maskPixmap, 
				 &xpm_attributes) == XpmSuccess) 
	    { 
	      tmp_win->icon_p_width = xpm_attributes.width;
	      tmp_win->icon_p_height = xpm_attributes.height;
	      tmp_win->flags |= XPM_FLAG;
	      tmp_win->flags |= PIXMAP_OURS;
	      tmp_win->iconDepth = Scr.d_depth;
#ifdef SHAPE
	      if (tmp_win->icon_maskPixmap)
		tmp_win->flags |= SHAPED_ICON;
#endif
	      
	    } 
	  else
#endif /* XPM */
	    {
	      tmp_win->icon_p_height = 0;
	      tmp_win->icon_p_width = 0;
	    }
	}
      else
	{
	  tmp_win->flags |= PIXMAP_OURS;
	}
    }
  /* Next, See if the app supplies its own icon window */
  else if (tmp_win->wmhints && tmp_win->wmhints->flags & IconWindowHint) 
    {
      if(XGetGeometry(dpy,   tmp_win->wmhints->icon_window,
		   &JunkRoot, &JunkX, &JunkY,
		   (unsigned int *)&tmp_win->icon_p_width, 
		   (unsigned int *)&tmp_win->icon_p_height, 
		   &JunkBW, &JunkDepth)==0)
	{
	  fprintf(stderr,"Help! Bad Icon Window!\n");
	}
      tmp_win->icon_p_width += JunkBW<<1;
      tmp_win->icon_p_height += JunkBW<<1;
      /*
       * Now make the new window the icon window for this window,
       * and set it up to work as such (select for key presses
       * and button presses/releases, set up the contexts for it,
       * and define the cursor for it).
       */
      tmp_win->icon_pixmap_w = tmp_win->wmhints->icon_window;
#ifdef SHAPE
      if (tmp_win->wmhints->flags & IconMaskHint)
	{
	  tmp_win->flags |= SHAPED_ICON;
	  tmp_win->icon_maskPixmap = tmp_win->wmhints->icon_mask;
	}
#endif
      /* Make sure that the window is a child of the root window ! */
      /* Olwais screws this up, maybe others do too! */
      XReparentWindow(dpy, tmp_win->icon_w, Scr.Root, 0,0);
      tmp_win->flags &= ~ICON_OURS;
    }
  /* now, try to get icon bitmap from the application */
  else if((tmp_win->wmhints)&&(tmp_win->wmhints->flags & IconPixmapHint))
    {
      XGetGeometry(dpy,   tmp_win->wmhints->icon_pixmap,
		   &JunkRoot, &JunkX, &JunkY,
		   (unsigned int *)&tmp_win->icon_p_width, 
		   (unsigned int *)&tmp_win->icon_p_height, 
		   &JunkBW, &JunkDepth);
      tmp_win->iconPixmap = tmp_win->wmhints->icon_pixmap;
      tmp_win->iconDepth = JunkDepth;
#ifdef SHAPE
      if (tmp_win->wmhints->flags & IconMaskHint)
	{
	  tmp_win->flags |= SHAPED_ICON;
	  tmp_win->icon_maskPixmap = tmp_win->wmhints->icon_mask;
	}
#endif
    }
  /* no bitmap */
  else
    {
      tmp_win->icon_p_height = 0;
      tmp_win->icon_p_width = 0;
    }

  /* figure out the icon window size */
  tmp_win->icon_t_width = XTextWidth(IconFont->font,tmp_win->icon_name, 
				     strlen(tmp_win->icon_name));
  if((tmp_win->flags & ICON_OURS)&&(tmp_win->icon_p_height >0))
    {
      tmp_win->icon_p_width += 4;
      tmp_win->icon_p_height +=4;
    }

  if(tmp_win->icon_p_width == 0)
    tmp_win->icon_p_width = tmp_win->icon_t_width+6;
  tmp_win->icon_w_width = tmp_win->icon_p_width;

  tmp_win->icon_w_height = ICON_HEIGHT;

  /* need to figure out where to put the icon window now */
  if (tmp_win->wmhints &&
      tmp_win->wmhints->flags & IconPositionHint)
    {
      final_x = tmp_win->wmhints->icon_x;
      final_y = tmp_win->wmhints->icon_y;
    }
  else
    {
      final_x = def_x;
      final_y = def_y;
      if(final_x <0)
	final_x = 0;
      if(final_y <0)
	final_y = 0;
      
      if(final_x + tmp_win->icon_w_width >=Scr.MyDisplayWidth)
	final_x = Scr.MyDisplayWidth - tmp_win->icon_w_width-1;
      if(final_y + tmp_win->icon_w_height >=Scr.MyDisplayHeight)
	final_y = Scr.MyDisplayHeight - tmp_win->icon_w_height-1;
    }
  
  /* make sure it winds up on the screen */
  if (final_x > Scr.MyDisplayWidth)
    final_x = Scr.MyDisplayWidth - tmp_win->icon_w_width-2;
  
  if (final_y > Scr.MyDisplayHeight)
    final_y = Scr.MyDisplayHeight - 
      IconFont->height - 6;

  tmp_win->icon_x_loc = final_x;
  tmp_win->icon_xl_loc = final_x;
  tmp_win->icon_y_loc = final_y;

  /* clip to fit on screen */
  attributes.background_pixel = Scr.StdColors.back;
  valuemask =  CWBorderPixel | CWCursor | CWEventMask | CWBackPixel;
  attributes.border_pixel = Scr.StdColors.fore;
  attributes.cursor = Scr.FvwmCursors[FRAME];
  attributes.event_mask = (ButtonPressMask | ButtonReleaseMask |
			   ExposureMask | KeyPressMask|EnterWindowMask |
			   LeaveWindowMask);
  tmp_win->icon_w = 
    XCreateWindow(dpy, Scr.Root, final_x, final_y+tmp_win->icon_p_height,
		  tmp_win->icon_w_width, tmp_win->icon_w_height,0,Scr.d_depth, 
		  CopyFromParent,Scr.d_visual,valuemask,&attributes);

  if((tmp_win->flags & ICON_OURS)&&(tmp_win->icon_p_width>0)&&
     (tmp_win->icon_p_height>0))
    {
      tmp_win->icon_pixmap_w = 
	XCreateWindow(dpy, Scr.Root, final_x, final_y, tmp_win->icon_p_width,
		      tmp_win->icon_p_height, 0, Scr.d_depth, 
		      CopyFromParent,Scr.d_visual,valuemask,&attributes);
    }
  else
    {
      valuemask = CWEventMask;
      XChangeWindowAttributes(dpy,tmp_win->icon_pixmap_w,
			      valuemask,&attributes);
    }


#ifdef XPM
#ifdef SHAPE
  if (tmp_win->flags & SHAPED_ICON)
    {
      XShapeCombineMask(dpy, tmp_win->icon_pixmap_w, ShapeBounding,2, 2,
			tmp_win->icon_maskPixmap, ShapeSet);
    }
#endif
#endif

  XSaveContext(dpy, tmp_win->icon_w, FvwmContext, (caddr_t)tmp_win);
  if(tmp_win->icon_pixmap_w != None)
    XSaveContext(dpy, tmp_win->icon_pixmap_w, FvwmContext, (caddr_t)tmp_win);
  XDefineCursor(dpy, tmp_win->icon_w, Scr.FvwmCursors[FRAME]);
  XDefineCursor(dpy, tmp_win->icon_pixmap_w, Scr.FvwmCursors[FRAME]);
  GrabIconButtons(tmp_win,tmp_win->icon_w);
  GrabIconKeys(tmp_win,tmp_win->icon_w);
  if(tmp_win->icon_pixmap_w)
    {
      GrabIconButtons(tmp_win,tmp_win->icon_pixmap_w);
      GrabIconKeys(tmp_win,tmp_win->icon_pixmap_w);
    }
  return;
#endif
}

/****************************************************************************
 *
 * Draws the icon window
 *
 ****************************************************************************/
void DrawIconWindow(FvwmWindow *Tmp_win)
{
#ifndef NO_ICONS
  GC Shadow, Relief;
  Pixel TextColor,BackColor;

  if(Scr.flags & SuppressIcons)
    return;

  flush_expose (Tmp_win->icon_w);
  if(Tmp_win->icon_pixmap_w != None)
    flush_expose (Tmp_win->icon_pixmap_w);

  if(Scr.Focus == Tmp_win)
    {
      if(Scr.d_depth < 2)
	Relief = Scr.HiShadowGC;
      else
	Relief = Scr.HiReliefGC;
      Shadow = Scr.HiShadowGC;
      XSetWindowBackground(dpy,Tmp_win->icon_w,Scr.HiColors.back);
      if((Tmp_win->flags & ICON_OURS)&&(Tmp_win->icon_pixmap_w != None))
	XSetWindowBackground(dpy,Tmp_win->icon_pixmap_w,Scr.HiColors.back);
      /* resize the icon name window */
      Tmp_win->icon_w_width = Tmp_win->icon_t_width+6;
      if(Tmp_win->icon_w_width < Tmp_win->icon_p_width)
	Tmp_win->icon_w_width = Tmp_win->icon_p_width;
      Tmp_win->icon_xl_loc = Tmp_win->icon_x_loc - 
	(Tmp_win->icon_w_width - Tmp_win->icon_p_width)/2;
      TextColor = Scr.HiColors.fore;
      BackColor = Scr.HiColors.back;
    }
  else
    {
      if(Scr.d_depth < 2)
	Relief = Scr.StdShadowGC;
      else
	Relief = Scr.StdReliefGC;
      Shadow = Scr.StdShadowGC;
      XSetWindowBackground(dpy,Tmp_win->icon_w,Scr.StdColors.back);
      if((Tmp_win->flags & ICON_OURS)&&(Tmp_win->icon_pixmap_w != None))
	XSetWindowBackground(dpy,Tmp_win->icon_pixmap_w,Scr.StdColors.back);
      /* resize the icon name window */
      Tmp_win->icon_w_width = Tmp_win->icon_p_width;
      Tmp_win->icon_xl_loc = Tmp_win->icon_x_loc;
      TextColor = Scr.StdColors.fore;
      BackColor = Scr.StdColors.back;
    }
  /* write the icon label */
  NewFontAndColor(IconFont->font->fid,TextColor,BackColor);

  XMoveWindow(dpy,Tmp_win->icon_pixmap_w,Tmp_win->icon_x_loc,
	      Tmp_win->icon_y_loc);
  XMoveResizeWindow(dpy, Tmp_win->icon_w, Tmp_win->icon_xl_loc,
		    Tmp_win->icon_y_loc+Tmp_win->icon_p_height,
		    Tmp_win->icon_w_width,ICON_HEIGHT);
  
  XClearWindow(dpy,Tmp_win->icon_w);

  if((Tmp_win->iconPixmap != None)&&(!(Tmp_win->flags & SHAPED_ICON)))
    RelieveWindow(Tmp_win->icon_pixmap_w,0,0,Tmp_win->icon_p_width,
		  Tmp_win->icon_p_height, Relief,Shadow);  

  /* need to locate the icon pixmap */
  if(Tmp_win->iconPixmap != None)
    {
      if(Tmp_win->iconDepth == Scr.d_depth)
	{
	  XCopyArea(dpy,Tmp_win->iconPixmap,Tmp_win->icon_pixmap_w,Scr.FontGC,
		    0,0,Tmp_win->icon_p_width-4, Tmp_win->icon_p_height-4,2,2);
	}
      else
	XCopyPlane(dpy,Tmp_win->iconPixmap,Tmp_win->icon_pixmap_w,Scr.FontGC,0,
		   0,Tmp_win->icon_p_width-4, Tmp_win->icon_p_height-4,2,2,1);
    }      
  XDrawString (dpy, Tmp_win->icon_w, Scr.FontGC,
	       (Tmp_win->icon_w_width - Tmp_win->icon_t_width)/2,
	       Tmp_win->icon_w_height-IconFont->height+IconFont->y-3,
	       Tmp_win->icon_name, strlen(Tmp_win->icon_name));
  RelieveWindow(Tmp_win->icon_w,0,0,Tmp_win->icon_w_width,
		ICON_HEIGHT,Relief,Shadow);
#endif  
}

/***********************************************************************
 *
 *  Procedure:
 *	RedoIconName - procedure to re-position the icon window and name
 *
 ************************************************************************/
void RedoIconName(FvwmWindow *Tmp_win)
{
#ifndef NO_PAGER
  if(Scr.PagerFont.height > 0)
    {
      XClearWindow(dpy,Tmp_win->pager_view);
      RedrawPager();
    }
#endif

#ifndef NO_ICONS
  if(Scr.flags & SuppressIcons)
    return;

  if (Tmp_win->icon_w == (int)NULL)
    return;
  
  Tmp_win->icon_t_width = XTextWidth(IconFont->font,Tmp_win->icon_name, 
				     strlen(Tmp_win->icon_name));
  /* clear the icon window, and trigger a re-draw via an expose event */
  if (Tmp_win->flags & ICON)
    XClearArea(dpy, Tmp_win->icon_w, 0, 0, 0, 0, True);
#endif
  return;
}



  
/***********************************************************************
 *
 *  Procedure:
 *	AutoPlace - Find a home for an icon
 *
 ************************************************************************/
void AutoPlace(FvwmWindow *t)
{
#ifndef NO_ICONS
  /* Search down the right side of the display, avoiding places where 
   * icons live, or active windows are open, then go accross the bottom
   * If no home is found, put it at the default location */
  int test_x=0, test_y=0,tw,th,tx,ty,temp_h,temp_w,i;
  int width,height;
  FvwmWindow *test_window;
  Bool loc_ok;

  width = t->icon_p_width;
  height = t->icon_w_height + t->icon_p_height;
  loc_ok = False;  

  /* check all boxes in order */
  i=0;
  while((i<Scr.NumBoxes)&&(!loc_ok))
    {
      /* In each IconBox, start at the upper left, travel right, then
       * down */
      test_y = Scr.IconBoxes[i][1];
      
      /* Generally, want to make sure that the entire icon window fits 
       * inside the icon box. BUT if we get an exceptionally tall or wide
       * icon, we should just try to fit one side of the icon in the icon
       * box. This temp_h, temp_w nonsense will take care of that case for
       * me. 
       */
      temp_h = 0;
      temp_w = 0;
      while(((test_y + temp_h) < Scr.IconBoxes[i][3])&&(!loc_ok))
	{
	  test_x = Scr.IconBoxes[i][0];
	  while(((test_x + temp_w) < Scr.IconBoxes[i][2])&&(!loc_ok))
	    {
	      loc_ok = True;
	      test_window = Scr.FvwmRoot.next;
	      while((test_window != (FvwmWindow *)0)&&(loc_ok == True))
		{
		  if((test_window->flags & ICON)&&(test_window->icon_w)&&
		     (test_window != t))
		    {
		      tw=test_window->icon_p_width;
		      th=test_window->icon_p_height+test_window->icon_w_height;
		      tx = test_window->icon_x_loc;
		      ty = test_window->icon_y_loc;
		      
		      if((tx < (test_x + width + 3))&&((tx + tw +3) > test_x)&&
			 (ty < (test_y + height + 3))&&((ty + th + 3)>test_y))
			{
			  loc_ok = False;
			  test_x = tx + tw;
			}
		    }
#ifdef STUBBORN_PLACEMENT
		  if(!(test_window->flags & ICON)&&(test_window != t))
		    {
		      tw=test_window->frame_width;
		      th=test_window->frame_height;
		      tx = test_window->frame_x;
		      ty = test_window->frame_y;
		      
		      if((tx < (test_x + width + 3))&&((tx + tw +3) > test_x)&&
			 (ty < (test_y + height + 3))&&((ty + th + 3)>test_y))
			{
			  loc_ok = False;
			  test_x = tx + tw;
			}
		    }
#endif
		  test_window = test_window->next;
		}
	      temp_w = width;
	      test_x +=3;
	    }
	  temp_h = height;
	  test_y +=3;
	}
      i++;
    }
  if(loc_ok == False)
    return;
  t->icon_x_loc = test_x;
  t->icon_y_loc = test_y;

  if(t->icon_x_loc + t->icon_p_width > Scr.MyDisplayWidth)
    {
      t->icon_x_loc = Scr.MyDisplayWidth - t->icon_p_width;
    }
  if(t->icon_y_loc + t->icon_p_height+ICON_HEIGHT > Scr.MyDisplayHeight)
    {
      t->icon_y_loc = Scr.MyDisplayHeight - t->icon_p_height - ICON_HEIGHT;
    }
  if(t->icon_pixmap_w)
    XMoveWindow(dpy,t->icon_pixmap_w,t->icon_x_loc, t->icon_y_loc);

  t->icon_w_width = t->icon_p_width;
  t->icon_xl_loc = t->icon_x_loc;

  XMoveResizeWindow(dpy, t->icon_w, t->icon_xl_loc,
		    t->icon_y_loc+t->icon_p_height, 
		    t->icon_w_width,ICON_HEIGHT);
#endif
}

/***********************************************************************
 *
 *  Procedure:
 *	GrabIconButtons - grab needed buttons for the icon window
 *
 *  Inputs:
 *	tmp_win - the fvwm window structure to use
 *
 ***********************************************************************/
void GrabIconButtons(FvwmWindow *tmp_win, Window w)
{
  MouseButton *MouseEntry;

  MouseEntry = Scr.MouseButtonRoot;
  while(MouseEntry != (MouseButton *)0)
    {
      if((MouseEntry->func != (int)0)&&(MouseEntry->Context & C_ICON))
	{
	  if(MouseEntry->Button >0)
	    XGrabButton(dpy, MouseEntry->Button, MouseEntry->Modifier, w, 
			True, ButtonPressMask | ButtonReleaseMask,
			GrabModeAsync, GrabModeAsync, None, 
			Scr.FvwmCursors[FRAME]);
	  else
	    {
	      XGrabButton(dpy, 1, MouseEntry->Modifier, w,
			  True, ButtonPressMask | ButtonReleaseMask,
			  GrabModeAsync, GrabModeAsync, None, 
			  Scr.FvwmCursors[FRAME]);
	      XGrabButton(dpy, 2, MouseEntry->Modifier, w,
			  True, ButtonPressMask | ButtonReleaseMask,
			  GrabModeAsync, GrabModeAsync, None, 
			  Scr.FvwmCursors[FRAME]);
	      XGrabButton(dpy, 3, MouseEntry->Modifier, w,
			  True, ButtonPressMask | ButtonReleaseMask,
			  GrabModeAsync, GrabModeAsync, None, 
			  Scr.FvwmCursors[FRAME]);
	    }
	}
      
      MouseEntry = MouseEntry->NextButton;
    }
  return;
}



/***********************************************************************
 *
 *  Procedure:
 *	GrabIconKeys - grab needed keys for the icon window
 *
 *  Inputs:
 *	tmp_win - the fvwm window structure to use
 *
 ***********************************************************************/
void GrabIconKeys(FvwmWindow *tmp_win,Window w)
{
  FuncKey *tmp;
  for (tmp = Scr.FuncKeyRoot.next; tmp != NULL; tmp = tmp->next)
    {
      if (tmp->cont & C_ICON)
	XGrabKey(dpy, tmp->keycode, tmp->mods, w, True,
		 GrabModeAsync, GrabModeAsync);
    }
  return;
}
