/****************************************************************************
 * This module is all original code 
 * by Rob Nation (nation@rocket.sanders.lockheed.com 
 * Copyright 1993, Robert Nation
 *     You may use this code for any purpose, as long as the original
 *     copyright remains in the source code and all documentation
 ****************************************************************************/

/***********************************************************************
 *
 * code for moving windows
 *
 ***********************************************************************/

#include <stdio.h>
#include <signal.h>
#include <string.h>
#include <X11/Xos.h>
#include <X11/keysym.h>
#include "fvwm.h"
#include "menus.h"
#include "misc.h"
#include "parse.h"
#include "screen.h"

extern XEvent Event;
extern int menuFromFrameOrWindowOrTitlebar;
/****************************************************************************
 *
 * Start a window move operation
 *
 ****************************************************************************/
void move_window(XEvent *eventp,Window w,FvwmWindow *tmp_win,int context)
{
  extern int Stashed_X, Stashed_Y;
  int origDragX,origDragY,DragX, DragY, DragWidth, DragHeight;
  int XOffset, YOffset,FinalX,FinalY;
  Bool opaque_move = False;
#ifndef NO_PAGER
  extern Bool pagerOn;
#endif

  /* gotta have a window */
  if(w == None)
    return;

  InstallRootColormap();
  if (menuFromFrameOrWindowOrTitlebar) 
    {
      /* warp the pointer to the cursor position from before menu appeared*/
      XWarpPointer(dpy, None, Scr.Root, 0, 0, 0, 0, Stashed_X,Stashed_Y);
      XFlush(dpy);
    }


  DragX = eventp->xbutton.x_root;
  DragY = eventp->xbutton.y_root;
  /* If this is left commented out, then the move starts from the button press 
   * location instead of the current location, which seems to be an
   * improvement */
  /*  XQueryPointer(dpy, Scr.Root, &JunkRoot, &JunkChild,
      &DragX, &DragY,	&JunkX, &JunkY, &JunkMask);*/

  if(!GrabEm(MOVE))
    {
      XBell(dpy,Scr.screen);
      return;
    }

#ifndef NO_PAGER
  pagerOn = False;
#endif

  if(tmp_win->flags & ICON)
    w = tmp_win->icon_w;
  else if (w != tmp_win->icon_w)
    w = tmp_win->lead_w;
  
  XGetGeometry(dpy, w, &JunkRoot, &origDragX, &origDragY,
	       (unsigned int *)&DragWidth, (unsigned int *)&DragHeight, 
	       &JunkBW,  &JunkDepth);

  if(DragWidth*DragHeight <
     (Scr.OpaqueSize*Scr.MyDisplayWidth*Scr.MyDisplayHeight)/100)
    {
      opaque_move = True;
    }
  if(!opaque_move)
    XGrabServer(dpy);
  
  if ((tmp_win->flags & ICON)&&(tmp_win->icon_pixmap_w != None))
    {
      XGetGeometry(dpy, tmp_win->icon_pixmap_w, &JunkRoot, 
		   &origDragX, &origDragY,
		   (unsigned int *)&DragWidth, (unsigned int *)&DragHeight, 
		   &JunkBW,  &JunkDepth);
      DragHeight += tmp_win->icon_w_height;
    }

  DragWidth += JunkBW;
  DragHeight+= JunkBW;
  XOffset = origDragX - DragX;
  YOffset = origDragY - DragY;
  XMapRaised(dpy,Scr.SizeWindow);
  moveLoop(tmp_win, XOffset,YOffset,DragWidth,DragHeight, &FinalX,&FinalY,
	   opaque_move);
  if (w == tmp_win->lead_w)
    SetupFrame (tmp_win, FinalX, FinalY,
		tmp_win->frame_width, tmp_win->frame_height,FALSE);
  else /* icon window */
    {
      tmp_win->icon_x_loc = FinalX ;
      tmp_win->icon_xl_loc = FinalX -
	(tmp_win->icon_w_width - tmp_win->icon_p_width)/2;
      tmp_win->icon_y_loc = FinalY; 
      XMoveWindow (dpy, w, tmp_win->icon_xl_loc, FinalY+tmp_win->icon_p_height);
      if(tmp_win->icon_pixmap_w != None)
	XMoveWindow (dpy, tmp_win->icon_pixmap_w, tmp_win->icon_x_loc,FinalY);
      
    }
  
  XUnmapWindow(dpy,Scr.SizeWindow);
  UninstallRootColormap();

  if(!opaque_move)
    XUngrabServer(dpy);
  UngrabEm();

#ifndef NO_PAGER
  pagerOn = True;
  RedrawPager();
#endif

  return;
}



/****************************************************************************
 *
 * Move the rubberband around, return with the new window location
 *
 ****************************************************************************/
void moveLoop(FvwmWindow *tmp_win, int XOffset, int YOffset, int Width,
	      int Height, int *FinalX, int *FinalY,Bool opaque_move)
{
  Bool finished = False;
  Bool done;
  int xl,yt,delta_x,delta_y;
  unsigned int pagerwidth,pagerheight;
  int ww,wh;
  int wx,wy;
  int MaxH,MaxW;
  XQueryPointer(dpy, Scr.Root, &JunkRoot, &JunkChild,&xl, &yt,
		&JunkX, &JunkY, &JunkMask);
  xl += XOffset;
  yt += YOffset;

  if(!opaque_move)
    MoveOutline(Scr.Root, xl, yt, Width,Height);

  while (!finished)
    {
      /* block until there is an interesting event */
      XMaskEvent(dpy, ButtonPressMask | ButtonReleaseMask | KeyPressMask |
		 PointerMotionMask | ButtonMotionMask | ExposureMask, &Event);
      if (Event.type == MotionNotify) 
	/* discard any extra motion events before a logical release */
	while(XCheckMaskEvent(dpy, PointerMotionMask | ButtonMotionMask |
			      ButtonRelease, &Event))
	  if(Event.type == ButtonRelease) break;

      done = FALSE;
      /* Handle a limited number of key press events to allow mouseless
       * operation */
      if(Event.type == KeyPress)
	Keyboard_shortcuts(&Event,ButtonRelease);
      switch(Event.type)
	{
	case ButtonPress:
	case KeyPress:
	  /* throw away enter and leave events until release */
	  done = TRUE;
	  break;
	case ButtonRelease:
	  if(!opaque_move)
	    MoveOutline(Scr.Root, 0, 0, 0, 0);

	  XQueryPointer(dpy, Scr.Root, &JunkRoot, &JunkChild,&xl, &yt,
			&JunkX, &JunkY, &JunkMask);
	  xl = xl + XOffset;
	  yt = yt + YOffset;

	  /* Resist moving windows over the edge of the screen! */
	  if(((xl + Width) >= Scr.MyDisplayWidth)&&
	     ((xl + Width) < Scr.MyDisplayWidth+Scr.MoveResistance))
	    xl = Scr.MyDisplayWidth - Width;
	  if((xl <= 0)&&(xl > -Scr.MoveResistance))
	    xl = 0;
	  if(((yt + Height) >= Scr.MyDisplayHeight)&&
	     ((yt + Height) < Scr.MyDisplayHeight+Scr.MoveResistance))
	    yt = Scr.MyDisplayHeight - Height;
	  if((yt <= 0)&&(yt > -Scr.MoveResistance))
	    yt = 0;

	  *FinalX = xl;
	  *FinalY = yt;

	  done = TRUE;
	  finished = TRUE;
	  break;

	case MotionNotify:
	  XQueryPointer(dpy, Scr.Root, &JunkRoot, &JunkChild,&xl, &yt,
			&JunkX, &JunkY, &JunkMask);
	  HandlePaging(Scr.MyDisplayWidth,Scr.MyDisplayHeight,&xl,&yt,
		       &delta_x,&delta_y,False);

	  /* redraw the rubberband */
	  xl += XOffset;
	  yt += YOffset;

	  /* Resist moving windows over the edge of the screen! */
	  if(((xl + Width) >= Scr.MyDisplayWidth)&&
	     ((xl + Width) < Scr.MyDisplayWidth+Scr.MoveResistance))
	    xl = Scr.MyDisplayWidth - Width;
	  if((xl <= 0)&&(xl > -Scr.MoveResistance))
	    xl = 0;
	  if(((yt + Height) >= Scr.MyDisplayHeight)&&
	     ((yt + Height) < Scr.MyDisplayHeight+Scr.MoveResistance))
	    yt = Scr.MyDisplayHeight - Height;
	  if((yt <= 0)&&(yt > -Scr.MoveResistance))
	    yt = 0;

#ifndef NO_PAGER
	  /* update location of the pager_view window */
	  MoveOutline(Scr.Root,0,0,0,0);
	  if(Scr.FvwmPager)
	    {
	      pagerwidth = Scr.FvwmPager->frame_width - 
		2*Scr.FvwmPager->boundary_width;
	      pagerheight = Scr.FvwmPager->frame_height - 
		Scr.FvwmPager->title_height - 2*Scr.FvwmPager->boundary_width;
	      
	      MaxW = Scr.VxMax + Scr.MyDisplayWidth;
	      MaxH = Scr.VyMax + Scr.MyDisplayHeight;
	      
	      if(!(tmp_win->flags & STICKY)&&
		 (!(tmp_win->flags & ICON)||(!(Scr.flags & SuppressIcons)))&&
		 (!(tmp_win->flags & ICON)||(!(Scr.flags & StickyIcons))))
		{
		  /* show the actual window */
		  wx = (xl + Scr.Vx)*(int)pagerwidth/MaxW;
		  wy = (yt + Scr.Vy)*(int)pagerheight/MaxH;
		  ww = Width*(int)pagerwidth/MaxW;
		  wh = Height*(int)pagerheight/MaxH;
		  if(ww<2)ww=2;
		  if(wh<2)wh=2;
		  XMoveResizeWindow(dpy, tmp_win->pager_view, wx, wy, ww, wh);
		}
	    }
#endif


	  if(!opaque_move)
	    MoveOutline(Scr.Root, xl, yt, Width,Height);
	  else
	    {
	      if (tmp_win->flags & ICON)
		{
		  tmp_win->icon_x_loc = xl ;
		  tmp_win->icon_xl_loc = xl -
		    (tmp_win->icon_w_width - tmp_win->icon_p_width)/2;
		  tmp_win->icon_y_loc = yt; 
		  XMoveWindow(dpy, tmp_win->icon_w,tmp_win->icon_xl_loc,
			      yt+tmp_win->icon_p_height);
		  if(tmp_win->icon_pixmap_w != None)
		    XMoveWindow (dpy, tmp_win->icon_pixmap_w,
				 tmp_win->icon_x_loc,yt);
		}
	      else
		XMoveWindow(dpy,tmp_win->lead_w,xl,yt);
	    }
	  DisplayPosition(tmp_win,xl+Scr.Vx,yt+Scr.Vy);
	  done = TRUE;
	  break;

	default:
	  break;
	}
      if(!done)
	{
	  if(!opaque_move)
	    MoveOutline(Scr.Root,0,0,0,0);
   	  DispatchEvent();
	  if(!opaque_move)
	    MoveOutline(Scr.Root, xl, yt, Width, Height);
	}
    }
}

/***********************************************************************
 *
 *  Procedure:
 *      DisplayPosition - display the position in the dimensions window
 *
 *  Inputs:
 *      tmp_win - the current fvwm window
 *      x, y    - position of the window
 *
 ************************************************************************/

void DisplayPosition (FvwmWindow *tmp_win, int x, int y)
{
  char str [100];
  int offset;
  
  (void) sprintf (str, " %+-4d %+-4d ", x, y);
  XClearWindow(dpy,Scr.SizeWindow);
  XRaiseWindow(dpy,Scr.SizeWindow);
  if(Scr.d_depth >= 2)
    RelieveWindow(Scr.SizeWindow,0,0,Scr.SizeStringWidth+ SIZE_HINDENT*2,
		  Scr.StdFont.height + SIZE_VINDENT*2,
		  Scr.StdReliefGC,Scr.StdShadowGC);
  offset = (Scr.SizeStringWidth + SIZE_HINDENT*2
	    - XTextWidth(Scr.StdFont.font,str,strlen(str)))/2;
  XDrawString (dpy, Scr.SizeWindow, Scr.NormalGC,
	       offset,
	       Scr.StdFont.font->ascent + SIZE_VINDENT,
	       str, 11);
}


/****************************************************************************
 *
 * For menus, move, and resize operations, we can effect keyboard 
 * shortcuts by warping the pointer.
 *
 ****************************************************************************/
void Keyboard_shortcuts(XEvent *Event, int ReturnEvent)  
{
  int x,y,x_root,y_root;
  int move_size,x_move,y_move;
  KeySym keysym;

  /* Pick the size of the cursor movement */
  move_size = Scr.EntryHeight;
  if(Event->xkey.state & ControlMask)
    move_size = 1;
  if(Event->xkey.state & ShiftMask)
    move_size = 100;

  keysym = XLookupKeysym(&Event->xkey,0);

  x_move = 0;
  y_move = 0;
  switch(keysym)
    {
    case XK_Up:
    case XK_k:
    case XK_p:
      y_move = -move_size;
      break;
    case XK_Down:
    case XK_n:
    case XK_j:
      y_move = move_size;
      break;
    case XK_Left:
    case XK_b:
    case XK_h:
      x_move = -move_size;
      break;
    case XK_Right:
    case XK_f:
    case XK_l:
      x_move = move_size;
      break;
    case XK_Return:
    case XK_space:
      /* beat up the event */
      Event->type = ReturnEvent;
      break;
    default:
      break;
    }
  XQueryPointer( dpy, Scr.Root, &JunkRoot, &Event->xany.window,
		&x_root, &y_root, &x, &y, &JunkMask);

  if((x_move != 0)||(y_move != 0))
    {
      /* beat up the event */
      XWarpPointer(dpy, None, Scr.Root, 0, 0, 0, 0, x_root+x_move,
		   y_root+y_move);

      /* beat up the event */
      Event->type = MotionNotify;
      Event->xkey.x += x_move;
      Event->xkey.y += y_move;
    }
}

