/*  by Matthias Lautner */
/*  by Robert Sanders */
/*  modified by Edward Der-Hua Liu for X11 interface */
/* make sure that this line ist the first of emu.c
   and link emu.o as the first object file to the lib */
	__asm__("___START___: jmp _emulate\n");
#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <errno.h>
#include <string.h>
#include <ctype.h>
#include <fcntl.h>
#include <signal.h>
#include <termio.h>
#include <termcap.h>
#include <sys/stat.h>
#include <time.h>
#include <sys/times.h>
#include <sys/time.h>
#include <limits.h>
#include <linux/fd.h>
#include "emu.h"
#include "timers.h"
#include "cmos.h"
#include "dosvga.h"

#ifdef XMS
#include "xms.h"
#endif

#define INIT_SCREEN_MODE        3  /* 80x25 VGA color */

#if	1
#define VID_COMBO               4  /* 4=EGA (ok), 8=VGA (not ok) */
#else
#define VID_COMBO               8  /* 4=EGA (ok), 8=VGA (not ok) */
#endif	0

#define VID_SUBSYS              0  /* 0=color */

extern void Flush_X();
/* without disk information */
#define CONFIGURATION (0xc90e | INIT_SCREEN_MODE)
int CO=80;
int LI=25;
#define SCRSIZE (80*25*2)

#define SCREEN_ADR(s)	(us *)(0xb8000 + s * 0x1000)
#define OUTBUFSIZE	3000
#define SETIVEC(i, seg, ofs)	((us *)0)[ (i<<1) +1] = (us)seg; \
				((us *)0)[  i<<1    ] = (us)ofs

extern int X_busy;
FILE *lpt[3]={ NULL, NULL, NULL };
char *prtnames[] =
{
  "dosemulpt1",  "dosemulpt2", "dosemulpt3"
};
char *comnames[] =
{
  "/dev/ttyS0", "/dev/ttyS1", "doscom3", "doscom4"
};
int printer_print(int, char), serial_write(int, char), serial_read(int);

/************************************************************/

/* Universal Asynchronous Receiver/Transmitter, 8250/16450 */
struct uart
{
  int base;     /* base port, i.e. com2=0x2f8 */
  unsigned char
    RX,         /* receive */
    TX,         /* transmit */
    IER,        /* interrupt enable */
    IIR,        /* interrupt ID */
    FCR,        /* FIFO control */
    LCR,        /* line control */
    MCR,        /* modem control */
    LSR,        /* line status */
    MSR,        /* modem status */
    SCR;        /* scratch */
  int fd;       /* file descriptor */
} uarts[4];

/* Programmable Interrupt Controller, 8259 */
struct pic
{
  int stage;    /* where in init. , 0=ICW1 */
        /* the seq. is ICW1 to 0x20, ICW2 to 0x21
         * if ICW1:D1=0, ICW3 to 0x20h, 
         * ICW4 to 0x21, OCWs any order
         */
  unsigned char
    ICW1,       /* Input Control Words */
    ICW2,
    ICW3,
    ICW4,
    OCW1,       /* Output Control Words */
    OCW2,
    OCW3;
} pics[2];

int port61=0xd0;  /* the pseudo-8255 device on AT's */

/* floppy disks, dos partitions or their images (files) (maximum 8 heads) */
int fdisks=2;    /* maximum 4 */

struct disk disktab1[] = {
		{"/dev/fd0", 0, 15, 2, 80, FIVE_INCH_FLOPPY,-1,1},
		{"/dev/fd1", 0, 0, 0, 0, THREE_INCH_FLOPPY,-1,1},
	};

struct disk disktab2[] = {
		{"fdimage         ", 0, 15, 2, 80, FIVE_INCH_FLOPPY,-1,0},
		{"/dev/fd1", 0, 0, 0, 0, THREE_INCH_FLOPPY,-1,1},
	};

struct disk *disktab=disktab1;

/* whole hard disks, dos extented partitions (containing one ore more partitions)
   or their images (files) */
int hdisks=2;
struct disk hdisktab[] = {
		{"hdimage", 0, 17, 2, 20},
		{"/dev/hda", 1, 17, 15, 930},
/*			     ^ readonly					*/
/*				^ sectors 				*/
/*				    ^ heads				*/
/*					^ cylinders			*/
	};
struct vm86_struct vm86s;
int error;
struct timeval scr_tv;
struct itimerval itv;
#if	0
int secalrm=0;
struct itimerval secitv;
#endif
unsigned char outbuf[OUTBUFSIZE], *outp = outbuf;
int iflag=1;
struct disk *boot_disk=hdisktab;
int scrtest_bitmap;
long start_time;
int c_screen=0, xpos[8], ypos[8];
int mem_size=640, extmem_size=MAX_XMS;
unsigned long last_ticks;
int in_interrupt=0;             /* for unimplemented interrupt code */
int card_init=0;
unsigned long precard_eip, precard_cs;
int screen_mode=INIT_SCREEN_MODE;
int console_video=0,
    console_keyb=0,		/* 1 if uses PC console */
    vga=0,			/* use VGA controls on sonsole */
    graphics=0;			/* can do graphics */
int gfx_mode = TEXT;
int max_page = 4;		/* number of highest vid page - 1*/


#define MEM_SIZE mem_size

/* this is the array of interrupt vectors */
struct vec_t {
  unsigned short offset;
  unsigned short segment;
} *ivecs=0;

int keybint=0;
int xms=0;
int mapped_bios=0, special_nowait=0;

struct vec_t orig[256];         /* "original" interrupt vectors */
struct vec_t snapshot[256];     /* vectors from last snapshot */

int poll_io=1, in_ioctl=0, ignore_segv;
int boot_in_progress=0;         /* 1 if booting */
int in_readkeyboard=0;
int timers=0;                   /* no timer emulation */
int sizes=0;

#define ENT_SEGV in_signal|=1
#define LEA_SEGV in_signal&=~1
#define ENT_ILL	in_signal|=2
#define LEA_ILL in_signal&=~2
#define ENT_TRAP in_signal|=4
#define LEA_TRAP in_signal&=~4	
#define ENT_FPE in_signal|=8
#define LEA_FPE in_signal&=~8


int in_signal=0;

unsigned char trans1[] = /* LATIN CHAR SET */
{	"\x20\0\0\0\0\0\0\x01\00\00\00\00\00\00\00\00"
	"\xbb\xab\0\0\266\247\0\0^v\x1b\x1a\0\0^v"
	" !\"#$%&'()*+,-./"
	"0123456789:;<=>?"
	"@ABCDEFGHIJKLMNO"
	"PQRSTUVWXYZ[\\]^_"
	"`abcdefghijklmno"
	"pqrstuvwxyz{|}~ "
	"\307\374\351\342\344\340\345\347\352\353\350\357\356\354\304\305"
	"\311\346\306\364\366\362\373\371\377\326\334\242\243\245\0\0"
	"\341\355\363\372\361\321\252\272\277\0\254\275\274\241\253\273"
	"\x02\x02\x02\x19\x16\x16\x16\x0c\x0c\x16\x19\x0c\x0b\x0b\x0b\x0c"
	"\x0e\x17\x18\x15\x12\x0f\x15\x15\x0e\x0d\x17\x18\x15\x12\x0f\x17"
	"\x17\x18\x18\x0e\x0e\x0d\x0d\x0f\x0f\x0b\x0d\x02\x02\x02\x02\x02"
	"\0\337\0\0\0\0\265\0\0\0\0\0\0\0\0\0"
	"\0\261\0\0\0\0\367\0\260\267\x01v\0\262\244\0"
};

unsigned char trans2[256];

unsigned char *trans;

void poscur(int x, int y)
{
  if ((unsigned)x >= CO || (unsigned)y >= LI) return;
  gotoxy(x,y);
}

extern void clrscr();
extern void str_norm(); 

unsigned char scr_mirror[80*25*2*2];
char blankstr[80];

void scrollup(int x0, int y0 , int x1, int y1, int l, int att)
{
	register int x;
	register us *p;
	int y, dx, dy, ofs;
	us *sadr, *msadr, *q, blank = ' ' | (att << 8);

	sadr = SCREEN_ADR(c_screen);
	if(l==0)	/* Wipe mode */
        {
		int width=x1-x0+1;	
		for(dy=y0;dy<=y1;dy++) {
			for(dx=x0;dx<=x1;dx++) {
				int ofs=dy*CO+dx;
				scr_mirror[ofs<<1]=sadr[ofs]=blank;
			}
			gotoxy(x0,dy);
			str_norm(blankstr,width,att);
		}
		return;
	}

	sadr += x0 + CO * (y0 + l);
	dx = x1 - x0 +1;
	dy = y1 - y0 - l +1;
	ofs = -CO * l;
	for (y=0; y<dy; y++) {
		p = sadr;
		for (x=0; x<dx; x++, p++) p[ofs] = p[0];
		sadr += CO;
	}
	for (y=0; y<l; y++) {
		sadr -= CO;
		p = sadr;
		for (x=0; x<dx; x++, p++) *p = blank;
	}
	/* This one is very bad but simple */
	p=(us *)scr_mirror;
	for(y=y0;y<=y1;y++)
	for(x=x0;x<=x1;x++) p[y*CO+x]=0xffff;
}

void scrolldn(int x0, int y0 , int x1, int y1, int l, int att)
{
	int dx, dy, x, y, ofs;
	us *sadr, *p, blank = ' ' | (att << 8);

	sadr = SCREEN_ADR(c_screen);
	sadr += x0 + CO * (y1 -l);
	dx = x1 - x0 +1;
	dy = y1 - y0 - l +1;
	ofs = CO * l;
	for (y=0; y<dy; y++) {
		p = sadr;
		if (l != 0) for (x=0; x<dx; x++, p++) p[ofs] = p[0];
		else        for (x=0; x<dx; x++, p++) p[0] = blank;
		sadr -= CO;
	}
	for (y=0; y<l; y++) {
		sadr += CO;
		p = sadr;
		for (x=0; x<dx; x++, p++) *p = blank;
	}
}


void char_out(unsigned char ch, int s)
{
	if (s > 7) return;
#if	0
        putchar(ch);
#endif
	X_busy=1;
	if (ch >= ' ') {
		unsigned char *chp;
		int ofs= (ypos[s]*CO+xpos[s]++)<<1 ;

		scr_mirror[ofs]=
		*(chp=( (unsigned char *)SCREEN_ADR(s) + ofs))=ch;
		if (s == c_screen) ch_norm(trans[ch], *(chp+1));

	} else if (ch == '\r') {
		xpos[s] = 0;
		if (s == c_screen) ch_cr();
	} else if (ch == '\n') {
		ypos[s]++;
		if (s == c_screen) ch_lf();
	} else if (ch == '\t') {
		puts("tab");
		do {
			char_out(' ', s);
		} while (xpos[s] % 8 != 0);
	} else if (ch == '\010' && xpos[s] > 0) {
		xpos[s]--;
		if (s == c_screen) ch_bs(); 
	} else if (ch == 7) {
		X_busy=1;
		Bell();
		X_busy=0;
	}
	if (xpos[s] == CO) {
		xpos[s] = 0;
		ypos[s]++;
	}
	if (ypos[s] == LI) {
		ypos[s]--;
		scrollup(0, 0, CO-1, LI-1, 1, 7);
	}
	{	char *pp=(char *)((char*)0x450+(s<<1));
		*pp=ypos[s];
		*(pp+1)=xpos[s];
	}
	X_busy=0;
}

void char_out_att(unsigned char ch, unsigned char att, int s)
{
	if (s > 7) return;
	X_busy=1;
	if (ch >= ' ') {
		unsigned char *chp;
		int ofs= (ypos[s]*CO+xpos[s]++)<<1 ;

		scr_mirror[ofs]=
		*(chp=( (unsigned char *)SCREEN_ADR(s) + ofs))=ch;
		*(chp+1)=att;
		if (s == c_screen)  { ch_norm(trans[ch], att); }
	}
	if (xpos[s] == CO) {
		xpos[s]--;
	}
	if (ypos[s] == LI) {
		ypos[s]--;
	}
	{	char *pp=(char *)((char*)0x450+(s<<1));
		*(pp+1)=xpos[s];
		*(pp)=ypos[s];
	}
	X_busy=0;
}

out_str(char *str,unsigned char att)
{
char ch;
while(ch=*(str++))
switch (ch) {
case '\n':
	xpos[0] = 0;
	ch_cr();
	ypos[0]++;
	ch_lf();
default:
	char_out_att(ch,att,0);
}
}

void clear_screen(int s, int att)
{
	us *sadr, *p, *q, blank = ' ' | (att << 8);

	if (s > 7) return;
	if (s == c_screen) clrscr();
	xpos[s] = ypos[s] = 0;
	sadr = SCREEN_ADR(s);
	q=(us *)(scr_mirror);
	for (p = sadr; p < sadr+2000; *p++=*q++=blank);
}


void restore_screen(void)
{
	unsigned char *p;
	unsigned char c;
	register unsigned long *ck, *mr, *end_addr;
	int x,y, tt, lx,ly;
	unsigned char catt, buf[200], clen;


	ck = (unsigned long *)SCREEN_ADR(c_screen);
	mr = (unsigned long *)scr_mirror;
	end_addr=(unsigned long *) ((char *)mr + SCRSIZE);

	lx=-1;
	ly=0;
	clen=0;
	for(;;) {
		while (*ck==*mr) {
			ck++; mr++;
		}
		if (mr >= end_addr ) break; 
		*mr=*ck;
		tt=((char *)mr - (char *)scr_mirror) >> 1;
		y=tt/CO;
		x=tt%CO;
		p=(unsigned char *)mr;
		if (lx+1==x && ly==y && catt==*(p+1)) {
			buf[clen++]=trans[*p];
			lx=x++;
		} else {
			gotoxy(lx+1-clen, ly);
			str_norm(buf, clen, catt);
			buf[0]=trans[*p];
			clen=1;
			catt=*(p+1);
			lx=x++;
			ly=y;
		}
		p+=2;
		if (catt==*(p+1)) {
			buf[clen++]=trans[*p];
			lx=x;
		} else {
			gotoxy(lx+1-clen, ly);
			str_norm(buf, clen, catt);
			buf[0]=trans[*p];
			clen=1;
			catt=*(p+1);
			lx=x;
			ly=y;
		}
		ck++; mr++;
	}
	if (clen) {
		gotoxy(lx+1-clen, ly);
		str_norm(buf, clen, catt);
	}
	poscur(xpos[c_screen],ypos[c_screen]);
	ShowCursor();
	Flush_X();
}

void disk_close(void) {
	struct disk * dp;

	for (dp = disktab; dp < &disktab[fdisks]; dp++) {
		if (dp->removeable && dp->fdesc >= 0) {
			(void)close(dp->fdesc);
			dp->fdesc = -1;
		}
	}
}

void disk_open(struct disk *dp)
{
struct floppy_struct fl;

	if (dp == NULL || dp->fdesc >= 0) return;
/*	dp->fdesc = open(dp->dev_name, dp->rdonly ? O_RDONLY : O_RDWR, 0); */
	dp->fdesc = open(dp->dev_name, O_RDWR, 0);
	if (dp->fdesc < 0) {
		printf("cann't open %s\n", dp->dev_name);
		error = 5;
		return;
	}
	if (ioctl(dp->fdesc, FDGETPRM, &fl) == -1) {
		if (errno == ENODEV) { /* no disk available */
			dp->sectors = 0;
			dp->heads = 0;
			dp->tracks = 0;
			return;
		}
		printf("cann't get floppy parameter of %s (%s)\n", dp->dev_name, sys_errlist[errno]);
		error = 5;
		return;
	}
	printf("FLOPPY %s h=%d, s=%d, t=%d\n", dp->dev_name, fl.head, fl.sect, fl.track);
	dp->sectors = fl.sect;
	dp->heads = fl.head;
	dp->tracks = fl.track;
}

void floppy_close_all()
{
	disk_close();
}

void disk_close_all(void)
{
	struct disk * dp;

	for (dp = disktab; dp < &disktab[fdisks]; dp++) {
		if (dp->fdesc >= 0) {
			(void)close(dp->fdesc);
			dp->fdesc = -1;
		}
	}

	for (dp = hdisktab; dp < &hdisktab[hdisks]; dp++) {
		if (dp->fdesc >= 0) {
			(void)close(dp->fdesc);
			dp->fdesc = -1;
		}
	}
}


void disk_init(void)
{
	int s;
	struct disk * dp;
	struct stat stbuf;
	char buf[30];

	for (dp = disktab; dp < &disktab[fdisks]; dp++) {
		if (stat(dp->dev_name, &stbuf) < 0) {
			printf("cann't stat %s\n", dp->dev_name);
			exit(1);
		}
		if (S_ISBLK(stbuf.st_mode)) printf("ISBLK\n");
		printf ("dev : %x\n", stbuf.st_rdev);
		if (S_ISBLK(stbuf.st_mode) && (stbuf.st_rdev & 0xff00) == 0x200) {
			printf("DISK %s removeable\n", dp->dev_name);
			dp->removeable = 1;
			dp->fdesc = -1;
			continue;
		}
		dp->fdesc = open(dp->dev_name, dp->rdonly ? O_RDONLY : O_RDWR, 0);
		if (dp->fdesc < 0) {
			printf("cann't open %s\n", dp->dev_name);
			exit(1);
		}
	}
	for (dp = hdisktab; dp < &hdisktab[hdisks]; dp++) {
/*
		dp->fdesc = open(dp->dev_name, dp->rdonly ? O_RDONLY : O_RDWR, 0);
*/
		dp->fdesc = open(dp->dev_name, O_RDWR, 0);
		dp->removeable = 0;
		if (dp->fdesc < 0) {
			printf("cann't open %s\n", dp->dev_name);
			exit(1);
		}
#if	0
		if (read(dp->fdesc, buf, 30) != 30) {
			printf("cann't read disk info of %s\n", dp->dev_name);
			exit(1);
		}
		dp->sectors = *(us *)&buf[24];
		dp->heads = *(us *)&buf[26];
		s = *(us *)&buf[19] + *(us *)&buf[28];  /* used sectors + hidden sectors */
		dp->tracks = s / (dp->sectors * dp->heads);
		printf("disk %s; h=%d, s=%d, t=%d, sz=%d, hid=%d\n", dp->dev_name, 
			dp->heads, dp->sectors, dp->tracks, s, *(us *)&buf[28]);
		if (s % (dp->sectors * dp->heads) != 0) {
			printf("cann't read track number of %s\n", dp->dev_name);
			exit(1);
		}
#endif
	}
}


void show_regs(void)
{
	int i;
	unsigned char *cp = SEG_ADR((unsigned char *), cs, ip);

	printf(" cs    eip     ss    esp      flags    ds   es   fs   gs \n");
	printf("%4x:%08x %4x:%08x %08x %4x %4x %4x %4x\n", *(us *)&_regs.cs, _regs.eip, 
		*(us *)&_regs.ss, _regs.esp, _regs.eflags, *(us *)&_regs.ds,
		*(us *)&_regs.es, *(us *)&_regs.fs, *(us *)&_regs.gs);
	printf("  eax      ebx      ecx      edx      edi      esi      ebp\n");
	printf("%08x %08x %08x %08x %08x %08x %08x \n", _regs.eax, _regs.ebx, 
		_regs.ecx, _regs.edx, _regs.edi, _regs.esi, _regs.ebp);
	for (i=0; i<10; i++)
		printf(" %02x", *cp++);
	printf("\n");
}
int lastscan=0;

void do_int();

int int9_fq=0, int9_eq=0, int9_cq=0;
int int9_key[1024];
int int9_atkey[1024];

int inb(int port)
{
	static unsigned int cga_r=0;
	static unsigned int tmp=0;
	int holder;

	port &= 0xffff;

	/* graphic status - many programs will use this port to sync with
	 * the vert & horz retrace so as not to cause CGA snow */
	if ((port == 0x3da) || (port == 0x3ba))
	  return (cga_r ^= 1) ? 0xcf : 0xc6;
	else
	  switch (port)
	    {
	    case 0x60:
/*		printf("key %x %x\n", at_key, int_key); */
	      if (int9_atkey[int9_cq])
		{ tmp=int9_atkey[int9_cq]; int9_atkey[int9_cq]=0; return tmp; }
	      else return int9_key[int9_cq];
	      break;
	    case 0x64:
	      tmp=0x10 | (lastscan ? 1 : 0);  /* low bit set = sc ready */
	      /* lastscan=0; */
	      k_printf("direct 8042 status check: 0x%02x\n", tmp);
	      return tmp;
	    case 0x61:
	      i_printf("inb [0x61] =  0x%x (8255 chip)\n", port61);
	      return port61;

	    case 0x70:
	    case 0x71:
	      return cmos_read(port);

	    case 0x2f8:
	      serial_read(1);
	      s_printf("com2 RX --> %c [%d]\n", uarts[1].RX, uarts[1].RX);
	      return uarts[1].RX;
	      break;
	    case 0x2f9:
	      s_printf("com2 IER --> 0x%2x\n", uarts[1].IER);
	      return uarts[1].IER;
	      break;
	    case 0x2fA:
	      s_printf("com2 IIR --> 0x%2x\n", uarts[1].IIR);
	      s_printf("setting IIR to 0x01\n");
	      tmp=uarts[1].IIR;
	      uarts[1].IIR = 0x1;
	      return tmp;
	      break;
	    case 0x2fb:
	      s_printf("com2 LCR --> 0x%2x\n", uarts[1].LCR);
	      return uarts[1].LCR;
	      break;
	    case 0x2fc:
	      s_printf("com2 MCR --> 0x%2x\n", uarts[1].MCR);
	      return uarts[1].MCR;
	      break;
	    case 0x2FD:
/*	      get_LSR(1); */
	      uarts[1].LSR &= 0xfe;
	      s_printf("com2 LSR --> 0x%2x\n", uarts[1].LSR); 
	      return uarts[1].LSR;
	      break;
	    case 0x2fe:
	      s_printf("com2 MSR --> 0x%2x\n", uarts[1].MSR);
	      return uarts[1].MSR;
	      break;
	    case 0x2ff:
	      s_printf("com2 SCR --> 0x%2x\n", uarts[1].SCR);
	      return uarts[1].SCR;
	      break;
	    case 0x40:
	      i_printf("inb [0x41] = 0x%x  1st timer inb\n",
			  pit.CNTR0--);
	      return pit.CNTR0;
	    case 0x41:
	      i_printf("inb [0x41] = 0x%x  2nd timer inb\n",
			  pit.CNTR1--);
	      return pit.CNTR1;
	    case 0x42:
	      i_printf("inb [0x42] = 0x%x  3rd timer inb\n",
			  pit.CNTR2--);
	      return pit.CNTR2;
	    case 0x3bc:
	      i_printf("printer port inb [0x3bc] = 0\n");
	      return 0;
	    case 0x3db:  /* light pen strobe reset */
	      return 0;
	    default:
	      i_printf("inb [0x%x] = 0x%x\n", port, _regs.eax);
	      return 0;
	    }
	return 0;
}

void outb(int port, int byte)
{
  int comidx;
  static int timer_beep=0;
  static int lastport=0;

  port &= 0xffff;
  byte &= 0xff;

  i_printf("outb [0x%x] 0x%x   ", port, byte);
  if ((port == 0x60) || (port == 0x64)) i_printf("keyboard outb\n");
  else if (port == 0x61) 
    {
      port61=byte;
      i_printf("8255 outb\n");
      if ((byte & 3 == 3) && (timer_beep == 1))
	{
	  i_printf("beep!\n");
	  fprintf(stderr,"\007");
	  timer_beep=0;
	} 
      else timer_beep=1;
    }

  else if ((port == 0x70) || (port == 0x71))
    cmos_write(port, byte);

  else if (port >= 0x40 && port <= 0x43)
    {
      i_printf("timer outb 0x%02x\n", byte);
      if ((port == 0x42) && (lastport == 0x42))
	{
	  if (timer_beep == 1)
	    {
	      fprintf(stderr,"\007");
	      timer_beep=0;
	    }
	  else timer_beep=1;
	}
    }
  else
    {
      int baseport=port & 0xfff8;	/* mask out low 3 bits */
      int thre_int;			/* irq for transmit done */

      /* if port is in a UART, perform UART emulation */
      for (comidx = 0; comidx <= 3; comidx ++)
	{
/*	  s_printf("outb port: 0x%04x, combase: 0x%04x, low: 0x%04x\n",
		 port & 0xfff8, uarts[comidx].base, port & 0x7); */
	  if (uarts[comidx].base == (port & 0xfff8))
	    switch ((port & 0x7))		/* get low 3 bits */
	      {
	      case 0:
		s_printf("com%d TX := %c [0x%x]\n", comidx+1, byte, byte);
		serial_write(comidx, byte);
		if (comidx & 1) thre_int=3 /* 0xb */;  /* for COM2 and COM4 only! */
		else thre_int= 4 /* 0xc */;		/* COM1 and COM3 */
		
		if (1 /* uarts[comidx].IER & 2 */ ) 
		  {
		    int i;
		    s_printf("Calling THRE interrupt 0x%x\n", thre_int);
		    for (i=0; i < 40000; i++) ;
#if	0
		    do_int(4 /* thre_int */);
#endif	0
		    run_int(3 /* thre_int */);
		  }
		break;
	      case 1:
		s_printf("com%d IER := 0x%x\n", comidx+1,byte);
		uarts[comidx].IER = byte;
		break;
	      case 2:
		s_printf("com%d FCR := 0x%x\n", comidx+1,byte);
		uarts[comidx].FCR = byte;
		break;
	      case 3:
		s_printf("com%d LCR := 0x%x\n", comidx+1, byte);
		uarts[comidx].LCR = byte;
		break;
	      case 4:
		s_printf("com%d MCR := 0x%x\n", comidx+1,byte);
		uarts[comidx].MCR = byte;
		break;
	      case 5:
		s_printf("com%d SCR := 0x%x\n", comidx+1, byte);
		uarts[comidx].SCR = byte;
		break;
	      }
	}
    }
  lastport = port;
}

extern void keybuf_clear();

unsigned char xmouse_han1[]="\x07\x1f\x5f\x5e\x5a\x59\x5b\x58\x9d\xcb";
void boot(struct disk *dp)
{
	char *buffer;
	int i;
	unsigned char *ptr;

	cmos_init();
	disk_close();
	disk_open(dp);
	buffer = (char *)0x7c00;
	memset((char *)0xff000, 0xF4, 0x1000); /* fill the last page with HLT */
	/* init trapped interrupts if called via jump */
	for (i=0; i<0x100; i++) {
		if ((i & 0xf8) == 0x60) continue; /* user interrupts */
		SETIVEC(i, 0xe000, 16*i);
		ptr=(unsigned char *)(0xe000*16 + 16*i);
		ptr[0]=0xcd;     /* 0xcd = INT */
		ptr[1]=i;
		ptr[2]=0xcf;     /* 0xcf = IRET */

	}

	SETIVEC(0x33,0,0);     /* zero mouse address */
	SETIVEC(0x1c,0xe000,2);  /* should be an IRET */
	SETIVEC(0x67,0,0);  /* no EMS */

#ifdef XMS
	/* XMS has it's handler just after the interrupt dummy segment */
	ptr=(unsigned char *)(XMSControl_ADD);
	ptr[0]=0xeb;       /* jmp short forward 3 */
	ptr[1]=3;
	ptr[2]=0x90;       /* nop */
	ptr[3]=0x90;       /* nop */
	ptr[4]=0x90;       /* nop */
	ptr[5]=0xf4;       /* HLT...the current emulator trap */
	ptr[6]=XMS_MAGIC;  /* just an info byte. reserved for later */
	ptr[7]=0xcb;       /* FAR RET */
	xms_init();
#endif

	*(us *)0x402 = 0x2f8;         /* com port addresses */
	*(us *)0x404 = 0x3f8;  
	*(us *)0x406 = 0x2e8;
	*(us *)0x408 = 0x3e8;
	*(us *)0x410 = CONFIGURATION;
	if (fdisks > 0) *(us *)0x410 |= 1 | ((fdisks -1)<<6);


	*(us *)0x413 = 640;	/* size of memory */
	*(char *)0x449 = screen_mode;	/* screen mode */
	*(us *)0x44a = CO;	/* chars per line */
	*(us *)0x44c = CO * LI * 2;	/* video buffer len */
	*(unsigned char *)0x484 = LI-1;    /* lines on screen - 1 */
	*(us *)0x41a = 0x1e;	/* key buf start ofs */
	*(us *)0x41c = 0x1e;	/* key buf end ofs */
	/* key buf 0x41e .. 0x43d */
	
	keybuf_clear();

	*(us *)0x463 = 0x3d4;
	*(char *)0x465 = 9;
#define BIOS_KEYBUF_SIZE 32
	*(us *)0x480=0x1e;
	*(us *)0x482=0x1e + (BIOS_KEYBUF_SIZE);
	*(char *)0x487 = 0x61;
	*(char *)0x488 = 0x81;
	*(char *)0x48a = VID_COMBO;     /* video type */

#if	0
	*(char *)0x496 = 16;            /* 102-key keyboard */
#endif
	*(long *)0x4a8 = 0;             /* pointer to video table */

	/* from Alan Cox's mods */
	/* we need somewhere for the bios equipment. Put it at d0000 */

#if	0
	*(char *)0xd0000=0x09;
	*(char *)0xd0001=0x00;        /* 9 byte table */
	*(char *)0xd0002=0xFC;        /* PC AT */
	*(char *)0xd0003=0x00;
	*(char *)0xd0004=0x04;        /* bios revision 4 */
	*(char *)0xd0005=0x20;        
	/* no mca no ebios no wat no keybint rtc no slave 8259 no dma 3 */
#else
	*(char *)0xd0000=0x08;
	*(char *)0xd0001=0x00;        /* 8 byte table */
	*(char *)0xd0002=0xFC;        /* PC AT */
	*(char *)0xd0003=0x01;
	*(char *)0xd0004=0x00;        /* bios revision 4 */
	*(char *)0xd0005=0x70;
	*(char *)0xd0006=0x00;
	*(char *)0xd0007=0x00;
	*(char *)0xd0008=0x00;
	*(char *)0xd0009=0x00;
#endif

/* X mouse handler */
#include "xmouse.h"
	bcopy(xmouse_han1, (char *)(0xe0000+XMOUSE_HANDLER1), 
		sizeof(xmouse_han1));

	lseek(dp->fdesc, 0, 0);
	i = read(dp->fdesc, buffer, 512);
	if (i != 512) {
		printf("cann't boot from disk, using harddisk\n");
		dp = hdisktab;
		lseek(dp->fdesc, 0, 0);
		i = read(dp->fdesc, buffer, 512);
		if (i != 512) {
			printf("cann't boot from disk\n");
			_exit(1);
		}
	}
	disk_close();
	_regs.eax = _regs.ebx = _regs.edx = 0;
	_regs.ecx = 0;
	_regs.ebp = _regs.esi = _regs.edi = _regs.esp = 0;
	_regs.cs = _regs.ss = _regs.ds = _regs.es = _regs.fs = _regs.gs = 0x7c0;
	_regs.eip = 0;
	_regs.eflags = 0;
	printf("booted\n");
#if	0
	out_str("Ŀ\n",0x9f);
	out_str(" X DosPrompt version 0.3e \n",0x9f);
	out_str("\n",0x9f);
#endif
}

void int10(void)
{
	int x, y, s, i, tmp;
	char c, m;
	us *sadr, sc;
	static int gfx_flag=0;
	char tmpchar;


switch(HI(ax)) {
    case 0x0: /* define mode */
      v_printf("define mode: 0x%x\n", LO(ax));
      switch (LO(ax))
	{
	case 2:
	case 3:
	  v_printf("text mode from %d to %d\n", screen_mode, LO(ax));
	  if (gfx_flag && vga)
	    {
#ifdef EXPERIMENTAL_GFX
	      v_printf("returning from gfx mode\n");
	      vga_setmode(TEXT);
	      ioperm(0x3b0, 0x3db-0x3b0, 0);
	      show_cursor();
#else
	      er_printf("returning from gfx mode, but no gfx support!\n");
#endif
	    }
	  max_page=4;
	  screen_mode = LO(ax);
	  gfx_flag=0;  /* we're in a text mode now */
	  gfx_mode = TEXT;
	  /* mode change clears screen unless bit7 of AL set */
	  if (! (LO(ax) & 0x80)) clear_screen(c_screen,7);
	  NOCARRY;
	  break;
#ifdef EXPERIMENTAL_GFX
      case 0xd:
	  tmp = G320x200x16;
	  goto s_gfx;
      case 0xe:
	  tmp = G640x200x16;
	  goto s_gfx;
      case 0x10:
	  tmp = G640x350x16;
	  goto s_gfx;
      case 0x12:
	  tmp = G640x480x16;
	  goto s_gfx;
      case 0x13:
	  tmp = G320x200x256;
	  goto s_gfx;
s_gfx:	  
	if (vga && graphics)
	  {
	    v_printf("DOS setmode 0x%x\n", LO(ax));
	    screen_mode = LO(ax);
	    gfx_mode=tmp;
#ifdef SYNC_ALOT
	    fflush(stdout);
	    sync();
#endif	    
	    vga_setmode(gfx_mode);
	    /* vga_newscreen(); */
	    ioperm(0x3b0, 0x3db-0x3b0, 1);
	    gfx_flag=1;
	    NOCARRY;
	    v_printf("DOS setmode finished!\n");
	  }
	else
	  {
	    v_printf("non-VGA card...can't do gfx mode 0x%x\n", LO(ax));

	    CARRY;
	    return;
	  }
	break;
#endif  /* EXPERIMENTAL_GFX */
      default:
	v_printf("undefined video mode 0x%x\n",
		 LO(ax));
	CARRY;
	return;
      }

    /* put the mode in the BIOS Data Area */
    ignore_segv=1;
    *(unsigned char *)0x449=screen_mode;
    ignore_segv=0;
    break;

	case 0x1: /* define cursor shape */
		CARRY;
		break;
	case 0x2: /* set cursor pos */
		s = HI(bx);
		x = LO(dx);
		y = HI(dx);
/*		if (s != 0) {
			printf("video error 2\n");
			CARRY;
			return;
		} */
		if (x >= CO || y >= LI) break;
		xpos[s] = x;
		ypos[s] = y;
		if (s == c_screen) {
			poscur(x, y);
		}
		{	char *pp=(char *)(0x450+(s<<1));
			*(pp)=ypos[s];
			*(pp+1)=xpos[s];
		}
		break;
	case 0x3: /* get cursor pos */
		s = HI(bx);
#if	0
		if (s != 0) {
			printf("video error 3\n");
			CARRY; 
			_regs.edx = (ypos[s] << 8) | xpos[s];
			return;
		}
#endif	0
		_regs.edx = (ypos[s] << 8) | xpos[s];
		break;
	case 0x5: /* change page */
		printf("video:  change page from %d to %d\n", c_screen, LO(ax));
		if ((s = LO(ax)) == c_screen) break;
		if (s < 4) {
			c_screen = s;
			scrtest_bitmap = 1 << (24 + c_screen);
			vm86s.screen_bitmap = -1;
			return;
		}
		printf("video error: set wrong screen %d\n", s);
		show_regs();
		error = 1;
		return;
	case 0x6: /* scroll up */
/*		printf("s up %d %d %d %d %d %d\n",
		 LO(cx), HI(cx), LO(dx), HI(dx), LO(ax), HI(bx)); */
		scrollup(LO(cx), HI(cx), LO(dx), HI(dx), LO(ax), HI(bx));
		vm86s.screen_bitmap = -1;
		break;
	case 0x7: /* scroll down */
		scrolldn(LO(cx), HI(cx), LO(dx), HI(dx), LO(ax), HI(bx));
		vm86s.screen_bitmap = -1;
		break;
	case 0x8: /* get char */
		s = HI(bx);
		if(s<0||s>max_page) {
			CARRY;
			break;
		}
		sadr = SCREEN_ADR(s);
		_regs.eax = sadr[ypos[s]*CO + xpos[s]];
		break;
	case 0x9: /* set chars at cursor pos */
		x = *(us *)&_regs.ecx;
		c = LO(ax);
		s = HI(bx);
		for (i=0; i<x; i++) char_out_att(c,(char)LO(bx),s);
		break;
	case 0xA: /* set chars at cursor pos */
		x = *(us *)&_regs.ecx;
		c = LO(ax);
		s = HI(bx);
		X_busy=1;
		for (i=0; i < x; i++) char_out(c, s);
		X_busy=0;
		break;
	case 0xe: /* print char */
		X_busy=1;
		char_out(*(char *)&_regs.eax, c_screen);
		X_busy=0;
		break;
	case 0x0f: /* get screen mode */
		_regs.eax = (CO << 8) | screen_mode; /* chrs per line, mode 2 */
/*                 printf("get screen mode %x\n", c_screen); */
		_regs.ebx &= 0xff;
		_regs.ebx |= c_screen << 8;
		break;
	case 0xb: /* palette */
		if (HI(bx) == 0) {
			printf("set border color 0x%x\n", LO(bx));
			break;
		}
	case 0xc: /* set dot */
	case 0xd: /* get dot */
	case 0x4: /* get light pen */
		printf("video error\n");
		show_regs();
		error = 1;
		return;
  case 0x12:
#if	0
    printf("get video subsystem config ax=0x%04x bx=0x%04x\n",
	     _regs.eax, _regs.ebx);
#endif
    switch (LO(bx))
      {
      case 0x10:
	HI(bx)=VID_SUBSYS;
	/* this breaks qedit! (any but 0x10) */
	/* LO(bx)=3;  */
#if	0	
	printf("video subsystem 0x10 BX=0x%04x\n", _regs.ebx);
#endif
	_regs.ecx=0x0809;

	break;
      case 0x20:
	printf("select alternate printscreen\n");
	break;
      case 0x30:
	if (LO(ax) == 0) tmp=200;
	else if(LO(ax) == 1) tmp=350;
	else tmp=400;
	printf("select textmode scanlines: %d\n", tmp);
	LO(ax)=12;   /* ok */
	break;
      case 0x32:  /* enable/disable cpu access to cpu */
	if (LO(ax) == 0)
	  printf("disable cpu access to video!\n");
	else printf("enable cpu access to video!\n");
	break;
      default:
	printf("ERROR: unrecognized video subsys config!!\n");
	show_regs();
      }
	break;
  case 0x1a: /* get display combo */
    if (LO(ax) == 0)
      {
#if	0
        v_printf("get display combo!\n");
#endif
        LO(ax) = 0x1a;          /* valid function=0x1a */
        LO(bx) = VID_COMBO;     /* active display */
        HI(bx) = 0;             /* no inactive display */
      }
    else {
      v_printf("set display combo not supported\n");
    }
    break;
  case 0xfe: /* get shadow buffer..return unchanged */
  case 0xff: /* update shadow buffer...do nothing */
#if	0
	puts("fe ff");
#endif
    break;
  case 0x10: /* ega palette */
  case 0x11: /* ega character generator */
  case 0x4f: /* vesa interrupt */
  default:
        if (HI(ax) >= 0xf0 && HI(ax) <=0xfa ) {
		xmouse_int10();
		return;
        }
  	printf("unknown video int 0x%x\n", _regs.eax);
	CARRY;
	break;
  }
}

checkdp(struct disk *disk)
{
  if (disk == NULL) 
    {
      printf("DISK: null dp\n");
      return 1;
    }
  else if (disk->fdesc == -1) {
    printf("DISK: closed disk\n");
    return 1;
  }
  else return 0;
}

void int13(void)
{
	unsigned int disk, head, sect, track, number, pos, res;
	char *buffer;
	struct disk *dp;
	
	disk = LO(dx);
	if (disk < fdisks) {
		dp = &disktab[disk];
	} else if (disk >= 0x80 && disk < 0x80 + hdisks) 
		dp = &hdisktab[disk - 0x80];
	else dp = NULL;
	switch(HI(ax)) {
		case 0: /* init */
			d_printf("DISK init %d\n", disk);
			_regs.eax &= ~0xff;
			NOCARRY;
			break;
		case 1: /* read error code */	
			_regs.eax &= ~0xff;
			NOCARRY;
			d_printf("DISK error code\n");
			break;
		case 2: /* read */
			disk_open(dp);
			head = HI(dx);
			sect = (_regs.ecx & 0x3f) -1;
			track = (HI(cx)) |
				((_regs.ecx & 0xc0) << 2);
			buffer = SEG_ADR((char *), es, bx);
			number = LO(ax);
			/* d_printf("DISK %d read [h%d,s%d,t%d](%d)->0x%x\n", disk, head, sect, track, number, buffer); */
			if (checkdp(dp) || head >= dp->heads || 
			    sect >= dp->sectors || track >= dp->tracks) {
			    printf("ERROR: Sector not found 1!\n");
			    show_regs();
			    _regs.eax = 0x400; /* sector not found */
			    _regs.eflags |= CF;
			    disk_close();
			    break;
			}
			pos = ((track * dp->heads + head) * dp->sectors + sect) << 9;
			if (pos != lseek(dp->fdesc, pos, 0)) {
			    printf("ERROR: Sector not found 2!\n");
			    show_regs();
			    _regs.eax = 0x400; /* sector not found */
			    _regs.eflags |= CF;
			    break;
			}
			res = read(dp->fdesc, buffer, number << 9);
			if (res & 0x1ff != 0) { /* must read multiple of 512 bytes  and res != -1 */
			    printf("ERROR: sector_corrupt 1!\n");
			    show_regs();
			    _regs.eax = 0x200; /* sector corrrupt */
			    _regs.eflags |= CF;
			    break;
			}
			_regs.eax = res >> 9;
			_regs.eflags &= ~CF;
			R_printf("DISK read @%d (%d) OK.\n", pos, res >> 9); 
			break;
		case 3: /* write */
			disk_open(dp);
			head = HI(dx);
			sect = (_regs.ecx & 0x3f) -1;
			track = (HI(cx)) |
				((_regs.ecx & 0xc0) << 2);
			buffer = SEG_ADR((char *), es, bx);
			number = LO(ax);
			W_printf("DISK write [h%d,s%d,t%d](%d)->0x%x\n", head, sect, track, number, buffer); 
			if (checkdp(dp) || head >= dp->heads || 
			    sect >= dp->sectors || track >= dp->tracks) {
			    printf("ERROR: Sector not found 3!\n");
			    show_regs();
			    _regs.eax = 0x400; /* sector not found */
			    _regs.eflags |= CF;
			    break;
			}
			if (dp->rdonly) {
			    printf("ERROR: write protect!\n");
			    show_regs();
			    _regs.eax = 0x300; /* write protect */
			    _regs.eflags |= CF;
			    break;
			}
			pos = ((track * dp->heads + head) * dp->sectors + sect) << 9;
			if (pos != lseek(dp->fdesc, pos, 0)) {
			    printf("ERROR: Sector not found 4!\n");
			    show_regs();
			    _regs.eax = 0x400; /* sector not found */
			    _regs.eflags |= CF;
			    break;
			}
			res = write(dp->fdesc, buffer, number << 9);
			if (res & 0x1ff != 0) { /* must read multiple of 512 bytes  and res != -1 */
			    printf("ERROR: Sector corrupt 2!\n");
			    show_regs();
			    _regs.eax = 0x200; /* sector corrrupt */
			    _regs.eflags |= CF;
			    break;
			}
			_regs.eax = res >> 9;
			_regs.eflags &= ~CF;
			W_printf("DISK write @%d (%d) OK.\n", pos, res >> 9); 
			break;
		case 4: /* test */
			disk_open(dp);
			head = HI(dx);
			sect = (_regs.ecx & 0x3f) -1;
			track = (HI(cx)) |
				((_regs.ecx & 0xc0) << 2);
			number = LO(ax);
			d_printf("DISK %d test [h%d,s%d,t%d](%d)\n", disk, head, sect, track, number);
			if (checkdp(dp) || head >= dp->heads || 
			    sect >= dp->sectors || track >= dp->tracks) {
			    _regs.eax = 0x400; /* sector not found */
			    _regs.eflags |= CF;
			    printf("ERROR: test: sector not found 5\n");
			    dbug_printf("hds: %d, sec: %d, tks: %d\n",
					dp->heads, dp->sectors, dp->tracks);
			    break;
			}
			pos = ((track * dp->heads + head) * dp->sectors + sect) << 9;
			if (pos != lseek(dp->fdesc, pos, 0)) {
			    _regs.eax = 0x400; /* sector not found */
			    _regs.eflags |= CF;
			    printf("ERROR: test: sector not found 6\n");
			    break;
			}
			_regs.eax = res >> 9;
			_regs.eflags &= ~CF;
			break;
		case 8: /* get disk drive parameters */
			d_printf("disk get parameters %d\n", disk); 

			if (dp != NULL) {
			  /* get CMOS type */
			  /* LO(bx) = 3; */
			  switch(dp->tracks)
			    {
			    case 9:
			      LO(bx)=3;
			      break;
			    case 15:
			      LO(bx)=2;
			      break;
			    case 18:
			      LO(bx)=4;
			      break;
			    case 0:
			      LO(bx)=dp->default_cmos;
			      dp->tracks=80;
			      dp->heads=2;
			      if (LO(bx) == 4)
				dp->sectors=18;
			      else dp->sectors=15;
			      d_printf("auto type defaulted to CMOS %d, sectors: %d\n", LO(bx), dp->sectors);
			      break;
			    default:
			      LO(bx)=4;
			      d_printf("type det. failed. num_tracks is: %d\n", dp->tracks);
			      break;
			    }

			  /* these numbers are "zero based" */
			  HI(dx) = dp->heads - 1; 
			  HI(cx) = (dp->tracks - 1) & 0xff;

			  LO(dx) = (disk < 0x80) ? fdisks : hdisks;
			  LO(cx) = dp->sectors | ((dp->tracks & 0x300) >> 2);
			  LO(ax) = 0;
			  /* show_regs(); */
			  _regs.eflags &= ~CF; /* no error */
			} else {
			  _regs.edx = 0; /* no hard disks */
			  _regs.ecx = 0;
			  LO(bx) = 0;
			  LO(ax) = 1; /* bad command */
			  _regs.eflags |= CF; /* error */
			}	
			break;
			
/* beginning of Adam's additions */
		case 0x9:	/* initialise drive from bpb */
			CARRY;
			break;
		case 0x0A:	/* We dont have access to ECC info */
		case 0x0B:
			CARRY;
			_regs.eax&=0xFF;
			_regs.eax|=0x0100;	/* unsupported opn. */
			break;
		case 0x0C:	/* explicit seek heads. - bit hard */
			CARRY;
			_regs.eax&=0xFF;
			_regs.eax|=0x0100;
			break;
		case 0x0D:	/* Drive reset (hd only) */
			NOCARRY;
			_regs.eax&=0xFF;
			break;
		case 0x0E:	/* XT only funcs */
		case 0x0F:
			CARRY;
			_regs.eax&=0xFF;
			_regs.eax|=0x0100;
			break;
		case 0x10:	/* Test drive is ok */
		case 0x11:	/* Recalibrate */
			disk=LO(dx);
			if(disk<0x80||disk>=0x80+hdisks)
			{
				_regs.eax&=0xFF;
				_regs.eax|=0x2000;	/* Controller didnt respond */
				CARRY;
				break;
			}
			_regs.eax&=0xFF;
			NOCARRY;
			break;
		case 0x12:	/* XT diagnostics */
		case 0x13:
			_regs.eax&=0xFF;
			CARRY;
			break;
		case 0x14:	/* AT diagnostics. Unix keeps the drive happy
					so report ok if it valid */
			_regs.eax&=0xFF;
			NOCARRY;
			break;
/* end of Adam's additions */


                case 0x15: /* Get type */
			d_printf("disk gettype %d\n", disk); 
			if (dp != NULL && disk >= 0x80) {
			  if (dp->removeable) {
			    HI(ax) = 1; /* floppy disk, no change detect */
			    d_printf("disk gettype: floppy\n");
			    _regs.edx = 0; 
			    _regs.ecx = 0; 
			  } else {
			    d_printf("disk gettype: hard disk\n");
			    HI(ax) = 3; /* fixed disk */
			    number = dp->tracks * dp->sectors * dp->heads;
			    _regs.ecx = number >> 16;
			    _regs.edx = number & 0xffff;
			  }
			  _regs.eflags &= ~CF; /* no error */
			} else {
			  if (dp != NULL)
			    {
			      d_printf("gettype on floppy %d\n", disk);
			      HI(ax) = 1;  /* floppy, no change detect=1 */
			      NOCARRY;
			    }
			  else
			    {
			      printf("ERROR: gettype: no disk %d\n", disk);
			      HI(ax) = 0; /* disk not there */
			      _regs.eflags |= CF; /* error */
			    }
			}
			break;

/* beg of Adam's 1st mods */
		case 0x16: 
			/* get disk change status - hard - by claiming
			our disks dont have a changed line we are kind of ok */
			warn("int13: CHECK DISKCHANGE LINE\n");
			disk=LO(dx);
			if(disk<0||disk>=fdisks )
			{
			  d_printf("int13: DISK CHANGED\n");
			  CARRY;
			  /* _regs.eax&=0xFF;
			     _regs.eax|=0x200; */
			  HI(ax)=1;  /* change occurred */
			}
			else {
			  NOCARRY;
			  HI(ax) = 00;  /* clear AH */
			  d_printf("int13: NO CHANGE\n");
			}
			break;
		case 0x17:
			/* set disk type: should do all the ioctls etc
			   but I'm not feeling that brave yet */
			/* al=type dl=drive */
			CARRY;
			break;
/* end of Adam's 2nd mods */

		case 0x18: /* Set media type for format */
			track = HI(cx) + ((LO(cx) & 0xc0) << 2);
			sect = LO(cx) & 0x3f;
			d_printf("disk: set media type %x, %d sectors, %d tracks\n", disk, sect, track);
			HI(ax) = 1; /* function not avilable */
			break;
		case 0x20: /* ??? */
			d_printf("weird int13, ah=0x%x\n", _regs.eax);
			break;
	        case 0x28: /* DRDOS 6.0 call ??? */
			d_printf("int 13h, ax=%04x...DRDOS call\n",_regs.eax);
			break;
		case 0x5:  /* format */
			NOCARRY;  /* successful */
			HI(ax)=0; /* no error */
			break;
		default:
			printf("ERROR: disk IO error: int13, ax=0x%x\n",
				    _regs.eax);
			show_regs();
			error = 5;
			return;
	}
}

void int14(void)
{
	int num;

	switch(HI(ax)) {
		case 0: /* init */
			_regs.eax = 0;
			num = _regs.edx & 0xffff;
			uarts[LO(dx)].fd=0;		/* no files yet */
			uarts[LO(dx)].IIR = 1;  /* no FIFO, no interrupt */
			uarts[LO(dx)].IER = 3;  /* int on data,  THRE */
			uarts[LO(dx)].LSR = 0x60;  /* TSHE&TSRE, no data*/
			uarts[LO(dx)].MSR = 0xb0;  /* DSR, CTS, CD */
			s_printf("init serial %d\n", num);
			break;
 	        case 1: /* write char */
			/* dbug_printf("send serial char '%c' com%d (0x%x)\n",
			   LO(ax), LO(dx)+1, LO(ax)); */
			if (LO(dx) > 3) LO(dx)=3;
			HI(ax) = serial_write(LO(dx), LO(ax));
			break;
 	        case 2: /* read char */
			if (LO(dx) > 3) LO(dx)=3;
			_regs.eax = serial_read(LO(dx));
			if (HI(ax) & 1)   /* data ready */
			  {
			    /* dbug_printf("recv serial char com%d '%c' (0x%x)\n",
				   LO(dx)+1, LO(ax), LO(ax)); */
			    HI(ax) &= 0x7f;   /* clear timeout bit */
			  }
			else
			  {
			    HI(ax) |= 0x80;   /* set timeout bit */
			    s_printf("failed serial read !!\n");
			  }
			break;
 	        case 3: /* port status */

			if (LO(dx) > 3) LO(dx) = 3;
			HI(ax) = 0x60;
			LO(ax) = 0xb0;   /* CD, DSR, CTS */
			if ( d_ready(uarts[LO(dx)].fd) )
			  {
			    HI(ax) |= 1; /* receiver data ready */
			    /* dbug_printf("BIOS serial port status com%d = 0x%x\n",
				   LO(dx), _regs.eax); */
			  }
			break;
	        case 4: /* extended initialize */
			s_printf("extended serial initialize\n");
			return;
		default:
			printf("ERROR: serial error\n");
			show_regs();
			error = 5;
			return;
	}
}

void int15(void)
{
  static int extcount=0;
  struct timeval wait_time;
  int num;
  NOCARRY;

#define MAX_EXT_COUNT 10

  switch(HI(ax)) {
  case 0x41: /* wait on external event */
    extcount++;
    if (extcount >= MAX_EXT_COUNT) return;
/*    if (d.general) */
#if	0
      {
	g_printf("wait on external event\n");
	show_regs();
      }
#endif	0
    break;
  case 0x4f:   /* Keyboard intercept */
    HI(ax) = 0x86;
    NOCARRY;  /* original scancode (no translation) */
    break;
  case 0x80:	/* default BIOS device open event */
    _regs.eax&=0x00FF;
    return;
  case 0x81:
    _regs.eax&=0x00FF;
    return;
  case 0x82:
    _regs.eax&=0x00FF;
    return;
  case 0x83:
    h_printf("int 15h event wait:\n");
    show_regs();
    CARRY;
    return;	/* no event wait */
  case 0x84:
    CARRY;
    return;	/* no joystick */
  case 0x85:
    num=_regs.eax&0xFF;	/* default bios handler for sysreq key */
    if(num==0||num==1)
      {
	_regs.eax&=0x00FF;
	return;
      }
    _regs.eax&=0xFF00;
    _regs.eax|=1;
    CARRY;
    return;
  case 0x86:
    /* wait...cx:dx=time in usecs */
    g_printf("doing int15 wait...ah=0x86\n");
    show_regs();
    wait_time.tv_sec = 0;
    wait_time.tv_usec = ((_regs.ecx&0xffff) << 16) | (_regs.edx&0xffff);
    select(STDIN_FILENO, NULL, NULL, NULL, &scr_tv);
    NOCARRY;
    return;

  case 0x87:
#ifdef XMS
    if (xms) xms_int15();
    else
#endif
      {
	_regs.eax&=0xFF;
	_regs.eax|=0x0300;	/* say A20 gate failed - a lie but enough */
	CARRY;
      }
    return;

  case 0x88:
#ifdef XMS
    if (xms) xms_int15();
    else
#endif
    {
      _regs.eax &= ~0xffff;   /* we don't have extended ram if it's not XMS */
      NOCARRY;
    }
    return;

  case 0x89:			/* enter protected mode : kind of tricky! */
    _regs.eax|=0xFF00;	/* failed */
    CARRY;
    return;
  case 0x90:			/* no device post/wait stuff */
    CARRY;
    return;
  case 0x91:
    CARRY;
    return;
  case 0xc0:
    g_printf("-- get sys config param\n");
    _regs.es=0xd000;
    _regs.ebx=0x0000;	/* bios data area - see emulate.. */
    return;
  case 0xc1:
    CARRY;
    return;			/* no ebios area */
  case 0xc2:
    _regs.eax&=0x00FF;
    _regs.eax|=0x0300;	/* interface error if use a ps2 mouse */
    CARRY;
    return;
  case 0xc3:
    /* no watchdog */
    CARRY;
    return;
  case 0xc4:
    /* no post */
    CARRY;
    return;
  default:
/*
    g_printf("int 15h error: ax=0x%04x\n", _regs.eax&0xffff);
*/
    CARRY;
    return;
  }
}

extern short kbd_read();
extern int kbd_pressed();
extern int get_kbd_state();
extern int by_int16;

void int16(void)
{
	int key;
	extern int ret_imm;

	ret_imm=0;
	switch(HI(ax)) {
		case 0: /* read key code, wait */
#if	1
			if (special_nowait) {
				if (kbd_read_nowait(&_regs.eax)) {
					_regs.eflags &= ~(ZF | CF);
				} else {
					_regs.eax=0;
					_regs.eflags |= ZF | CF;
				}
				return;
			}
#endif
			by_int16=1;
			key = kbd_read();
			if (!ret_imm) _regs.eax=key; 
#if	0
			if (secalrm) setitimer(ITIMER_REAL, &itv, NULL); */
#endif
			/* speed up response time */
			return;
		case 1: /* test key code */
/*			puts("test key"); */
			by_int16=1;
			if (kbd_pressed(&key)) {
				_regs.eflags &= ~(ZF | CF); /* key pressed */
				_regs.eax = key;
#if	0
				if(secalrm) setitimer(ITIMER_REAL, &itv, NULL);  
#endif
			} else {
				_regs.eflags |= ZF | CF; /* no key */
			}
			return;
		case 2: /* read key state */
			key=get_kbd_state();
/*			puts("key state"); */
			_regs.eax=(_regs.eax & 0xffffff00) | key;
			break;
		case 0x55: /* MS word coop w/TSR? */
#if	1
			_regs.eax=0x4d53; /* say keyboard already handled */
			special_nowait ^= 1;
#else
	/*		_regs.eax=0x4300| (_regs.eax&0xff); */
#endif
			printf("int16h x55 -> ax:%x\n",_regs.eax);
                        return;
		default:
			printf("int16h %d\n", HI(ax));
/*			show_regs(); */
			CARRY;
/*			error = 7; */
			return;
	}
}

int printer_print(int prnum, char outchar)
{
  if (lpt[prnum] == NULL) lpt[prnum] = fopen(prtnames[prnum], "a");
  fputc(outchar, lpt[prnum]);

  return(0xd0);   /* not busy, selected, ACK */
}

void int17(void)
{
	int num;

	switch(HI(ax)) {
	        case 0: /* write char */
	                printf("print character on lpt%d : %c (%d)\n",
			       LO(dx), LO(ax), LO(ax)); 
			HI(ax) = printer_print(LO(dx), LO(ax));
			/* HI(ax) = 0xd0;  not busy, ACK, selected */
			break;
		case 1: /* init */
			HI(ax) = 0;
			num = _regs.edx & 0xffff;
			printf("init printer %d\n", num);
			break;
		case 2: /* get status */
			HI(ax) = 0xd0;    /* not busy, ack, selected */
			/* dbug_printf("printer 0x%x status: 0x%x\n", LO(dx), HI(ax)); */
			break;
		default:
			printf("printer error: int 17h, ax=0x%x\n", _regs.eax);
			show_regs();
			error = 8;
			return;
	}
}


void int1a(void)
{
	int num;
	unsigned long ticks;
	long akt_time, elapsed;
	struct timeval tp;
	struct timezone tzp;
	struct tm *tm;


	switch(HI(ax)) {
		case 0: /* read time counter */
			time(&akt_time);
			elapsed = akt_time - start_time;
			ticks = (elapsed *182) / 10 + last_ticks;
			_regs.eax &= ~0xff; /* 0 hours */
			_regs.ecx = ticks >> 16;
			_regs.edx = ticks & 0xffff;
			/* dbug_printf("read timer st: %ud %ud t=%d\n",
				    start_time, ticks, akt_time); */
			break;
		case 1: /* write time counter */
			last_ticks = (_regs.ecx << 16) | (_regs.edx & 0xffff);
			set_ticks(last_ticks);
			time(&start_time);
			g_printf("set timer to %ud \n", last_ticks);
			break;
		case 2: /* get time */
			gettimeofday(&tp, &tzp);
			ticks = tp.tv_sec - (tzp.tz_minuteswest*60);
			tm = localtime((time_t *)&ticks);
        		/* g_printf("get time %d:%02d:%02d\n", tm->tm_hour, tm->tm_min, tm->tm_sec); */
			HI(cx) = tm->tm_hour % 10;
			tm->tm_hour /= 10;
			HI(cx) |= tm->tm_hour << 4;
			LO(cx) = tm->tm_min % 10;
			tm->tm_min /= 10;
			LO(cx) |= tm->tm_min << 4;
			HI(dx) = tm->tm_sec % 10;
			tm->tm_sec /= 10;
			HI(dx) |= tm->tm_sec << 4;
			/* LO(dx) = tm->tm_isdst; */
			_regs.eflags &= ~CF;
			break;
		case 4: /* get date */
			gettimeofday(&tp, &tzp);
			ticks = tp.tv_sec - (tzp.tz_minuteswest*60);
			tm = localtime((time_t *)&ticks);
			tm->tm_year += 1900;
			tm->tm_mon ++;
        		/* g_printf("get date %d.%d.%d\n", tm->tm_mday, tm->tm_mon, tm->tm_year); */
			_regs.ecx = tm->tm_year % 10;
			tm->tm_year /= 10;
			_regs.ecx |= (tm->tm_year % 10) << 4;
			tm->tm_year /= 10;
			_regs.ecx |= (tm->tm_year % 10) << 8;
			tm->tm_year /= 10;
			_regs.ecx |= (tm->tm_year) << 12;
			LO(dx) = tm->tm_mday % 10;
			tm->tm_mday /= 10;
			LO(dx) |= tm->tm_mday << 4;
			HI(dx) = tm->tm_mon % 10;
			tm->tm_mon /= 10;
			HI(dx) |= tm->tm_mon << 4;
			_regs.eflags &= ~CF;
			break;
		case 3: /* set time */
		case 5: /* set date */
			printf("ERROR: timer: can't set time/date\n");
			break;
		default:
			printf("ERROR: timer error AX=0x%04x\n", _regs.eax);
			/* show_regs(); */
			/* error = 9; */
			return;
	}
}

void dos_ctrlc(void)
{
  k_printf("DOS ctrl-c!\n");
/*  p_dos_str("^C\n\r");    print DOS's ctrl-c message */
  keybuf_clear();
  if (_regs.eflags & IF) do_int(0x23);
  else warn("CAN'T DO INT 0x23: IF CLEAR\n");
}


int ms_dos(int nr) /* returns 1 if emulated, 0 if internal handling */
{
	char *csp, *p; 
	int c;
	static int nextcode=0;

Restart:
	/* printf("DOSINT 0x%x\n", nr); */
	/* emulate keyboard io to avoid DOS' busy wait */
	switch(nr) {
#if	0
	case 7: /* read char, do not check <ctrl> C */
	case 1: /* read and echo char */
	case 8: /* read char */
	  /* k_printf("KBD/DOS: int 21h ah=%d\n", nr); */
	  disk_close();   /* DISK */
	  if (nextcode)
	    {
	      _regs.eax = nextcode;
	      nextcode = 0;
	    }
	  else {
	       c=kbd_read();
	      _regs.eax = c & 0xff;  /* mask out scan code */
	      if (_regs.eax == 0)    /* extended scan code */
		nextcode = c >> 8; /* get scan code */
	    }
	  if ((nr == 1) && (_regs.eax != 0)) 
	    char_out(_regs.eax, c_screen);
	  /* ctrl-C checking */
	  if ((_regs.eax == 3) && (nr != 7))
	    dos_ctrlc();
	  NOCARRY;
	  break;
#endif	0
	case 12: /* clear key buffer, do int AL */
		keybuf_clear();
		nr = LO(ax);
		if (nr == 0) break; /* thanx to R Michael McMahon for the hint */
		HI(ax) = LO(ax);
		NOCARRY;
		goto Restart;
	default:
		/* printf(" dos interrupt 0x%x \n", nr); */
		return 0;
	}
	return 1;
}

int kbd_fd=0;
int int28(void)		 /* keyboard busy loop */
{
	fd_set fds;

	return 0;
}


/* frun */
run_int(int i)
{
  us *first, *ssp;

  first = SP_ADR;
  ssp =SEG_ADR((us *), ss, sp);
/*
  if (first!=ssp) {
	printf("diff %x %x %x %x --\n", first , ssp, _regs.ss, _regs.esp);
  }
*/
  *(--ssp) = _regs.eflags;
  *(--ssp) = _regs.cs;
  *(--ssp) = _regs.eip;
  if (_regs.esp > 0xffff) {
	puts("fat: run_int");
  }
  _regs.esp -= 6;
  _regs.cs =  ((us *)0)[ (i<<1) +1];
  _regs.eip = ((us *)0)[  i<<1	];
/*  _regs.eflags &= ~IF; */
  _regs.eflags &= 0xfffffcff;
}

is_iret(int i)
{
  /* return 1 if points to iret */
  unsigned char *byte=(unsigned char *)(ISEG(i)*16 + IOFF(i));

  if (*byte == 0xcf) 
    return 1;
  else 
    return 0;
}

can_revector (int i)
{
/* here's sort of a guideline:
 * if we emulate it completely, but there is a good reason to stick
 * something in front of it, and it seems to work, by all means revector it.
 * if we emulate none of it, say yes, as that is a little bit faster.
 * if we emulate it, but things don't seem to work when it's revectored,
 * (like int15h and LINUX.EXE), then don't let it be revectored.
 *
 */

  switch(i)
    {
      /* some things, like 0x29, need to be unrevectored if the vectors
       * are the DOS vectors...but revectored otherwise
       */
    case 0x21: /* we want it first...then we'll pass it on */
    case 0x2a: 
    case 0x15: /* need this for LINUX.EXE...why??  */
    case 0x29: /* DOS fast char output... */
#ifdef XMS
    case 0x2f:
#endif
      return 0;


    case 0x28: /* keyboard busy loop */
               /* keep int28h revectorable so that things go fast */
    case 0: 
    case 1:
    case 2:
    case 3:
    case 4:
    case 0x25: /* absolute disk read, calls int 13h */
    case 0x26: /* absolute disk write, calls int 13h */
    case 0x1b: /* ctrl-break handler */
    case 0x1c: /* user timer tick */
    case 0x17: /* BIOS printer */
    case 0x10: /* BIOS video */
    case 0x16: /* BIOS keyboard */
    case 0x13: /* BIOS disk */
    case 0x27: /* TSR */
#ifndef XMS
    case 0x2f: /* multiplex */
#endif
    case 0x20: /* exit program */
    case 0x33: /* mouse */
      /* if (i == 0x16) k_printf("SHOCK! revectoring int 0x%02x\n", i); */
      return 1;
    default:
      g_printf("revectoring 0x%02x\n", i);
      return 1;
    }
}


dos_helper()
{
  switch (LO(ax)) 
    {
    case 0x20:
      mfs_inte5();
      return 1;
      break;

    case 0xff:
      if (LWORD(eax) == 0xffff)
	leavedos();
      break;
    default:
	printf("Undefined call");
	show_regs();
    }
}

extern void x_mouse();

/*fdo_int */
void do_int(int i)
{
  us *ssp;
  int highint=0;

  in_interrupt++;

#if	0
  if ((_regs.cs&0xffff) == 0xe000)
    highint=1;
  else
    if ((ISEG(i) != 0xe000) && can_revector(i)  && !is_iret(i)
	&& (_regs.eflags & VM) )
      {
	run_int(i);
	return;
      }
#endif

  switch(i) {
      case 0x5   :
	g_printf("BOUNDS exception\n");
	goto default_handling;
      case 0x08  :
/*	puts("-8"); */
#if	1
	if ((_regs.cs&0xffff)==0xe000) {   /* reduce iret */
		us *ssp;

		ssp =  SP_ADR ;
		_regs.eip = *(ssp++);
		_regs.cs = *(ssp++);
		_regs.eflags = (_regs.eflags & 0xffff0000) | *(ssp++);
		_regs.esp += 6;
	} else puts("int 8 ????");
#endif	0
	return;
      case 0x09:
#if	1
	if ((_regs.cs&0xffff)==0xe000) {
		us *ssp;

		ssp = SP_ADR ;
		_regs.eip = *(ssp++);
		_regs.cs = *(ssp++);
		_regs.eflags = (_regs.eflags & 0xffff0000) | *(ssp++);
		_regs.esp += 6;
	} else puts("int 9 ????");
#endif	0
/*	puts("-9"); */
	return;	
      case 0x0a  :
      case 0x0b  : /* com2 interrupt */
      case 0x0c  : /* com1 interrupt */
      case 0x0d  :
      case 0x0e  :
      case 0x0f  :
	g_printf("IRQ->interrupt %x\n", i);
	goto default_handling;
	return;
      case 0x10 : /* VIDEO */
	int10();
	return;
      case 0x11 : /* CONFIGURATION */
	_regs.eax = CONFIGURATION;
	if (fdisks > 0) _regs.eax |= 1 | ((fdisks -1)<<6);
	return;
      case 0x12 : /* MEMORY */
	_regs.eax = MEM_SIZE;
	g_printf("memory tested: %dK\n", MEM_SIZE);
	return;
      case 0x13 : /* DISK IO */
	int13();
	return;
      case 0x14 : /* COM IO */
	int14();
	return;
      case 0x15 : /* Cassette */
	int15();
	return;
      case 0x16 : /* KEYBOARD */
	int16();
	return;
      case 0x17 : /* PRINTER */
	int17();
	return;
      case 0x18 : /* BASIC */
	break;
      case 0x19 : /* LOAD SYSTEM */
	boot(boot_disk);
	return;
      case 0x1a : /* CLOCK */
	int1a();
	return;
      case 0x1b : /* BREAK */
		puts("int 1b");
		return;
      case 0x1c : /* TIMER */
		puts("int 1c");
		return;
#if 0
      case 0x1d : /* SCREEN INIT */
      case 0x1e : /* DEF DISK PARMS */
      case 0x1f : /* DEF GRAPHIC */
      case 0x20 : /* EXIT */
      case 0x27 : /* TSR */
#endif
      case 0x21 : /* MS-DOS */
	if (ms_dos(HI(ax))) return;
	/* else do default handling in vm86 mode */
	goto default_handling;
	
      case 0x28 : /* KEYBOARD BUSY LOOP */
#if	0
	goto default_handling;
#else
	if (wait_Xevent()) { 
		by_int16=0; xevents();
	}
	goto default_handling; 
#endif
      case 0x29 : /* FAST CONSOLE OUTPUT */
	char_out(*(char *)&_regs.eax, c_screen);    /* char in AL */
	return;

      case 0x2a : /* CRITICAL SECTION */
	goto default_handling;

      case 0x2f : /* Multiplex */
	if ( LWORD(eax) == 0x1680) {
		usleep(80000);
		return;
	}
	if (HI(ax) == 0x11 && mfs_redirector())
		return;
#ifdef XMS

	if ((HI(ax) == XMS_MAGIC) && xms) {
	  switch(LO(ax))
	    {
	    case 0:  /* check for XMS */
	      x_printf("Check for XMS\n");
	      LO(ax)=0x80;
	      break;
	    case 0x10:
	      x_printf("Get XMSControl address\n");
	      _regs.es = XMSControl_SEG;
	      _regs.ebx &= ~0xffff;
	      _regs.ebx |= XMSControl_OFF;
	      break;
	    default:
	      x_printf("BAD int 0x2f XMS function\n");
	    }
	  in_interrupt--;
	  return;
	}
	else 
#endif
        goto default_handling;
      case 0x33:
	x_mouse();
	return;

      case 0xe5: /* dos helper and mfs startup (was 0xfe) */
        (void)dos_helper();

      default :
#if	0
/*	if (d.defint) */
	  dbug_printf("int 0x%x, ax=0x%x\n", i, _regs.eax);
	  /* fall through */
#endif	0
      default_handling:

	if (highint)
	  {
	    g_printf("default handling for highint: 0x%2x!\n", i);
	    in_interrupt--;
	    return;
	  }

	if (ISEG(i) == 0xe000) 
	  {
	    g_printf("DEFIVEC: int 0x%x  SG: 0x%04x  OF: 0x%04x\n",
			i, ISEG(i), IOFF(i));
	    in_interrupt--;
	    return;
	  }
 	if (is_iret(i))
	  {
	    if ((i != 0x2a) && (i != 0x28))
	      g_printf("just an iret 0x%02x\n", i);
	    in_interrupt--;
	    return; 
	  }
	ssp = SEG_ADR((us *), ss, sp);
	*--ssp = _regs.eflags;
	*--ssp = _regs.cs;
	*--ssp = _regs.eip;
	_regs.esp -= 6;
	_regs.cs =  ((us *)0)[ (i<<1) +1];
	_regs.eip = ((us *)0)[  i<<1    ];
	if ((_regs.eip == 0) && (_regs.cs == 0) /* && d.warning */ )
	  {
	    warn("NULL interrupt 0x%x handler\n",i);
	    show_regs();
	  }
	_regs.eflags &= 0xfffffcff;
	return;
  }
  er_printf("\nERROR: int 0x%x not implemented\n", i);
  show_regs();
  error = 1;
  return;
}


void sigalrm(int sig)
{
	static inalrm=0;
	int didkbd=0;
	int jj;

	if (inalrm) {
		printf("ERROR: Reentering SIGALRM!\n");
		setitimer(ITIMER_REAL, &itv, NULL);
		return;
	}
	inalrm=1;
	if ( !X_busy && (vm86s.screen_bitmap & scrtest_bitmap) ) {
		vm86s.screen_bitmap=0;
		restore_screen();
	}

	if (_regs.eflags & IF) timer_tick();
	by_int16=0;
#if	0
	secalrm=1;
#endif
	if (!in_signal && (_regs.eflags & IF) && (_regs.eflags & VM) ) {
	    if (*((us *)0x26) < 0xa000 && kbd_press_rel()) {
		run_int(9);
		int9_cq=int9_fq;
/*		printf("key %x\n", int9_key[int9_cq]); */
#if	1
		int9_fq++;
#endif
		if (int9_fq==int9_eq) int9_eq=int9_fq=0;
#if	0
		secalrm=0;
#endif
	    }
	    if (*((us *)0x22)< 0xa000)
			run_int(8);
	    if ((*((us *)0x70)< 0xa000))
			run_int(0x1c);
	}
#if	0
	if (secalrm)
	  setitimer(ITIMER_REAL, &secitv, NULL);
	else
#endif
	  setitimer(ITIMER_REAL, &itv, NULL);
	inalrm=0;
}

void sigsegv(int sig)
{
	short d;
	unsigned long a;
	us *ssp;
	unsigned char *csp,*lina;
	static int haltcount=0;

#define MAX_HALT_COUNT 1
/*  
  if (ignore_segv)
    {
      g_printf("sigsegv ignored!\n");
      return;
    } */

    if (in_signal) {
	printf("?? double signal %x", in_signal);
	return;
    }
    ENT_SEGV;
    lina=(unsigned char *)
	(  ( (_regs.cs<<4) + _regs.eip) & 0xfffff );

  if (! (_regs.eflags & VM)) /* test VM bit */
    {
/*      er_printf("ERROR: NON-VM86 general protection!\n"); */
	LEA_SEGV;
	return;
    }
	if (_regs.eflags & TF) {
		printf("SIGSEGV %d received\n", sig);
		show_regs(); 
	}
	csp = SEG_ADR((unsigned char *), cs, ip);
	switch (*csp) {
		case 0x62: /* bound */
			_regs.eip += 4;
			break;
  case 0x6c: /* insb */
  case 0x6d: /* insw */
  case 0x6e: /* outsb */
  case 0x6f: /* outsw */
    er_printf("ERROR: IN/OUT SB/SW: 0x%02x\n",*csp);
    _regs.eip++;
    break;
  case 0xcb: /* ret far */
    er_printf("FAR RET SIGSEGV???\n");
    show_regs();
    ssp = SEG_ADR((us *), ss, sp);
    _regs.eip = *ssp++;
    _regs.cs = *ssp++;
    break;
	case 0xcd: /* int xx */
		_regs.eip += 2;
		do_int((int)*(++csp));
		LEA_SEGV;
		return;
	case 0xcc: /* int 3 */
		_regs.eip += 1;
		run_int(3); /***/
		break;
	case 0xcf: /* iret */
		ssp = SP_ADR ;
		_regs.eip = *(ssp++);
		_regs.cs = *(ssp++);
		_regs.eflags = (_regs.eflags & 0xffff0000) | *(ssp++);
		_regs.esp += 6;
/*		printf("%x:%x\n", _regs.ss, _regs.esp); */
		LEA_SEGV;
		return;
  case 0xe5: /* inw xx */
    _regs.eax &= ~0xff00;
    _regs.eax |= inb((int)csp[1] +1) << 8;
  case 0xe4: /* inb xx */
    _regs.eax &= ~0xff;
    _regs.eax |= inb((int)csp[1]);
    _regs.eip += 2;
    break;
  case 0xed: /* inw dx */
    _regs.eax &= ~0xff00;
    _regs.eax |= inb(_regs.edx +1) << 8;
  case 0xec: /* inb dx */
    _regs.eax &= ~0xff;
    _regs.eax |= inb(_regs.edx);
    _regs.eip += 1;
    break;
  case 0xe7: /* outw xx */
    outb((int)csp[1] +1, HI(ax));
  case 0xe6: /* outb xx */
    outb((int)csp[1], LO(ax));
    _regs.eip += 2;
    break;
  case 0xef: /* outw dx */
    outb(_regs.edx +1, HI(ax));
  case 0xee: /* outb dx */
    outb(_regs.edx, LO(ax));
    _regs.eip += 1;
    break;
	case 0xfa: /* cli */
		_regs.eflags &= (~IF);
		iflag = 0;
		_regs.eip++;
		break;
	case 0xfb: /* sti */
		_regs.eflags |= IF;
		iflag = 1;
		_regs.eip++;
		break;
	case 0x9c: /* pushf */
/*		if (iflag) _regs.eflags |= IF;
		else _regs.eflags &= ~IF; */
		ssp = SEG_ADR((us *), ss, sp);
		*--ssp = (us)_regs.eflags;
		_regs.esp -= 2;
		_regs.eip++;
		break;
	case 0x9d: /* popf */
		ssp = SEG_ADR((us *), ss, sp);
		_regs.eflags &= ~0xffff;
		_regs.eflags |= (int)*ssp;
		_regs.esp += 2;
		_regs.eip++;
		break;
  case 0xf4: /* hlt...I use it for various things, 
		like trapping direct jumps into the XMS function */
    if ((_regs.cs & 0xffff) == 0xf000) /* jump into BIOS */
      {
	er_printf("jump into BIOS...simulating IRET\n");
	/* simulate IRET */
	ssp = SEG_ADR((us *), ss, sp);
	_regs.eip = *ssp++;
	_regs.cs = *ssp++;
	_regs.eflags = (_regs.eflags & 0xffff0000) | *ssp++;
	_regs.esp += 6;
	LEA_SEGV;
	in_interrupt--;
	return;
    } else if (lina == (unsigned char *)0xffff0) {
        er_printf("Jump to BIOS exit routine, flag: 0x%04x\n",
	      *(unsigned short int *)0x472);
	leavedos(1);
#ifdef XMS
    } else if (lina == (unsigned char *)XMSTrap_ADD) {
        _regs.eip+=2;  /* skip halt and info byte to point to FAR RET */
	xms_control();
	LEA_SEGV;
	return;
#endif
    } else {
        er_printf("HLT requested: lina=0x%06x!\n", lina);
        show_regs();
	haltcount++;
	if (haltcount > MAX_HALT_COUNT) error=0xf4;
	_regs.eip += 1;
      }
    break;
		case 0xf0: /* lock */
			_regs.eip++;
			break;
		default:
			printf("%x:%x ? %x %x %x %x\n",
				 _regs.cs, _regs.eip, *csp, *(csp+1),
				 *(csp+2), *(csp+3));
/*			show_regs(); */
/*			_regs.eip++; */
                        break;
	}
	if (_regs.eflags & TF) {
/*		printf("emulation done");
		show_regs();  */
		_regs.eflags &=~TF;
		puts("TF");
	}
	LEA_SEGV;
}

void sigill(int sig)
{
  unsigned char *csp;
  int i, d;

  ENT_ILL;
  if (! (_regs.eflags & VM)) /* test VM bit */ {
      er_printf("ERROR: NON-VM86 illegal insn!\n");
      return;
    }
/*  er_printf("SIGILL %d received\n", sig); */
/*  show_regs(); */
  csp = SEG_ADR((unsigned char *), cs, ip) ;
  if (csp[0] == 0xf0)
    {
      dbug_printf("ERROR: LOCK prefix not permitted!\n");
      _regs.eip++;
      return;
    }
  i = (csp[0] << 8) + csp[1]; /* swapped */
  if ((i & 0xf800) != 0xd800) { /* no FPU insns */
/*    er_printf("NO FPU instructions\n");
    error = 4; */
    LEA_ILL;
    return;
  }
  switch(i & 0xc0) {
  case 0x00:
    if ((i & 0x7) == 0x6) {
      d = *(short *)(csp +2);
      _regs.eip += 4;
    } else {
      _regs.eip += 2;
      d = 0;
    }
    break;
  case 0x40:
    d = (signed)csp[2];
    _regs.eip += 3;
    break;
  case 0x80:
    d = *(short *)(csp +2);
    _regs.eip += 4;
    break;
  default:
    _regs.eip += 2;
    d = 0;
  }
  LEA_ILL;
  dbug_printf("math emulation %x d=%x\n", i, d);
}

void sigfpe(int sig)
{
	printf("SIGFPE %d received\n", sig);
	show_regs();
        ENT_FPE;
	if (_regs.eflags & VM) run_int(0);
        LEA_FPE;
}

void sigtrap(int sig)
{
	if (_regs.eflags & TF)  /* trap flag */
		_regs.eip++;
/*	show_regs(); */
	ENT_TRAP;
	run_int(3);
	LEA_TRAP;
}

void sigdummy(int sig)
{
      printf("SIGNAL %d received\n", sig);
      show_regs();
}


void sigint(int sig)
{	disk_close_all();
	puts("^C caught"); 
	dump_int_vect();
	puts("-----------------------------------------------------");
	show_regs();
	
/*  exit(-1);  */   /* exit doesn't work */
	kill(getpid(), SIGKILL);
}

#define SETSIG(sig, fun)	sa.sa_handler = fun; \
				sa.sa_flags = 0; \
				sa.sa_mask = 0; \
				sigaction(sig, &sa, NULL);
void xdos_title()
{
        out_str("Ŀ\n",0x9f);
        out_str(" X DosPrompt version 0.3e \n",0x9f);
        out_str("\n",0x9f);
}

void hardware_init();

char *tmpdir;

int emulate(int argc, char **argv)
{

	struct sigaction sa;
	char *str,*p;
	int dos_hd,i;

	sync(); /* for safety */
        puts("\nStart EMU -------");

	Init_X (argc, argv);
	for(i=0;i<8;i++) clear_screen(i, 7);
	xdos_title();
#if	0
	if (str=getenv("DOS_DISABLE_WP")) {
		if (strcmp(str,"TRUE")==0) {
			printf("%s is write-enable\n", hdisktab[1].dev_name);
			hdisktab[1].rdonly=0;
		}
	}
#endif
	str=getenv("DOS_USE_FDIMAGE");
	if (str) {
		disktab=disktab2;
		if (*str)
                    strcpy(disktab[0].dev_name,str);
		else
		    strcpy(disktab[0].dev_name,"fdimage");
	}

	str=getenv("DOS_BOOT_DEV");
	if (str && (strcmp(str,"C")==0||strcmp(str,"c")==0) ) 
		boot_disk=hdisktab;
	else  
		boot_disk=disktab;

	str=getenv("DOS_HDS");
	if (!str) {
		puts("Read README.xdos first");
		exit(0);
	}

	dos_hd=*str-'0';
	if (dos_hd > 2 || dos_hd<0 ) {
		hdisks=2;
		out_str("Invaild Parameter DOS_HDS . Assume 2 HDs", 0x90);
	} else hdisks=dos_hd;

	str=getenv("DOS_DEV_HD_FIRST");
	if (str) {
		struct disk dtmp;
		dtmp=hdisktab[0];
		hdisktab[0]=hdisktab[1];
		hdisktab[1]=dtmp;
	}

	
	{ char tstr[80];
	sprintf(tstr,"Boot From Drive %c:   device: %s\n",
	boot_disk==hdisktab? 'C':'A', boot_disk->dev_name);
	out_str(tstr,0xf0);
	Flush_X();
	}

	tmpdir= tempnam ("/tmp", "dosemu");

	/* init signal handlers */
	SETSIG(SIGSEGV, sigsegv);
	SETSIG(SIGILL, sigill);
	SETSIG(SIGALRM, sigalrm);
	SETSIG(SIGFPE, sigfpe);
	SETSIG(SIGTRAP, sigtrap);
	SETSIG(SIGINT, sigint);
        /* do time stuff - necessary for initial time setting */
	{
	struct timeval tp;
	struct timezone tzp;
	struct tm *tm;
	unsigned long ticks;

	time(&start_time);
	gettimeofday(&tp, &tzp);
	ticks = tp.tv_sec - (tzp.tz_minuteswest*60);
	tm = localtime((time_t *)&ticks);
	last_ticks=(tm->tm_hour*60*60 + tm->tm_min*60 + tm->tm_sec)*18.206;
	set_ticks(last_ticks);
	};
	disk_init();
	hardware_init();
	for(i=0;i<80;i++) blankstr[i]=' ';
        SETSIG(SIGSEGV, sigdummy);
        boot(boot_disk);
	for(i=0;i<sizeof(scr_mirror); scr_mirror[i++]=0xff);
        SETSIG(SIGSEGV, sigsegv);
	fflush(stdout);
	itv.it_interval.tv_sec=0;
	itv.it_interval.tv_usec = UPDATE;
	itv.it_value.tv_sec=0;
	itv.it_value.tv_usec = UPDATE;
#if	0
	secitv.it_interval.tv_sec=1;
	secitv.it_interval.tv_usec = 0;
	secitv.it_value.tv_sec=1;
	secitv.it_value.tv_usec = 0;
#endif
	vm86s.screen_bitmap = 0;
	vm86s.flags = VM86_SCREEN_BITMAP;
	scrtest_bitmap = 1 << (24 + c_screen);
	setitimer(ITIMER_REAL, &itv, NULL);

	for(;!error;) (void)vm86(&vm86s);

	disk_close_all();
	_exit(error);
}

leavedos()
{	disk_close_all();
	dump_int_vect();
	rmdir(tmpdir);
	puts("---- Shutdown dos ----");
	sync();
/*  exit(-1); */   /* exit doesn't work */
	kill(getpid(), SIGKILL);
}

int serial_write(int comnum, char outchar)
{
  if (uarts[comnum].fd == 0)
    {
      uarts[comnum].fd=open(comnames[comnum], O_RDWR);
      s_printf("Serial port com%d opened out to %d\n", comnum+1, comnames[comnum]);
    }

  uarts[comnum].TX = outchar;
  uarts[comnum].MSR = 0xb0;     /* DCD, DSR, CTS for modem status */

  if (uarts[comnum].fd) write(uarts[comnum].fd, &outchar, 1);
  else s_printf("ERROR: can't write serial char\n");

  uarts[comnum].IIR = 2;   /* tr-reg-empty, int pending */

  return(0x60);   /* send ok, transmit empty, tr. hold empty, no error */
}

/* this functions returns a character from
 * the serial port */
int serial_read(int comnum)
{
   char tempchar; 
   int ready;

  if (uarts[comnum].fd == 0)
    {
      uarts[comnum].fd=open(comnames[comnum], O_RDWR);
      s_printf("Serial port com%d opened in to %s\n", comnum+1, comnames[comnum]);
    }
  uarts[comnum].MSR = 0xb0;     /* DCD, DSR, CTS for modem status */
  uarts[comnum].LSR = 0x60;
  
  if (uarts[comnum].fd && d_ready(uarts[comnum].fd)) {
       read(uarts[comnum].fd, &tempchar, 1);
       uarts[comnum].RX = tempchar;
       uarts[comnum].LSR |= 0x1;       /* receiver data ready */
       s_printf("chars ready at com%d\n", comnum+1);
     }
   else uarts[comnum].RX = 0;

  /* high byte is line stat, low is char */
  return((uarts[comnum].LSR << 8) | uarts[comnum].RX);
}

void hardware_init(void)
{
  int i;
  unsigned int ics, iip;

  /* do PIT init here */

  /* do UART init here - need to setup registers*/
  for (i = 0; i < 4; i++)
    uarts[i].fd = 0;

  uarts[0].base = 0x3f8;   /* COM1 */
  uarts[1].base = 0x2f8;   /* COM2, etc. */
  uarts[2].base = 0x3e8;
  uarts[3].base = 0x2e8;   

  /* LPT file init here */
  for (i = 0; i < 3; i++)
    lpt[i] = NULL;

  /* PIC init */
  for (i=0; i < 2; i++)
    {
      pics[i].OCW1 = 0;   /* no IRQ's serviced */
      pics[i].OCW2 = 0;   /* no EOI's received */
      pics[i].OCW3 = 8;   /* just marks this as OCW3 */
    }
  g_printf("Hardware (8259, 8253, 8250) initialized\n"); 

}

/* check the fd for data ready for reading */
int d_ready(int fd)
{
   struct timeval w_time;
   fd_set checkset;

   w_time.tv_sec=0;
   w_time.tv_usec=200000;

   FD_ZERO(&checkset);
   FD_SET(fd, &checkset);
 
   if (select(fd+1, &checkset, NULL, NULL, &w_time) == 1)
     {
       if (FD_ISSET(fd, &checkset)) return(1);
       else return(0);
     }
   else return(0);
 }
