/*
 * BarGauge: Widget to periodically display a value in form of a horizontal bar.
 * based on Athena StripChart Widget.
 *
 * Author: Gabor Herr
 *
 * $Id: BarGaugeP.h,v 1.1 1992/10/25 22:46:42 gabor Exp $
 */
 
/***********************************************************
Copyright 1992, by Gabor Herr
Copyright 1987, 1988 by Digital Equipment Corporation, Maynard, Massachusetts,
and the Massachusetts Institute of Technology, Cambridge, Massachusetts.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, 
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in 
supporting documentation, and that the names of Gabor Herr or Digital or MIT not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.  

GABOR HERR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
DIGITAL BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.

******************************************************************/

#ifndef _XawBarGaugeP_h
#define _XawBarGaugeP_h

#include "BarGauge.h"
#include <X11/Xaw/SimpleP.h>

#define NO_GCS 0
#define FOREGROUND 1 << 0
#define HIGHLIGHT  1 << 1
#define ALL_GCS (FOREGROUND | HIGHLIGHT)

/* New fields for the barGauge widget instance record */

typedef struct {
    Pixel	fgpixel;	/* color index for graph */
    Pixel	hipixel;	/* color index for lines */
    GC	fgGC;		/* graphics context for fgpixel */
    GC	hiGC;		/* graphics context for hipixel */
    
    /* start of graph stuff */
    
    int	update;		/* update frequence */
    int	scale;		/* scale factor */
    int	min_scale;	/* smallest scale factor */
    double max_value;	/* Max Value in window */
    double last_value;	/* last displayed value */
    XtCallbackList get_value; /* proc to call to fetch load pt */
    XtIntervalId interval_id;
} BarGaugePart;

/* Full instance record declaration */
typedef struct _BarGaugeRec {
   CorePart core;
   SimplePart simple;
   BarGaugePart bar_gauge;
} BarGaugeRec;

/* New fields for the BarGauge widget class record */
typedef struct {int dummy;} BarGaugeClassPart;

/* Full class record declaration. */
typedef struct _BarGaugeClassRec {
   CoreClassPart core_class;
   SimpleClassPart simple_class;
   BarGaugeClassPart bar_gauge_class;
} BarGaugeClassRec;

/* Class pointer. */
extern BarGaugeClassRec barGaugeClassRec;

#endif /* _XawBarGaugeP_h */
