/*
 * xsysinfo: X application for displaying some kernel parameters
 *
 * $Id: xsysinfo.c,v 1.5 1992/10/27 09:45:26 gabor Exp $
 *
 */

/* 
 * Written by Gabor Herr <herr@iti.informatik.th-darmstadt.de>.
 *
 * Copyright (c) 1992 by Gabor Herr, all rights reserved.
 * 
 * Permission to use, copy, modify, distribute, and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear in
 * supporting documentation, and that may name is not used in
 * advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission. I make no representations
 * about the suitability of this software for any purpose. It is
 * provided "as is" without express or implied warranty.
 */

#include <X11/Intrinsic.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Label.h>
#include "BarGauge.h"
#include <stdio.h>
#include "sysinfo.h"

#define norm(x,max)	((double)(x) / (max))

static void getloadCB( widget, client_data, call_data )
Widget widget;
XtPointer client_data;
XtPointer call_data;
{
  double *value = (double *) call_data;
  *value = get_load();  
}

static void getidleCB( widget, client_data, call_data )
Widget widget;
XtPointer client_data;
XtPointer call_data;
{
  double *value = (double *) call_data;
  *value = get_idle();
}

static void getmemCB( widget, client_data, call_data )
Widget widget;
XtPointer client_data;
XtPointer call_data;
{
  double *value = (double *) call_data;
  char type = * (String) client_data;
  static struct meminfo mem;
  static Boolean update_mem = True;

  if (update_mem)
    get_meminfo( &mem );

  update_mem = !update_mem;
    
  if (type == 'm')
    *value = norm(mem.used,mem.total);
  else
    *value = norm(mem.cache,mem.total);
}

static void getswapCB( widget, client_data, call_data )
Widget widget;
XtPointer client_data;
XtPointer call_data;
{
  double *value = (double *) call_data;
  static struct meminfo swap[MAX_SWAPFILES];
  int swapfiles;
  get_swapinfo( &swapfiles, swap );
  *value = norm(swap[0].used,swap[0].total);
}

static Widget create_gauge( name, parent, valueproc, client_data )
String name;
Widget parent;
XtCallbackProc valueproc;
XtPointer client_data;
{
  Widget gauge;
  Widget bar;

  gauge = XtCreateManagedWidget( name, formWidgetClass, parent, NULL, 0 );
  XtCreateManagedWidget( "name", labelWidgetClass, gauge, NULL, 0 );
  bar = XtCreateManagedWidget( "bar",  barGaugeWidgetClass, gauge, NULL, 0 );
  XtAddCallback( bar, XtNgetValue, valueproc, client_data );
  return gauge;
}

static void create_app( top )
Widget top;
{
  Widget form;
  form = XtCreateManagedWidget( "form", formWidgetClass, top, NULL, 0 );
  XtCreateManagedWidget( "title", labelWidgetClass, form, NULL, 0 );
  create_gauge( "load",  form, getloadCB, NULL );
  create_gauge( "idle",  form, getidleCB, NULL );
  create_gauge( "mem",   form, getmemCB, "m" );
  create_gauge( "cache", form, getmemCB, "c" );
  create_gauge( "swap",  form, getswapCB, NULL );
}

main( argc, argv )
int argc;
char **argv;
{
  Arg args[1];
  Widget toplevel;
  XtAppContext context;

  if (open_psdb()) {
    perror("cannot open psdatabase");
    exit(2);
  }

  toplevel = XtAppInitialize( &context, "XSysinfo", NULL, 0,
			      &argc, argv, NULL, NULL, 0 );

  create_app( toplevel );

  XtRealizeWidget(toplevel);
  XtAppMainLoop(context);
}

