/*
 * init.c
 *
 * Initialisations for 3Dc engine and pieces.
 * Interface initialisation is external.
 */
/*

    3Dc, a game of 3-Dimensional Chess
    Copyright (C) 1995  Paul Hicks

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    E-Mail: P.Hicks@net-cs.ucd.ie
*/
#include <malloc.h>
#include "machine.h"
#include "3Dc.h"

stack *MoveStack; /* The history of moves */
Piece *Board[3][8][8]; /* The board */
Piece *Muster[2][48]; /* The list of pieces */

/*
 * This function sets up the board
 */
void Init3Dc(void)
{
  File x;
  Rank y;
  Level z;
  Colour bw;
  int count[2][11] = {{0,0,0,0,0,0,0,0,0,0,0},{0,0,0,0,0,0,0,0,0,0,0}};
  Title name;
  /* This structure is mainly for "obviuosness"; it is entirely trivial */
  Title StartBoard[3][8][8] =

{ /* The boards */
  { /* Bottom board */
    { galley,  cannon, abbey, prince, princess,abbey, cannon, galley},
    {   pawn,   pawn,   pawn,   pawn,   pawn,   pawn,   pawn,   pawn},
    {   none,   none,   none,   none,   none,   none,   none,   none},
    {   none,   none,   none,   none,   none,   none,   none,   none},
    {   none,   none,   none,   none,   none,   none,   none,   none},
    {   none,   none,   none,   none,   none,   none,   none,   none},
    {   pawn,   pawn,   pawn,   pawn,   pawn,   pawn,   pawn,   pawn},
    { galley,  cannon, abbey, prince, princess,abbey, cannon, galley},
  },
  { /* Middle board */
    {   rook, knight, bishop,   king,  queen, bishop, knight,   rook},
    {   pawn,   pawn,   pawn,   pawn,   pawn,   pawn,   pawn,   pawn},
    {   none,   none,   none,   none,   none,   none,   none,   none},
    {   none,   none,   none,   none,   none,   none,   none,   none},
    {   none,   none,   none,   none,   none,   none,   none,   none},
    {   none,   none,   none,   none,   none,   none,   none,   none},
    {   pawn,   pawn,   pawn,   pawn,   pawn,   pawn,   pawn,   pawn},
    {   rook, knight, bishop,   king,  queen, bishop, knight,   rook}
  },
  { /* Top board */
    { galley,  cannon, abbey, prince, princess,abbey, cannon, galley},
    {   pawn,   pawn,   pawn,   pawn,   pawn,   pawn,   pawn,   pawn},
    {   none,   none,   none,   none,   none,   none,   none,   none},
    {   none,   none,   none,   none,   none,   none,   none,   none},
    {   none,   none,   none,   none,   none,   none,   none,   none},
    {   none,   none,   none,   none,   none,   none,   none,   none},
    {   pawn,   pawn,   pawn,   pawn,   pawn,   pawn,   pawn,   pawn},
    { galley,  cannon, abbey, prince, princess,abbey, cannon, galley},
  }
}; /* StartBoard */


  for (z = 0; z < 3; ++z)
    {
      bw = white;
      for (y = 0; y < 8; ++y)
        {
          if (y == 4)
            bw = black;
          for (x = 0; x < 8; ++x)
            {
              name = StartBoard[z][y][x];
              if (name != none)
                {
                  Muster[bw][idx(name, count[bw][name])] = 
                    Board[z][y][x] =
                      pieceNew(name, x, y, z, bw);
                  (count[bw][name])++;
                }
            }
        }
    }

  /* That's the pieces done.  Now for the move stack */
  MoveStack = (stack *)malloc(sizeof(stack));
  MoveStack->nSize = 0;
  MoveStack->top = NULL;
  /* Wow. I'm a genius. :) */
}
