/*****************************************************************************
 *                                                                           *
 *  Copyright (c) 1993, 1994, Elan Feingold (feingold@zko.dec.com)           *
 *                                                                           *
 *     PERMISSION TO USE, COPY, MODIFY, AND TO DISTRIBUTE THIS SOFTWARE      *
 *     AND ITS DOCUMENTATION FOR ANY PURPOSE IS HEREBY GRANTED WITHOUT       *
 *     FEE, PROVIDED THAT THE ABOVE COPYRIGHT NOTICE APPEAR IN ALL           *
 *     COPIES AND MODIFIED COPIES AND THAT BOTH THAT COPYRIGHT NOTICE AND    *
 *     THIS PERMISSION NOTICE APPEAR IN SUPPORTING DOCUMENTATION.  THERE     *
 *     IS NO REPRESENTATIONS ABOUT THE SUITABILITY OF THIS SOFTWARE FOR      *
 *     ANY PURPOSE.  THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT EXPRESS       *
 *     OR IMPLIED WARRANTY.                                                  *
 *                                                                           *
 *****************************************************************************/

#ifndef _NETWORK
#define _NETWORK

#include <sys/types.h>

#include "types.h"
#include "riskgame.h"

/****************/
/* The Messages */
/****************/

#define MSG_REGISTERCLIENT   0x01
typedef struct _msgRegisterClient
{
  String strClientAddress;
} MsgRegisterClient;

#define MSG_EXCHANGECARDS      0x03
typedef struct _msgExchangeCards
{
  Int piCards[3];
} MsgExchangeCards;

#define MSG_REQUESTCARD      0x04
typedef struct _msgRequestCard
{
  Int iPlayer;
} MsgRequestCard;

#define MSG_CARDPACKET       0x05
typedef struct _msgCardPacket
{
  Int  iPlayer;
  Int  cdCard;
} MsgCardPacket;

#define MSG_REPLYPACKET      0x06
typedef struct _msgReplyPacket
{
  Int iReply;
} MsgReplyPacket;

#define MSG_SENDMESSAGE      0x07
typedef struct _msgSendMessage
{
  String strMessage;
  String strDestination;
} MsgSendMessage;


#define MSG_MESSAGEPACKET    0x08
typedef struct _msgMessagePacket
{
  String  strMessage;
  String  strFrom;
  Int     iTo;
} MsgMessagePacket;

#define DST_ALLPLAYERS -1
#define DST_ALLBUTME   -2

#define MSG_EXIT        0x09
#define MSG_STARTGAME   0x0A

#define MSG_TURNNOTIFY  0x0B
typedef struct _msgTurnNotify
{
  Int iPlayer;
  Int iClient;
} MsgTurnNotify;

#define MSG_ENDTURN     0x0C

#define MSG_CLIENTIDENT 0x0D
typedef struct _msgClientIdent
{
  Int iClientID;
} MsgClientIdent;

#define MSG_ENTERSTATE  0x0E
typedef struct _msgEnterState
{
  Int iState;
} MsgEnterState;

#define MSG_ENDOFGAME   0x10

#define MSG_OBJSTRUPDATE 0x11
typedef struct _msgObjStrUpdate
{
  Int     iField;
  Int     iIndex1, iIndex2;
  String  strNewValue;
} MsgObjStrUpdate;

#define MSG_OBJINTUPDATE 0x12
typedef struct _msgObjIntUpdate
{
  Int     iField;
  Int     iIndex1, iIndex2;
  Int     iNewValue;
} MsgObjIntUpdate;

#define MSG_GAMENEWPLAYERS   0x13
#define MSG_GAMEMOREPLAYERS  0x14
#define MSG_GAMEANOTHER      0x15
#define MSG_DEREGISTERCLIENT 0x16

#define MSG_DELETEMSGDST     0x17
typedef struct _msgDeleteMsgDst
{
  Int iClient;
} MsgDeleteMsgDst;

#define MSG_STARTREGISTRATION 0x18
#define MSG_ALLOCPLAYER       0x19
#define MSG_FREEPLAYER        0x20
typedef struct _msgFreePlayer
{
  Int iPlayer;
} MsgFreePlayer;

#define MSG_NETMESSAGE        0x21
typedef struct _msgNetMessage
{
  String strMessage;
} MsgNetMessage;

void NET_SendMessage(Int iSocket, Int iMessType, void *pvMessage);
void NET_RecvMessage(Int iSocket, Int *piMessType, void **pvMessage);
void NET_DeleteMessage(Int iMessType, void *pvMessage);
void NET_SendSyncMessage(Int iSendSocket, Int iMessType, void *pvMessage, 
			 Int iRecvSocket, Int iReturnMessType,
			  void (*CBK_MessageReceived)(Int, void *));
#endif
