/*
**                      Softwarepraktikum iMaze
**                              1993/94
**                Joerg Czeranski    Hans-Ulrich Kiel
**
** Datei: system.h
**
** Kommentar:
**  Definition der Prototypen fuer den betriebssystemspezifischen Teil
*/


static char sccsid_system[] = "@(#)system.h	1.18 25 Oct 1994";


/* Prototypen fuer betriebssystemspezifische Funktionen */

#ifdef __STDC__

#ifdef SYSV_SIGNAL
void (*signal(int signum, void (*handler)()))();
#endif
int signal_blockiert(int signum);
void signal_blockieren(int signum);
void signal_freigeben(int signum);
int max_deskriptor_anzahl(void);
int deskriptor_nicht_blockieren(int deskriptor);
int puffer_lesen(int deskriptor, int puffer_laenge, void *puffer);
int puffer_schreiben(int deskriptor, int puffer_laenge, void *puffer);
void timer_starten(int ms);
void timer_stoppen(void);
int timer_restzeit(void);
void timer_abwarten(void);
void *timer_retten(void);
void timer_restaurieren(void *zustand);
char *uhrzeit(void);
char *benutzer_name(void);

#else

#ifdef SYSV_SIGNAL
void (*signal())();
#endif
int signal_blockiert();
void signal_blockieren();
void signal_freigeben();
int max_deskriptor_anzahl();
int deskriptor_nicht_blockieren();
int puffer_lesen();
int puffer_schreiben();
void timer_starten();
void timer_stoppen();
int timer_restzeit();
void timer_abwarten();
void *timer_retten();
void timer_restaurieren();
char *uhrzeit();
char *benutzer_name();

#endif
