/*
 * bitmaps1.h  - Xpipeman
 *
 * Send Constructive comments, bug reports, etc. to either
 *
 *          JANET: pavern@uk.ac.man.cs
 *
 *  or      INER : pavern%cs.man.ac.uk@nsfnet-relay.ac.uk
 *
 * All other comments > /dev/null !!
 * 
 * Copyright 1991 Nigel Paver
 * 
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the author's name not be used in advertising or
 * publicity pertaining to distribution of the software without specific,
 * written prior permission.  The author makes no representations about the
 * suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 * 
 * THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING 
 * ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL THE 
 * AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY 
 * DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN 
 * AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF 
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 * 
 */

/***********************************************************************/


/*                Standard Blocks                                      */



/***********************************************************************/
#define b1_height 40
#define b1_width 40
static char b1_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0xc0, 0x07, 0x00, 0x00,
   0x00, 0xe0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x07, 0x00, 0x00, 0x00, 0xe0, 0x03,
   0x00, 0x00, 0x00, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

#define b2_height 40
#define b2_width 40
static char b2_bits [] = {
   0x00, 0x1f, 0x00, 0xf8, 0x00, 0x00, 0x1f, 0x00, 0xf8, 0x00, 0x00, 0x1e,
   0x00, 0x78, 0x00, 0x00, 0x1c, 0x00, 0x38, 0x00, 0x00, 0x1c, 0x00, 0x38,
   0x00, 0x00, 0x1c, 0x00, 0x38, 0x00, 0x00, 0x1c, 0x00, 0x38, 0x00, 0x00,
   0x1c, 0x00, 0x38, 0x00, 0x00, 0x1c, 0x00, 0x38, 0x00, 0x00, 0x1c, 0x00,
   0x38, 0x00, 0x00, 0x1c, 0x00, 0x38, 0x00, 0x00, 0x1c, 0x00, 0x38, 0x00,
   0x00, 0x1c, 0x00, 0x38, 0x00, 0x00, 0x1c, 0x00, 0x38, 0x00, 0x00, 0x1c,
   0x00, 0x38, 0x00, 0x00, 0x1c, 0x00, 0x38, 0x00, 0x00, 0x1c, 0x00, 0x38,
   0x00, 0x00, 0x1c, 0x00, 0x38, 0x00, 0x00, 0x1c, 0x00, 0x38, 0x00, 0x00,
   0x1c, 0x00, 0x38, 0x00, 0x00, 0x1c, 0x00, 0x38, 0x00, 0x00, 0x1c, 0x00,
   0x38, 0x00, 0x00, 0x1c, 0x00, 0x38, 0x00, 0x00, 0x1c, 0x00, 0x38, 0x00,
   0x00, 0x1c, 0x00, 0x38, 0x00, 0x00, 0x1c, 0x00, 0x38, 0x00, 0x00, 0x1c,
   0x00, 0x38, 0x00, 0x00, 0x1c, 0x00, 0x38, 0x00, 0x00, 0x1c, 0x00, 0x38,
   0x00, 0x00, 0x1c, 0x00, 0x38, 0x00, 0x00, 0x1c, 0x00, 0x38, 0x00, 0x00,
   0x1c, 0x00, 0x38, 0x00, 0x00, 0x1c, 0x00, 0x38, 0x00, 0x00, 0x1c, 0x00,
   0x38, 0x00, 0x00, 0x1c, 0x00, 0x38, 0x00, 0x00, 0x1c, 0x00, 0x38, 0x00,
   0x00, 0x1c, 0x00, 0x38, 0x00, 0x00, 0x1e, 0x00, 0x78, 0x00, 0x00, 0x1f,
   0x00, 0xf8, 0x00, 0x00, 0x1f, 0x00, 0xf8, 0x01};

#define b3_width 40
#define b3_height 40
static char b3_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x00, 0x00, 0x00,
   0x00, 0xf0, 0x00, 0x00, 0x00, 0x80, 0xff, 0x00, 0x00, 0x00, 0xf0, 0xff,
   0x00, 0x00, 0x00, 0xfc, 0xff, 0x00, 0x00, 0x00, 0xff, 0x07, 0x00, 0x00,
   0x80, 0x7f, 0x00, 0x00, 0x00, 0xe0, 0x0f, 0x00, 0x00, 0x00, 0xf0, 0x03,
   0x00, 0x00, 0x00, 0xf8, 0x01, 0x00, 0x00, 0x00, 0x7c, 0x00, 0x00, 0x00,
   0x00, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x00, 0x00, 0x00, 0x80, 0x0f,
   0x00, 0x00, 0x00, 0x80, 0x07, 0x00, 0x00, 0x00, 0xc0, 0x03, 0x00, 0x00,
   0x00, 0xe0, 0x03, 0x00, 0x00, 0x00, 0xe0, 0x01, 0x00, 0x00, 0x00, 0xf0,
   0x00, 0x00, 0xe0, 0x00, 0xf0, 0x00, 0x00, 0xfc, 0x00, 0x78, 0x00, 0x00,
   0xff, 0x00, 0x78, 0x00, 0x80, 0xff, 0x00, 0x78, 0x00, 0xc0, 0xdf, 0x00,
   0x3c, 0x00, 0xe0, 0x03, 0x00, 0x3c, 0x00, 0xf0, 0x01, 0x00, 0x3c, 0x00,
   0xf0, 0x00, 0x00, 0x3c, 0x00, 0x78, 0x00, 0x00, 0x1c, 0x00, 0x78, 0x00,
   0x00, 0x1e, 0x00, 0x78, 0x00, 0x00, 0x1e, 0x00, 0x3c, 0x00, 0x00, 0x1f,
   0x00, 0x3c, 0x00, 0x00, 0x1f, 0x00, 0x3c, 0x00};

#define b4_width 40
#define b4_height 40
static char b4_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x00, 0x00,
   0x00, 0x00, 0xff, 0x01, 0x00, 0x00, 0x00, 0xff, 0x0f, 0x00, 0x00, 0x00,
   0xff, 0x3f, 0x00, 0x00, 0x00, 0xe0, 0xff, 0x00, 0x00, 0x00, 0x00, 0xfe,
   0x01, 0x00, 0x00, 0x00, 0xf0, 0x07, 0x00, 0x00, 0x00, 0xc0, 0x0f, 0x00,
   0x00, 0x00, 0x80, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x00, 0x00, 0x00,
   0x00, 0x7c, 0x00, 0x00, 0x00, 0x00, 0xf8, 0x00, 0x00, 0x00, 0x00, 0xf0,
   0x01, 0x00, 0x00, 0x00, 0xe0, 0x01, 0x00, 0x00, 0x00, 0xc0, 0x03, 0x00,
   0x00, 0x00, 0xc0, 0x07, 0x00, 0x00, 0x00, 0x80, 0x07, 0x00, 0x07, 0x00,
   0x00, 0x0f, 0x00, 0x3f, 0x00, 0x00, 0x0f, 0x00, 0xff, 0x00, 0x00, 0x1e,
   0x00, 0xff, 0x01, 0x00, 0x1e, 0x00, 0xfb, 0x03, 0x00, 0x1e, 0x00, 0xc0,
   0x07, 0x00, 0x3c, 0x00, 0x80, 0x0f, 0x00, 0x3c, 0x00, 0x00, 0x0f, 0x00,
   0x3c, 0x00, 0x00, 0x1e, 0x00, 0x3c, 0x00, 0x00, 0x1e, 0x00, 0x38, 0x00,
   0x00, 0x1e, 0x00, 0x78, 0x00, 0x00, 0x3c, 0x00, 0x78, 0x00, 0x00, 0x3e,
   0x00, 0xf8, 0x00, 0x00, 0x3e, 0x00, 0xf8, 0x00};

#define b5_width 40
#define b5_height 40
static char b5_bits[] = {
   0x00, 0x1f, 0x00, 0x7c, 0x00, 0x00, 0x1f, 0x00, 0x7c, 0x00, 0x00, 0x1e,
   0x00, 0x3c, 0x00, 0x00, 0x1e, 0x00, 0x78, 0x00, 0x00, 0x1c, 0x00, 0x78,
   0x00, 0x00, 0x3c, 0x00, 0x78, 0x00, 0x00, 0x3c, 0x00, 0xf0, 0x00, 0x00,
   0x3c, 0x00, 0xf0, 0x01, 0x00, 0x3c, 0x00, 0xe0, 0x03, 0x00, 0x78, 0x00,
   0xc0, 0xdf, 0x00, 0x78, 0x00, 0x80, 0xff, 0x00, 0x78, 0x00, 0x00, 0xff,
   0x00, 0xf0, 0x00, 0x00, 0xfc, 0x00, 0xf0, 0x00, 0x00, 0xe0, 0x00, 0xe0,
   0x01, 0x00, 0x00, 0x00, 0xe0, 0x03, 0x00, 0x00, 0x00, 0xc0, 0x03, 0x00,
   0x00, 0x00, 0x80, 0x07, 0x00, 0x00, 0x00, 0x80, 0x0f, 0x00, 0x00, 0x00,
   0x00, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x7c,
   0x00, 0x00, 0x00, 0x00, 0xf8, 0x01, 0x00, 0x00, 0x00, 0xf0, 0x03, 0x00,
   0x00, 0x00, 0xe0, 0x0f, 0x00, 0x00, 0x00, 0x80, 0x7f, 0x00, 0x00, 0x00,
   0x00, 0xff, 0x07, 0x00, 0x00, 0x00, 0xfc, 0xff, 0x00, 0x00, 0x00, 0xf0,
   0xff, 0x00, 0x00, 0x00, 0x80, 0xff, 0x00, 0x00, 0x00, 0x00, 0xf0, 0x00,
   0x00, 0x00, 0x00, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

#define b6_width 40
#define b6_height 40
static char b6_bits[] = {
   0x00, 0x3e, 0x00, 0xf8, 0x00, 0x00, 0x3e, 0x00, 0xf8, 0x00, 0x00, 0x3c,
   0x00, 0x78, 0x00, 0x00, 0x1e, 0x00, 0x78, 0x00, 0x00, 0x1e, 0x00, 0x38,
   0x00, 0x00, 0x1e, 0x00, 0x3c, 0x00, 0x00, 0x0f, 0x00, 0x3c, 0x00, 0x80,
   0x0f, 0x00, 0x3c, 0x00, 0xc0, 0x07, 0x00, 0x3c, 0x00, 0xfb, 0x03, 0x00,
   0x1e, 0x00, 0xff, 0x01, 0x00, 0x1e, 0x00, 0xff, 0x00, 0x00, 0x1e, 0x00,
   0x3f, 0x00, 0x00, 0x0f, 0x00, 0x07, 0x00, 0x00, 0x0f, 0x00, 0x00, 0x00,
   0x80, 0x07, 0x00, 0x00, 0x00, 0xc0, 0x07, 0x00, 0x00, 0x00, 0xc0, 0x03,
   0x00, 0x00, 0x00, 0xe0, 0x01, 0x00, 0x00, 0x00, 0xf0, 0x01, 0x00, 0x00,
   0x00, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x3e,
   0x00, 0x00, 0x00, 0x80, 0x1f, 0x00, 0x00, 0x00, 0xc0, 0x0f, 0x00, 0x00,
   0x00, 0xf0, 0x07, 0x00, 0x00, 0x00, 0xfe, 0x01, 0x00, 0x00, 0xe0, 0xff,
   0x00, 0x00, 0x00, 0xff, 0x3f, 0x00, 0x00, 0x00, 0xff, 0x0f, 0x00, 0x00,
   0x00, 0xff, 0x01, 0x00, 0x00, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x03,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

#define b7_height 40
#define b7_width 40
static char b7_bits[] = {
   0x00, 0x1f, 0x00, 0xf8, 0x00, 0x00, 0x1f, 0x00, 0xf8, 0x00, 0x00, 0x1e,
   0x00, 0x78, 0x00, 0x00, 0x1c, 0x00, 0x38, 0x00, 0x00, 0x1c, 0x00, 0x38,
   0x00, 0x00, 0x1c, 0x00, 0x38, 0x00, 0x00, 0x1c, 0x00, 0x38, 0x00, 0x01,
   0x1c, 0x00, 0x38, 0x80, 0x03, 0x1e, 0x00, 0x78, 0xc0, 0x07, 0x1f, 0x00,
   0xf8, 0xe0, 0xff, 0x1f, 0x00, 0xf8, 0xff, 0xff, 0x1f, 0x00, 0xf8, 0xff,
   0xff, 0x1f, 0x00, 0xf8, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0xff, 0x1f, 0x00, 0xf8, 0xff, 0xff, 0x1f, 0x00, 0xf8,
   0xff, 0xff, 0x1f, 0x00, 0xf8, 0xff, 0x07, 0x1f, 0x00, 0xf8, 0xe0, 0x03,
   0x1e, 0x00, 0x78, 0xc0, 0x00, 0x1c, 0x00, 0x38, 0x00, 0x00, 0x1c, 0x00,
   0x38, 0x00, 0x00, 0x1c, 0x00, 0x38, 0x00, 0x00, 0x1c, 0x00, 0x38, 0x00,
   0x00, 0x1c, 0x00, 0x38, 0x00, 0x00, 0x1e, 0x00, 0x78, 0x00, 0x00, 0x1f,
   0x00, 0xf8, 0x00, 0x00, 0x1f, 0x00, 0xf8, 0x00};

/***********************************************************************/


/*                    One Way Blocks                                    */



/***********************************************************************/

#define b11w_width 40
#define b11w_height 40
static char b11w_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0xc0, 0x07, 0x00, 0x00,
   0x00, 0xe0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x01, 0x00, 0x00, 0x00, 0x00, 0x03, 0xf0, 0xff, 0xff, 0xff, 0x07, 0xf0,
   0xff, 0xff, 0xff, 0x0f, 0xf0, 0xff, 0xff, 0xff, 0x07, 0x00, 0x00, 0x00,
   0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x07, 0x00, 0x00, 0x00, 0xe0, 0x03,
   0x00, 0x00, 0x00, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

#define b21w_width 40
#define b21w_height 40
static char b21w_bits[] = {
   0x00, 0x1f, 0x00, 0xf8, 0x00, 0x00, 0x1f, 0x00, 0xf8, 0x00, 0x00, 0x1e,
   0x00, 0x78, 0x00, 0x00, 0x1c, 0x00, 0x38, 0x00, 0x00, 0x1c, 0x1c, 0x38,
   0x00, 0x00, 0x1c, 0x1c, 0x38, 0x00, 0x00, 0x1c, 0x1c, 0x38, 0x00, 0x00,
   0x1c, 0x1c, 0x38, 0x00, 0x00, 0x1c, 0x1c, 0x38, 0x00, 0x00, 0x1c, 0x1c,
   0x38, 0x00, 0x00, 0x1c, 0x1c, 0x38, 0x00, 0x00, 0x1c, 0x1c, 0x38, 0x00,
   0x00, 0x1c, 0x1c, 0x38, 0x00, 0x00, 0x1c, 0x1c, 0x38, 0x00, 0x00, 0x1c,
   0x1c, 0x38, 0x00, 0x00, 0x1c, 0x1c, 0x38, 0x00, 0x00, 0x1c, 0x1c, 0x38,
   0x00, 0x00, 0x1c, 0x1c, 0x38, 0x00, 0x00, 0x1c, 0x1c, 0x38, 0x00, 0x00,
   0x1c, 0x1c, 0x38, 0x00, 0x00, 0x1c, 0x1c, 0x38, 0x00, 0x00, 0x1c, 0x1c,
   0x38, 0x00, 0x00, 0x1c, 0x1c, 0x38, 0x00, 0x00, 0x1c, 0x1c, 0x38, 0x00,
   0x00, 0x1c, 0x1c, 0x38, 0x00, 0x00, 0x1c, 0x1c, 0x38, 0x00, 0x00, 0x1c,
   0x1c, 0x38, 0x00, 0x00, 0x1c, 0x1c, 0x38, 0x00, 0x00, 0x1c, 0x1c, 0x38,
   0x00, 0x00, 0x1c, 0x1c, 0x38, 0x00, 0x00, 0x1c, 0x1c, 0x38, 0x00, 0x00,
   0x1c, 0x1c, 0x38, 0x00, 0x00, 0x1c, 0x7f, 0x38, 0x00, 0x00, 0x1c, 0x3e,
   0x38, 0x00, 0x00, 0x1c, 0x1c, 0x38, 0x00, 0x00, 0x1c, 0x08, 0x38, 0x00,
   0x00, 0x1c, 0x00, 0x38, 0x00, 0x00, 0x1e, 0x00, 0x78, 0x00, 0x00, 0x1f,
   0x00, 0xf8, 0x00, 0x00, 0x1f, 0x00, 0xf8, 0x01};

#define b31w_width 40
#define b31w_height 40
static char b31w_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x00, 0x00, 0x00,
   0x00, 0xf0, 0x00, 0x00, 0x00, 0x80, 0xff, 0x00, 0x00, 0x00, 0xf0, 0xff,
   0x00, 0x00, 0x00, 0xfc, 0xff, 0x00, 0x00, 0x00, 0xff, 0x07, 0x00, 0x00,
   0x80, 0x7f, 0x00, 0x00, 0x00, 0xe0, 0x0f, 0x00, 0x00, 0x00, 0xf0, 0x03,
   0x00, 0x00, 0x00, 0xf8, 0x01, 0x08, 0x00, 0x00, 0x7c, 0x00, 0x18, 0x00,
   0x00, 0x3e, 0x00, 0x3f, 0x00, 0x00, 0x1f, 0xe0, 0x7f, 0x00, 0x80, 0x0f,
   0xf0, 0x3f, 0x00, 0x80, 0x07, 0xfc, 0x18, 0x00, 0xc0, 0x03, 0x3e, 0x08,
   0x00, 0xe0, 0x03, 0x0f, 0x00, 0x00, 0xe0, 0x81, 0x07, 0x00, 0x00, 0xf0,
   0xc0, 0x03, 0xe0, 0x00, 0xf0, 0xc0, 0x01, 0xfc, 0x00, 0x78, 0xe0, 0x00,
   0xff, 0x00, 0x78, 0xf0, 0x80, 0xff, 0x00, 0x78, 0x70, 0xc0, 0xdf, 0x00,
   0x3c, 0x70, 0xe0, 0x03, 0x00, 0x3c, 0x38, 0xf0, 0x01, 0x00, 0x3c, 0x38,
   0xf0, 0x00, 0x00, 0x3c, 0x38, 0x78, 0x00, 0x00, 0x1c, 0x1c, 0x78, 0x00,
   0x00, 0x1e, 0x00, 0x78, 0x00, 0x00, 0x1e, 0x00, 0x3c, 0x00, 0x00, 0x1f,
   0x00, 0x3c, 0x00, 0x00, 0x1f, 0x00, 0x3c, 0x00};

#define b41w_width 40
#define b41w_height 40
static char b41w_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x00, 0x00,
   0x00, 0x00, 0xff, 0x01, 0x00, 0x00, 0x00, 0xff, 0x0f, 0x00, 0x00, 0x00,
   0xff, 0x3f, 0x00, 0x00, 0x00, 0xe0, 0xff, 0x00, 0x00, 0x00, 0x00, 0xfe,
   0x01, 0x00, 0x00, 0x00, 0xf0, 0x07, 0x00, 0x00, 0x00, 0xc0, 0x0f, 0x00,
   0x00, 0x10, 0x80, 0x1f, 0x00, 0x00, 0x18, 0x00, 0x3e, 0x00, 0x00, 0xfc,
   0x00, 0x7c, 0x00, 0x00, 0xfe, 0x07, 0xf8, 0x00, 0x00, 0xfc, 0x0f, 0xf0,
   0x01, 0x00, 0x18, 0x3f, 0xe0, 0x01, 0x00, 0x10, 0x7c, 0xc0, 0x03, 0x00,
   0x00, 0xf0, 0xc0, 0x07, 0x00, 0x00, 0xe0, 0x81, 0x07, 0x00, 0x07, 0xc0,
   0x03, 0x0f, 0x00, 0x3f, 0x80, 0x03, 0x0f, 0x00, 0xff, 0x00, 0x07, 0x1e,
   0x00, 0xff, 0x01, 0x0f, 0x1e, 0x00, 0xfb, 0x03, 0x0e, 0x1e, 0x00, 0xc0,
   0x07, 0x0e, 0x3c, 0x00, 0x80, 0x0f, 0x1c, 0x3c, 0x00, 0x00, 0x0f, 0x1c,
   0x3c, 0x00, 0x00, 0x1e, 0x1c, 0x3c, 0x00, 0x00, 0x1e, 0x38, 0x38, 0x00,
   0x00, 0x1e, 0x00, 0x78, 0x00, 0x00, 0x3c, 0x00, 0x78, 0x00, 0x00, 0x3e,
   0x00, 0xf8, 0x00, 0x00, 0x3e, 0x00, 0xf8, 0x00};

#define b51w_width 40
#define b51w_height 40
static char b51w_bits[] = {
   0x00, 0x1f, 0x00, 0x7c, 0x00, 0x00, 0x1f, 0x00, 0x7c, 0x00, 0x00, 0x1e,
   0x00, 0x3c, 0x00, 0x00, 0x1e, 0x00, 0x78, 0x00, 0x00, 0x1c, 0x1c, 0x78,
   0x00, 0x00, 0x3c, 0x38, 0x78, 0x00, 0x00, 0x3c, 0x38, 0xf0, 0x00, 0x00,
   0x3c, 0x38, 0xf0, 0x01, 0x00, 0x3c, 0x70, 0xe0, 0x03, 0x00, 0x78, 0x70,
   0xc0, 0xdf, 0x00, 0x78, 0xf0, 0x80, 0xff, 0x00, 0x78, 0xe0, 0x00, 0xff,
   0x00, 0xf0, 0xc0, 0x01, 0xfc, 0x00, 0xf0, 0xc0, 0x03, 0xe0, 0x00, 0xe0,
   0x81, 0x07, 0x00, 0x00, 0xe0, 0x03, 0x0f, 0x00, 0x00, 0xc0, 0x03, 0x3e,
   0x08, 0x00, 0x80, 0x07, 0xfc, 0x18, 0x00, 0x80, 0x0f, 0xf0, 0x3f, 0x00,
   0x00, 0x1f, 0xe0, 0x7f, 0x00, 0x00, 0x3e, 0x00, 0x3f, 0x00, 0x00, 0x7c,
   0x00, 0x18, 0x00, 0x00, 0xf8, 0x01, 0x08, 0x00, 0x00, 0xf0, 0x03, 0x00,
   0x00, 0x00, 0xe0, 0x0f, 0x00, 0x00, 0x00, 0x80, 0x7f, 0x00, 0x00, 0x00,
   0x00, 0xff, 0x07, 0x00, 0x00, 0x00, 0xfc, 0xff, 0x00, 0x00, 0x00, 0xf0,
   0xff, 0x00, 0x00, 0x00, 0x80, 0xff, 0x00, 0x00, 0x00, 0x00, 0xf0, 0x00,
   0x00, 0x00, 0x00, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

#define b61w_width 40
#define b61w_height 40
static char b61w_bits[] = {
   0x00, 0x3e, 0x00, 0xf8, 0x00, 0x00, 0x3e, 0x00, 0xf8, 0x00, 0x00, 0x3c,
   0x00, 0x78, 0x00, 0x00, 0x1e, 0x00, 0x78, 0x00, 0x00, 0x1e, 0x38, 0x38,
   0x00, 0x00, 0x1e, 0x1c, 0x3c, 0x00, 0x00, 0x0f, 0x1c, 0x3c, 0x00, 0x80,
   0x0f, 0x1c, 0x3c, 0x00, 0xc0, 0x07, 0x0e, 0x3c, 0x00, 0xfb, 0x03, 0x0e,
   0x1e, 0x00, 0xff, 0x01, 0x0f, 0x1e, 0x00, 0xff, 0x00, 0x07, 0x1e, 0x00,
   0x3f, 0x80, 0x03, 0x0f, 0x00, 0x07, 0xc0, 0x03, 0x0f, 0x00, 0x00, 0xe0,
   0x81, 0x07, 0x00, 0x00, 0xf0, 0xc0, 0x07, 0x00, 0x10, 0x7c, 0xc0, 0x03,
   0x00, 0x18, 0x3f, 0xe0, 0x01, 0x00, 0xfc, 0x0f, 0xf0, 0x01, 0x00, 0xfe,
   0x07, 0xf8, 0x00, 0x00, 0xfc, 0x00, 0x7c, 0x00, 0x00, 0x18, 0x00, 0x3e,
   0x00, 0x00, 0x10, 0x80, 0x1f, 0x00, 0x00, 0x00, 0xc0, 0x0f, 0x00, 0x00,
   0x00, 0xf0, 0x07, 0x00, 0x00, 0x00, 0xfe, 0x01, 0x00, 0x00, 0xe0, 0xff,
   0x00, 0x00, 0x00, 0xff, 0x3f, 0x00, 0x00, 0x00, 0xff, 0x0f, 0x00, 0x00,
   0x00, 0xff, 0x01, 0x00, 0x00, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x03,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

/***********************************************************************/


/*                Half Filled CrossOver                                */



/***********************************************************************/
#define b8_width 40
#define b8_height 40
static char b8_bits[] = {
   0x00, 0x1f, 0x00, 0xf8, 0x00, 0x00, 0x1f, 0x00, 0xf8, 0x00, 0x00, 0x1e,
   0x00, 0x78, 0x00, 0x00, 0x1c, 0x00, 0x38, 0x00, 0x00, 0x1c, 0x00, 0x38,
   0x00, 0x00, 0x1c, 0x00, 0x38, 0x00, 0x00, 0x1c, 0x00, 0x38, 0x00, 0x01,
   0x1c, 0x00, 0x38, 0x80, 0x03, 0x1e, 0x00, 0x78, 0xc0, 0x07, 0x1f, 0x00,
   0xf8, 0xe0, 0xff, 0x1f, 0x00, 0xf8, 0xff, 0xff, 0x1f, 0x00, 0xf8, 0xff,
   0xff, 0x1f, 0x00, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0xff, 0xff, 0xff, 0xff, 0x1f, 0x00, 0xf8, 0xff, 0xff, 0x1f, 0x00, 0xf8,
   0xff, 0xff, 0x1f, 0x00, 0xf8, 0xff, 0x07, 0x1f, 0x00, 0xf8, 0xe0, 0x03,
   0x1e, 0x00, 0x78, 0xc0, 0x00, 0x1c, 0x00, 0x38, 0x00, 0x00, 0x1c, 0x00,
   0x38, 0x00, 0x00, 0x1c, 0x00, 0x38, 0x00, 0x00, 0x1c, 0x00, 0x38, 0x00,
   0x00, 0x1c, 0x00, 0x38, 0x00, 0x00, 0x1e, 0x00, 0x78, 0x00, 0x00, 0x1f,
   0x00, 0xf8, 0x00, 0x00, 0x1f, 0x00, 0xf8, 0x00};

#define b9_width 40
#define b9_height 40
static char b9_bits[] = {
   0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0xfe,
   0xff, 0x7f, 0x00, 0x00, 0xfc, 0xff, 0x3f, 0x00, 0x00, 0xfc, 0xff, 0x3f,
   0x00, 0x00, 0xfc, 0xff, 0x3f, 0x00, 0x00, 0xfc, 0xff, 0x3f, 0x00, 0x01,
   0xfc, 0xff, 0x3f, 0x80, 0x03, 0xfe, 0xff, 0x7f, 0xc0, 0x07, 0xff, 0xff,
   0xff, 0xe0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0xe0, 0xff, 0x07, 0x00, 0x00, 0xe0,
   0xff, 0x07, 0x00, 0x00, 0xe0, 0xff, 0x07, 0x00, 0x00, 0xe0, 0xff, 0x07,
   0x00, 0x00, 0xe0, 0xff, 0x07, 0x00, 0x00, 0xe0, 0xff, 0x07, 0x00, 0x00,
   0xe0, 0xff, 0x07, 0x00, 0x00, 0xe0, 0xff, 0x07, 0x00, 0x00, 0xe0, 0xff,
   0x07, 0x00, 0x00, 0xe0, 0xff, 0x07, 0x00, 0x00, 0xe0, 0xff, 0x07, 0x00,
   0x00, 0xe0, 0xff, 0x07, 0x00, 0x00, 0xe0, 0xff, 0x07, 0x00, 0x00, 0xe0,
   0xff, 0x07, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x07, 0xff, 0xff, 0xff, 0xe0, 0x03,
   0xfe, 0xff, 0x7f, 0xc0, 0x00, 0xfc, 0xff, 0x3f, 0x00, 0x00, 0xfc, 0xff,
   0x3f, 0x00, 0x00, 0xfc, 0xff, 0x3f, 0x00, 0x00, 0xfc, 0xff, 0x3f, 0x00,
   0x00, 0xfc, 0xff, 0x3f, 0x00, 0x00, 0xfe, 0xff, 0x7f, 0x00, 0x00, 0xff,
   0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00};

/***********************************************************************/


/*                Obstacle Blocks                                      */



/***********************************************************************/

#define ob1_width 40
#define ob1_height 40
static char ob1_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x03, 0x00, 0x00, 0x00,
   0xc0, 0x07, 0x00, 0x00, 0x00, 0xc0, 0x07, 0x00, 0x00, 0x00, 0xc0, 0x1f,
   0x00, 0x00, 0x00, 0x80, 0xff, 0x00, 0x00, 0x00, 0x00, 0x7f, 0x01, 0x00,
   0x00, 0x00, 0x7f, 0x02, 0x00, 0x00, 0x00, 0xfe, 0x04, 0x00, 0x00, 0x00,
   0xfe, 0x07, 0x00, 0x00, 0x00, 0xfe, 0x07, 0x00, 0x00, 0x00, 0xff, 0x1f,
   0x00, 0x00, 0x80, 0xff, 0x7f, 0x00, 0x00, 0xc0, 0xff, 0x7f, 0x00, 0x00,
   0xe0, 0xbf, 0x3f, 0x00, 0x00, 0xf0, 0x1f, 0x1f, 0x00, 0x00, 0xf8, 0x0f,
   0x0f, 0x00, 0x00, 0xfe, 0x07, 0x07, 0x00, 0x00, 0xff, 0x03, 0x02, 0x00,
   0x80, 0xff, 0x01, 0x00, 0x00, 0xc0, 0xff, 0x00, 0x00, 0x00, 0xe0, 0x7f,
   0x00, 0x00, 0x00, 0xf0, 0x7f, 0x00, 0x00, 0x00, 0xf8, 0x3f, 0x00, 0x00,
   0x00, 0xfc, 0x1f, 0x00, 0x00, 0x00, 0xfe, 0x0f, 0x00, 0x00, 0x00, 0xff,
   0x07, 0x00, 0x00, 0x80, 0xff, 0x03, 0x00, 0x00, 0xc0, 0xff, 0x01, 0x00,
   0x00, 0xe0, 0xff, 0x00, 0x00, 0x00, 0xf0, 0x7f, 0x00, 0x00, 0x00, 0xf8,
   0x3f, 0x00, 0x00, 0x00, 0xfc, 0x1f, 0x00, 0x00, 0x00, 0xfe, 0x0f, 0x00,
   0x00, 0x00, 0xfe, 0x07, 0x00, 0x00, 0x00, 0xfe, 0x03, 0x00, 0x00, 0x00,
   0xfe, 0x01, 0x00, 0x00, 0x00, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
#define ob2_width 40
#define ob2_height 40
static char ob2_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0xf0, 0x00, 0x00, 0x00, 0x00, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x7e,
   0x00, 0x00, 0x00, 0x00, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x00, 0x00,
   0x00, 0x80, 0x0f, 0x30, 0x00, 0x00, 0x80, 0x07, 0x30, 0x00, 0x00, 0x80,
   0x07, 0x38, 0x00, 0x00, 0x80, 0x07, 0x3c, 0x00, 0x00, 0x80, 0x07, 0x3e,
   0x00, 0x00, 0xc0, 0x0f, 0x3f, 0x00, 0x00, 0xe0, 0xff, 0x1f, 0x00, 0x00,
   0xf0, 0xff, 0x0f, 0x00, 0x00, 0xf8, 0xff, 0x07, 0x00, 0x00, 0xfc, 0xff,
   0x01, 0x00, 0x00, 0xfe, 0x7f, 0x00, 0x00, 0x00, 0xff, 0x07, 0x00, 0x00,
   0x80, 0xff, 0x03, 0x00, 0x00, 0xc0, 0xff, 0x01, 0x00, 0x00, 0xe0, 0xff,
   0x00, 0x00, 0x00, 0xe0, 0x7f, 0x00, 0x00, 0x80, 0xff, 0x3f, 0x00, 0x00,
   0xe0, 0xff, 0x1f, 0x00, 0x00, 0xf0, 0xff, 0x0f, 0x00, 0x00, 0xf8, 0xff,
   0x07, 0x00, 0x00, 0xf8, 0xf0, 0x03, 0x00, 0x00, 0x7c, 0xe0, 0x01, 0x00,
   0x00, 0x3c, 0xe0, 0x01, 0x00, 0x00, 0x1c, 0xe0, 0x01, 0x00, 0x00, 0x0c,
   0xe0, 0x01, 0x00, 0x00, 0x00, 0xf0, 0x01, 0x00, 0x00, 0x00, 0xf8, 0x00,
   0x00, 0x00, 0x00, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x7f, 0x00, 0x00, 0x00,
   0x80, 0x3f, 0x00, 0x00, 0x00, 0x80, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
#define ob3_width 40
#define ob3_height 40
static char ob3_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00,
   0x00, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x80, 0x1f, 0x00, 0x00, 0x00, 0xc0,
   0x3f, 0x00, 0x00, 0x00, 0xf0, 0x7f, 0x00, 0x00, 0x00, 0xf8, 0x7f, 0x00,
   0x00, 0x00, 0xfc, 0x7f, 0x00, 0x00, 0x00, 0xff, 0x3f, 0x00, 0x00, 0x80,
   0xff, 0x3f, 0x00, 0x00, 0xc0, 0xff, 0x1f, 0x00, 0x00, 0xe0, 0xff, 0x0f,
   0x00, 0x00, 0xf8, 0xff, 0x07, 0x00, 0x00, 0xfc, 0xff, 0x03, 0x00, 0x00,
   0xfe, 0xff, 0x03, 0x00, 0x80, 0xff, 0xff, 0x00, 0x00, 0xc0, 0xff, 0xff,
   0x00, 0x00, 0xe0, 0xff, 0x3f, 0x00, 0x00, 0xf0, 0xff, 0x3f, 0x00, 0x00,
   0xf8, 0xff, 0x3f, 0x00, 0x00, 0xff, 0xff, 0x0f, 0x00, 0x80, 0xff, 0xff,
   0x0f, 0x00, 0xe0, 0xe0, 0xff, 0x0f, 0x00, 0x30, 0x80, 0xff, 0x01, 0x00,
   0x18, 0x8e, 0xff, 0x01, 0x00, 0x8c, 0x3b, 0xff, 0x01, 0x00, 0x1e, 0x61,
   0x3e, 0x00, 0x00, 0x20, 0x42, 0x3e, 0x00, 0x00, 0x40, 0xc4, 0x3c, 0x00,
   0x00, 0x40, 0x84, 0x04, 0x00, 0x00, 0x80, 0xc8, 0x04, 0x00, 0x00, 0x00,
   0x51, 0x06, 0x00, 0x00, 0x00, 0x22, 0x02, 0x00, 0x00, 0x00, 0x04, 0x03,
   0x00, 0x00, 0x00, 0x84, 0x01, 0x00, 0x00, 0x00, 0xc8, 0x00, 0x00, 0x00,
   0x00, 0x70, 0x00, 0x00, 0x00, 0x00, 0x30, 0x00, 0x00, 0x00, 0x00, 0x10,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
#define ob4_width 40
#define ob4_height 40
static char ob4_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x00,
   0x00, 0x00, 0x00, 0x70, 0x00, 0x00, 0x00, 0x00, 0x78, 0x00, 0x00, 0x00,
   0x00, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x7f,
   0x00, 0x00, 0x00, 0x80, 0xff, 0x00, 0x00, 0x00, 0x80, 0xfb, 0x01, 0x00,
   0x00, 0x00, 0xf0, 0x03, 0x00, 0x00, 0x00, 0xe0, 0x07, 0x00, 0x00, 0x00,
   0xc0, 0x0f, 0x00, 0x00, 0x00, 0x80, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x3e,
   0x00, 0x00, 0x00, 0x00, 0x7c, 0x00, 0x00, 0x00, 0x00, 0xf8, 0x00, 0x00,
   0x00, 0x00, 0xf0, 0x01, 0x00, 0x00, 0x00, 0xc0, 0x03, 0x00, 0x00, 0x00,
   0x80, 0x07, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x1e,
   0x00, 0x00, 0x00, 0x00, 0x38, 0x00, 0x00, 0x00, 0x00, 0x70, 0x00, 0x00,
   0x00, 0x00, 0xe0, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x01, 0x00, 0x00, 0x00,
   0x80, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
#define ob5_width 40
#define ob5_height 40
static char ob5_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x01, 0x00, 0x00, 0x00,
   0xfe, 0x01, 0x00, 0x00, 0x00, 0xfe, 0x01, 0x00, 0x00, 0x00, 0xfc, 0x00,
   0x00, 0x00, 0x00, 0xfc, 0x00, 0x00, 0x00, 0x00, 0xfc, 0x00, 0x00, 0x00,
   0x00, 0xfc, 0x00, 0x00, 0x00, 0x00, 0xfc, 0x00, 0x00, 0x00, 0x00, 0xfc,
   0x00, 0x00, 0x00, 0x00, 0xfe, 0x01, 0x00, 0x00, 0x00, 0xff, 0x03, 0x00,
   0x00, 0x80, 0xff, 0x07, 0x00, 0x00, 0x80, 0xff, 0x07, 0x00, 0x00, 0xc0,
   0xff, 0x0f, 0x00, 0x00, 0xe0, 0xff, 0x1f, 0x00, 0x00, 0xe0, 0xff, 0x1f,
   0x00, 0x00, 0xe0, 0xff, 0x1f, 0x00, 0x00, 0xe0, 0xff, 0x1f, 0x00, 0x00,
   0xe0, 0xff, 0x1f, 0x00, 0x00, 0xe0, 0xff, 0x1f, 0x00, 0x00, 0xe0, 0xff,
   0x1f, 0x00, 0x00, 0xe0, 0x00, 0x1c, 0x00, 0x00, 0xe0, 0xe6, 0x1c, 0x00,
   0x00, 0xe0, 0xaa, 0x1c, 0x00, 0x00, 0xe0, 0xea, 0x1c, 0x00, 0x00, 0xe0,
   0x20, 0x1c, 0x00, 0x00, 0xe0, 0x00, 0x1c, 0x00, 0x00, 0xe0, 0x5a, 0x1d,
   0x00, 0x00, 0xe0, 0xee, 0x1c, 0x00, 0x00, 0xe0, 0x00, 0x1c, 0x00, 0x00,
   0xe0, 0xff, 0x1f, 0x00, 0x00, 0xe0, 0xff, 0x1f, 0x00, 0x00, 0xe0, 0xff,
   0x1f, 0x00, 0x00, 0xe0, 0xff, 0x1f, 0x00, 0x00, 0xe0, 0xff, 0x1f, 0x00,
   0x00, 0xe0, 0xff, 0x1f, 0x00, 0x00, 0xe0, 0xff, 0x1f, 0x00, 0x00, 0xe0,
   0xff, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
#define ob6_width 40
#define ob6_height 40
static char ob6_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0xff,
   0xff, 0xff, 0x3f, 0xfc, 0xff, 0xff, 0xff, 0x3f, 0x0c, 0x00, 0x00, 0x00,
   0x30, 0x0c, 0x00, 0x18, 0x00, 0x30, 0x0c, 0x00, 0x18, 0x00, 0x30, 0x0c,
   0x00, 0x18, 0x00, 0x30, 0x0c, 0x06, 0x00, 0x00, 0x30, 0x0c, 0x0e, 0x00,
   0x00, 0x30, 0x0c, 0x1c, 0x00, 0x00, 0x30, 0x0c, 0x38, 0x00, 0x00, 0x30,
   0x0c, 0x70, 0x00, 0x00, 0x30, 0x0c, 0xe0, 0x00, 0x00, 0x30, 0x0c, 0xc0,
   0x01, 0x00, 0x30, 0x0c, 0x80, 0x03, 0x00, 0x30, 0x0c, 0x00, 0x07, 0x00,
   0x30, 0x0c, 0x00, 0x0e, 0x00, 0x30, 0xec, 0x00, 0x1c, 0x00, 0x37, 0xec,
   0x00, 0x3e, 0x00, 0x37, 0x0c, 0x00, 0x1c, 0x00, 0x30, 0x0c, 0x00, 0x1c,
   0x00, 0x30, 0x0c, 0x00, 0x1c, 0x00, 0x30, 0x0c, 0x00, 0x1c, 0x00, 0x30,
   0x0c, 0x00, 0x1c, 0x00, 0x30, 0x0c, 0x00, 0x1c, 0x00, 0x30, 0x0c, 0x00,
   0x1c, 0x00, 0x30, 0x0c, 0x00, 0x08, 0x00, 0x30, 0x0c, 0x00, 0x00, 0x00,
   0x30, 0x0c, 0x00, 0x00, 0x00, 0x30, 0x0c, 0x00, 0x00, 0x00, 0x30, 0x0c,
   0x00, 0x00, 0x00, 0x30, 0x0c, 0x00, 0x18, 0x00, 0x30, 0x0c, 0x00, 0x18,
   0x00, 0x30, 0x0c, 0x00, 0x18, 0x00, 0x30, 0x0c, 0x00, 0x00, 0x00, 0x30,
   0xfc, 0xff, 0xff, 0xff, 0x3f, 0xfc, 0xff, 0xff, 0xff, 0x3f, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
#define ob7_width 40
#define ob7_height 40
static char ob7_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0x01, 0x00, 0x00, 0x00, 0xf0,
   0x03, 0x00, 0x00, 0x00, 0xf8, 0x03, 0x00, 0x00, 0x00, 0xfc, 0x03, 0x00,
   0x00, 0x00, 0xff, 0x03, 0x00, 0x00, 0x80, 0xff, 0x01, 0x00, 0x00, 0xc0,
   0xff, 0x00, 0x00, 0x00, 0xe0, 0x7f, 0x00, 0x00, 0x00, 0xf0, 0x7f, 0x00,
   0x00, 0x00, 0xf8, 0x3f, 0x00, 0x00, 0x00, 0xf0, 0x1f, 0x00, 0x00, 0x00,
   0xe0, 0x0f, 0x00, 0x00, 0x00, 0xd0, 0x0f, 0x00, 0x00, 0x00, 0x48, 0x07,
   0x00, 0x00, 0x00, 0x24, 0x02, 0x00, 0x00, 0x00, 0x12, 0x00, 0x00, 0x00,
   0x00, 0x09, 0x00, 0x00, 0x00, 0x80, 0x04, 0x00, 0x00, 0x00, 0x40, 0x02,
   0x00, 0x00, 0x00, 0x20, 0x01, 0x00, 0x00, 0x00, 0x90, 0x00, 0x00, 0x00,
   0x00, 0x48, 0x00, 0x00, 0x00, 0x00, 0x24, 0x00, 0x00, 0x00, 0x00, 0x13,
   0x00, 0x00, 0x00, 0x80, 0x08, 0x00, 0x00, 0x00, 0x40, 0x04, 0x00, 0x00,
   0x00, 0x20, 0x04, 0x00, 0x00, 0x00, 0x40, 0x02, 0x00, 0x00, 0x00, 0x80,
   0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};


/***********************************************************************/


/*               Flow starting soon blocks */




/***********************************************************************/
#define flowst_width 40
#define flowst_height 40
static char flowst_bits[] = {
   0xf0, 0xff, 0xff, 0xff, 0x0f, 0xf0, 0xff, 0xff, 0xff, 0x0f, 0xf0, 0xff,
   0xff, 0xff, 0x0f, 0xf0, 0xff, 0xff, 0xff, 0x0f, 0xf0, 0xff, 0xff, 0xff,
   0x0f, 0xf0, 0xff, 0xff, 0xff, 0x0f, 0xf0, 0xff, 0xff, 0xff, 0x0f, 0xf0,
   0xff, 0xff, 0xff, 0x0f, 0xf0, 0xff, 0xff, 0xff, 0x0f, 0xf0, 0xff, 0xff,
   0xff, 0x0f, 0xf0, 0xff, 0xff, 0xff, 0x0f, 0xf0, 0xff, 0xff, 0xff, 0x0f,
   0xf0, 0xff, 0xff, 0xff, 0x0f, 0xf0, 0xff, 0xff, 0xff, 0x0f, 0xf0, 0xff,
   0xff, 0xff, 0x0f, 0xf0, 0xff, 0xff, 0xff, 0x0f, 0xf0, 0xff, 0xff, 0xff,
   0x0f, 0xf0, 0xff, 0xff, 0xff, 0x0f, 0xf0, 0xff, 0xff, 0xff, 0x0f, 0xf0,
   0xff, 0xff, 0xff, 0x0f, 0xf0, 0xd0, 0xc7, 0x7d, 0x0f, 0xf0, 0xde, 0xbb,
   0x7d, 0x0f, 0xf0, 0xde, 0xbb, 0x7d, 0x0f, 0xf0, 0xd8, 0xbb, 0x7d, 0x0f,
   0xf0, 0xde, 0xbb, 0x6d, 0x0f, 0xf0, 0xde, 0xbb, 0x6d, 0x0f, 0xf0, 0x1e,
   0xc6, 0x93, 0x0f, 0xf0, 0xff, 0xff, 0xff, 0x0f, 0x30, 0x04, 0xe3, 0x18,
   0x0c, 0xb0, 0xdf, 0x5d, 0x77, 0x0f, 0xb0, 0xdf, 0x5d, 0x77, 0x0f, 0x30,
   0xdc, 0x5d, 0x78, 0x0f, 0xf0, 0xdd, 0x41, 0x7d, 0x0f, 0xf0, 0xdd, 0x5d,
   0x7b, 0x0f, 0x30, 0xdc, 0x5d, 0x77, 0x0f, 0xf0, 0xff, 0xff, 0xff, 0x0f,
   0xf0, 0xff, 0xff, 0xff, 0x0f, 0xf0, 0xff, 0xff, 0xff, 0x0f, 0xf0, 0xff,
   0xff, 0xff, 0x0f, 0xf0, 0xff, 0xff, 0xff, 0x0f};

#define fbar_width 40
#define fbar_height 40
static char fbar_bits[] = {
   0x30, 0x30, 0x00, 0x18, 0x0c, 0x30, 0x30, 0x00, 0x18, 0x0c, 0x30, 0x30,
   0x00, 0x18, 0x0c, 0x30, 0x30, 0x00, 0x18, 0x0c, 0x30, 0x3c, 0x00, 0x18,
   0x0c, 0x30, 0x30, 0x00, 0x18, 0x0c, 0x30, 0x30, 0x00, 0x18, 0x0c, 0x30,
   0x30, 0x00, 0x18, 0x0c, 0x30, 0x30, 0x00, 0x18, 0x0c, 0x30, 0x3c, 0x00,
   0x18, 0x0c, 0x30, 0x30, 0x00, 0x18, 0x0c, 0x30, 0x30, 0x00, 0x18, 0x0c,
   0x30, 0x30, 0x00, 0x18, 0x0c, 0x30, 0x30, 0x00, 0x18, 0x0c, 0x30, 0x3c,
   0x00, 0x18, 0x0c, 0x30, 0x30, 0x00, 0x18, 0x0c, 0x30, 0x30, 0x00, 0x18,
   0x0c, 0x30, 0x30, 0x00, 0x18, 0x0c, 0x30, 0x30, 0x00, 0x18, 0x0c, 0x30,
   0x3c, 0x00, 0x18, 0x0c, 0x30, 0x30, 0x00, 0x18, 0x0c, 0x30, 0x30, 0x00,
   0x18, 0x0c, 0x30, 0x30, 0x00, 0x18, 0x0c, 0x30, 0x30, 0x00, 0x18, 0x0c,
   0x30, 0x3c, 0x00, 0x18, 0x0c, 0x30, 0x30, 0x00, 0x18, 0x0c, 0x30, 0x30,
   0x00, 0x18, 0x0c, 0x30, 0x30, 0x00, 0x18, 0x0c, 0x30, 0x30, 0x00, 0x18,
   0x0c, 0x30, 0x3c, 0x00, 0x18, 0x0c, 0x30, 0x30, 0x00, 0x18, 0x0c, 0x30,
   0x30, 0x00, 0x18, 0x0c, 0x30, 0x30, 0x00, 0x18, 0x0c, 0x30, 0x30, 0x00,
   0x18, 0x0c, 0x30, 0x3c, 0x00, 0x18, 0x0c, 0x30, 0x30, 0x00, 0x18, 0x0c,
   0x30, 0x30, 0x00, 0x18, 0x0c, 0x30, 0x30, 0x00, 0x18, 0x0c, 0x30, 0x30,
   0x00, 0x18, 0x0c, 0x30, 0x3c, 0x00, 0x18, 0x0c};


#define fbar1_width 40
#define fbar1_height 40
static char fbar1_bits[] = {
   0x30, 0x30, 0x00, 0x18, 0x0c, 0x30, 0x30, 0x00, 0x18, 0x0c, 0x30, 0x30,
   0x00, 0x18, 0x0c, 0x30, 0x30, 0x00, 0x18, 0x0c, 0x30, 0x3c, 0x00, 0x18,
   0x0c, 0x30, 0x30, 0x00, 0x18, 0x0c, 0x30, 0x30, 0x00, 0x18, 0x0c, 0x30,
   0x30, 0x00, 0x18, 0x0c, 0x30, 0x30, 0x00, 0x18, 0x0c, 0x30, 0x3c, 0x00,
   0x18, 0x0c, 0x30, 0x30, 0x00, 0x18, 0x0c, 0x30, 0x30, 0x00, 0x18, 0x0c,
   0x30, 0x30, 0x00, 0x18, 0x0c, 0x30, 0x30, 0x00, 0x18, 0x0c, 0x30, 0x3c,
   0x00, 0x18, 0x0c, 0x30, 0x30, 0x00, 0x18, 0x0c, 0x30, 0x30, 0x00, 0x18,
   0x0c, 0x30, 0x30, 0x00, 0x18, 0x0c, 0x30, 0x30, 0x00, 0x18, 0x0c, 0x30,
   0xbc, 0xff, 0x1b, 0x0c, 0x30, 0xb0, 0xff, 0x1b, 0x0c, 0x30, 0xb0, 0xff,
   0x1b, 0x0c, 0x30, 0xb0, 0xff, 0x1b, 0x0c, 0x30, 0xb0, 0xff, 0x1b, 0x0c,
   0x30, 0xbc, 0xff, 0x1b, 0x0c, 0x30, 0xb0, 0xff, 0x1b, 0x0c, 0x30, 0xb0,
   0xff, 0x1b, 0x0c, 0x30, 0xb0, 0xff, 0x1b, 0x0c, 0x30, 0xb0, 0xff, 0x1b,
   0x0c, 0x30, 0xbc, 0xff, 0x1b, 0x0c, 0x30, 0xb0, 0xff, 0x1b, 0x0c, 0x30,
   0xb0, 0xff, 0x1b, 0x0c, 0x30, 0xb0, 0xff, 0x1b, 0x0c, 0x30, 0xb0, 0xff,
   0x1b, 0x0c, 0x30, 0xbc, 0xff, 0x1b, 0x0c, 0x30, 0xb0, 0xff, 0x1b, 0x0c,
   0x30, 0xb0, 0xff, 0x1b, 0x0c, 0x30, 0xb0, 0xff, 0x1b, 0x0c, 0x30, 0xb0,
   0xff, 0x1b, 0x0c, 0x30, 0xbc, 0xff, 0x1b, 0x0c};

#define fbar2_width 40
#define fbar2_height 40
static char fbar2_bits[] = {
   0x30, 0xb0, 0xff, 0x1b, 0x0c, 0x30, 0xb0, 0xff, 0x1b, 0x0c, 0x30, 0xb0,
   0xff, 0x1b, 0x0c, 0x30, 0xb0, 0xff, 0x1b, 0x0c, 0x30, 0xbc, 0xff, 0x1b,
   0x0c, 0x30, 0xb0, 0xff, 0x1b, 0x0c, 0x30, 0xb0, 0xff, 0x1b, 0x0c, 0x30,
   0xb0, 0xff, 0x1b, 0x0c, 0x30, 0xb0, 0xff, 0x1b, 0x0c, 0x30, 0xbc, 0xff,
   0x1b, 0x0c, 0x30, 0xb0, 0xff, 0x1b, 0x0c, 0x30, 0xb0, 0xff, 0x1b, 0x0c,
   0x30, 0xb0, 0xff, 0x1b, 0x0c, 0x30, 0xb0, 0xff, 0x1b, 0x0c, 0x30, 0xbc,
   0xff, 0x1b, 0x0c, 0x30, 0xb0, 0xff, 0x1b, 0x0c, 0x30, 0xb0, 0xff, 0x1b,
   0x0c, 0x30, 0xb0, 0xff, 0x1b, 0x0c, 0x30, 0xb0, 0xff, 0x1b, 0x0c, 0x30,
   0xbc, 0xff, 0x1b, 0x0c, 0x30, 0xb0, 0xff, 0x1b, 0x0c, 0x30, 0xb0, 0xff,
   0x1b, 0x0c, 0x30, 0xb0, 0xff, 0x1b, 0x0c, 0x30, 0xb0, 0xff, 0x1b, 0x0c,
   0x30, 0xbc, 0xff, 0x1b, 0x0c, 0x30, 0xb0, 0xff, 0x1b, 0x0c, 0x30, 0xb0,
   0xff, 0x1b, 0x0c, 0x30, 0xb0, 0xff, 0x1b, 0x0c, 0x30, 0xb0, 0xff, 0x1b,
   0x0c, 0x30, 0xbc, 0xff, 0x1b, 0x0c, 0x30, 0xb0, 0xff, 0x1b, 0x0c, 0x30,
   0xb0, 0xff, 0x1b, 0x0c, 0x30, 0xb0, 0xff, 0x1b, 0x0c, 0x30, 0xb0, 0xff,
   0x1b, 0x0c, 0x30, 0xbc, 0xff, 0x1b, 0x0c, 0x30, 0xb0, 0xff, 0x1b, 0x0c,
   0x30, 0xb0, 0xff, 0x1b, 0x0c, 0x30, 0xb0, 0xff, 0x1b, 0x0c, 0x30, 0xb0,
   0xff, 0x1b, 0x0c, 0x30, 0xbc, 0xff, 0x1b, 0x0c};

/***********************************************************************/


/*                    Misc Blocks                                      */



/***********************************************************************/

#define bar_width 40
#define bar_height 40
static char bar_bits[] = {
   0xf0, 0xff, 0xff, 0xff, 0x0f, 0xf0, 0xff, 0xff, 0xff, 0x0f, 0xf0, 0xff,
   0xff, 0xff, 0x0f, 0xf0, 0xff, 0xff, 0xff, 0x0f, 0xf0, 0xff, 0xff, 0xff,
   0x0f, 0xf0, 0xff, 0xff, 0xff, 0x0f, 0xf0, 0xff, 0xff, 0xff, 0x0f, 0xf0,
   0xff, 0xff, 0xff, 0x0f, 0xf0, 0xff, 0xff, 0xff, 0x0f, 0xf0, 0xff, 0xff,
   0xff, 0x0f, 0xf0, 0xff, 0xff, 0xff, 0x0f, 0xf0, 0xff, 0xff, 0xff, 0x0f,
   0xf0, 0xff, 0xff, 0xff, 0x0f, 0xf0, 0xff, 0xff, 0xff, 0x0f, 0xf0, 0xff,
   0xff, 0xff, 0x0f, 0xf0, 0xff, 0xff, 0xff, 0x0f, 0xf0, 0xff, 0xff, 0xff,
   0x0f, 0xf0, 0xff, 0xff, 0xff, 0x0f, 0xf0, 0xff, 0xff, 0xff, 0x0f, 0xf0,
   0xff, 0xff, 0xff, 0x0f, 0xf0, 0xff, 0xff, 0xff, 0x0f, 0xf0, 0xff, 0xff,
   0xff, 0x0f, 0xf0, 0xff, 0xff, 0xff, 0x0f, 0xf0, 0xff, 0xff, 0xff, 0x0f,
   0xf0, 0xff, 0xff, 0xff, 0x0f, 0xf0, 0xff, 0xff, 0xff, 0x0f, 0xf0, 0xff,
   0xff, 0xff, 0x0f, 0xf0, 0xff, 0xff, 0xff, 0x0f, 0xf0, 0xff, 0xff, 0xff,
   0x0f, 0xf0, 0xff, 0xff, 0xff, 0x0f, 0xf0, 0xff, 0xff, 0xff, 0x0f, 0xf0,
   0xff, 0xff, 0xff, 0x0f, 0xf0, 0xff, 0xff, 0xff, 0x0f, 0xf0, 0xff, 0xff,
   0xff, 0x0f, 0xf0, 0xff, 0xff, 0xff, 0x0f, 0xf0, 0xff, 0xff, 0xff, 0x0f,
   0xf0, 0xff, 0xff, 0xff, 0x0f, 0xf0, 0xff, 0xff, 0xff, 0x0f, 0xf0, 0xff,
   0xff, 0xff, 0x0f, 0xf0, 0xff, 0xff, 0xff, 0x0f};

#define arrow_width 40
#define arrow_height 40
static char arrow_bits[] = {
   0xf0, 0xff, 0xff, 0xff, 0x0f, 0xf0, 0xbb, 0xe8, 0x82, 0x0f, 0xf0, 0xb3,
   0x5e, 0xef, 0x0f, 0xf0, 0xab, 0xbc, 0xef, 0x0f, 0xf0, 0x9b, 0x5e, 0xef,
   0x0f, 0xf0, 0xbb, 0xe8, 0xee, 0x0f, 0xf0, 0xff, 0xff, 0xff, 0x0f, 0xf0,
   0xff, 0xff, 0xff, 0x0f, 0xf0, 0xff, 0xff, 0xff, 0x0f, 0xf0, 0x7f, 0x00,
   0xfe, 0x0f, 0xf0, 0x7f, 0x00, 0xfe, 0x0f, 0xf0, 0x7f, 0x00, 0xfe, 0x0f,
   0xf0, 0x7f, 0x00, 0xfe, 0x0f, 0xf0, 0x7f, 0x00, 0xfe, 0x0f, 0xf0, 0x7f,
   0x00, 0xfe, 0x0f, 0xf0, 0x7f, 0x00, 0xfe, 0x0f, 0xf0, 0x7f, 0x00, 0xfe,
   0x0f, 0xf0, 0x7f, 0x00, 0xfe, 0x0f, 0xf0, 0x7f, 0x00, 0xfe, 0x0f, 0xf0,
   0x7f, 0x00, 0xfe, 0x0f, 0xf0, 0x7f, 0x00, 0xfe, 0x0f, 0xf0, 0x7f, 0x00,
   0xfe, 0x0f, 0xf0, 0x7f, 0x00, 0xfe, 0x0f, 0xf0, 0x7f, 0x00, 0xfe, 0x0f,
   0xf0, 0x7f, 0x00, 0xfe, 0x0f, 0xf0, 0x7f, 0x00, 0xfe, 0x0f, 0xf0, 0x7f,
   0x00, 0xfe, 0x0f, 0x30, 0x00, 0x00, 0x00, 0x0c, 0x70, 0x00, 0x00, 0x00,
   0x0e, 0xf0, 0x01, 0x00, 0x80, 0x0f, 0xf0, 0x03, 0x00, 0xc0, 0x0f, 0xf0,
   0x07, 0x00, 0xe0, 0x0f, 0xf0, 0x0f, 0x00, 0xf0, 0x0f, 0xf0, 0x3f, 0x00,
   0xfc, 0x0f, 0xf0, 0x7f, 0x00, 0xfe, 0x0f, 0xf0, 0xff, 0x00, 0xff, 0x0f,
   0xf0, 0xff, 0xc3, 0xff, 0x0f, 0xf0, 0xff, 0xe7, 0xff, 0x0f, 0xf0, 0xff,
   0xff, 0xff, 0x0f, 0xf0, 0xff, 0xff, 0xff, 0x0f};

#define empty_width 40
#define empty_height 40
static char empty_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0xff,
   0xff, 0xff, 0x3f, 0x04, 0x00, 0x00, 0x00, 0x20, 0x04, 0x00, 0x00, 0x00,
   0x20, 0x04, 0x00, 0x00, 0x00, 0x20, 0x04, 0x00, 0x00, 0x00, 0x20, 0x04,
   0x00, 0x00, 0x00, 0x20, 0x04, 0x00, 0x00, 0x00, 0x20, 0x04, 0x00, 0x00,
   0x00, 0x20, 0x04, 0x00, 0x00, 0x00, 0x20, 0x04, 0x00, 0x00, 0x00, 0x20,
   0x04, 0x00, 0x00, 0x00, 0x20, 0x04, 0x00, 0x00, 0x00, 0x20, 0x04, 0x00,
   0x00, 0x00, 0x20, 0x04, 0x00, 0x00, 0x00, 0x20, 0x04, 0x00, 0x00, 0x00,
   0x20, 0x04, 0x00, 0x00, 0x00, 0x20, 0x04, 0x00, 0x00, 0x00, 0x20, 0x04,
   0x00, 0x00, 0x00, 0x20, 0x04, 0x00, 0x00, 0x00, 0x20, 0x04, 0x00, 0x00,
   0x00, 0x20, 0x04, 0x00, 0x00, 0x00, 0x20, 0x04, 0x00, 0x00, 0x00, 0x20,
   0x04, 0x00, 0x00, 0x00, 0x20, 0x04, 0x00, 0x00, 0x00, 0x20, 0x04, 0x00,
   0x00, 0x00, 0x20, 0x04, 0x00, 0x00, 0x00, 0x20, 0x04, 0x00, 0x00, 0x00,
   0x20, 0x04, 0x00, 0x00, 0x00, 0x20, 0x04, 0x00, 0x00, 0x00, 0x20, 0x04,
   0x00, 0x00, 0x00, 0x20, 0x04, 0x00, 0x00, 0x00, 0x20, 0x04, 0x00, 0x00,
   0x00, 0x20, 0x04, 0x00, 0x00, 0x00, 0x20, 0x04, 0x00, 0x00, 0x00, 0x20,
   0x04, 0x00, 0x00, 0x00, 0x20, 0xfc, 0xff, 0xff, 0xff, 0x3f, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

#define start_width 40
#define start_height 40
static char start_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x03, 0x00, 0x80,
   0xff, 0xff, 0x07, 0x00, 0xe0, 0xff, 0xff, 0x07, 0x00, 0xf0, 0xff, 0xff,
   0x0f, 0x00, 0xf8, 0xff, 0xff, 0x1f, 0x00, 0xfc, 0xff, 0xff, 0x3f, 0x00,
   0xfe, 0xff, 0xff, 0x3f, 0x80, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff,
   0xff, 0xff, 0xe0, 0xff, 0xff, 0xff, 0xff, 0xf0, 0xff, 0xff, 0xff, 0xff,
   0xf8, 0xff, 0xff, 0xff, 0xff, 0xfc, 0xff, 0x03, 0x00, 0x00, 0xfc, 0xff,
   0x03, 0x00, 0x00, 0xfc, 0xff, 0x03, 0x00, 0x00, 0x7c, 0xf0, 0x03, 0x00,
   0x00, 0x7c, 0xff, 0x03, 0x00, 0x00, 0x7c, 0xff, 0x03, 0x00, 0x00, 0x7c,
   0xf0, 0x03, 0x00, 0x00, 0xfc, 0xf7, 0x03, 0x00, 0x00, 0xfc, 0xf7, 0x03,
   0x00, 0x00, 0x7c, 0xf0, 0x03, 0x00, 0x00, 0xfc, 0xff, 0x03, 0x00, 0x00,
   0xfc, 0xff, 0x03, 0x00, 0x00, 0xfc, 0xff, 0x03, 0x00, 0x00, 0xfc, 0xff,
   0x03, 0x00, 0x00, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xf0, 0xff, 0xff, 0xff,
   0xff, 0xe0, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0x80,
   0xff, 0xff, 0xff, 0xff, 0x00, 0xff, 0xff, 0xff, 0x3f, 0x00, 0xfc, 0xff,
   0xff, 0x3f, 0x00, 0xf8, 0xff, 0xff, 0x1f, 0x00, 0xf0, 0xff, 0xff, 0x0f,
   0x00, 0xe0, 0xff, 0xff, 0x07, 0x00, 0x80, 0xff, 0xff, 0x07, 0x00, 0x00,
   0xff, 0xff, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00};
#define startfull_width 40
#define startfull_height 40
static char startfull_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x03, 0x00, 0x80,
   0xff, 0xff, 0x07, 0x00, 0xe0, 0xff, 0xff, 0x07, 0x00, 0xf0, 0xff, 0xff,
   0x0f, 0x00, 0xf8, 0xff, 0xff, 0x1f, 0x00, 0xfc, 0xff, 0xff, 0x3f, 0x00,
   0xfe, 0xff, 0xff, 0x3f, 0x80, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff,
   0xff, 0xff, 0xe0, 0xff, 0xff, 0xff, 0xff, 0xf0, 0xff, 0xff, 0xff, 0xff,
   0xf8, 0xff, 0xff, 0xff, 0xff, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xfc, 0xff,
   0xff, 0xff, 0xff, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xfc, 0xff, 0xff, 0xff,
   0xff, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xfc,
   0xff, 0xff, 0xff, 0xff, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xfc, 0xff, 0xff,
   0xff, 0xff, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xfc, 0xff, 0xff, 0xff, 0xff,
   0xfc, 0xff, 0xff, 0xff, 0xff, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xfc, 0xff,
   0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xf0, 0xff, 0xff, 0xff,
   0xff, 0xe0, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0x80,
   0xff, 0xff, 0xff, 0xff, 0x00, 0xff, 0xff, 0xff, 0x3f, 0x00, 0xfc, 0xff,
   0xff, 0x3f, 0x00, 0xf8, 0xff, 0xff, 0x1f, 0x00, 0xf0, 0xff, 0xff, 0x0f,
   0x00, 0xe0, 0xff, 0xff, 0x07, 0x00, 0x80, 0xff, 0xff, 0x07, 0x00, 0x00,
   0xff, 0xff, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00};

#define block_width 40
#define block_height 40
