/*
version: $Id: hshgen_h.h,v 5.123 1995/01/18 01:24:58 hitman Exp $
purpose: Definition of constants and pre compiler define statements, also all externals for the main kernel
function.
updates: All updates are handled by RCS
*/

#ifndef __HSHGEN_H_H
#define __HSHGEN_H_H

/****************************************************************/
/* Definitions for state transactions.                          */
#define TABLEND         -1
#define RET_AGAIN       -2
#define RET_NORMAL      0
#define RET_ERROR1      1
#define RET_ERROR2      2

/****************************************************************/
/* Quickys to save me some time. */
#define TURN    Channel[0].Control

/****************************************************************/
/* Boolean definitions. */
#ifndef TRUE
#define TRUE            1
#endif /* TRUE */
#ifndef FALSE
#define FALSE           0
#endif /* FALSE */

/****************************************************************/
/* Maximums and Minimiums. */
#define MAXCHANNEL       0
 /* The maximum number of user channels. */
 /* This number determines how many people are can use at one time, plus one channel for system, and one channel for the system master, then leftover channels are for
 processes. */

#define MAXCHANNELNAME  10
 /* Most channels are named so if a user lists out current processes you have something to tell them.  */

/****************************************************************/
/* Who is controlling the character. */
#define COMPUTER        0	/* Definition of a computer for control.*/
#define HUMAN           1	/* Definition of a human for control.   */

/****************************************************************/
/* Controls for Activities.  When you quit the program has to   */
/*      decide what to do with your character. */ 
/*
		type
		of
		activity        value
		~~~~~~~~        ~~~~~*/
#define IDLE            0
 /****************************************************************/
 /* Input and Output constants. */ 
#define INPUT                   1
#define OUTPUT                  2
#define RUNNING                 3

/****************************************************************/
/* QuestionStatus. */
#define NEUTRAL         0
#define YES                     1
#define NO                      2
#define NOANSWER        3
#define FORFEIT         4
#define ANSWERED        5

/****************************************************************/
/* Define a few ACSII characters. */
#define RETURN          13
#define ESC             27
#define SPACE           (int) ' '
#define BACKSPACE       (int) '\b'

#endif /* __HSHGEN_H_H */
