#ifndef	_MASTER_H_
#define	_MASTER_H_	"$Header: /private/postgres/src/lib/H/support/RCS/master.h,v 1.5 1992/06/10 05:08:19 mer Exp $"

/*
 *	Structure definitions for the postmaster
 */

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <sys/wait.h>
#include <sys/time.h>
#include <sys/resource.h>

/* The following expansions are done by the postmaster */
/* '~' expands into the home direcotory of postgres */
/* '&' expands into the directory of a database */
/* '%' expands into the directory of global data */

#define	DEF_PORT	4321
#define	DEF_LOGLVL	0
#define	DEF_BIN		"~/bin/postgres"
#define	DefaultVacuumDemonPath	"~/bin/vacuumd"

struct	bcommon {
	char	user[16];	/* users name */
	short	pid;		/* process number of backend */
	short	debuglvl;	/* debug level */
	long	key;		/* process' key */
};

/* kai: I could not find any fuction, which uses struct backend, but the
   field ecode is disliked by gcc, as union wait seemes to be defined
   nowhere */
#if 0
struct	backend	{
	struct	bcommon	bcomm;	/* data both backend and postmaster need */
	char	database[64];	/* path to database */
	char	globdata[64];	/* path to global data */
	char	tty[16];	/* users terminal */
	char	options[16];	/* options to pass to backend */
	char	dblog[64];	/* per database log file */
	char	back[64];	/* file using as binary */
	struct	sockaddr_in sin; /* address of datagram port of backend */
	struct	rusage	ruse;	/* resource use */
	union	wait	ecode;	/* exit status place holder */
	struct	backend	*next, *last;
};
#endif

struct	dpacket	{
	long	len;		/* packet length */
	long	key;		/* process' key */
	short	pid;		/* process num */
	short	type;		/* packet type */
	char	data[1000];	/* packet data */
};

#endif
