#ifndef	_ALIGN_H_
#define	_ALIGN_H_	"$Header: /private/postgres/src/lib/H/tmp/RCS/align.h,v 1.5 1991/06/18 23:28:24 cimarron Exp $"

/*
 *	align.h		- alignment macros
 */

/*
 *	SHORTALIGN(LEN)	- length (or address) aligned for shorts
 */
#define	SHORTALIGN(LEN)\
	(((long)(LEN) + 1) & ~01)

/*
 *	LONGALIGN(LEN)	- length (or address) aligned for longs
 */
#if defined(sun) && ! defined(sparc)
#define	LONGALIGN(LEN)	SHORTALIGN(LEN)
#else 
#define	LONGALIGN(LEN)\
	(((long)(LEN) + 3) & ~03)
#endif

/* ----------------
 *	the reverse alignment macros are for use with the executor
 *	shared memory allocator's ExecSMHighAlloc routine which
 *	allocates memory from the high-area "down" to the low-area.
 *	In this case we need alignment in the "other" direction than
 *	provided by SHORTALIGN and LONGALIGN
 * ----------------
 */
#define	REVERSESHORTALIGN(LEN)\
    (((long)(LEN)) & ~01)

#if defined(sun) && ! defined(sparc)
#define	REVERSELONGALIGN(LEN)	REVERSESHORTALIGN(LEN)
#else
#define	REVERSELONGALIGN(LEN)\
    (((long)(LEN)) & ~03)
#endif

#endif
