/*
 * clib.h --
 *	Standard C library definitions.
 *
 * Note:
 *	This file is OPERATING SYSTEM dependent!!!
 *
 * Identification:
 *	$Header: /private/postgres/src/lib/H/tmp/RCS/clib.h,v 1.3 1991/11/14 19:38:34 kemnitz Exp $
 */

#ifndef	CLibIncluded	/* Include this file only once. */
#define CLibIncluded	1

#ifdef NOTDEF
#include "tmp/c.h"

/* ----------------
 *	stuff from old libc.h file:
 * ----------------
 */
extern char
	*memccpy(),
	*memchr(),
	*memcpy(),
	*memset();
extern int memcmp();

/* ----------------
 *	LibCCopyLength is only used within this file. -cim 6/12/90
 * ----------------
 */
typedef int	LibCCopyLength;

/*
 * memccpy --
 *	memory(3)
 */
extern
char *
memccpy ARGS((
	const String		toBuffer,
	const String		fromBuffer,
	const char		stopCharacter,
	const LibCCopyLength	length
));

/*
 * memchr --
 *	memory(3)
 */
extern
char *
memchr ARGS((
	const String		buffer,
	const char		stopCharacter,
	const LibCCopyLength	length
));

/*
 * memchr --
 *	memory(3)
 */
extern
int
memcmp ARGS((
	const String		buffer1,
	const String		buffer2,
	const LibCCopyLength	length
));

/*
 * memcpy --
 *	memory(3)
 */
extern
char *
memcpy ARGS((
	const String		toBuffer,
	const String		fromBuffer,
	const LibCCopyLength	length
));

/*
 * memset --
 *	memory(3)
 */
extern
char *
memset ARGS((
	const String		toBuffer,
	const char		value,
	const LibCCopyLength	length
));

/* ----------------
 *	end of libc.h
 * ----------------
 */

typedef 	CLibCopyLength;

/*
 * MemoryCopy --
 *	Copies fixed length block of memory to another.
 */
#define MemoryCopy(toBuffer, fromBuffer, length)\
    memcpy(toBuffer, fromBuffer, length)

#endif
#endif	/* !defined(CLibIncluded) */
