/*
 * oset.h --
 *	Fixed format ordered set definitions.
 *
 * Note:
 *	Fixed format ordered sets are <EXPLAIN>.
 *	XXX This is a preliminary version.  Work is needed to explain
 *	XXX semantics of the external definitions.  Otherwise, the
 *	XXX functional interface should not change.
 *
 * Identification:
 *	$Header: /private/postgres/src/lib/H/tmp/RCS/oset.h,v 1.5 1990/08/17 08:54:48 cimarron Exp $
 */

#ifndef	OSetIncluded		/* Include this only once */
#define OSetIncluded	1

#include "tmp/c.h"

typedef struct OrderedElemData OrderedElemData;
typedef OrderedElemData* OrderedElem;

typedef struct OrderedSetData OrderedSetData;
typedef OrderedSetData* OrderedSet;

struct OrderedElemData {
	OrderedElem	next;	/* Next elem or &this->set->dummy	*/
	OrderedElem	prev;	/* Previous elem or &this->set->head	*/
	OrderedSet	set;	/* Parent set				*/
};

struct OrderedSetData {
	OrderedElem	head;	/* First elem or &this->dummy		*/
	OrderedElem	dummy;	/* (hack) Terminator == NULL		*/
	OrderedElem	tail;	/* Last elem or &this->head		*/
	Offset		offset;	/* Offset from struct base to elem	*/
	/* this could be signed short int! */
};

/*
 * OrderedSetInit --
 */
extern
void
OrderedSetInit ARGS((
	OrderedSet	set,
	Offset		offset
));

/*
 * OrderedElemInit --
 */
extern
void
OrderedElemInit ARGS((
	OrderedElem	elem,
	OrderedSet	set
));

/*
 * OrderedSetContains --
 *	True iff ordered set contains given element.
 */
extern
bool
OrderedSetContains ARGS((
	OrderedSet	set,
	OrderedElem	elem
));

/*
 * OrderedSetGetHead --
 */
extern
Pointer
OrderedSetGetHead ARGS((
	OrderedSet	set
));

/*
 * OrderedSetGetTail --
 */
extern
Pointer
OrderedSetGetTail ARGS((
	OrderedSet	set
));

/*
 * OrderedElemGetPredecessor --
 */
extern
Pointer
OrderedElemGetPredecessor ARGS((
	OrderedElem	elem
));

/*
 * OrderedElemGetSuccessor --
 */
extern
Pointer
OrderedElemGetSuccessor ARGS((
	OrderedElem	elem
));

/*
 * OrderedElemPop --
 */
extern
void
OrderedElemPop ARGS((
	OrderedElem	elem
));

/*
 * OrderedElemPushInto --
 */
extern
void
OrderedElemPushInto ARGS((
	OrderedElem	elem,
	OrderedSet	set
));

/*
 * OrderedElemPush --
 */
extern
void
OrderedElemPush ARGS((
	OrderedElem	elem
));

/*
 * OrderedElemPushHead --
 */
extern
void
OrderedElemPushHead ARGS((
	OrderedElem	elem
));

/*
 * OrderedElemPushTail --
 */
extern
void
OrderedElemPushTail ARGS((
	OrderedElem	elem
));

/*
 * OrderedElemPushAfter --
 */
extern
void
OrderedElemPushAfter ARGS((
	OrderedElem	elem,
	OrderedElem	oldElem
));

/*
 * OrderedElemPushBefore --
 */
extern
void
OrderedElemPushBefore ARGS((
	OrderedElem	elem,
	OrderedElem	oldElem
));

/*
 * OrderedSetPop --
 */
extern
Pointer
OrderedSetPop ARGS((
	OrderedSet	set
));

/*
 * OrderedSetPopHead --
 */
extern
Pointer
OrderedSetPopHead ARGS((
	OrderedSet	set
));

/*
 * OrderedSetPopTail --
 */
extern
Pointer
OrderedSetPopTail ARGS((
	OrderedSet	set
));

#endif	/* !defined(OSetIncluded) */
