/*
 * excid.h --
 *	POSTGRES known exception identifier definitions.
 */

#ifndef	ExcIdIncluded		/* Include this file only once */
#define ExcIdIncluded	1

/*
 * Identification:
 */
#define EXCID_H	"$Header: /private/postgres/src/lib/H/utils/RCS/excid.h,v 1.5 1990/08/17 08:53:58 cimarron Exp $"

#include "tmp/c.h"
#include "utils/exc.h"	/* for Exception */

/*
 * Nonrecoverable Exceptions
 *
 *	Exceptions which cannot be recovered.  The system is dead.
 */
/* none? */

/*
 * Recoverable (Fail-Fast) Exceptions
 *
 *	Exceptions which can be recovered by resetting the system.
 */

/*
 * Generic Recoverable Exceptions
 */

/*
 * FailedAssertion --
 *	Indicates an Assert(...) failed.
 */
extern Exception FailedAssertion;

/*
 * BadState --
 *	Indicates a function call request is inconsistent with module state.
 */
extern Exception BadState;

/*
 * BadArg --
 *	Indicates a function call argument or arguments is out-of-bounds.
 */
extern Exception BadArg;

/*
 * Specific Recoverable Exceptions
 */

/*
 * BadAllocSize --
 *	Indicates that an allocation request is of unreasonable size.
 */
extern Exception BadAllocSize;


/*
 * Retryable (Abort-Transaction) Exceptions
 *
 *	Exceptions which need only cause the current transaction to abort.
 */

/*
 * ExhaustedMemory --
 *	Indicates an dynamic memory allocation failed.
 */
extern Exception ExhaustedMemory;

/*
 * Unimplemented --
 *	Indicates a function call request requires unimplemented code.
 */
extern Exception Unimplemented;

/*
 * Parser Exceptions
 *
 *	Exceptions generated by the parser.  These should be renamed and
 * merged in with the exceptions generated by other parts of the system.
 */

/*
 *  --
 */
extern Exception CatalogFailure;	/* XXX inconsistent naming style */

/*
 * --
 */
extern Exception InternalError;		/* XXX inconsistent naming style */

/*
 *  --
 */
extern Exception SemanticError;		/* XXX inconsistent naming style */

/*
 *  --
 */
extern Exception SystemError;		/* XXX inconsistent naming style */

#endif	/* !defined(ExcIdIncluded) */
