/*
 * os.h --
 *	Operating system definitions.
 *
 * Note:
 *	This file is OPERATING SYSTEM dependent!!!
 *
 * Identification:
 *	$Header: /private/postgres/src/lib/H/tmp/RCS/os.h,v 1.6 1990/08/17 08:54:47 cimarron Exp $
 */

#ifndef	OSIncluded		/* Include this file only once */
#define OSIncluded	1

#include "tmp/c.h"
#include "tmp/unix.h"	/* UNIX operating system definitions */

/*
 * SystemPort --
 *	Unbuffered system I/O port.
 */
typedef HostSystemPort	SystemPort;

/*
 * SystemFileMode --
 *	File mode.
 */
typedef HostSystemFileMode	SystemFileMode;

/*
 * SystemByteCount --
 *	Number of bytes--used in calls to read, write, etc.
 */
typedef HostSystemByteCount	SystemByteCount;

/*
 * SystemFilePosition --
 *	Number of bytes from beginning of file.
 */
typedef HostSystemFilePosition	SystemFilePosition;

/*
 * SystemFileOffset --
 *	Number of offset bytes for lseek.
 */
typedef HostSystemFileOffset	SystemFileOffset;

/*
 * SystemTime --
 *	Time in seconds.
 */
typedef HostSystemTime	SystemTime;

/*
 * open --
 *	open(2)
 */
extern
SystemPort
OpenSystemPortFile ARGS((
	const String		path,
	const int		flags,
	const SystemFileMode	mode
));

/*
 * close --
 *	close(2)
 */
extern
void
CloseSystemPort ARGS((
	const SystemPort	port
));

/*
 * read --
 *	read(2)
 *
 * Note:
 *	String may not be proper usage here.
 */
extern
SystemByteCount
SystemPortRead ARGS((
	const SystemPort	port,
	const String		buffer,
	const SystemByteCount	numberBytes
));

/*
 * write --
 *	write(2)
 *
 * Note:
 *	String may not be proper usage here.
 */
extern
SystemByteCount
SystemPortWrite ARGS((
	const SystemPort	port,
	const String		buffer,
	const SystemByteCount	numberBytes
));

/*
 * lseek --
 *	lseek(2)
 */
extern
SystemFilePosition
SystemPortSeek ARGS((
	const SystemPort	port,
	const SystemFileOffset	offset,
	const int		whence
));

/*
 * GetSystemTime --
 *	Returns system time.
 */
SystemTime
GetSystemTime ARGS((
	void
));

/*
 * PointerIsToStaticData --
 * PointerIsToDynamicData --
 *	True iff pointer points to memory allocated at compile-time or
 *	run-time, respectively.
 *
 * Note:
 *	This is compiler and operating system dependent.
 *	Look in "unix.h", etc. for the appropriate definition.
 */

#endif	/* !defined(OSIncluded) */
