/*
 * unix.h --
 *	UNIX operating system definitions.
 *
 * Note:
 *	This file is for the Sun UNIX OPERATING SYSTEM 3.4 or 3.5 or 3.6!!!
 *
 * Identification:
 *	$Header: /private/postgres/src/lib/H/tmp/RCS/unix.h,v 1.7 1990/11/14 08:34:11 kemnitz Exp $
 */

#ifndef	UNIXIncluded		/* Include this file only once */
#define UNIXIncluded	1

#include <sys/types.h>

#include "tmp/c.h"

/*
 * HostSystemPort --
 *	Unbuffered system I/O port.
 */
typedef int	HostSystemPort;

/*
 * HostSystemFileMode --
 *	File mode.
 */
typedef int	HostSystemFileMode;

/*
 * HostSystemByteCount --
 *	Number of bytes--used in calls to read, write, etc.
 */
typedef int	HostSystemByteCount;

/*
 * HostSystemFilePosition --
 *	Number of bytes from beginning of file.
 */
typedef long	HostSystemFilePosition;

/*
 * HostSystemFileOffset --
 *	Number of offset bytes for lseek.
 */
typedef long	HostSystemFileOffset;

/*
 * HostSystemTime --
 *	Time in seconds from the UNIX epoch.
 */
typedef time_t	HostSystemTime;

/*
 * open --
 *	open(2)
 */
extern
HostSystemPort
open ARGS((
	const String			path,
	const int			flags,
	const HostSystemFileMode	mode
));

/*
 * close --
 *	close(2)
 */
extern
void
close ARGS((
	const HostSystemPort	port
));

/*
 * read --
 *	read(2)
 *
 * Note:
 *	String may not be proper usage here.
 */
extern
HostSystemByteCount
read ARGS((
	const HostSystemPort		port,
	const String			buffer,
	const HostSystemByteCount	numberBytes
));

/*
 * write --
 *	write(2)
 *
 * Note:
 *	String may not be proper usage here.
 */
extern
HostSystemByteCount
write ARGS((
	const HostSystemPort		port,
	const String			buffer,
	const HostSystemByteCount	numberBytes
));

/*
 * lseek --
 *	lseek(2)
 */
extern
HostSystemFilePosition
lseek ARGS((
	const HostSystemPort		port,
	const HostSystemFileOffset	offset,
	const int			whence
));

/*
 * time --
 *	time(3)
 */
extern
HostSystemTime
time ARGS((
	HostSystemTime	*tloc
));

/*
 * These tests can be made more strict given a particular compiler.
 *
 * XXX Someday, this should go into the compiler port directory.
 */
#ifndef	__SABER__
#define PointerIsToDynamicData(pointer)	((bool)((char *)(pointer) >= end))
#define PointerIsToStaticData(pointer)	((bool)((char *)(pointer) < end))
#else
#define PointerIsToDynamicData(pointer)	(true)
#define PointerIsToStaticData(pointer)	(true)
#endif

#endif	/* !defined(UNIXIncluded) */
