/*
 * item/internal.h --
 *	Internal definitions.
 *
 * Identification:
 *	$Header: /private/postgres/src/storage/page/RCS/internal.h,v 1.5 1991/04/28 09:14:32 cimarron Exp $
 */

#ifndef	InternalIncluded	/* Include this file only once. */
#define InternalIncluded	1

#include "tmp/c.h"

#include "storage/part.h"

/*
 * PagePartitionGetNumberOfPageBits --
 *	Returns the number of bits needed to represent a page.
 */
#define PagePartitionGetNumberOfPageBits(partition)	(partition)

/*
 * PagePartitionGetNumberOfOffsetBits --
 *	Returns the number of bits needed to represent a offset.
 */
#define PagePartitionGetNumberOfOffsetBits(partition)\
	(16 - PagePartitionGetNumberOfPageBits(partition))

/*
 * PageNumberMask --
 *	Mask for a page number.
 */
#define PageNumberMask(partition)\
	(0xffff & (0xffff << PagePartitionGetNumberOfOffsetBits(partition)))

/*
 * OffsetNumberMask --
 *	Mask for an offset number.
 */
#define OffsetNumberMask(partition)\
	(0xffff >> PagePartitionGetNumberOfPageBits(partition))

#endif	/* !defined(InternalIncluded) */
