/*h---------------------------------------------------------------------------+
|   keys.h                                                                    |
+-----------------------------------------------------------------------------+
|                                                                             |
|   Description: FPTED -> Default key mappings.				      |
|                                                                             |
|   Contact: Fernando Joaquim Ganhao Pereria (fjp@minerva.inesc.pt)           |
|                                                                             |
|   Dependences: Some of this keys aren't accessible in some keyboards.       |
|                                                                             |
|   Notes: (Should verify compatibility between PREF and curses key codes)    |
|                                                                             |
+----------------------------------------------------------------------------*/

#ifndef _FPTED_KEYS
#define _FPTED_KEYS

#define PREF_KEY	'\013'			/* '^K' */
#define PREF		4*1024

#define K_INSOVR	'\017'			/* '^O' */
#define K_INDENT	(PREF+'\017')		/* '^O' */
#define K_COMPLET	(PREF+'o')		/* 'o'  */
#define K_MOUSE		(PREF+'O')		/* 'O'  */
#define K_MATCH		'\07'			/* '^G' */
#define K_CENTER	(PREF+'\07')		/* '^G' */
#define K_DELCHAR	'\04'			/* '^D' */
#define K_DELSEL	(PREF+'\04')		/* '^D' */
#define K_COPYCHAR	'\03'			/* '^C' */
#define K_SENSIT	(PREF+'c')		/* 'c'  */
#define K_COPYSEL	(PREF+'\03')		/* '^C' */
#define K_PASTE		'\020'			/* '^P' */
#define K_PIPE		(PREF+'\020')		/* '^P' */
#define K_MARK		'\030'			/* '^X' */
#define K_EXMARK	(PREF+'\030')		/* '^]' */
#define K_REPEAT	'\022'			/* '^R' */
#define K_PREVB		(PREF+'\022')		/* '^R' */
#define K_SEARCH	'\016'			/* '\n' */
#define K_SUBST		(PREF+'\016')		/* '^N' */
#define K_FNEXT		(PREF+'n')		/* 'n'  */
#define K_FPREV		(PREF+'N')		/* 'N'  */
#define K_REFRESH	'\f'			/* '^L' */
#define K_PREVSCR	'\02'			/* '^B' */
#define K_BOF		(PREF+'\02')		/* '^B' */
#define K_NEXTSCR	'\06'			/* '^F' */
#define K_EOF		(PREF+'\06')		/* '^F' */
#define K_UNCTRL	'\026'			/* '^V' */
#define K_DEFKEY	(PREF+'\026')		/* '^V' */
#define K_KILL		'\031'			/* '^Y' */
#define K_DELTO		(PREF+'\031')		/* '^Y' */
#define K_SAVE		'\032'			/* '^Z' */
#define K_EXIT		(PREF+'\032')		/* '^Z' */
#define K_WORD		'\027'			/* '^W' */
#define K_DELWORD	(PREF+'\027')		/* '^W' */
#define K_BWORD		'\024'			/* '^T' */
#define K_DELBWORD	(PREF+'\024')		/* '^T' */
#define K_UNDO		'\025'			/* '^U' */
#define K_NEXTB		(PREF+'\025')		/* '^U' */
#define K_HOME		'\01'			/* '^A' */
#define K_DELBOL	(PREF+'\01')		/* '^A' */
#define K_EOL		'\05'			/* '^E' */
#define K_DELEOL	(PREF+'\05')		/* '^E' */
#define K_DOWN		(PREF+'\n')		/* '^J' */
#define K_LEFT		(PREF+'\010')		/* '^H' */
#define K_RIGHT		(PREF+'\f')		/* '^L' */
#define K_UP		(PREF+'\013')		/* '^K' */
#define K_ENTER		'\r'
#define K_RETURN	'\r'
#define K_RSHIFT	(PREF+K_RETURN)
#define K_BSPACE	'\b'
#define K_DELETE	127
#define K_LSHIFT	(PREF+K_DELETE)
#define K_ESCAPE	'\033'
#define K_MENU		K_ESCAPE
#define K_COMMAND	(PREF+K_MENU)
#define K_NULL		'\0'
#define K_TAB		'\t'
#define K_ALIAS 	K_TAB
#define K_EXPAND 	(PREF+K_TAB)
#define K_HELP		(PREF+'H')		/* '^H' */
#define K_CHCASE	'\n'			/* '^J' */
#define K_AGAIN		'\037'			/* '^_' */

#ifdef VT_TERM

 /* If your keyboard generates ^[OA instead of ^[[A when pressing the UP   */
 /* arroy key you should use (1<<8) instead of (2<<8).                     */

#define ARROW_KEY_ENCODER (2<<8)

 /* Don't worry with several possible compilation warnings in this section */
#define KEY_UP		(ARROW_KEY_ENCODER+'A')
#define KEY_DOWN	(ARROW_KEY_ENCODER+'B')
#define KEY_RIGHT	(ARROW_KEY_ENCODER+'C')
#define KEY_LEFT	(ARROW_KEY_ENCODER+'D')


#endif /* VT_TERM */

#define MOUSE_EVENT	((2<<8)+'M')


#endif /* _FPTED_KEYS */


