#ifndef __TURBOC__
#ifndef LINT
static char filer_module[] = "@(#)filer.c       1.2 12/2/90";
#endif
#endif

/*{{{  includes*/
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include "inmos.h"
#include "globals.h"
#include "misc.h"
#include "oriedt.h"
#include "edtutil.h"
#include "macros.h"
#include "filer.h"
/*}}}  */
/*{{{  externs*/
extern char *strdup P((char *));
extern int P_argc;
extern char **P_argv;
/*}}}  */
/*{{{  defines*/
#define MAX_BASEPATHS	50
#ifdef __TURBOC__
#  define INIT_BASEPATH ".\\"
#else
#  define INIT_BASEPATH "./"
#endif
/*}}}  */
/*{{{  locals*/
int bfile_no = 0, bfile_last = 0;
buffer buff;   /*should have 1 for each file*/
PRIVATE int the_pos;
static char *base_path[MAX_BASEPATHS];
static int  current_basepath = -1;
/*}}}  */
/*{{{  prototypes*/
PRIVATE void expand_filename P((char *, char *));
PRIVATE int P_eof P((FILE *));
PRIVATE void get_dsp_file P((LOC_file *));
PRIVATE void create_node P((LOC_file *));
PRIVATE void read_b P((uchar *, LOC_file *));
PRIVATE void read_tag P((int *, int *, LOC_file *));
PRIVATE void read_string P((char *, LOC_file *));
PRIVATE void connect_fold P((LOC_file *));
PRIVATE void start_a_fold P((int, int, LOC_file *));
PRIVATE void read_a_list P((int, LOC_file *));
PRIVATE void read_fold P((int *, BOOL, LOC_file *));
PRIVATE BOOL read_tds P((LOC_file *));
PRIVATE BOOL find_dialect P((char *));
PRIVATE void get_the_pos P((char *, LOC_file *));
/*}}}  */
/*{{{F filer.h*/
/*:::F filer.h*/
/*}}}  */

/*{{{  PRIVATE void expand_filename(char *fname, *expname)*/
PRIVATE void expand_filename(fname, expname)
char *fname, *expname;
{
    *expname = '\0';
    if (*fname != *FILE_SEPARATOR)
        /* relative filename, expand with current base */
        strcat(expname, base_path[current_basepath]);
    strcat(expname, fname);
}
/*}}}  */
/*{{{  void split_filename(char *fname, *path, *name)*/
void split_filename(fname, path, name)
char *fname, *path, *name;
{
    int i = strlen(fname) - 1;

    while (i >= 0 && fname[i] != *FILE_SEPARATOR)
	i--;
    if (path) {
        if (i < 0) {
            strcpy(path, ".");
            strcat(path, FILE_SEPARATOR);
        }
        else {
    	    strcpy(path, fname);
	    path[i+1] = '\0';
       }
    }
    if (name)
	strcpy(name, fname + (i+1));
}
/*}}}  */
/*{{{  void init_basepath(char *path)*/
void init_basepath(path)
char *path;
{

    while (current_basepath >= 0)
        pop_basepath();
    base_path[++current_basepath] =
	strdup((path == NULL) ? INIT_BASEPATH : path);
}
/*}}}  */
/*{{{  int push_basepath(char *fname)*/
int push_basepath(fname)
char *fname;
{
    int i;
    char buf[MAX_FIELD_SIZE + 1];

    if (current_basepath == (MAX_BASEPATHS-1)) {
        fprintf(stderr, "too many nested filed folds\n");
        die_a_quick_death(0,0);
    }
    expand_filename(fname, buf);
    i = strlen(buf);
    while (buf[i] != *FILE_SEPARATOR)
      i--;
    buf[i+1] = '\0';
    if ((base_path[++current_basepath] = strdup(buf)) == NULL) {
        fprintf(stderr, "not enough memory\n");
        die_a_quick_death(0,0);
    }

    return 0;
}
/*}}}  */
/*{{{  void pop_basepath(void)*/
void pop_basepath()
{
    if (current_basepath < 0) {
        fprintf(stderr, "basepath stack underflow\n");
        die_a_quick_death(0, 0);
    }
    free(base_path[current_basepath--]);
}
/*}}}  */
/*{{{  COMMENT void print_basepath(void)*/
/*void print_basepath()*/
/*{*/
    /*message(base_path[current_basepath]);*/
/*}*/
/*}}}  */


/*{{{  PRIVATE int P_eof(FILE *f)*/
PRIVATE int P_eof(f)
FILE *f;
{
  int ch;

  if (feof(f))
    return 1;
  if (f == stdin)
    return 0;    /* not safe to look-ahead on the keyboard! */
  ch = getc(f);
  if (ch == EOF)
    return 1;
  (void) ungetc(ch, f);
  return 0;
}
/*}}}  */
/*{{{  char *file_info(char *s)*/
char *file_info(s)
char *s;
{
    int i;
    FILE *f;
    static char fname[MAX_FIELD_SIZE + 1];

    i = strpos2(s, " ", 1);
    if (i > 0)
        s[i-1] = '\0';
    expand_filename(s, fname);
    file_exists = FALSE;
    can_open = FALSE;
    if ((f = fopen (fname,"r")) != NULL) {
        file_exists = TRUE;
        can_open = TRUE;
        fclose (f);
        return fname;
    }
    else if ((f = fopen (fname,"w")) != NULL) {
        can_open = TRUE;
        fclose (f);
        unlink (fname);
        return fname;
    }

    return fname;
}
/*}}}  */
/*{{{  void proc_error(int b)*/
void proc_error(b)
int b;
{
  switch (b) {   /*case*/

  case 0:
    message("line is not a simple fold!!");
    executing_macro = FALSE;
    break;

  case 1:
    message("not at top");
    executing_macro = FALSE;
    break;
  }
}
/*}}}  */
/*{{{  BOOL normal_att(element *p)*/
BOOL normal_att(p)
element *p;
{
  return (p->UU.U1.fold_type == 0 && p->UU.U1.fold_contents == 1);
}
/*}}}  */


/*{{{  PRIVATE void get_dsp_file(LOC_file *LINK)*/
PRIVATE void get_dsp_file(LINK)
LOC_file *LINK;
{
  char path[MAX_FIELD_SIZE + 1],
       name[MAX_FIELD_SIZE + 1];

  if (param_count > 0) {
    strcpy(LINK->filename, P_argv[param_count]);
    param_count = 0;
  }
  else
    readprompt(LINK->filename, "filename", 60);
  split_filename(LINK->filename, path, name);
  strcpy(LINK->filename, name);
  init_basepath(path);
}
/*}}}  */
/*{{{  PRIVATE void create_node(LOC_file *LINK)*/
PRIVATE void create_node(LINK)
LOC_file *LINK;
{
  element *pt;

  proc_new(&pt);
  copy_line_to_parts(LINK->dsp_line, &pt);
  if (LINK->trailing == NULL)
    pt->UU.U1.indent = LINK->new_indent;
  join_links(LINK->current, pt);
  LINK->current = pt;
}
/*}}}  */
/*{{{  PRIVATE void read_b(uchar *b,LOC_file *LINK)*/
PRIVATE void read_b(b, LINK)
uchar *b;
LOC_file *LINK;
{
  bfile_no++;
  if (bfile_no >= bfile_last) {
    bfile_last = fread((char *)buff, 1, sizeof(uchar) * 512, LINK->tdsfile);
    bfile_no = 0;
  }
  *b = buff[bfile_no];
}
/*}}}  */
/*{{{  PRIVATE void read_tag(int *tag,int *value,LOC_file *LINK)*/
PRIVATE void read_tag(tag, value, LINK)
int *tag, *value;
LOC_file *LINK;
{
  uchar b;

  *value = 0;
  do {
    read_b(&b, LINK);
    *tag = b >> 6;
    *value = ((*value) << 6) + (b & 63);
  } while (*tag == 3);
}
/*}}}  */
/*{{{  PRIVATE void read_string(char *s, LOC_file *LINK)*/
PRIVATE void read_string(s, LINK)
char *s;
LOC_file *LINK;
{
  int i, tag, value;
  uchar b;

  read_tag(&tag, &value, LINK);
  if (tag != 0) {
    sprintf(s, "%d", value);
    return;
  }
  s[value] = '\0';
  /* p2c: edtio.pas, line 133:
   * Note: Modification of string length may translate incorrectly [146]
   */
  for (i = 0; i < value; i++) {
    read_b(&b, LINK);
    s[i] = b;
  }
}
/*}}}  */
/*{{{  PRIVATE void connect_fold(LOC_file *LINK)*/
PRIVATE void connect_fold(LINK)
LOC_file *LINK;
{
  if (LINK->trailing == NULL)
    return;
  LINK->S = LINK->trailing;
  join_links(LINK->current, LINK->S->other_end);
  LINK->current = LINK->S->other_end;
  LINK->current->other_end = LINK->S;
  LINK->trailing = LINK->S->fold;
  LINK->S->fold = LINK->S->next;
  LINK->S->other_end = LINK->current;
  LINK->S->foldline = LINK->current->foldline;   /*start*/
  /* _fold or _filed */
  current_ind -= LINK->S->UU.U1.fold_indent;
  LINK->current->foldline = END_FOLD;
  LINK->current = LINK->S;
}
/*}}}  */
/*{{{  PRIVATE void start_a_fold(uchar start_,int indent,LOC_file *LINK)*/
PRIVATE void start_a_fold(start_, indent, LINK)
int start_;
int indent;
LOC_file *LINK;
{
  copy_line_to_parts(LINK->dsp_line, &LINK->current);
  LINK->current->UU.U1.fold_indent = indent;
  current_ind += indent;
  LINK->current->fold = LINK->trailing;
  LINK->trailing = LINK->current;
  proc_new(&LINK->current->other_end);
  LINK->current->other_end->foldline = start_;
}
/*}}}  */
/*{{{  PRIVATE void read_a_list(int indent,LOC_file *LINK)*/
PRIVATE void read_a_list(indent, LINK)
int indent;
LOC_file *LINK;
{
  int i, tag, value;
  uchar b;

  do {
    read_tag(&tag, &value, LINK);
    switch (tag) {

    case 0:   /*record tag*/
      LINK->dsp_line[value] = '\0';
      /* p2c: edtio.pas, line 218:
       * Note: Modification of string length may translate incorrectly [146]
       */
      for (i = 0; i < value; i++) {
        read_b(&b, LINK);
        LINK->dsp_line[i] = b;
      }
      create_node(LINK);
      break;

    case 2:   /*function tag*/
      switch (value) {

      case 2:   /*startfold*/
        read_fold(&indent, FALSE, LINK);
        break;

      case 4:   /*startfiled*/
        read_fold(&indent, TRUE, LINK);
        break;
      }
      break;
    }
  } while (tag != 2 || value != 1);
}
/*}}}  */
/*{{{  PRIVATE void read_fold(int *indent,BOOL filed, LOC_file *LINK)*/
PRIVATE void read_fold(indent, filed, LINK)
int *indent;
BOOL filed;
LOC_file *LINK;
{
  char buf[MAX_FIELD_SIZE + 1];
  int tag, value, t, c, i, extra_indent;
  element *WITH;
  /*{{{  COMMENT old comment handling part 1*/
  /*int comment_fold = 0;*/
  /*}}}  */

  /*{{{  COMMENT old comment handling part 2*/
  /*do {*/
    /*if (comment_fold) {*/
      /*read_tag(&tag, &value, LINK); / * start list * /*/
      /*read_tag(&tag, &value, LINK); / * start fold * /*/
    /*}*/
    /*read_tag(&tag, &value, LINK);   / * startlist * /*/
    /*read_string(buf, LINK);*/
    /*read_tag(&tag, &t, LINK);*/
    /*read_tag(&tag, &c, LINK);*/
    /*read_tag(&tag, &i, LINK);*/
    /*read_tag(&tag, &value, LINK);   / * should be endlist * /*/
    /*if (!comment_fold) {*/
      /*strcpy(LINK->dsp_line, buf);*/
      /*extra_indent = i;*/
    /*}*/
    /*comment_fold++;*/
  /*} while (strncmp(skip_spaces(buf), COMMENT_MSG, strlen(COMMENT_MSG)) == 0);*/
  /*}}}  */
  /*{{{  new comment handling*/
  read_tag(&tag, &value, LINK);   /*startlist*/
  read_string(buf, LINK);
  read_tag(&tag, &t, LINK);
  read_tag(&tag, &c, LINK);
  read_tag(&tag, &i, LINK);
  read_tag(&tag, &value, LINK);   /*should be endlist*/
  strcpy(LINK->dsp_line, buf);
  extra_indent = i;
  /*}}}  */
  create_node(LINK);
  if (filed)
    start_a_fold(START_FILED, extra_indent, LINK);
  else
    start_a_fold(START_FOLD, extra_indent, LINK);
  if (filed) {
    read_string(LINK->dsp_line, LINK);
    copy_line_to_parts(LINK->dsp_line, &LINK->trailing->other_end);
  }
  else
    read_a_list(*indent + extra_indent, LINK);
  /*{{{  COMMENT old comment handling part 3*/
  /*while (--comment_fold) {*/
    /*/ * cleanup the mess * /*/
    /*read_tag(&tag, &value, LINK);   / * end fold * /*/
    /*read_tag(&tag, &value, LINK);   / * end list * /*/
  /*}*/
  /*}}}  */
  read_tag(&tag, &value, LINK);   /* endfold or endfiled */
  connect_fold(LINK);
  WITH = LINK->current;
  WITH->UU.U1.fold_type = t;
  WITH->UU.U1.fold_contents = c;
}
/*}}}  */
/*{{{  PRIVATE BOOL read_tds(LOC_file *LINK)*/
PRIVATE BOOL read_tds(LINK)
LOC_file *LINK;
{
  int tag, value;
  BOOL tds;

  tds = TRUE;
  bfile_no = bfile_last;
  read_tag(&tag, &value, LINK);
  if (tag == 2 && value == 0) {
    dialect = NO_LANGUAGES;
    read_a_list(0, LINK);
  }
  else
    tds = FALSE;
  if (LINK->tdsfile != NULL)
    (void) fclose(LINK->tdsfile);
  LINK->tdsfile = NULL;
  return tds;
}
/*}}}  */
/*{{{  PRIVATE BOOL find_dialect(char *ss)*/
PRIVATE BOOL find_dialect(ss)
char *ss;
{
  char s[MAX_FIELD_SIZE + 1];
  int i;
  BOOL b;
  char STR1[MAX_FIELD_SIZE + 1];

  b = TRUE;
  strcpy(s, ss);
  i = first_char(s);
  if (i > strlen(s)) {
    dialect = 0;
    return b;
  }
  b = FALSE;
  strcpy(s, copy_to_end(STR1, s, i));
  /* trailing_spaces(s);  Take begin of comment literally Sun 6/May/92 */
  for (i = 1; i < NO_LANGUAGES; i++) {
    if ((strlen(s) == strlen(dialect_start[i])) &&
        (strpos2(dialect_start[i], s, 1) == 1)) {
      dialect = i;
      b = TRUE;
    }
  }
  return b;
}
/*}}}  */
/*{{{  PRIVATE void get_the_pos(char *str,LOC_file *LINK)*/
PRIVATE void get_the_pos(str, LINK)
char *str;
LOC_file *LINK;
{
  int i;
  char STR1[256];
  char STR2[MAX_FIELD_SIZE + 1];

  the_pos = strpos2(LINK->dsp_line, str, 1);
  if (the_pos <= 0)
    return;
  sprintf(STR1, "%.*s", the_pos - 1, LINK->dsp_line);
  if (!find_dialect(STR1)) {
    the_pos = 0;
    return;
  }
  strcpy(LINK->dsp_line,
         copy_to_end(STR2, LINK->dsp_line, the_pos + strlen(str)));
  i = first_char(LINK->dsp_line);
  if (i <= strlen(LINK->dsp_line))
    strcpy(LINK->dsp_line, copy_to_end(STR2, LINK->dsp_line, i));
  i = strlen(LINK->dsp_line) - strlen(dialect_end[dialect]);
  if (i > 0) {
    LINK->dsp_line[i] = '\0';
    /* p2c: edtio.pas, line 266:
     * Note: Modification of string length may translate incorrectly [146] */
  }
  else
    LINK->dsp_line[0] = '\0';
  the_pos -= strlen(dialect_start[dialect]);
}
/*}}}  */
/*{{{  void insert_file(element *file_ptr,element *prec_ptr,element *next_ptr,BOOL remember_file)*/
void insert_file(file_ptr, prec_ptr, next_ptr, remember_file)
element *file_ptr, *prec_ptr, *next_ptr;
BOOL remember_file;
{
  LOC_file V;
  BOOL add_c;
  int marker_pos, i, j;
  char STR1[74];
  char STR2[256];
  char *TEMP, *full_name;
  char STR3[MAX_FIELD_SIZE + 1];
  char STR4[6];
  char braces[7];

  V.tdsfile = NULL;
  V.current = prec_ptr;
  V.new_indent = insert_indent_of(next_ptr);
  /*{{{  open the file*/
  do {
    if (file_ptr == NULL)
      get_dsp_file(&V);
    else
      (void) line_of(V.filename, file_ptr);
  /*
    if (*V.filename == '\0' && remember_file)
      exit(0);
  */
    full_name = file_info(V.filename);
  } while ((!can_open) && (strlen(V.filename) > 0));
  strcpy(V.tdsfile_NAME, V.filename);
  /*}}}  */
  backup_file_made = 0;
  if ((strlen(V.filename) > 0) && file_exists) {   /*io=0*/
    if (V.tdsfile != NULL)
      V.tdsfile = freopen(full_name, "rb", V.tdsfile);
    else
      V.tdsfile = fopen(full_name, "rb");
    if (V.tdsfile==NULL) {
      P_ioresult = FileNotFound;
      die_a_quick_death(0,0);
    }
    else
      P_ioresult = 0;
    sprintf(STR1, "Loading %s", full_name);
    message(STR1);
    V.trailing = NULL;
    current_ind = 0;
    /*{{{  read the file*/
    if (!read_tds(&V)) {
      int comment_fold = 0;
    
      /*{{{  open file again*/
      strcpy(tstorefile_NAME, V.filename);
      if (tstorefile != NULL)
        tstorefile = freopen(full_name, "r", tstorefile);
      else
        tstorefile = fopen(full_name, "r");
      if (tstorefile==NULL) {
        P_ioresult = FileNotFound;
        die_a_quick_death(0,0);
      }
      else
        P_ioresult = 0;
      /*}}}  */
      while (!P_eof(tstorefile) && available(1)) {
        /*{{{  read line*/
        if (fgets(V.dsp_line, MAX_FIELD_SIZE + 1, tstorefile) == NULL)
          P_ioresult = EndOfFile;
        else
          P_ioresult = 0;
        TEMP = strchr(V.dsp_line, '\n');
        if (TEMP != NULL)
          *TEMP = 0;
        /*}}}  */
        /*{{{  look for dialect marker*/
        strcpy(braces, "{{{");  /* split the braces onto two lines, */
        strcat(braces, "}}}");  /* otherwise origami will find them with */
                                /* the next line !!!! */
        marker_pos = strpos2(V.dsp_line, braces, 1);
        if (marker_pos > 0) {
          trailing_spaces(V.dsp_line);
          dialect = NO_LANGUAGES - 1;
          sprintf(STR2, "%.*s", marker_pos - 1, V.dsp_line);
          strcpy(dialect_start[dialect], STR2);
          strcpy(dialect_end[dialect],
                 strsub(STR2, V.dsp_line, marker_pos + 6, strlen(V.dsp_line)));
          /*{{{  read line*/
          if (fgets(V.dsp_line, MAX_FIELD_SIZE + 1, tstorefile) == NULL) P_ioresult=EndOfFile;
          else P_ioresult=0;
          TEMP = strchr(V.dsp_line, '\n');
          if (TEMP != NULL)
            *TEMP = 0;
          /*}}}  */
        }
        /*}}}  */
        trailing_spaces(V.dsp_line);
        strcpy(V.dsp_line, tabbed_out(STR3, V.dsp_line));
        if (strlen(V.dsp_line) < current_ind)
          pad_(V.dsp_line, ' ', current_ind);
        /*{{{  FORTRAN stuff*/
        add_c = FALSE;
        if (upper(V.dsp_line[0]) == 'C') {
          i = strpos2(V.dsp_line, "C{{{", 1);
          j = strpos2(V.dsp_line, "C...", 1);
          if (dialect == fortran_ && current_ind > 0 || i > 1 || j > 1)
            V.dsp_line[0] = ' ';
          if (dialect == fortran_ && i == 0 && j == 0)
            add_c = TRUE;
        }
        /*}}}  */
        i = first_char(V.dsp_line);
        if (i <= current_ind)
          strcpy(V.dsp_line, copy_to_end(STR3, V.dsp_line, i));
        else
          strcpy(V.dsp_line, copy_to_end(STR3, V.dsp_line, current_ind + 1));
        /*{{{  more FORTRAN stuff*/
        if (add_c) {
          if (*V.dsp_line == '\0')
            strcpy(V.dsp_line, "C");
          else if (upper(V.dsp_line[0]) != 'C')
            strinsert("C ", V.dsp_line, 1);
        }
        /*}}}  */
        /*{{{  attributes*/
        get_the_pos(":::A", &V);
        if (the_pos > 0) {  /*read and save attributes*/
          if (V.trailing != NULL) {
            the_pos = strpos2(V.dsp_line, " ", 1);
            sprintf(STR2, "%.*s", the_pos - 1, V.dsp_line);
            i = (sscanf(STR2, "%d", &V.trailing->UU.U1.fold_type) == 0);
            i = (sscanf(copy_to_end(STR3, V.dsp_line, the_pos), "%d",
                        &V.trailing->UU.U1.fold_contents) == 0);
          }
          continue;
        }
        /*}}}  */
        /*{{{  a file name*/
        get_the_pos(":::F", &V);
        if (the_pos > 0) {  /*save filename*/
          if (V.trailing != NULL) {
            copy_line_to_parts(V.dsp_line, &V.trailing->other_end);
            if (V.trailing->UU.U1.fold_type != 0)
              connect_fold(&V);
          }
          continue;
        }
        /*}}}  */
        /*{{{  end of a fold*/
        get_the_pos("}}}", &V);
        if (the_pos > 0) {
          if (comment_fold > 0)
            comment_fold--;
          connect_fold(&V);
          continue;
        }
        /*}}}  */
        /*{{{  remove comments if comment fold*/
        if (strncmp(V.dsp_line + strlen(dialect_start[dialect]), "{{{", 3) != 0 &&
            comment_fold > 0) {
          char buf[MAX_FIELD_SIZE + 1];
          char *c_start = dialect_start[dialect];
          char *c_end = dialect_end[dialect];
          char *start = skip_spaces(V.dsp_line);
        
          if (strncmp(c_start, start, strlen(c_start)) == 0 &&
              strcmp(c_end, V.dsp_line + strlen(V.dsp_line) - strlen(c_end)) == 0) {
            int length, spaces;
        
            spaces = (int) (start - V.dsp_line);
            strncpy(buf, V.dsp_line, spaces);
            strcpy(buf + spaces, start + strlen(c_start));
            length = strlen(buf) - strlen(c_end);
            strncpy(V.dsp_line, buf, length);
            V.dsp_line[length] = '\0';
          }
        }
        /*}}}  */
        create_node(&V);
        sprintf(STR4, "%sF", fold_open_str);
        get_the_pos(STR4, &V);
        if (the_pos == 0)
          get_the_pos("...F", &V);
        if (the_pos > 0) {
          if (comment_fold > 0 ||
                  strncmp(skip_spaces(V.dsp_line), COMMENT_MSG, strlen(COMMENT_MSG)) == 0)
            comment_fold++;
          start_a_fold(START_FILED, the_pos - 1, &V);
        }
        else {
          get_the_pos(fold_open_str, &V);
          if (the_pos > 0) {
            if (comment_fold > 0 ||
                    strncmp(skip_spaces(V.dsp_line), COMMENT_MSG, strlen(COMMENT_MSG)) == 0)
              comment_fold++;
            start_a_fold(START_FOLD, the_pos - 1, &V);
          }
        }
    }
      if (tstorefile != NULL)
        (void) fclose(tstorefile);
      tstorefile = NULL;
    }
    /*}}}  */
    if (!available(1)) {
      message("not enough memory");
      exit(0);
    }
  }
  if (remember_file) {
    char name[MAX_FIELD_SIZE + 1];

    split_filename(V.filename, NULL, name);
    if (file_ptr == NULL)
      copy_line_to_parts(name, &prec_ptr);
    copy_line_to_parts(name, &next_ptr);
  }
  join_links(V.current, next_ptr);
  if (V.tdsfile != NULL)
    (void) fclose(V.tdsfile);
}
/*}}}  */
