/*
static char globals_h[] = "@(#)globals.h        1.2 12/2/90";
*/
#ifndef GLOBALS_H
#define GLOBALS_H

#ifdef GLOBALS_G
# define vextern
#else
# define vextern extern
#endif

#define version         "2.02"   /*modified by A.M. Henshaw & J.P.E. Sunter*/

#define MAX_FIELD_SIZE  256

#define DIAMOND "\004"

#define TITLE_LINE        2
#define MESSAGE_LINE      TITLE_LINE
#define OVERFLOW_LINE     1
#define SCREEN_LEN        (screen_lines-2) /*23 /*(W_dy-2) /* 23 */
#define SELECT_X          (W_dx-1) /* 79 */
#define NOT_FOLD          0
#define START_FILED       0x81
#define START_FOLD        0x82
#define END_FOLD          0x83
#define START_OPEN_FOLD   0x86
#define START_ENTER_FILED 0x87
#define START_ENTER_FOLD  0x88
#define MARKER_LEN        5
#define NO_LANGUAGES      8   /*(inc User-defined)+tds*/
#define START             1
#define LEN               (W_dx-3) /*77*/

#define COMMENT_MSG       "COMMENT"

typedef unsigned char uchar;
typedef uchar buffer[1024];

typedef char language_comment[NO_LANGUAGES + 1][35];

typedef int fields[2];

typedef struct element {
  char strng[MAX_FIELD_SIZE + 1];
  struct element *prec, *next, *fold, *other_end;
  BOOL selected;
  uchar foldline, fold_close_line;
  union {
    struct {
      int indent, fold_indent, fold_type, fold_contents;
    } U1;
    struct {
      int int1, int2;
    } U0;
  } UU;
} element;

typedef int key_conversion[3];
typedef key_conversion key_convert_lists[75];


#define null_dsp_line   ""

extern key_convert_lists key_convert_list;   /*field. again*/

extern BOOL file_changed, browse_mode, backup_file_made;

extern fields dsp_fields;

extern BOOL backup, select_on;

extern char deleted_ch;

vextern element *line_dsp_line, *part_line, *new_file_ptr;
vextern BOOL split_line;
vextern element *head, *tail, *current, *select_ptr, *screen_start,
                *screen_end, *null_item_ptr, *deleted_line_ptr,
                *buff_start_ptr, *buff_end_ptr, *real_head, *real_tail;
vextern int makefold_indent;
vextern element *move_ptr, *copy_ptr, *pick_ptr, *dispose_head, *dispose_tail,
                *pick_head, *pick_tail;
extern int cursor_level, screen_end_level;
extern char item_to_look_for[33], replace_item[33];
extern BOOL key_already_pressed;
extern char already_pressed_key;
extern BOOL already_pressed_keypad_key, screen_message;

extern language_comment dialect_start;

extern language_comment dialect_end;

extern uchar fortran_;

extern char language_string[NO_LANGUAGES + 1][11];

extern int dialect, dispose_size, enter_depth, enter_depth_spaces;
extern char fold_open_str[5];
extern char specials[9];
extern BOOL new_file, defining_macro, executing_macro;
extern int macro_count, macro_length;


struct LOC_flare2_program {
  char command_str[17];
  BOOL keypad;
  int cursor_x_pos;
} ;
typedef struct LOC_flare2_program LOC_flare;

struct LOC_field_edit {
  int *field_pos;
  char *field_str;
  BOOL field_key;
  int sect, full_len, ind;
} ;
typedef struct LOC_field_edit LOC_field;

struct LOC_insert_file {
  FILE *tdsfile;
  element *current, *trailing, *S;
  char filename[65];
  int new_indent;
  char dsp_line[MAX_FIELD_SIZE + 1];
  char tdsfile_NAME[120];
} ;
typedef struct LOC_insert_file LOC_file;

struct LOC_proc_exit {
  element *file_ptr, *p, *pn;
  char dsp_line[MAX_FIELD_SIZE + 1];
  FILE *tdsfile;
  char tdsfile_NAME[120];
} ;
typedef struct LOC_proc_exit LOC_proc;

vextern int old_dialect;
vextern FILE *tstorefile;
vextern int param_count, line_size, current_ind, first_edit_pos,
              pre_edit_pos;
vextern char current_dsp_line[MAX_FIELD_SIZE + 1],
             old_current_dsp_line[MAX_FIELD_SIZE + 1];
vextern char tstorefile_NAME[120];

vextern int P_ioresult, W_dy, W_oy,W_dx,screen_lines;
vextern BOOL file_exists, can_open;
vextern element *End_of_fold, *Start_of_fold, *Line_after_fold;

#undef vextern

void wrline P((char *));

#endif


