#ifndef __TURBOC__
#ifndef LINT
static char oriedt_module[] = "@(#)oriedt.c     1.1 10/30/90";
#endif
#endif
/*{{{  includes*/
#include <stdio.h>
#include <ctype.h>
#ifdef __TURBOC__
#include <conio.h>
#include <alloc.h>
#endif
#include "inmos.h"
#include "globals.h"
#include "misc.h"
#include "edtutil.h"
#include "macros.h"
#include "oriedt.h"
/*}}}  */
/*{{{F oriedt.h*/
/*:::F oriedt.h*/
/*}}}  */

/*{{{  int first_char(s)*/
int first_char(s)
char *s;
{
  BOOL completed;
  int i, l;

  l = strlen(s);
  i = 0;
  completed = FALSE;
  while (i < l && !completed) {
    i++;
    completed = (s[i - 1] != ' ');
  }
  if (completed)
    return i;
  else
    return (l + 1);
}
/*}}}  */
/*{{{  int last_char(s)*/
int last_char(s)
char *s;
{
  int i;

  i = strlen(s);
  while (s[i - 1] == ' ' && i > 0)
    i--;
  return i;
}
/*}}}  */
/*{{{  void trailing_spaces(s)*/
void trailing_spaces(s)
char *s;
{
  BOOL completed;

  completed = FALSE;
  do {
    if (*s != '\0') {
      if (isspace(s[strlen(s) - 1]))
	s[strlen(s) - 1] = '\0';
      else
	completed = TRUE;
    }
    else
      completed = TRUE;
  } while (!completed);
}
/*}}}  */
/*{{{  void join_links(p, q)*/
void join_links(p, q)
element *p, *q;
{
  p->next = q;
  q->prec = p;
  if (filed_or_fold(p))
    p->other_end->next = q;
}
/*}}}  */
/*{{{  void move_on(p)*/
void move_on(p)
element **p;
{
  if ((*p)->foldline == START_FOLD)
    *p = (*p)->fold;
  else
    *p = (*p)->next;
}
/*}}}  */
/*{{{  int insert_indent_of(p)*/
int insert_indent_of(p)
element *p;
{
  if (p->foldline == START_OPEN_FOLD)
    return (p->UU.U1.indent - p->UU.U1.fold_indent);
  else
    return (p->UU.U1.indent);
}
/*}}}  */
/*{{{  void close_fold_at(ptr)*/
void close_fold_at(ptr)
element *ptr;
{
  element *p;
  int i;

  p = ptr;
  if (p->foldline == START_OPEN_FOLD) {
    p->foldline = START_FOLD;
    p->fold = p->next;
    p->next = p->other_end->next;
    p->next->prec = p;
  }
  i = p->UU.U1.fold_indent;
  p->UU.U1.indent -= i;
  i += p->UU.U1.indent;
  p = p->fold;
  while (p->foldline != END_FOLD) {
    if (p->foldline == START_OPEN_FOLD)
      close_fold_at(p);
    p->UU.U1.indent -= i;
    p = p->next;
  }
  p->UU.U1.indent -= i;
}
/*}}}  */
/*{{{  int lines_within(p)*/
int lines_within(p)
element *p;
{
  element *q;
  int l;

  if (p->foldline != START_FOLD) {
    l = 1;
    return l;
  }
  l = 0;
  q = p;
  while (q != p->next) {
    l++;
    move_on(&q);
  }
  return l;
}
/*}}}  */
/*{{{  BOOL available(lines)*/
BOOL available(lines)
int lines;
{
  BOOL a;
  long l;

  l = dispose_size + maxavail() / line_size - lines - 2;   /* safety */
  a = (l >= 0L);
  if (l >= 200L) return a;
  if (a) {
    message("Running out of memory ");
    printf("%ld lines left", l);
  }
  else {
    message("Not enough memory to create lines. Need ");
    printf("%d but only have %ld lines left", lines, l + lines);
  }
  return a;
}
/*}}}  */
/*{{{  void proc_undispose(p)*/
void proc_undispose(p)
element **p;
{
  /* try harder to get back deleted line */

  if (dispose_head == dispose_tail) {
    *p = NULL;
    return;
  }
  *p = dispose_tail;
  dispose_size -= lines_within(*p);
  dispose_tail = (*p)->prec;
}
/*}}}  */
/*{{{  void proc_new(p)*/
void proc_new(p)
element **p;
{
  element *q;

  if (dispose_head != dispose_tail) {
    *p = dispose_head->next;
    if (filed_or_fold(*p)) {
      q = (*p)->other_end;
      (*p)->foldline = NOT_FOLD;
      q->foldline = NOT_FOLD;
      if (dispose_tail == *p)
        dispose_tail = q;
      (*p)->next = (*p)->fold;
    }
    if (dispose_tail == *p)
      dispose_tail = dispose_head;
    else
      join_links(dispose_head, (*p)->next);
    dispose_size--;
  }
  else
    *p = (element *) malloc(sizeof(element));
  **p = *null_item_ptr;
}
/*}}}  */
/*{{{  void proc_to_edit_pos()*/
void proc_to_edit_pos()
{
  element *WITH;

  WITH = current;
  pre_edit_pos = WITH->UU.U1.indent;
  first_edit_pos = pre_edit_pos + 1;
  if (filed_or_fold(current)) {
    pre_edit_pos = first_edit_pos + WITH->UU.U1.fold_indent;
    first_edit_pos = pre_edit_pos + MARKER_LEN;
  }
  if (WITH->foldline == START_OPEN_FOLD || WITH->foldline == START_ENTER_FOLD) {
    pre_edit_pos = 0;
    first_edit_pos += MARKER_LEN;
  }
  if (WITH->foldline == END_FOLD || WITH->foldline == START_ENTER_FILED) {
    pre_edit_pos = 0;
    first_edit_pos = 255;
  }
}
/*}}}  */
/*{{{  void proc_from_edit_pos()*/
void proc_from_edit_pos()
{
  element *WITH;

  WITH = current;
  if (filed_or_fold(current))
    WITH->UU.U1.fold_indent =
      strpos2(current_dsp_line, "...", 1) - WITH->UU.U1.indent - 1;
}
/*}}}  */
/*{{{  void copyin(line, p, full)*/
void copyin(line, p, full)
char *line;
element *p;
BOOL full;
{
        char            fold_str[17];
        int             ind;
        char            STR1[MAX_FIELD_SIZE + 1];
        char            STR2[174];

        ind = p->UU.U1.indent;
        copy_parts_to_line(p, line);
        if (p->foldline == END_FOLD)
                *line = '\0';
        if (full)
                trailing_spaces(line);
        if (p->foldline != NOT_FOLD) {
                if (filed_or_fold(p)) {
                        if (full && (p->foldline != START_FILED || p->UU.U1.fold_type != 1))
                                strcpy(fold_str, fold_open_str);
                        else
                                strcpy(fold_str, "...");
                        if (p->foldline == START_FILED)
                                strcat(fold_str, "F ");
                        else
                                strcat(fold_str, "  ");
                        ind += p->UU.U1.fold_indent;
                }
                if (dialect >= 0) {
                        switch (p->foldline) {
                        case START_OPEN_FOLD:
                        case START_ENTER_FOLD:
                                sprintf(fold_str, "%s  ", fold_open_str);
                                break;
                        case START_ENTER_FILED:
                                sprintf(fold_str, "%sF ", fold_open_str);
                                break;
                        case END_FOLD:
                                strcpy(fold_str, "}}}");
                                break;
                        }
                        if (full)
                                pad_(fold_str, ' ', 5);
                        else
                                pad_(fold_str, '\0', 5);
                        if (full)
                                strinsert(dialect_start[dialect], fold_str, 1);
                } else
                        *fold_str = '\0';
        } else
                *fold_str = '\0';
        sprintf(STR2, "%s%s", spaces(STR1, ind), fold_str);
        strinsert(STR2, line, 1);
        if (p->foldline != NOT_FOLD && full && dialect >= 0)
                strcat(line, dialect_end[dialect]);
}
/*}}}  */
/*{{{  void copyout(line, p)*/
void copyout(line, p)
char *line;
element *p;
{
  int i;
  element *WITH;
  char STR1[MAX_FIELD_SIZE + 1];

  WITH = p;
  if (WITH->foldline == NOT_FOLD)
    i = WITH->UU.U1.indent;
  else
    i = WITH->UU.U1.indent + MARKER_LEN;
  if (filed_or_fold(p))
    i += WITH->UU.U1.fold_indent;
  copy_line_to_parts(copy_to_end(STR1, line, i + 1), &p);
}
/*}}}  */
