/*{{{  COMMENT please read this*/
/*{{{  Johan Sunter*/
/*Modified, enhanced and debugged*/
/**/
/*Feel free to contact me if there are any problems, concerns, or questions.*/
/**/
/*Johan Sunter, Twente University, +31-53-893885*/
/**/
/*Email: sun@rt.el.utwente.nl*/
/*}}}  */
/*{{{  Charlie Lawrence*/
/*Converted from Turbo Pascal by p2c and ported*/
/**/
/*Feel free to contact me if there are any problems, concerns, or questions.*/
/**/
/*Charlie Lawrence Eastman Kodak Co. (716) 726-7007*/
/**/
/*Email: lawrence@lawrence.kodak.com*/
/*}}}  */
/*{{{  Martin Green*/
/*Ferranti is willing to waive all rights to the folding editor "origami" so*/
/*that it may be freely distributed as public domain software subject to the*/
/*following conditions :-*/
/**/
/*A program that uses this software must display on the screen on startup:-*/
/**/
/*"originally devised by:- Martin Green Ferranti Ltd Cheadle Heath Stockport*/
/*England"*/
/**/
/*The word "ORIGAMI" is displayed as well.*/
/*}}}  */
/*}}}  */

#ifndef __TURBOC__
#ifndef LINT
static char     origami_module[] = "@(#)origami.c       1.2 12/2/90";
#endif
#endif
/*{{{  includes*/
#include <stdio.h>
#include <ctype.h>
#include <signal.h>
#ifdef __TURBOC__
#include <conio.h>
#endif
#include "inmos.h"
#include "globals.h"
#include "misc.h"
#include "keyboard.h"
#include "screen.h"
#include "oriedt.h"
#include "edtutil.h"
#include "editor.h"
#include "fieldedt.h"
#include "filer.h"
#include "procexit.h"
#include "macros.h"
#include "keys.h"
/*}}}  */
/*{{{  defines*/
#define read_list();    create_list(); title(); restore_element(4);

#define copy_parts_to_parts(in_parts, parts)    \
                        strcpy((*(parts))->strng, (in_parts)->strng)

#define append_to_pick()          join_links(pick_tail, pick_ptr); \
                                  pick_ptr->UU.U1.indent = 0; \
                                  pick_tail = pick_ptr;
/*}}}  */
/*{{{  prototypes*/
PRIVATE void    proc_language P((LOC_flare *));
PRIVATE void    initialise P((LOC_flare *));
PRIVATE void    proc_command P((LOC_flare *));
PRIVATE BOOL    valid_screen_key P((BOOL *, int *));
PRIVATE void    flare2_program P((void));
int             main P((int, char **));
/*}}}  */

int             P_argc;
char          **P_argv;
static int init_line_number = 0;

/*{{{  PRIVATE void    proc_language(LOC_flare * LINK)*/
PRIVATE void    proc_language(LINK)
    LOC_flare      *LINK;
{
    int             i;
    char            lang_prompt[65];
    char            STR1[256];
    char            STR2[65];

    *lang_prompt = '\0';
    for (i = 0; i <= NO_LANGUAGES; i++) {
        strcat(lang_prompt, language_string[i]);
        /*
         * p2c: edtdsp.pas, line 24: Note: Possible string truncation in
         * assignment [145]
         */
    }
    (void) readprompt(LINK->command_str, lang_prompt, 1);
    /*
     * p2c: edtdsp.pas, line 25: Note: Possible string truncation in
     * assignment [145]
     */
    if (*LINK->command_str != '\0') {
        for (i = 0; i <= NO_LANGUAGES; i++) {
            sprintf(STR1, "%c", upper(LINK->command_str[0]));
            if (strpos2(language_string[i], STR1, 1) != 0)
                dialect = i;
        }
    }
    if (dialect == NO_LANGUAGES - 1) {
        strcpy(dialect_start[dialect],
               readprompt(STR2, "Start-of-comment string", 31));
        /*
         * p2c: edtdsp.pas, line 32: Note: Possible string truncation in
         * assignment [145]
         */
        strcpy(dialect_end[dialect], readprompt(STR2, "End-of-comment string", 31));
        /*
         * p2c: edtdsp.pas, line 33: Note: Possible string truncation in
         * assignment [145]
         */
    }
    title();
}
/*}}}  */
/*{{{  PRIVATE void    initialise(LOC_flare * LINK)*/
PRIVATE void    initialise(LINK)
    LOC_flare      *LINK;
{
    element        *WITH;

    real_tail = real_head;      /* added by A. M. Henshaw */
    dispose_head = (element *) malloc(sizeof(element));
    line_size = sizeof(element);
    dispose_tail = dispose_head;
    null_item_ptr = dispose_head;
    copy_line_to_parts(null_dsp_line, &null_item_ptr);
    WITH = null_item_ptr;
    WITH->selected = FALSE;
    WITH->foldline = NOT_FOLD;
    WITH->UU.U1.indent = 0;
    WITH->UU.U1.fold_indent = 0;
    WITH->fold = NULL;
    WITH->UU.U1.fold_type = 0;
    WITH->UU.U1.fold_contents = 1;
    WITH->fold_close_line = 4;
    proc_new(&new_file_ptr);
    proc_new(&pick_head);
    pick_tail = pick_head;
    proc_new(&deleted_line_ptr);
    proc_new(&buff_start_ptr);
    buff_end_ptr = buff_start_ptr;
    move_ptr = NULL;
    pick_ptr = NULL;
    param_count = P_argc - 1;
    LINK->keypad = TRUE;
    line_dsp_line = NULL;       /* null_dsp_line */
}
/*}}}  */
/*{{{  PRIVATE void    proc_command(LOC_flare * LINK)*/
PRIVATE void    proc_command(LINK)
    LOC_flare      *LINK;
{
    int             command_line;

    (void) readprompt(LINK->command_str, "Line number", 15);
    /*
     * p2c: edtdsp.pas, line 79: Note: Possible string truncation in
     * assignment [145]
     */
    command_line = 0;
    if (*LINK->command_str != '\0')
        sscanf(LINK->command_str, "%d", &command_line);
    if (command_line > 0) {
        LINK->cursor_x_pos = 1;
        find_element(command_line, 4);
    }
}
/*}}}  */
/*{{{  PRIVATE BOOL    valid_screen_key(BOOL * keypad, int *ch)*/
PRIVATE BOOL    valid_screen_key(keypad, ch)
    BOOL           *keypad;
    int            *ch;
{
    BOOL            valid;

    valid = TRUE;
    if (*keypad && select_on)   /* makefold */
        valid = (key_convert_list[*ch - 256][2]);
    return valid;
}
/*}}}  */
/*{{{  PRIVATE void    flare2_program(void)*/
PRIVATE void    flare2_program()
{
    LOC_flare       V;
    int             sect_lines;
    int             ch;
    BOOL            temp_b;
    char            t_str[MAX_FIELD_SIZE + 1], STR1[MAX_FIELD_SIZE + 1];
    static BOOL     quitt = FALSE, exitt = FALSE;
    static int      cursor_x_pos = 1;
    element        *WITH;
    char            STR2[166];
    char            STR3[170];
    char            STR4[168];
    char            STR5[256];

    V.cursor_x_pos = cursor_x_pos;
    initialise(&V);
    set_tabsize();
    read_list();
    if (init_line_number > 0)
      find_element(init_line_number, 4);
    do {
        dummy_cursor(TRUE);
        copyin(current_dsp_line, current, FALSE);
        proc_to_edit_pos();
        strcpy(old_current_dsp_line, current_dsp_line);
        dsp_fields[0] = cursor_level + TITLE_LINE;
        ch = field_edit(&V.keypad, &V.cursor_x_pos, current_dsp_line);
        dummy_cursor(FALSE);
        proc_from_edit_pos();
        if (current->foldline != END_FOLD)
            copyout(current_dsp_line, current);
        if (valid_screen_key(&V.keypad, &ch)) {
            no_message();
            if (V.keypad) {
                switch (ch) {

                /*{{{  case O_AUTO_FOLD:*/
                case O_AUTO_FOLD:       /* autofold */
                    if (!select_on) {   /* makefold */
                        /*
                         * V.cursor_x_pos = current->UU.U1.indent; /*force
                         * cursor to left
                         */
                        start_make_fold(V.cursor_x_pos);        /* makefold */
                        if (select_on) {
                            while (current != tail && last_char(line_of(STR1, current)) > 0)
                                move_down();
                            make_fold(&V.cursor_x_pos);
                            if (!select_on) {   /* makefold */
                                WITH = current;
                                copy_parts_to_parts(WITH->fold, &current);
                                write_dsp_line(current, cursor_level);
                                move_down();
                                while (current != tail && last_char(line_of(STR1, current)) == 0)
                                    move_down();
                            }
                        }
                    }
                    break;
                /*}}}  */
                /*{{{  case O_FOLD_INFO:*/
                case O_FOLD_INFO:       /* fold info */
                    WITH = current;
                    message("Enter depth  ");
                    colour(3);
                    printf("%d folds. %d spaces. ", enter_depth, enter_depth_spaces);
                    if (filed_or_fold(current))
                        printf(":::A %2d %d", WITH->UU.U1.fold_type, WITH->UU.U1.fold_contents);
                    if (WITH->foldline == START_FILED)
                        printf(" %s", line_of(STR1, WITH->other_end));
                    colour(1);
                    break;
                /*}}}  */
                /*{{{  case O_FIND:*/
                case O_FIND:    /* find */
                    find_next(&V.cursor_x_pos);
                    break;
                /*}}}  */
                /*{{{  case O_OPEN_NEW_FILE:*/
                case O_OPEN_NEW_FILE:   /* open new file */
                    temp_b = yes("File not saved. Save");
                    if (temp_b)
                        total_save();
                    delete_list(real_head, real_tail);
                    read_list();
                    break;
                /*}}}  */
                /*{{{  case O_UNDEL_LINE:*/
                case O_UNDEL_LINE:      /* und l */
                    if (!entered(current)) {
                        if (line_dsp_line == NULL && dispose_head != dispose_tail) {
                            message("press restore line again for best try");
                            ch = edit_key(&V.keypad);
                            if (V.keypad && ch == O_UNDEL_LINE)
                                proc_undispose(&line_dsp_line);
                            else
                                press(ch, V.keypad);
                        }
                        if (line_dsp_line != NULL)
                            undelete_before(line_dsp_line);
                        line_dsp_line = NULL;
                    }
                    break;
                /*}}}  */
                /*{{{  case O_BOT_OF_FOLD:*/
                case O_BOT_OF_FOLD:
                    bottom();
                    break;
                /*}}}  */
                /*{{{  case O_TOP_OF_FOLD:*/
                case O_TOP_OF_FOLD:
                    top();
                    break;
                /*}}}  */
                /*{{{  case O_COPY_PICK:*/
                case O_COPY_PICK:       /* copy_pick */
                    if (current->foldline == NOT_FOLD || current->foldline == START_FOLD) {
                        pick_ptr = NULL;
                        if (copy_a_line(&pick_ptr))
                            append_to_pick();
                    }
                    break;
                /*}}}  */
                /*{{{  case O_PICK:*/
                case O_PICK:    /* pick_line */
                    pick_ptr = NULL;
                    remove_line(&pick_ptr);
                    if (pick_ptr != NULL)
                        append_to_pick();
                    break;
                /*}}}  */
                /*{{{  case O_PUT_PICK:*/
                case O_PUT_PICK:        /* put pick */
                    if (!entered(current)) {
                        if (pick_head != pick_tail) {
                            if (available(2))
                                undelete_pick_before();
                        } else
                            message("no pick");
                    }
                    break;
                /*}}}  */
                /*{{{  case O_LANGUAGE:*/
                case O_LANGUAGE:
                    proc_language(&V);
                    break;
                /*}}}  */
                /*{{{  case O_FILE_FOLD:*/
                case O_FILE_FOLD:       /* file/unfile */
                    if (filed_or_fold(current)) {
                        if (normal_att(current)) {
                            if (current->foldline == START_FOLD) {
                                char *full_name;
                
                                check_fold(current);
                                copy_parts_to_line(Start_of_fold, t_str);
                                full_name = file_info(t_str);
                                if (can_open) {
                                    if (file_exists) {
                                        sprintf(STR4, "overwrite %s", full_name);
                                        can_open = yes(STR4);
                                    }
                                    if (can_open) {
                                        copy_line_to_parts(t_str, &End_of_fold);
                                        proc_exit(End_of_fold, Start_of_fold);
                                        if (Start_of_fold->fold != End_of_fold)
                                            delete_list(Start_of_fold->fold, End_of_fold->prec);
                                        Start_of_fold->fold = End_of_fold;
                                        End_of_fold->prec = Start_of_fold;
                                        Start_of_fold->foldline = START_FILED;
                                    }
                                } else {
                                    sprintf(STR3, "cannot open %s", full_name);
                                    message(STR3);
                                }
                            } else {    /* unfile */
                                pre_open_fold(current);
                                if (Start_of_fold->next == End_of_fold)
                                    insert_file(End_of_fold, Start_of_fold, End_of_fold, FALSE);
                                close_fold_at(current);
                            }
                            colour(1);
                            write_dsp_line(current, cursor_level);
                        }
                    }
                    break;
                /*}}}  */
                /*{{{  case O_QUIT:*/
                case O_QUIT:
                    if (!file_changed || yes("quit without save"))
                        quitt = TRUE;
                    break;
                /*}}}  */
                /*{{{  case O_UP:*/
                case O_UP:
                    move_up();
                    break;
                /*}}}  */
                /*{{{  case O_DOWN:*/
                case O_DOWN:
                    move_down();
                    break;
                /*}}}  */
                /*{{{  case O_LINE_UP:*/
                case O_LINE_UP:
                    line_up();
                    break;
                /*}}}  */
                /*{{{  case O_LINE_DOWN:*/
                case O_LINE_DOWN:
                    line_down();
                    break;
                /*}}}  */
                /*{{{  case O_FINISH:*/
                case O_FINISH:
                    if (tail == real_tail)
                        exitt = TRUE;
                    else
                        proc_error(1);
                    break;
                /*}}}  */
                /*{{{  case O_HELP:*/
                case O_HELP:
                    message("help");
                    help();
                    title();
                    restore(1);
                    break;
                /*}}}  */
                /*{{{  case O_FIND_NEXT:*/
                case O_FIND_NEXT:       /* findnxt */
                    find_item(&V.cursor_x_pos);
                    break;
                /*}}}  */
                /*{{{  case O_INSERT_FILE:*/
                case O_INSERT_FILE:
                    if (!entered(current)) {
                        insert_file((element *) NULL, current->prec, current, FALSE);
                        restore_element((uchar) cursor_level);
                    }
                    break;
                /*}}}  */
                /*{{{  case O_DEL_LINE:*/
                case O_DEL_LINE:
                    remove_line(&line_dsp_line);
                    break;
                /*}}}  */
                /*{{{  case O_ATTACH_FILE:*/
                case O_ATTACH_FILE:
                    if (current->foldline == START_FOLD) {
                        if (normal_att(current)) {
                            check_fold(current);
                            if (Start_of_fold->fold == End_of_fold) {
                                char *full_name;
                
                                copy_parts_to_line(Start_of_fold, t_str);
                                skip_controls(t_str);
                                full_name = file_info(t_str);
                                if (file_exists && can_open) {
                                  copy_line_to_parts(t_str, &End_of_fold);
                                  Start_of_fold->foldline = START_FILED;
                                  sprintf(STR2, "attached %s", full_name);
                                }
                                else
                                  sprintf(STR2, "file %s not found", full_name);
                                message(STR2);
                                colour(1);
                                write_dsp_line(current, cursor_level);
                                message(STR2);
                            }
                        }
                    }
                    break;
                /*}}}  */
                /*{{{  case O_PAGE_DOWN:*/
                case O_PAGE_DOWN:       /* page */
                    for (sect_lines = 1; sect_lines <= (screen_lines-3); sect_lines++)
                        move_down();
                    V.cursor_x_pos = 1;
                    break;
                /*}}}  */
                /*{{{  case O_PAGE_UP:*/
                case O_PAGE_UP:/* page */
                    for (sect_lines = 1; sect_lines <= (screen_lines-3); sect_lines++)
                        move_up();
                    V.cursor_x_pos = 1;
                		    break;
                /*}}}  */
                /*{{{  case O_RETURN:*/
                case O_RETURN:
                    if (!select_on) {   /* makefold */
                        if (split_line) {
                            undelete_after(part_line);
                        } else {
                            undelete_before(part_line);
                            move_down();
                        }
                        (void) available(0);    /* redisplay lines left */
                    }
                		    break;
                /*}}}  */
                /*{{{  case O_SAVE_FILE:*/
                case O_SAVE_FILE:       /* save */
                    if (tail == real_tail) {
                        old_dialect = dialect;
                        (void) readprompt(t_str, "save filename", 63);
                        if (*t_str != '\0')
                            copy_line_to_parts(t_str, &new_file_ptr);
                        proc_language(&V);
                        if (*V.command_str != '\0') {   /* for List */
                            if (upper(V.command_str[0]) == 'L')
                                dialect = -1;
                			}
                        proc_exit(new_file_ptr, real_head->next);
                        dialect = old_dialect;
                        title();/* I think this was already here */
                    } else
                        proc_error(1);
                    break;
                /*}}}  */
                /*{{{  case O_DELETE:*/
                case O_DELETE:
                    if (current->foldline == NOT_FOLD) {
                        if (current != tail && current != head->next &&
                            current->prec->foldline == NOT_FOLD) {
                            copy_parts_to_line(current, t_str);
                            trailing_spaces(t_str);
                            part_line = NULL;
                            remove_line(&part_line);
                            proc_dispose(part_line);
                            move_up();
                            copyin(current_dsp_line, current, FALSE);
                            trailing_spaces(current_dsp_line);
                            V.cursor_x_pos = strlen(current_dsp_line) + 1;
                            sprintf(STR5, "%s%s", line_of(STR1, current), t_str);
                            copy_line_to_parts(STR5, &current);
                            write_dsp_line(current, cursor_level);
                        }
                    }
                    break;
                /*}}}  */
                /*{{{  case O_REPLACE:*/
                case O_REPLACE:/* replace */
                    proc_replace(item_to_look_for, replace_item, current_dsp_line,
                                 V.cursor_x_pos);
                    copyout(current_dsp_line, current);
                    write_dsp_line(current, cursor_level);
                    break;
                /*}}}  */
                /*{{{  case O_REFRESH:*/
                case O_REFRESH:/* refresh */
                    title();
                    restore(1);
                    break;
                /*}}}  */
                /*{{{  case O_GOTO_LINE:*/
                case O_GOTO_LINE:       /* line mode */
                    proc_command(&V);
                    break;
                /*}}}  */
                /*{{{  case O_FIRST_LINE_TO_FOLD_HEADER:*/
                case O_FIRST_LINE_TO_FOLD_HEADER:
                    WITH = current;
                    if (WITH->foldline == START_FOLD) {
                        copy_parts_to_parts(WITH->fold, &current);
                        write_dsp_line(current, cursor_level);
                    }
                    break;
                /*}}}  */
                /*{{{  case O_CREATE_FOLD:*/
                case O_CREATE_FOLD:
                    if (!select_on) {   /* makefold */
                        if (available(3))
                            start_make_fold(V.cursor_x_pos);
                    } else
                        make_fold(&V.cursor_x_pos);
                    break;
                /*}}}  */
                /*{{{  case O_ENTER_FOLD:*/
                case O_ENTER_FOLD:
                    V.cursor_x_pos = 1;
                    enter_fold();
                    break;
                /*}}}  */
                /*{{{  case O_EXIT_FOLD:*/
                case O_EXIT_FOLD:
                    exit_fold();
                    break;
                /*}}}  */
                /*{{{  case O_REMOVE_FOLD:*/
                case O_REMOVE_FOLD:
                    remove_fold();
                    break;
                /*}}}  */
                /*{{{  case O_OPEN_FOLD:*/
                case O_OPEN_FOLD:
                    open_fold();
                    break;
                /*}}}  */
                /*{{{  case O_COMMENT_FOLD:*/
                case O_COMMENT_FOLD:
                    comment_fold();
                    break;
                /*}}}  */
                /*{{{  case O_CLOSE_FOLD:*/
                case O_CLOSE_FOLD:
                    close_fold();
                    break;
                /*}}}  */
                /*{{{  case O_MOVE:*/
                case O_MOVE:    /* move line */
                    if (move_ptr != NULL) {
                        if (!entered(current)) {
                            undelete_before(move_ptr);
                            move_ptr = NULL;
                        }
                    } else
                        remove_line(&move_ptr);
                    break;
                /*}}}  */
                /*{{{  case O_COPY:*/
                case O_COPY:
                    if ((current->foldline == NOT_FOLD ||
                      current->foldline == START_FOLD) && current != tail) {
                        if (available(lines_within(current))) { /* copy line */
                            if (copy_a_line(&copy_ptr))
                                undelete_after(copy_ptr);
                        }
                    }
                    break;
                /*}}}  */
                /*{{{  case O_COMMAND:*/
                case O_COMMAND:
                    if (tail == real_tail) {
                        /*{{{  command escape*/
                        (void)readprompt(STR2, "Command", 63);
                        if (strlen(STR2)) {
                            total_save();
                            colour(0);
                            ClrScr();
                            printf("Origami command\n");
                            printf("%s\n", STR2);
                            fflush(stdout);
                            reset_keyboard();
                            system(STR2);
                            init_keyboard();
                            colour(3);
                            printf("\n");
                            Gotoxy(1, screen_lines);
                            printf("Press return to continue...");
                            while (getc(stdin) != '\n');
                        }
                        colour(1);
                        ClrScr();
                        title();
                        restore(1);
                        no_message();
                        /*}}}  */
                    }
                    else
                        proc_error(1);
                    break;
                /*}}}  */
                /*{{{  case O_WORD_WRAP:*/
                case O_WORD_WRAP:
                    if ((wordwrap_mode = !wordwrap_mode) != 0)
                      message("word wrap ON");
                    else
                      message("word wrap OFF");
                    break;
                /*}}}  */
                }
            }
        } else
            message("key disabled during create fold");
    } while (!(quitt || exitt));

    full_window();              /* reset scroll */
    ClrScr();
    title();
    if (exitt)                  /* (1,1,80,25) */
        total_save();
#ifdef __TURBOC__
     normvideo();
#endif
    if (exitt)
        message("exit");
    else
        message("quit");
#ifdef __TURBOC__
     normvideo();
#endif
    Gotoxy(1, TITLE_LINE + 1);
}
/*}}}  */

/*{{{  int             main(int argc, char *argv[])*/
int             main(argc, argv)
    char           *argv[];
{
    if (HostBegin())
        exit(1);
    colour(1);
    full_window();
    ClrScr();
    colour(3);
    Gotoxy(1, MESSAGE_LINE);
    Clreol();
    colour(1);
    Gotoxy(1, 5);
    printf("%s", "originally by:- Martin Green, Ferranti Ltd, Cheadle Heath, Stockport, England");
    Gotoxy(1, 6);
    printf("%s", "Converted from Pascal and modified by Charlie Lawrence, Eastman Kodak Co.");
    Gotoxy(1, 7);
    printf("%s", "Keymap-helpfiles and other modifications by Johan Sunter, University of Twente");
    fflush(stdout);
#ifndef __TURBOC__
    signal(SIGQUIT, SIG_IGN);
#endif
#ifndef __DEBUGGING__
    signal(SIGINT, SIG_IGN);
#endif
    P_argc = argc;
    P_argv = argv;
    if (argc == 1)
        param_count = 0;
    else {
	if (*argv[1] == '+') {
	    sscanf(argv[1]+1, "%d", &init_line_number);
	    param_count = (argc <= 2) ? 0 : argc-1;
	}
	param_count = argc - 1;
    }
    flare2_program();

#ifdef __TURBOC__
     colour(0);
     ClrScr();
#endif

    reset_keyboard();
    store_macros();
    exit(0);

    return 0;
}
/*}}}  */

