#include <stdio.h>
#ifdef __TURBOC__
#include <conio.h>
#endif
#include "inmos.h"
#include "globals.h"
#include "screen.h"

#ifndef __TURBOC__
#ifndef LINT
static char screen_module[] = "@(#)screen.c     1.4 12/3/90";
#endif
#endif

/*{{{F screen.h*/
/*:::F screen.h*/
/*}}}  */

#ifndef __TURBOC__
/*{{{  default vt100 escape codes*/
static char vt100_al[] = "e[L";
static char vt100_dl[] = "e[M";
static char vt100_ic[] = "e[@";
static char vt100_dc[] = "e[P";
static char vt100_me[] = "e[m";
static char vt100_mr[] = "e[7m";
/*}}}  */

static char termcap_area[400];
static char *cm,        /* cursor motion */
            *ce,*cd,    /* clear to end of display/line */
            *al,*dl,    /* append and delete line */
            *dc,        /* delete character */
            *me,        /* turn off all attributes */
            *mr,        /* reverse video */
            *ti, *te,   /* terminal initialization and finalization */
            *ks, *ke;   /* keypad transmit mode on and off */
static char *BC,*UP,PC,*pc;
static short ospeed;

#endif

/*{{{  void invert_on ()*/
void invert_on ()
{
#ifdef __TURBOC__
        highvideo();
#else
        tputs(mr,1,outchar);
#endif
}
/*}}}  */
/*{{{  void invert_off ()*/
void invert_off ()
{
#ifdef __TURBOC__
        normvideo();
#else
        tputs(me,1,outchar);
#endif
}
/*}}}  */
/*{{{  void full_window ()*/
void full_window ()
{
extern W_oy,W_dy;
        W_oy = 1;
        W_dy = screen_lines;
}
/*}}}  */
/*{{{  void Gotoxy (x,y)*/
void Gotoxy (x,y)
int x,y;
{
#ifdef __TURBOC__
        gotoxy(x, y);
#else
        tputs (tgoto(cm,x-1,y-1),1,outchar);
#endif
}
/*}}}  */
/*{{{  void Clreol ()*/
void Clreol ()
{
#ifdef __TURBOC__
        clreol();
#else
        tputs(ce,1,outchar);
#endif
}
/*}}}  */
/*{{{  void insLine ()*/
void insLine ()
{
#ifdef __TURBOC__
        insline();
#else
        tputs(al,1,outchar);
#endif
}
/*}}}  */
/*{{{  void DelLine ()*/
void DelLine ()
{
#ifdef __TURBOC__
        delline();
#else
        tputs(dl,1,outchar);
#endif
}
/*}}}  */
/*{{{  void ClrScr ()*/
void ClrScr ()
{
#ifdef __TURBOC__
        clrscr();
#else
        Gotoxy(1, 1); /* W_oy); */
        tputs(cd,1,outchar);
#endif
}
/*}}}  */
/*{{{  void DelCharLeft ()*/
void DelCharLeft ()
{
#ifndef __TURBOC__
        putchar ('\b');
        tputs (dc,1,outchar);
#else
#endif
}
/*}}}  */
/*{{{  void InitTerminal()*/
void InitTerminal()
{
#ifndef __TURBOC__
        if (ti != NULL && te != NULL)
          tputs(ti, 1, outchar);
        if (ks != NULL && ke != NULL)
          tputs(ks, 1, outchar);
#endif
}
/*}}}  */
/*{{{  void EndTerminal()*/
void EndTerminal()
{
#ifndef __TURBOC__
        if (ks != NULL && ke != NULL)
          tputs(ke, 1, outchar);
        if (ti != NULL && te != NULL)
          tputs(te, 1, outchar);
#endif
}
/*}}}  */
/*{{{  void outchar (ch)*/
void outchar (ch)
int ch;
{
        putchar (ch);
}
/*}}}  */
/*{{{  int get_terminal_capability ()*/
int get_terminal_capability ()
{
#ifndef __TURBOC__
char bp[1024];
char *terminal;
char *getenv(),*tgetstr();
char *pointer;
extern int W_dx;

        *vt100_al = *vt100_dl = *vt100_ic = *vt100_dc = 0x1b;
        vt100_me[0] = vt100_mr[0] = 0x1b;
        if ((terminal = getenv ("TERM")) == 0) {
                printf ("Environment variable TERM not set.\n");
                return (1);
        }
        switch (tgetent (bp,terminal)) {
                case 1:
                        break;
                case -1:
                        printf ("Cannot open termcap file.\n");
                        return (1);
                        break;
                case 0:
                        printf ("Cannot find %s in termcap file.\n",terminal);
                        return (1);
                        break;
        }

        screen_lines = tgetnum("li");
        W_dx = tgetnum("co");

        pointer = termcap_area;
        /*{{{  cm*/
        if ((cm = tgetstr("cm",&pointer)) == 0) {
                printf ("Cusor Motion: No definition in termcap. \n");
                return (1);
        }
        /*}}}  */
        /*{{{  ce*/
        if ((ce = tgetstr("ce",&pointer)) == 0) {
                printf ("Clear EOL: No definition in termcap. \n");
                return (1);
        }
        /*}}}  */
        /*{{{  cd*/
        if ((cd = tgetstr("cd",&pointer)) == 0) {
                printf ("Clear EOD: No definition in termcap. \n");
                return (1);
        }
        /*}}}  */
        /*{{{  al*/
        if ((al = tgetstr("al",&pointer)) == 0) {
                al = vt100_al;
        }
        /*}}}  */
        /*{{{  dl*/
        if ((dl = tgetstr("dl",&pointer)) == 0) {
                dl = vt100_dl;
        }
        /*}}}  */
        /*{{{  ic*/
        /*
        if ((ic = tgetstr("ic",&pointer)) == 0) {
                ic = vt100_ic;
        }
        */
        /*}}}  */
        /*{{{  dc*/
        if ((dc = tgetstr("dc",&pointer)) == 0) {
                dc = vt100_dc;
        }
        /*}}}  */
        /*{{{  ti and te*/
        /* J.Sunter, 16 Jul 1992 */
        ti = tgetstr("ti", &pointer);
        te = tgetstr("te", &pointer);
        /*}}}  */
        /*{{{  ks and ke*/
        /* J.Sunter, 20 Oct 1992 */
        ks = tgetstr("ks", &pointer);
        ke = tgetstr("ke", &pointer);
        /*}}}  */
        /*{{{  pc*/
        if ((pc = tgetstr("pc",&pointer)) == 0) {
                PC = '\0';
        }
        else
                PC = *pc;
        /*}}}  */
        /*{{{  up*/
        if ((UP = tgetstr("up",&pointer)) == 0) {
                printf ("up: No definition in termcap. \n");
                return (1);
        }
        /*}}}  */
        /*{{{  bs*/
        if (tgetflag("bs")) {
        }
        else {
                printf ("Back Char: No definition in termcap. \n");
                return (1);
        }
        /*}}}  */
        /*{{{  mr*/
        if ((mr = tgetstr("mr",&pointer)) == 0) {
                mr = vt100_mr;
        }
        /*}}}  */
        /*{{{  me*/
        if ((me = tgetstr("me",&pointer)) == 0) {
                me = vt100_me;
        }
        /*}}}  */

        ospeed = 0;
#else
        struct text_info info;

        gettextinfo(&info);
        screen_lines = info.screenheight;
        W_dx = info.screenwidth;
#endif
        return (0);
}
/*}}}  */

