/*
 *  cxfft.h from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */

#ifndef CXFFT_DOT_H
#define CXFFT_DOT_H

#include "ObjProDSP/portable.h"
#include "ObjProDSP/entenm.h"
#include "ObjProGen/debug.h"
#include "ObjProUsr/procstr.h"

class CxFFT: public ProcessNodeStr {
#line 87 "../cxfft.usr"
 
	static CxMachWord ComplexToCxMachWord(complex& val);
	static int32 FftSize(int LogSize);
	static int32 FftOverlap(double Overlap,int LogSize);
#ifdef INTERACTIVE
	static StreamStr * FftStreamStr(int Elements, int LogSize,
    	double CenterFreq, double Overlap);
#endif
	
	virtual void clear_buffers(){FftBufferBase = 0 ; DataInBuffer = 0 ;}
#line 31 "/usrb/dist/ftp/opd-0.1/src/include/ObjProDSPint/ObjProUsr/cxfft.h"
	CxMachWord *  CxCoeff;
	CxMachWord *  FftBuffer;
	int32  Size;
	int32  FftBufferBase;
	int32  DataInBuffer;
	int32  FftBufferSize;
	int16  LogSize_1;
	double  Overlap_2;
	double  CenterFrequency_3;
	int16  InverseFlag_4;
public:
	CxFFT (const char * Name, int16 LogSize, double Overlap, 
		double CenterFrequency, int16 InverseFlag);
	virtual ~CxFFT();
	int16 GetLogSize() const {return LogSize_1;}
	double GetOverlap() const {return Overlap_2;}
	double GetCenterFrequency() const {return CenterFrequency_3;}
	int16 GetInverseFlag() const {return InverseFlag_4;}
	virtual int CheckSafeDelete() ;
	CxMachWord * GetCxCoeff() const { return CxCoeff;}
	CxMachWord * GetFftBuffer() const { return FftBuffer;}
	int32 GetSize() const { return Size;}
	int32 GetFftBufferBase() const { return FftBufferBase;}
	int32 GetDataInBuffer() const { return DataInBuffer;}
	int32 GetFftBufferSize() const { return FftBufferSize;}
	virtual ErrCode DoNode(int32);
	void Describe(OutTokens& Out, ListEntity Option);
	virtual int CppList(OutTokens& Out, CppListCmds Cmd);
	void SetCenterFrequency(double  CenterFrequency) { CenterFrequency_3 = CenterFrequency; parameter_changed(); }
#line 98 "../cxfft.usr"
	static int32 index_start(int32 size, double center_freq) {
		if (center_freq < 0.0) center_freq = 1.0 + center_freq ;
		return (int32) ((1.0 - center_freq) * size + 1.5) ;
	}
#line 66 "/usrb/dist/ftp/opd-0.1/src/include/ObjProDSPint/ObjProUsr/cxfft.h"
};

extern CxFFT * CxFFTDef;


#endif /* #ifdef CXFFT_DOT_H */
