/*
 *  pipe_com.h from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
#ifndef PIPE_COM_DOT_H
#define PIPE_COM_DOT_H
/*  pipe_com.h   */
/*  Copyright 1993 Mountain Math Software  */
/*  All Rights Reserved                    */
// These are the data structures associated with shared memory

#include "ObjProDSP/portable.h"
#include "ObjProDSP/mpacket.h"

typedef void (*NotifyCommActive)();
class ImplementPipeCommunication_ ;

class PipeCommunication {
	ImplementPipeCommunication_ * pipe_com ;
public:
	PipeCommunication(int file_desc, int write_flag = 0);
	~PipeCommunication() ;
	void WritePacket(PacketHeader&, const char *Data=0);
	int CheckPacketRead() ;
	int ReadPacket() ;
	static int is_comm_active(NotifyCommActive Notify = 0) ;
	static void set_comm_active();
	static PipeCommunication * read_segment();
	static PipeCommunication * write_segment();
	void block();
	void no_block();
};


extern void ProcessPacket(PacketHeader&, const char *,
	PacketHeader * NextPacketHead);

extern int SharedMemoryExitState ;

#define OPD_PIPES 

#endif /* #ifdef PIPE_COM_DOT_H */
