/*
 *  typout.C from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */

#include <string.h>
#include <stream.h>
#include "typout.h"
#ifndef OVERFLOW
#include <complex.h>
#endif


const TypeBufSize = 128 ;
static char TypeBuf[TypeBufSize]; 

#define CONVERT_TO_STRING(x,type,func_cast)		\
	ostream Temp(TypeBufSize-1,TypeBuf);	\
	for (int i = 0 ; i < TypeBufSize;i++) TypeBuf[i] = '\0' ;			\
	Temp << ((type) func_cast(x)) ;			\
	return TypeBuf 				\


const char * TypeToString(MachWord x)
{
	return dec(int16(x));
}

const char * TypeToString(AccMachWord x)
{
	return dec(int32(x));
}

const char * TypeToString(class complex& x)
{
	strcpy(TypeBuf,"( ");
	strcat(TypeBuf,form("%f",real(x)));
	strcat(TypeBuf,", ");
	strcat(TypeBuf,form("%f",imag(x)));
	strcat(TypeBuf," )");
	return TypeBuf ;
}

const char * TypeToString(CxMachWord& x)
{
	return TypeToString(complex(int16(MachReal(x)),int16(MachImag(x))));
}

const char * TypeToString(CxAccMachWord& x)
{
	return TypeToString(complex(int32(MachReal(x)),int32(MachImag(x))));
}

const char * TypeToString(int16 x)
{
	return dec(x);
}

const char * TypeToString(int32 x)
{
	return dec(x);
}

const char * TypeToString(double x)
{
	return(form("%e",x));
}


